/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.treemap.AbstractNodeRenderer;
import com.treemap.Rendering;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapSettings;
import com.treemap.TreeMapView;
import com.treemap.crossplatform.TGraphics;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Shape;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\"\u0010\t\u001a\u00020\u00062\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u000bH\u0016J=\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u000b2\u0006\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J/\u0010\u0012\u001a\u00020\u00062\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u000b2\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014J\"\u0010\u0015\u001a\u00020\u00102\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0017H\u0016JW\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u000b2\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016\u00a2\u0006\u0002\u0010 R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/treemap/LeafNodeRenderer;", "N", "Row", "Column", "Lcom/treemap/AbstractNodeRenderer;", "drawText", "", "<init>", "(Z)V", "isEnabled", "view", "Lcom/treemap/TreeMapView;", "getOrder", "", "root", "pass", "", "(Lcom/treemap/TreeMapView;Ljava/lang/Object;I)Ljava/lang/Iterable;", "shouldPaint", "node", "(Lcom/treemap/TreeMapView;Ljava/lang/Object;)Z", "getPasses", "model", "Lcom/treemap/TreeMapModel;", "paintNode", "g", "Lcom/treemap/crossplatform/TGraphics;", "passes", "bounds", "Lorg/mkui/geom/Rectangle;", "shape", "Lorg/mkui/geom/Shape;", "(Lcom/treemap/crossplatform/TGraphics;Lcom/treemap/TreeMapView;Ljava/lang/Object;IILorg/mkui/geom/Rectangle;Lorg/mkui/geom/Shape;)Z", "treemap"})
@StabilityInferred(parameters=8)
public final class LeafNodeRenderer<N, Row, Column>
extends AbstractNodeRenderer<N, Row, Column> {
    private final boolean drawText;
    public static final int $stable;

    public LeafNodeRenderer(boolean drawText) {
        this.drawText = drawText;
    }

    @Override
    public boolean isEnabled(@NotNull TreeMapView<N, Row, Column> view) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        return true;
    }

    @Override
    @NotNull
    public Iterable<N> getOrder(@NotNull TreeMapView<N, Row, Column> view, N root, int pass) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        TreeMapModel<N, Row, Column> treeMapModel = view.getModel();
        Intrinsics.checkNotNull(treeMapModel);
        Rendering rendering = treeMapModel.getSettings().getRendering();
        Intrinsics.checkNotNull((Object)rendering);
        return rendering.getOrder(view, root, pass);
    }

    @Override
    public boolean shouldPaint(@NotNull TreeMapView<N, Row, Column> view, N node) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        TreeMapModel<N, Row, Column> treeMapModel = view.getModel();
        Intrinsics.checkNotNull(treeMapModel);
        return treeMapModel.hasNoChildren(node);
    }

    @Override
    public int getPasses(@NotNull TreeMapModel<N, Row, Column> model) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Rendering rendering = model.getSettings().getRendering();
        Intrinsics.checkNotNull((Object)rendering);
        return rendering.getPasses(model);
    }

    @Override
    public boolean paintNode(@NotNull TGraphics g, @NotNull TreeMapView<N, Row, Column> view, N node, int pass, int passes, @NotNull Rectangle bounds, @NotNull Shape shape) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        boolean completed = true;
        TreeMapModel<N, Row, Column> treeMapModel = view.getModel();
        Intrinsics.checkNotNull(treeMapModel);
        TreeMapModel<N, Row, Column> model = treeMapModel;
        if (bounds.getWidth() > 0.0 && bounds.getHeight() > 0.0) {
            TreeMapSettings<Column> settings = model.getSettings();
            Rendering rendering = settings.getRendering();
            Intrinsics.checkNotNull((Object)rendering);
            Rendering rendering2 = rendering;
            completed = rendering2.paintNode(g, view, node, pass, bounds, shape);
            if (this.drawText && bounds.getWidth() > 4.0 && bounds.getHeight() > 4.0) {
                if (settings.getBackgroundColumn() != null) {
                    rendering2.paintBackground(g, view, node, pass, passes, bounds, shape);
                }
                if (!((Collection)settings.getLabelsColumns()).isEmpty()) {
                    rendering2.paintLabel(g, view, node, pass, passes, bounds, shape);
                }
            }
            rendering2.paintBorder(g, view, node, pass, bounds, shape);
        }
        return completed;
    }
}

