/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.details;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.treemap.DefaultTreeMapModel;
import com.treemap.TreeMapModel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.dataframe.AbstractDataFrame;
import org.molap.dataframe.DataFrame;
import org.molap.dataframe.DataFrameEvent;
import org.molap.dataframe.DataFrameListener;
import org.molap.index.DefaultUniqueIndex;
import org.molap.index.UniqueIndex;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001e*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u0018\u0012\u0004\u0012\u0002H\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004:\u0001\u001eB!\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001b\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u0016J!\u0010\u0013\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00028\u00022\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u001b\u001a\u00020\u001cH\u0004J\b\u0010\u001d\u001a\u00020\u001cH\u0004R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018\u00a8\u0006\u001f"}, d2={"Lcom/treemap/details/DetailsDataFrame;", "N", "R", "C", "Lorg/molap/dataframe/AbstractDataFrame;", "", "", "model", "Lcom/treemap/TreeMapModel;", "<init>", "(Lcom/treemap/TreeMapModel;)V", "current", "Ljava/lang/Object;", "getRowClass", "Lkotlin/reflect/KClass;", "row", "(Ljava/lang/Object;)Lkotlin/reflect/KClass;", "getColumnClass", "column", "getValueAt", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", "rowIndex", "Lorg/molap/index/UniqueIndex;", "getRowIndex", "()Lorg/molap/index/UniqueIndex;", "columnIndex", "getColumnIndex", "scheduleUpdate", "", "updateImmediatelly", "Companion", "treemap"})
@StabilityInferred(parameters=0)
public final class DetailsDataFrame<N, R, C>
extends AbstractDataFrame<C, String, Object> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TreeMapModel<N, R, C> model;
    @Nullable
    private N current;
    public static final int $stable = 8;
    @NotNull
    private static final String NAME = "Variable";
    @NotNull
    private static final String VALUE = "Value";
    @NotNull
    private static final UniqueIndex<String> columns;

    public DetailsDataFrame(final @NotNull TreeMapModel<N, R, C> model) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        this.model = model;
        model.getProbing().addSingleSelectionListener(new SingleSelectionListener<N>(){

            public void selectionChanged(SingleSelectionEvent<N> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                if (event.getCurrentSelection() != null) {
                    current = event.getCurrentSelection();
                } else if (model.getSelection().isActive() && model.getSelection().getSelectedCount() == 1) {
                    for (Object node : model.getSelection()) {
                        current = node;
                    }
                } else {
                    current = null;
                }
                this.scheduleUpdate();
            }
        });
        DataFrame dataFrame = ((DefaultTreeMapModel)model).getDataFrame();
        Intrinsics.checkNotNull(dataFrame);
        dataFrame.addDataFrameListener(new DataFrameListener<R, C>(){

            public void dataFrameChanged(DataFrameEvent<R, C> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                this.scheduleUpdate();
            }
        });
    }

    @Nullable
    public KClass<?> getRowClass(C row) {
        return null;
    }

    @NotNull
    public KClass<?> getColumnClass(@Nullable String column) {
        return column == NAME ? Reflection.getOrCreateKotlinClass(String.class) : (column == VALUE ? Reflection.getOrCreateKotlinClass(Object.class) : Reflection.getOrCreateKotlinClass(Object.class));
    }

    @Nullable
    public Object getValueAt(C row, @Nullable String column) {
        Object object;
        if (Intrinsics.areEqual((Object)column, (Object)NAME)) {
            TreeMapModel<N, R, C> treeMapModel = this.model;
            Intrinsics.checkNotNull(treeMapModel, (String)"null cannot be cast to non-null type com.treemap.DefaultTreeMapModel<*, C of com.treemap.details.DetailsDataFrame>");
            DataFrame dataFrame = ((DefaultTreeMapModel)treeMapModel).getDataFrame();
            Intrinsics.checkNotNull(dataFrame);
            object = dataFrame.getColumnName(row);
        } else if (Intrinsics.areEqual((Object)column, (Object)VALUE)) {
            if (this.current != null) {
                N n = this.current;
                Intrinsics.checkNotNull(n);
                object = this.model.getValueAt(n, row);
            } else {
                object = null;
            }
        } else {
            object = null;
        }
        return object;
    }

    @NotNull
    public UniqueIndex<C> getRowIndex() {
        TreeMapModel<N, R, C> treeMapModel = this.model;
        Intrinsics.checkNotNull(treeMapModel, (String)"null cannot be cast to non-null type com.treemap.DefaultTreeMapModel<*, C of com.treemap.details.DetailsDataFrame>");
        DataFrame dataFrame = ((DefaultTreeMapModel)treeMapModel).getDataFrame();
        Intrinsics.checkNotNull(dataFrame);
        return dataFrame.getColumnIndex();
    }

    @NotNull
    public UniqueIndex<String> getColumnIndex() {
        return columns;
    }

    protected final void scheduleUpdate() {
        this.updateImmediatelly();
    }

    protected final void updateImmediatelly() {
        this.notifyDataFrameChanged(new DataFrameEvent(null, null, true));
    }

    static {
        Object[] objectArray = new String[]{NAME, VALUE};
        columns = (UniqueIndex)new DefaultUniqueIndex(objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/treemap/details/DetailsDataFrame$Companion;", "", "<init>", "()V", "NAME", "", "VALUE", "columns", "Lorg/molap/index/UniqueIndex;", "treemap"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

