/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.colormap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.collection.SortedSet;
import com.macrofocus.common.collection.UniversalComparator;
import com.macrofocus.common.interval.IntervalEvent;
import com.macrofocus.common.interval.IntervalListener;
import com.macrofocus.common.interval.MutableInterval;
import com.macrofocus.common.properties.EnumProperties;
import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertyDelegates;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.common.properties.SimpleProperty;
import java.awt.Color;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.color.MkColor2;
import org.mkui.color.MkColorFactory;
import org.mkui.colormap.AbstractColorMap;
import org.mkui.colormap.Assignments;
import org.mkui.colormap.ColorMapEvent;
import org.mkui.colormap.Matching;
import org.mkui.colormap.MutableColorMap;
import org.mkui.colormap.SetStoreMutableProperty;
import org.mkui.palette.CustomPalette;
import org.mkui.palette.InterpolatedPalette;
import org.mkui.palette.MutablePalette;
import org.mkui.palette.PaletteEvent;
import org.mkui.palette.PaletteListener;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b#\n\u0002\u0010\b\n\u0002\b\u0017\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0010\u001c\n\u0002\b\f\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004B\u0019\b\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0003\u0010\tB'\b\u0017\u0012\f\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0003\u0010\u000eJ\u001f\u0010u\u001a\n\u0018\u00010(j\u0004\u0018\u0001`)2\b\u0010v\u001a\u0004\u0018\u00010'H\u0016\u00a2\u0006\u0002\u0010wJ\u0019\u0010x\u001a\u00020y2\n\u0010z\u001a\u0006\u0012\u0002\b\u00030{H\u0002\u00a2\u0006\u0002\u0010|J\u0015\u0010\u0083\u0001\u001a\u00030\u0084\u00012\t\u0010\u0085\u0001\u001a\u0004\u0018\u00010,H\u0016J\u0015\u0010\u0086\u0001\u001a\u00030\u0084\u00012\t\u0010\u0087\u0001\u001a\u0004\u0018\u00010.H\u0016J \u0010\u008a\u0001\u001a\u00030\u0084\u00012\u000f\u0010\u008b\u0001\u001a\n\u0018\u00010(j\u0004\u0018\u0001`)H\u0016\u00a2\u0006\u0002\u00105J \u0010\u008e\u0001\u001a\u00030\u0084\u00012\u000f\u0010\u008f\u0001\u001a\n\u0018\u00010(j\u0004\u0018\u0001`)H\u0016\u00a2\u0006\u0002\u00105J\u001e\u0010\u0092\u0001\u001a\u00030\u0084\u00012\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u0092\u0001\u001a\u00030\u0084\u00012\u0016\u0010\n\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010'0{\"\u0004\u0018\u00010'H\u0016\u00a2\u0006\u0003\u0010\u0093\u0001J\u001b\u0010\u0092\u0001\u001a\u00030\u0084\u00012\u000f\u0010\n\u001a\u000b\u0012\u0006\u0012\u0004\u0018\u00010'0\u0094\u0001H\u0016J+\u0010\u0095\u0001\u001a\u00030\u0084\u00012\b\u0010v\u001a\u0004\u0018\u00010'2\u000f\u0010\u0096\u0001\u001a\n\u0018\u00010(j\u0004\u0018\u0001`)H\u0016\u00a2\u0006\u0003\u0010\u0097\u0001J\n\u0010\u0098\u0001\u001a\u00030\u0084\u0001H\u0016J\n\u0010\u009c\u0001\u001a\u00030\u0084\u0001H\u0016J\u001f\u0010\u009d\u0001\u001a\u00030\u0084\u00012\t\u0010\u009e\u0001\u001a\u0004\u0018\u00010y2\b\u0010v\u001a\u0004\u0018\u00010'H\u0016J\u000b\u0010\u009f\u0001\u001a\u00020yH\u0096\u0080\u0004R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R(\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\"\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR/\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\u001e\u001a\u0004\u0018\u00010\b8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b#\u0010$\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R6\u0010%\u001a*\u0012\u0006\u0012\u0004\u0018\u00010'\u0012\b\u0012\u00060(j\u0002`)0&j\u0014\u0012\u0006\u0012\u0004\u0018\u00010'\u0012\b\u0012\u00060(j\u0002`)`*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010/\u001a\u0010\u0012\f\u0012\n\u0018\u00010(j\u0004\u0018\u0001`)0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u001bR;\u00101\u001a\n\u0018\u00010(j\u0004\u0018\u0001`)2\u000e\u0010\u001e\u001a\n\u0018\u00010(j\u0004\u0018\u0001`)8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b6\u0010$\u001a\u0004\b2\u00103\"\u0004\b4\u00105R \u00107\u001a\b\u0012\u0004\u0012\u00020\r0\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\u001b\"\u0004\b9\u0010\u001dR(\u0010:\u001a\u0010\u0012\f\u0012\n\u0018\u00010(j\u0004\u0018\u0001`)0\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010\u001b\"\u0004\b<\u0010\u001dR\"\u0010=\u001a\u0010\u0012\f\u0012\n\u0018\u00010(j\u0004\u0018\u0001`)0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010\u001bR \u0010?\u001a\b\u0012\u0004\u0012\u00020\r0\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010\u001b\"\u0004\bA\u0010\u001dR(\u0010B\u001a\u0010\u0012\f\u0012\n\u0018\u00010(j\u0004\u0018\u0001`)0\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010\u001b\"\u0004\bD\u0010\u001dR\"\u0010E\u001a\u0010\u0012\f\u0012\n\u0018\u00010(j\u0004\u0018\u0001`)0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010\u001bR \u0010G\u001a\b\u0012\u0004\u0012\u00020\r0\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010\u001b\"\u0004\bH\u0010\u001dR+\u0010I\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\r8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\bM\u0010$\u001a\u0004\bI\u0010J\"\u0004\bK\u0010LR \u0010N\u001a\b\u0012\u0004\u0012\u00020\r0\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010\u001b\"\u0004\bP\u0010\u001dR \u0010Q\u001a\b\u0012\u0004\u0012\u00020R0\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010\u001b\"\u0004\bT\u0010\u001dR+\u0010U\u001a\u00020R2\u0006\u0010\u001e\u001a\u00020R8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\bZ\u0010$\u001a\u0004\bV\u0010W\"\u0004\bX\u0010YR \u0010[\u001a\b\u0012\u0004\u0012\u00020R0\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\\\u0010\u001b\"\u0004\b]\u0010\u001dR+\u0010^\u001a\u00020R2\u0006\u0010\u001e\u001a\u00020R8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\ba\u0010$\u001a\u0004\b_\u0010W\"\u0004\b`\u0010YR \u0010b\u001a\b\u0012\u0004\u0012\u00020R0\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bc\u0010\u001b\"\u0004\bd\u0010\u001dR+\u0010e\u001a\u00020R2\u0006\u0010\u001e\u001a\u00020R8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\bh\u0010$\u001a\u0004\bf\u0010W\"\u0004\bg\u0010YR$\u0010i\u001a\u00020j2\u0006\u0010i\u001a\u00020j@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bk\u0010l\"\u0004\bm\u0010nR\u000e\u0010o\u001a\u00020pX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010q\u001a\u00020rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010s\u001a\u00020tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010}\u001a\u00020~8DX\u0084\u0004\u00a2\u0006\u0007\u001a\u0005\b\u007f\u0010\u0080\u0001R\u0017\u0010\u0081\u0001\u001a\u00020~8DX\u0084\u0004\u00a2\u0006\b\u001a\u0006\b\u0082\u0001\u0010\u0080\u0001R\u001a\u0010\u0088\u0001\u001a\u00060(j\u0002`)8VX\u0096\u0004\u00a2\u0006\u0007\u001a\u0005\b\u0089\u0001\u00103R\u001a\u0010\u008c\u0001\u001a\u00060(j\u0002`)8VX\u0096\u0004\u00a2\u0006\u0007\u001a\u0005\b\u008d\u0001\u00103R\u0016\u0010\u0090\u0001\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0007\u001a\u0005\b\u0090\u0001\u0010JR\u0016\u0010\u0091\u0001\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0007\u001a\u0005\b\u0091\u0001\u0010JR\u001f\u0010\u0099\u0001\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010'0\u000b8VX\u0096\u0004\u00a2\u0006\b\u001a\u0006\b\u009a\u0001\u0010\u009b\u0001\u00a8\u0006\u00a0\u0001"}, d2={"Lorg/mkui/colormap/SimpleColorMap;", "Lorg/mkui/colormap/AbstractColorMap;", "Lorg/mkui/colormap/MutableColorMap;", "<init>", "()V", "interval", "Lcom/macrofocus/common/interval/MutableInterval;", "palette", "Lorg/mkui/palette/MutablePalette;", "(Lcom/macrofocus/common/interval/MutableInterval;Lorg/mkui/palette/MutablePalette;)V", "values", "", "cyclic", "", "(Ljava/util/Set;ZLorg/mkui/palette/MutablePalette;)V", "properties", "Lcom/macrofocus/common/properties/MutableProperties;", "Lorg/mkui/colormap/AbstractColorMap$PropertyType;", "getProperties", "()Lcom/macrofocus/common/properties/MutableProperties;", "getInterval", "()Lcom/macrofocus/common/interval/MutableInterval;", "setInterval", "(Lcom/macrofocus/common/interval/MutableInterval;)V", "paletteProperty", "Lcom/macrofocus/common/properties/MutableProperty;", "getPaletteProperty", "()Lcom/macrofocus/common/properties/MutableProperty;", "setPaletteProperty", "(Lcom/macrofocus/common/properties/MutableProperty;)V", "<set-?>", "getPalette", "()Lorg/mkui/palette/MutablePalette;", "setPalette", "(Lorg/mkui/palette/MutablePalette;)V", "palette$delegate", "Lkotlin/properties/ReadWriteProperty;", "dictionary", "Ljava/util/HashMap;", "", "Ljava/awt/Color;", "Lorg/mkui/color/MkColor;", "Lcom/macrofocus/common/collection/TreeMap;", "_matching", "Lorg/mkui/colormap/Matching;", "_assignments", "Lorg/mkui/colormap/Assignments;", "nullColorProperty", "getNullColorProperty", "nullColor", "getNullColor", "()Ljava/awt/Color;", "setNullColor", "(Ljava/awt/Color;)V", "nullColor$delegate", "underColorSetProperty", "getUnderColorSetProperty", "setUnderColorSetProperty", "underColorStoreProperty", "getUnderColorStoreProperty", "setUnderColorStoreProperty", "underColorProperty", "getUnderColorProperty", "overColorSetProperty", "getOverColorSetProperty", "setOverColorSetProperty", "overColorStoreProperty", "getOverColorStoreProperty", "setOverColorStoreProperty", "overColorProperty", "getOverColorProperty", "isInvertedProperty", "setInvertedProperty", "isInverted", "()Z", "setInverted", "(Z)V", "isInverted$delegate", "colorCountSetProperty", "getColorCountSetProperty", "setColorCountSetProperty", "colorCountProperty", "", "getColorCountProperty", "setColorCountProperty", "colorCount", "getColorCount", "()I", "setColorCount", "(I)V", "colorCount$delegate", "brightnessProperty", "getBrightnessProperty", "setBrightnessProperty", "brightness", "getBrightness", "setBrightness", "brightness$delegate", "saturationProperty", "getSaturationProperty", "setSaturationProperty", "saturation", "getSaturation", "setSaturation", "saturation$delegate", "alpha", "", "getAlpha", "()F", "setAlpha", "(F)V", "factory", "Lorg/mkui/color/MkColorFactory;", "intervalListener", "Lcom/macrofocus/common/interval/IntervalListener;", "paletteListener", "Lorg/mkui/palette/PaletteListener;", "getColor", "value", "(Ljava/lang/Object;)Ljava/awt/Color;", "arrayToString", "", "array", "", "([Ljava/lang/Object;)Ljava/lang/String;", "lowestFraction", "", "getLowestFraction", "()D", "highestFraction", "getHighestFraction", "setMatching", "", "matching", "setAssignments", "assignments", "underflowColor", "getUnderflowColor", "setUnderColor", "underColor", "overflowColor", "getOverflowColor", "setOverColor", "overColor", "isOverflowColorSet", "isUnderflowColorSet", "assignColors", "([Ljava/lang/Object;)V", "", "setColor", "color", "(Ljava/lang/Object;Ljava/awt/Color;)V", "clearAssignedColor", "assignedValues", "getAssignedValues", "()Ljava/util/Set;", "resetAssignedValues", "setProperty", "property", "toString", "mkui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSimpleColorMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleColorMap.kt\norg/mkui/colormap/SimpleColorMap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,573:1\n1#2:574\n*E\n"})
public final class SimpleColorMap
extends AbstractColorMap
implements MutableColorMap {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final MutableProperties<AbstractColorMap.PropertyType> properties;
    @Nullable
    private MutableInterval interval;
    @NotNull
    private MutableProperty<MutablePalette> paletteProperty;
    @NotNull
    private final ReadWriteProperty palette$delegate;
    @NotNull
    private final HashMap<Object, Color> dictionary;
    @NotNull
    private Matching _matching;
    @NotNull
    private Assignments _assignments;
    @NotNull
    private final MutableProperty<Color> nullColorProperty;
    @NotNull
    private final ReadWriteProperty nullColor$delegate;
    @NotNull
    private MutableProperty<Boolean> underColorSetProperty;
    @NotNull
    private MutableProperty<Color> underColorStoreProperty;
    @NotNull
    private final MutableProperty<Color> underColorProperty;
    @NotNull
    private MutableProperty<Boolean> overColorSetProperty;
    @NotNull
    private MutableProperty<Color> overColorStoreProperty;
    @NotNull
    private final MutableProperty<Color> overColorProperty;
    @NotNull
    private MutableProperty<Boolean> isInvertedProperty;
    @NotNull
    private final ReadWriteProperty isInverted$delegate;
    @NotNull
    private MutableProperty<Boolean> colorCountSetProperty;
    @NotNull
    private MutableProperty<Integer> colorCountProperty;
    @NotNull
    private final ReadWriteProperty colorCount$delegate;
    @NotNull
    private MutableProperty<Integer> brightnessProperty;
    @NotNull
    private final ReadWriteProperty brightness$delegate;
    @NotNull
    private MutableProperty<Integer> saturationProperty;
    @NotNull
    private final ReadWriteProperty saturation$delegate;
    private float alpha;
    @NotNull
    private final MkColorFactory factory;
    @NotNull
    private final IntervalListener intervalListener;
    @NotNull
    private final PaletteListener paletteListener;
    public static final int $stable;

    private SimpleColorMap() {
        this.properties = (MutableProperties)new EnumProperties((Enum[])AbstractColorMap.PropertyType.values());
        this.paletteProperty = this.properties.createProperty((Object)AbstractColorMap.PropertyType.Palette, null);
        this.palette$delegate = PropertyDelegates.INSTANCE.mutable(this.getPaletteProperty());
        this._matching = Matching.EXACT;
        this._assignments = Assignments.STATIC;
        this.nullColorProperty = this.properties.createProperty((Object)AbstractColorMap.PropertyType.MissingValuesColor, null);
        this.nullColor$delegate = PropertyDelegates.INSTANCE.mutable(this.getNullColorProperty());
        this.underColorSetProperty = (MutableProperty)new SimpleProperty((Object)false);
        this.underColorStoreProperty = (MutableProperty)new SimpleProperty(null);
        this.underColorProperty = this.properties.addProperty((Object)AbstractColorMap.PropertyType.UnderflowColor, (MutableProperty)new SetStoreMutableProperty(this.getUnderColorSetProperty(), this.getUnderColorStoreProperty(), this.getPaletteProperty(), 0.0));
        this.overColorSetProperty = (MutableProperty)new SimpleProperty((Object)false);
        this.overColorStoreProperty = (MutableProperty)new SimpleProperty(null);
        this.overColorProperty = this.properties.addProperty((Object)AbstractColorMap.PropertyType.OverflowColor, (MutableProperty)new SetStoreMutableProperty(this.getOverColorSetProperty(), this.getOverColorStoreProperty(), this.getPaletteProperty(), 1.0));
        this.isInvertedProperty = this.properties.createProperty((Object)AbstractColorMap.PropertyType.Inverted, (Object)false);
        this.isInverted$delegate = PropertyDelegates.INSTANCE.mutable(this.isInvertedProperty());
        this.colorCountSetProperty = (MutableProperty)new SimpleProperty((Object)false);
        this.colorCountProperty = this.properties.createProperty((Object)AbstractColorMap.PropertyType.NumberOfSteps, (Object)3);
        this.colorCount$delegate = PropertyDelegates.INSTANCE.mutable(this.getColorCountProperty());
        this.brightnessProperty = this.properties.createProperty((Object)AbstractColorMap.PropertyType.Brightness, (Object)0);
        this.brightness$delegate = PropertyDelegates.INSTANCE.mutable(this.getBrightnessProperty());
        this.saturationProperty = this.properties.createProperty((Object)AbstractColorMap.PropertyType.Saturation, (Object)0);
        this.saturation$delegate = PropertyDelegates.INSTANCE.mutable(this.getSaturationProperty());
        this.alpha = 1.0f;
        this.factory = MkColorFactory.Companion.getInstance();
        this.intervalListener = new IntervalListener(this){
            final /* synthetic */ SimpleColorMap this$0;
            {
                this.this$0 = $receiver;
            }

            public void intervalChanged(IntervalEvent event2) {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                this.this$0.notifyColorMapChanged(new ColorMapEvent(this.this$0, "inverval", null, null));
            }
        };
        this.paletteListener = new PaletteListener(this){
            final /* synthetic */ SimpleColorMap this$0;
            {
                this.this$0 = $receiver;
            }

            public void paletteChanged(PaletteEvent event2) {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                this.this$0.notifyColorMapChanged(new ColorMapEvent(this.this$0, "palette", null, null));
            }
        };
        this.properties.createProperty((Object)AbstractColorMap.PropertyType.Inverval, null);
        this.properties.createProperty((Object)AbstractColorMap.PropertyType.Matching, (Object)Matching.EXACT);
        this.properties.createProperty((Object)AbstractColorMap.PropertyType.Assignments, (Object)Assignments.STATIC);
        this.getPaletteProperty().addPropertyListener((PropertyListener)new PropertyListener<MutablePalette>(){

            public void propertyChanged(PropertyEvent<MutablePalette> event2) {
                Intrinsics.checkNotNullParameter(event2, (String)"event");
                if (event2.getOldValue() != null) {
                    Object object = event2.getOldValue();
                    Intrinsics.checkNotNull((Object)object);
                    ((MutablePalette)object).removePaletteListener(paletteListener);
                }
                if (event2.getNewValue() != null) {
                    Object object = event2.getNewValue();
                    Intrinsics.checkNotNull((Object)object);
                    ((MutablePalette)object).addPaletteListener(paletteListener);
                }
                this.notifyColorMapChanged(new ColorMapEvent(this, "palette", event2.getOldValue(), event2.getNewValue()));
            }
        });
        this.isInvertedProperty().addPropertyListener((PropertyListener)new PropertyListener<Boolean>(){

            public void propertyChanged(PropertyEvent<Boolean> event2) {
                Intrinsics.checkNotNullParameter(event2, (String)"event");
                this.notifyColorMapChanged(new ColorMapEvent(this, "inverted", event2.getOldValue(), event2.getNewValue()));
            }
        });
        this.getBrightnessProperty().addPropertyListener((PropertyListener)new PropertyListener<Integer>(){

            public void propertyChanged(PropertyEvent<Integer> event2) {
                Intrinsics.checkNotNullParameter(event2, (String)"event");
                this.notifyColorMapChanged(new ColorMapEvent(this, "brightness", event2.getOldValue(), event2.getNewValue()));
            }
        });
        this.getSaturationProperty().addPropertyListener((PropertyListener)new PropertyListener<Integer>(){

            public void propertyChanged(PropertyEvent<Integer> event2) {
                Intrinsics.checkNotNullParameter(event2, (String)"event");
                this.notifyColorMapChanged(new ColorMapEvent(this, "saturation", event2.getOldValue(), event2.getNewValue()));
            }
        });
        this.getOverColorProperty().addPropertyListener((PropertyListener)new PropertyListener<Color>(){

            public void propertyChanged(PropertyEvent<Color> event2) {
                Intrinsics.checkNotNullParameter(event2, (String)"event");
                this.notifyColorMapChanged(new ColorMapEvent(this, "overflowColor", event2.getOldValue(), event2.getNewValue()));
            }
        });
        this.getUnderColorProperty().addPropertyListener((PropertyListener)new PropertyListener<Color>(){

            public void propertyChanged(PropertyEvent<Color> event2) {
                Intrinsics.checkNotNullParameter(event2, (String)"event");
                this.notifyColorMapChanged(new ColorMapEvent(this, "underflowColor", event2.getOldValue(), event2.getNewValue()));
            }
        });
        this.getNullColorProperty().addPropertyListener((PropertyListener)new PropertyListener<Color>(){

            public void propertyChanged(PropertyEvent<Color> event2) {
                Intrinsics.checkNotNullParameter(event2, (String)"event");
                this.notifyColorMapChanged(new ColorMapEvent(this, "missingValuesColor", event2.getOldValue(), event2.getNewValue()));
            }
        });
        this.getColorCountSetProperty().addPropertyListener((PropertyListener)new PropertyListener<Boolean>(){

            public void propertyChanged(PropertyEvent<Boolean> event2) {
                Intrinsics.checkNotNullParameter(event2, (String)"event");
                this.notifyColorMapChanged(new ColorMapEvent(this, "numberOfSteps", event2.getOldValue(), event2.getNewValue()));
            }
        });
        this.getColorCountProperty().addPropertyListener((PropertyListener)new PropertyListener<Integer>(){

            public void propertyChanged(PropertyEvent<Integer> event2) {
                Intrinsics.checkNotNullParameter(event2, (String)"event");
                this.notifyColorMapChanged(new ColorMapEvent(this, "numberOfSteps", event2.getOldValue(), event2.getNewValue()));
            }
        });
        this.getNullColorProperty().setValue((Object)this.factory.getGray());
        this.dictionary = new HashMap();
    }

    @NotNull
    protected final MutableProperties<AbstractColorMap.PropertyType> getProperties() {
        return this.properties;
    }

    @Override
    @Nullable
    public MutableInterval getInterval() {
        return this.interval;
    }

    @Override
    public void setInterval(@Nullable MutableInterval interval) {
        if (this.interval != interval) {
            MutableInterval old = this.getInterval();
            if (this.interval != null) {
                MutableInterval mutableInterval = this.interval;
                Intrinsics.checkNotNull((Object)mutableInterval);
                mutableInterval.removeIntervalListener(this.intervalListener);
            }
            this.interval = interval;
            if (this.interval != null) {
                MutableInterval mutableInterval = this.interval;
                Intrinsics.checkNotNull((Object)mutableInterval);
                mutableInterval.addIntervalListener(this.intervalListener);
            }
            this.notifyColorMapChanged(new ColorMapEvent(this, "inverval", old, interval));
        }
    }

    @Override
    @NotNull
    public MutableProperty<MutablePalette> getPaletteProperty() {
        return this.paletteProperty;
    }

    public void setPaletteProperty(@NotNull MutableProperty<MutablePalette> mutableProperty) {
        Intrinsics.checkNotNullParameter(mutableProperty, (String)"<set-?>");
        this.paletteProperty = mutableProperty;
    }

    @Override
    @Nullable
    public MutablePalette getPalette() {
        return (MutablePalette)this.palette$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Override
    public void setPalette(@Nullable MutablePalette mutablePalette) {
        this.palette$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)mutablePalette);
    }

    @Override
    @NotNull
    public MutableProperty<Color> getNullColorProperty() {
        return this.nullColorProperty;
    }

    @Override
    @Nullable
    public Color getNullColor() {
        return (Color)this.nullColor$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Override
    public void setNullColor(@Nullable Color color) {
        this.nullColor$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)color);
    }

    @Override
    @NotNull
    public MutableProperty<Boolean> getUnderColorSetProperty() {
        return this.underColorSetProperty;
    }

    public void setUnderColorSetProperty(@NotNull MutableProperty<Boolean> mutableProperty) {
        Intrinsics.checkNotNullParameter(mutableProperty, (String)"<set-?>");
        this.underColorSetProperty = mutableProperty;
    }

    @Override
    @NotNull
    public MutableProperty<Color> getUnderColorStoreProperty() {
        return this.underColorStoreProperty;
    }

    public void setUnderColorStoreProperty(@NotNull MutableProperty<Color> mutableProperty) {
        Intrinsics.checkNotNullParameter(mutableProperty, (String)"<set-?>");
        this.underColorStoreProperty = mutableProperty;
    }

    @Override
    @NotNull
    public MutableProperty<Color> getUnderColorProperty() {
        return this.underColorProperty;
    }

    @Override
    @NotNull
    public MutableProperty<Boolean> getOverColorSetProperty() {
        return this.overColorSetProperty;
    }

    public void setOverColorSetProperty(@NotNull MutableProperty<Boolean> mutableProperty) {
        Intrinsics.checkNotNullParameter(mutableProperty, (String)"<set-?>");
        this.overColorSetProperty = mutableProperty;
    }

    @Override
    @NotNull
    public MutableProperty<Color> getOverColorStoreProperty() {
        return this.overColorStoreProperty;
    }

    public void setOverColorStoreProperty(@NotNull MutableProperty<Color> mutableProperty) {
        Intrinsics.checkNotNullParameter(mutableProperty, (String)"<set-?>");
        this.overColorStoreProperty = mutableProperty;
    }

    @Override
    @NotNull
    public MutableProperty<Color> getOverColorProperty() {
        return this.overColorProperty;
    }

    @Override
    @NotNull
    public MutableProperty<Boolean> isInvertedProperty() {
        return this.isInvertedProperty;
    }

    public void setInvertedProperty(@NotNull MutableProperty<Boolean> mutableProperty) {
        Intrinsics.checkNotNullParameter(mutableProperty, (String)"<set-?>");
        this.isInvertedProperty = mutableProperty;
    }

    @Override
    public boolean isInverted() {
        return (Boolean)this.isInverted$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    public void setInverted(boolean bl) {
        this.isInverted$delegate.setValue((Object)this, $$delegatedProperties[2], (Object)bl);
    }

    @Override
    @NotNull
    public MutableProperty<Boolean> getColorCountSetProperty() {
        return this.colorCountSetProperty;
    }

    public void setColorCountSetProperty(@NotNull MutableProperty<Boolean> mutableProperty) {
        Intrinsics.checkNotNullParameter(mutableProperty, (String)"<set-?>");
        this.colorCountSetProperty = mutableProperty;
    }

    @Override
    @NotNull
    public MutableProperty<Integer> getColorCountProperty() {
        return this.colorCountProperty;
    }

    public void setColorCountProperty(@NotNull MutableProperty<Integer> mutableProperty) {
        Intrinsics.checkNotNullParameter(mutableProperty, (String)"<set-?>");
        this.colorCountProperty = mutableProperty;
    }

    @Override
    public int getColorCount() {
        return ((Number)this.colorCount$delegate.getValue((Object)this, $$delegatedProperties[3])).intValue();
    }

    public void setColorCount(int n) {
        this.colorCount$delegate.setValue((Object)this, $$delegatedProperties[3], (Object)n);
    }

    @Override
    @NotNull
    public MutableProperty<Integer> getBrightnessProperty() {
        return this.brightnessProperty;
    }

    public void setBrightnessProperty(@NotNull MutableProperty<Integer> mutableProperty) {
        Intrinsics.checkNotNullParameter(mutableProperty, (String)"<set-?>");
        this.brightnessProperty = mutableProperty;
    }

    @Override
    public int getBrightness() {
        return ((Number)this.brightness$delegate.getValue((Object)this, $$delegatedProperties[4])).intValue();
    }

    @Override
    public void setBrightness(int n) {
        this.brightness$delegate.setValue((Object)this, $$delegatedProperties[4], (Object)n);
    }

    @Override
    @NotNull
    public MutableProperty<Integer> getSaturationProperty() {
        return this.saturationProperty;
    }

    public void setSaturationProperty(@NotNull MutableProperty<Integer> mutableProperty) {
        Intrinsics.checkNotNullParameter(mutableProperty, (String)"<set-?>");
        this.saturationProperty = mutableProperty;
    }

    @Override
    public int getSaturation() {
        return ((Number)this.saturation$delegate.getValue((Object)this, $$delegatedProperties[5])).intValue();
    }

    @Override
    public void setSaturation(int n) {
        this.saturation$delegate.setValue((Object)this, $$delegatedProperties[5], (Object)n);
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(float alpha) {
        if (!(this.alpha == alpha)) {
            float old = this.alpha;
            this.alpha = alpha;
            this.notifyColorMapChanged(new ColorMapEvent(this, "alpha", Float.valueOf(old), Float.valueOf(alpha)));
        }
    }

    public SimpleColorMap(@NotNull MutableInterval interval, @NotNull MutablePalette palette) {
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
        this();
        this.setInterval(interval);
        this.setPalette(palette);
    }

    public SimpleColorMap(@Nullable Set<?> values, boolean cyclic, @NotNull MutablePalette palette) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
            this();
            this.setPalette(palette);
            Set<?> set = values;
            if (set == null) break block0;
            Set<?> it = set;
            boolean bl = false;
            this.assignColors(it, cyclic);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Color getColor(@Nullable Object value) {
        Color color = null;
        if (value != null) {
            if (value instanceof Color) {
                return (Color)value;
            }
            if (value instanceof Comparable && this.dictionary.containsKey(value)) {
                color = this.dictionary.get(value);
            } else if (value instanceof Number && this.getInterval() != null) {
                int colorCount;
                double v = ((Number)value).doubleValue();
                double fraction = 0.0;
                MutableInterval mutableInterval = this.getInterval();
                Intrinsics.checkNotNull((Object)mutableInterval);
                if (!mutableInterval.isDegenerate()) {
                    MutableInterval mutableInterval2 = this.getInterval();
                    Intrinsics.checkNotNull((Object)mutableInterval2);
                    double d = v - mutableInterval2.getStart();
                    MutableInterval mutableInterval3 = this.getInterval();
                    Intrinsics.checkNotNull((Object)mutableInterval3);
                    v4 = d / mutableInterval3.getExtent();
                } else {
                    v4 = fraction = 0.5;
                }
                if (this.isInverted()) {
                    fraction = 1.0 - fraction;
                }
                if (fraction < this.getLowestFraction()) {
                    return this.getUnderflowColor();
                }
                if (fraction > this.getHighestFraction()) {
                    return this.getOverflowColor();
                }
                int n = colorCount = (Boolean)this.getColorCountSetProperty().getValue() != false ? this.getColorCount() : 0;
                if (colorCount > 0) {
                    fraction = colorCount > 1 ? (double)((int)(fraction * (double)colorCount)) / (double)(colorCount - 1) : 0.5;
                }
                Object object = this.getPaletteProperty().getValue();
                Intrinsics.checkNotNull((Object)object);
                color = ((MutablePalette)object).getColor(fraction);
            } else if (value instanceof Object[]) {
                String str = this.arrayToString((Object[])value);
                color = this.dictionary.containsKey(str) ? this.dictionary.get(str) : this.getNullColor();
            } else {
                Color color2;
                if (this._assignments == Assignments.DYNAMIC) {
                    void var3_5;
                    Object object = this.getPaletteProperty().getValue();
                    Intrinsics.checkNotNull((Object)object);
                    MutablePalette mutablePalette = (MutablePalette)object;
                    int n = this.dictionary.size();
                    Object object2 = this.getPaletteProperty().getValue();
                    Intrinsics.checkNotNull((Object)object2);
                    Color c2 = mutablePalette.getColorAt(n % ((MutablePalette)object2).getColorCount());
                    this.dictionary.put(value, c2);
                    color2 = var3_5;
                } else {
                    color2 = this.getNullColor();
                }
                color = color2;
            }
        } else {
            color = this.getNullColor();
        }
        if (color != null && (((Number)this.getBrightnessProperty().getValue()).intValue() != 0 || ((Number)this.getSaturationProperty().getValue()).intValue() != 0)) {
            color = MkColor2.brightenAndSaturate(color, ((Number)this.getBrightnessProperty().getValue()).floatValue() / 300.0f, ((Number)this.getSaturationProperty().getValue()).floatValue() / 300.0f);
        }
        if (color != null && !(this.getAlpha() == 1.0f)) {
            color = MkColor2.alpha(color, this.getAlpha());
        }
        return color;
    }

    private final String arrayToString(Object[] array) {
        Object str = "";
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            Object v = array[i];
            if (v != null) {
                str = (String)str + v;
            }
            if (i >= array.length - 1) continue;
            str = (String)str + "/";
        }
        return str;
    }

    protected final double getLowestFraction() {
        if (this.getPaletteProperty().getValue() instanceof InterpolatedPalette) {
            Object object = this.getPaletteProperty().getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.mkui.palette.InterpolatedPalette");
            Set<InterpolatedPalette.Entry> set = ((InterpolatedPalette)object).getEntries();
            Intrinsics.checkNotNull(set, (String)"null cannot be cast to non-null type com.macrofocus.common.collection.SortedSet<org.mkui.palette.InterpolatedPalette.Entry>");
            SortedSet entries = (SortedSet)set;
            if (!entries.isEmpty()) {
                return ((InterpolatedPalette.Entry)CollectionsKt.first((Iterable)((Iterable)entries))).getFraction();
            }
        } else if (this.getPaletteProperty().getValue() instanceof CustomPalette) {
            MutablePalette mutablePalette = this.getPalette();
            Intrinsics.checkNotNull((Object)mutablePalette, (String)"null cannot be cast to non-null type org.mkui.palette.CustomPalette");
            Set<CustomPalette.Entry> set = ((CustomPalette)mutablePalette).getEntries();
            Intrinsics.checkNotNull(set, (String)"null cannot be cast to non-null type com.macrofocus.common.collection.SortedSet<org.mkui.palette.CustomPalette.Entry>");
            SortedSet entries = (SortedSet)set;
            if (!entries.isEmpty()) {
                return ((CustomPalette.Entry)CollectionsKt.first((Iterable)((Iterable)entries))).getFraction();
            }
        }
        return 0.0;
    }

    protected final double getHighestFraction() {
        if (this.getPaletteProperty().getValue() instanceof InterpolatedPalette) {
            Object object = this.getPaletteProperty().getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.mkui.palette.InterpolatedPalette");
            Set<InterpolatedPalette.Entry> set = ((InterpolatedPalette)object).getEntries();
            Intrinsics.checkNotNull(set, (String)"null cannot be cast to non-null type com.macrofocus.common.collection.SortedSet<org.mkui.palette.InterpolatedPalette.Entry>");
            SortedSet entries = (SortedSet)set;
            if (!entries.isEmpty()) {
                return ((InterpolatedPalette.Entry)CollectionsKt.last((Iterable)((Iterable)entries))).getFraction();
            }
        } else if (this.getPaletteProperty().getValue() instanceof CustomPalette) {
            MutablePalette mutablePalette = this.getPalette();
            Intrinsics.checkNotNull((Object)mutablePalette, (String)"null cannot be cast to non-null type org.mkui.palette.CustomPalette");
            Set<CustomPalette.Entry> set = ((CustomPalette)mutablePalette).getEntries();
            Intrinsics.checkNotNull(set, (String)"null cannot be cast to non-null type com.macrofocus.common.collection.SortedSet<org.mkui.palette.CustomPalette.Entry>");
            SortedSet entries = (SortedSet)set;
            if (!entries.isEmpty()) {
                return ((CustomPalette.Entry)CollectionsKt.last((Iterable)((Iterable)entries))).getFraction();
            }
        }
        return 1.0;
    }

    @Override
    public void setMatching(@Nullable Matching matching) {
        if (this._matching != matching) {
            Matching old = this._matching;
            Matching matching2 = matching;
            Intrinsics.checkNotNull((Object)((Object)matching2));
            this._matching = matching2;
            this.notifyColorMapChanged(new ColorMapEvent(this, "matching", (Object)old, (Object)matching));
        }
    }

    @Override
    public void setAssignments(@Nullable Assignments assignments) {
        if (this._assignments != assignments) {
            Assignments old = this._assignments;
            Assignments assignments2 = assignments;
            Intrinsics.checkNotNull((Object)((Object)assignments2));
            this._assignments = assignments2;
            this.notifyColorMapChanged(new ColorMapEvent(this, "assignments", (Object)old, (Object)assignments));
        }
    }

    @Override
    @NotNull
    public Color getUnderflowColor() {
        Object object = this.getUnderColorProperty().getValue();
        Intrinsics.checkNotNull((Object)object);
        return (Color)object;
    }

    @Override
    public void setUnderColor(@Nullable Color underColor) {
        if (!(Intrinsics.areEqual((Object)this.getUnderflowColor(), (Object)underColor) || this.getUnderflowColor() != null && Intrinsics.areEqual((Object)this.getUnderflowColor(), (Object)underColor))) {
            MutableProperty<Color> mutableProperty = this.getUnderColorProperty();
            Color color = underColor;
            Intrinsics.checkNotNull((Object)color);
            mutableProperty.setValue((Object)color);
        }
    }

    @Override
    @NotNull
    public Color getOverflowColor() {
        Object object = this.getOverColorStoreProperty().getValue();
        Intrinsics.checkNotNull((Object)object);
        return (Color)object;
    }

    @Override
    public void setOverColor(@Nullable Color overColor) {
        if (!(Intrinsics.areEqual((Object)this.getOverflowColor(), (Object)overColor) || this.getOverflowColor() != null && Intrinsics.areEqual((Object)this.getOverflowColor(), (Object)overColor))) {
            this.getOverColorStoreProperty().setValue((Object)overColor);
        }
    }

    @Override
    public boolean isOverflowColorSet() {
        return (Boolean)this.getOverColorSetProperty().getValue();
    }

    @Override
    public boolean isUnderflowColorSet() {
        return (Boolean)this.getUnderColorSetProperty().getValue();
    }

    @Override
    public void assignColors(@NotNull Set<?> values, boolean cyclic) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this.dictionary.clear();
        int i = 0;
        for (Object value : values) {
            Color color;
            Color color2 = null;
            if (!cyclic) {
                Object object = this.getPaletteProperty().getValue();
                Intrinsics.checkNotNull((Object)object);
                color = ((MutablePalette)object).getColor((double)i / (double)values.size());
            } else {
                Object object = this.getPaletteProperty().getValue();
                Intrinsics.checkNotNull((Object)object);
                MutablePalette mutablePalette = (MutablePalette)object;
                Object object2 = this.getPaletteProperty().getValue();
                Intrinsics.checkNotNull((Object)object2);
                color = mutablePalette.getColorAt(i % ((MutablePalette)object2).getColorCount());
            }
            color2 = color;
            Object v = null;
            v = value instanceof Object[] ? this.arrayToString((Object[])value) : value;
            Color color3 = color2;
            Intrinsics.checkNotNull((Object)color3);
            this.dictionary.put(v, color3);
            ++i;
        }
        this.notifyColorMapChanged(new ColorMapEvent(this, "assignments", null, null));
    }

    @Override
    public void assignColors(Object ... values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this.dictionary.clear();
        int i = 0;
        for (Object value : values) {
            if (this.dictionary.containsKey(value)) continue;
            Object object = this.getPaletteProperty().getValue();
            Intrinsics.checkNotNull((Object)object);
            MutablePalette mutablePalette = (MutablePalette)object;
            Object object2 = this.getPaletteProperty().getValue();
            Intrinsics.checkNotNull((Object)object2);
            this.dictionary.put(value, mutablePalette.getColorAt(i % ((MutablePalette)object2).getColorCount()));
            ++i;
        }
        this.notifyColorMapChanged(new ColorMapEvent(this, "assignments", null, null));
    }

    @Override
    public void assignColors(@NotNull Iterable<? extends Object> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this.dictionary.clear();
        int i = 0;
        for (Object object : values) {
            if (this.dictionary.containsKey(object)) continue;
            Object object2 = this.getPaletteProperty().getValue();
            Intrinsics.checkNotNull((Object)object2);
            MutablePalette mutablePalette = (MutablePalette)object2;
            Object object3 = this.getPaletteProperty().getValue();
            Intrinsics.checkNotNull((Object)object3);
            this.dictionary.put(object, mutablePalette.getColorAt(i % ((MutablePalette)object3).getColorCount()));
            ++i;
        }
        this.notifyColorMapChanged(new ColorMapEvent(this, "assignments", null, null));
    }

    @Override
    public void setColor(@Nullable Object value, @Nullable Color color) {
        Color color2 = color;
        Intrinsics.checkNotNull((Object)color2);
        this.dictionary.put(value, color2);
        this.notifyColorMapChanged(new ColorMapEvent(this, "assignments", null, null));
    }

    @Override
    public void clearAssignedColor() {
        this.dictionary.clear();
        this.notifyColorMapChanged(new ColorMapEvent(this, "assignments", null, null));
    }

    @Override
    @NotNull
    public Set<Object> getAssignedValues() {
        Set<Object> set = this.dictionary.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        return set;
    }

    @Override
    public void resetAssignedValues() {
        Set set = (Set)new SortedSet((Comparator)new UniversalComparator(), null, 2, null);
        Set<Object> set2 = this.dictionary.keySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-keys>(...)");
        set.addAll((Collection)set2);
        this.assignColors(set, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setProperty(@Nullable String property, @Nullable Object value) {
        String string = property;
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case -230491182: {
                    if (!string.equals("saturation")) break;
                    n = 1;
                    break;
                }
                case 1749373766: {
                    if (!string.equals("assignments")) break;
                    n = 2;
                    break;
                }
                case 648162385: {
                    if (!string.equals("brightness")) break;
                    n = 3;
                    break;
                }
                case -469157123: {
                    if (!string.equals("underflowColor")) break;
                    n = 4;
                    break;
                }
                case -1323103225: {
                    if (!string.equals("numberOfSteps")) break;
                    n = 5;
                    break;
                }
                case 92909918: {
                    if (!string.equals("alpha")) break;
                    n = 6;
                    break;
                }
                case 627676675: {
                    if (!string.equals("inverval")) break;
                    n = 7;
                    break;
                }
                case -798910853: {
                    if (!string.equals("palette")) break;
                    n = 8;
                    break;
                }
                case 627674869: {
                    if (!string.equals("inverted")) break;
                    n = 9;
                    break;
                }
                case 581745793: {
                    if (!string.equals("overflowColor")) break;
                    n = 10;
                    break;
                }
                case -184159717: {
                    if (!string.equals("missingValuesColor")) break;
                    n = 11;
                    break;
                }
                case 296922109: {
                    if (!string.equals("matching")) break;
                    n = 12;
                    break;
                }
            }
            switch (n) {
                case 7: {
                    Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.macrofocus.common.interval.MutableInterval");
                    this.setInterval((MutableInterval)value);
                    return;
                }
                case 8: {
                    Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type org.mkui.palette.MutablePalette");
                    this.setPalette((MutablePalette)value);
                    return;
                }
                case 12: {
                    Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type org.mkui.colormap.Matching");
                    this.setMatching((Matching)((Object)value));
                    return;
                }
                case 2: {
                    Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type org.mkui.colormap.Assignments");
                    this.setAssignments((Assignments)((Object)value));
                    return;
                }
                case 11: {
                    Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type java.awt.Color");
                    this.setNullColor((Color)value);
                    return;
                }
                case 4: {
                    Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type java.awt.Color");
                    this.setUnderColor((Color)value);
                    return;
                }
                case 10: {
                    Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type java.awt.Color");
                    this.setOverColor((Color)value);
                    return;
                }
                case 9: {
                    Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Boolean");
                    this.setInverted((Boolean)value);
                    return;
                }
                case 5: {
                    Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Int");
                    this.setColorCount((Integer)value);
                    return;
                }
                case 3: {
                    Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Int");
                    this.setBrightness((Integer)value);
                    return;
                }
                case 1: {
                    Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Int");
                    this.setSaturation((Integer)value);
                    return;
                }
                case 6: {
                    Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Float");
                    this.setAlpha(((Float)value).floatValue());
                    return;
                }
            }
        }
        System.out.println((Object)("Unknonw property " + property));
    }

    @NotNull
    public String toString() {
        return "SimpleColorMap{interval=" + this.getInterval() + ", palette=" + this.getPalette() + ", nullColor=" + this.getNullColor() + ", underColor=" + this.getUnderColorProperty() + "}";
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(SimpleColorMap.class, "palette", "getPalette()Lorg/mkui/palette/MutablePalette;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(SimpleColorMap.class, "nullColor", "getNullColor()Ljava/awt/Color;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(SimpleColorMap.class, "isInverted", "isInverted()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(SimpleColorMap.class, "colorCount", "getColorCount()I", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(SimpleColorMap.class, "brightness", "getBrightness()I", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(SimpleColorMap.class, "saturation", "getSaturation()I", 0)))};
        $$delegatedProperties = kPropertyArray;
        $stable = 8;
    }
}

