/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.component.input;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.interval.IntervalEvent;
import com.macrofocus.common.interval.IntervalListener;
import com.macrofocus.common.interval.MutableBoundedInterval;
import java.util.EventListener;
import javax.swing.BoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 -2\u00020\u0001:\u0001-B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u000eH\u0016J\b\u0010\u0018\u001a\u00020\u000eH\u0016J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u000eH\u0016J\b\u0010\u001c\u001a\u00020\u0005H\u0016J\b\u0010\u001d\u001a\u00020\u000eH\u0016J\b\u0010\u001e\u001a\u00020\u000eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u000eH\u0016J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u000eH\u0016J\n\u0010#\u001a\u00020$H\u0096\u0080\u0004J0\u0010%\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\u0005H\u0016J\u0010\u0010)\u001a\u00020\u00102\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\u00102\u0006\u0010*\u001a\u00020+H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006."}, d2={"Lorg/mkui/component/input/BoundedIntervalAdapter;", "Ljavax/swing/BoundedRangeModel;", "boundedRangeModel", "Lcom/macrofocus/common/interval/MutableBoundedInterval;", "useExtent", "", "<init>", "(Lcom/macrofocus/common/interval/MutableBoundedInterval;Z)V", "listenerList", "Ljavax/swing/event/EventListenerList;", "changeEvent", "Ljavax/swing/event/ChangeEvent;", "isAdjusting", "adjustingValue", "", "fireStateChanged", "", "getMinimum", "multiplier", "", "getMultiplier", "()D", "setMinimum", "minimum", "getMaximum", "setValueIsAdjusting", "setMaximum", "maximum", "getValueIsAdjusting", "getValue", "getExtent", "setValue", "value", "setExtent", "extent", "toString", "", "setRangeProperties", "min", "max", "adjusting", "addChangeListener", "listener", "Ljavax/swing/event/ChangeListener;", "removeChangeListener", "Companion", "mkui"})
@StabilityInferred(parameters=0)
public final class BoundedIntervalAdapter
implements BoundedRangeModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MutableBoundedInterval boundedRangeModel;
    private final boolean useExtent;
    @NotNull
    private final EventListenerList listenerList;
    @Nullable
    private ChangeEvent changeEvent;
    private boolean isAdjusting;
    private int adjustingValue;
    public static final int $stable = 8;
    private static boolean isContinuousUpdate = true;

    public BoundedIntervalAdapter(@NotNull MutableBoundedInterval boundedRangeModel, boolean useExtent) {
        Intrinsics.checkNotNullParameter((Object)boundedRangeModel, (String)"boundedRangeModel");
        this.boundedRangeModel = boundedRangeModel;
        this.useExtent = useExtent;
        this.listenerList = new EventListenerList();
        this.boundedRangeModel.addIntervalListener(new IntervalListener(){

            public void intervalChanged(IntervalEvent event2) {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                this.fireStateChanged();
            }
        });
    }

    private final void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            Object object = listeners[i + 1];
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.event.ChangeListener");
            ((ChangeListener)object).stateChanged(this.changeEvent);
        }
    }

    @Override
    public int getMinimum() {
        return 0;
    }

    private final double getMultiplier() {
        return this.getMaximum() - this.getMinimum();
    }

    @Override
    public void setMinimum(int minimum) {
        this.boundedRangeModel.setMinimum((double)minimum / this.getMultiplier());
    }

    @Override
    public int getMaximum() {
        return 100;
    }

    @Override
    public void setValueIsAdjusting(boolean isAdjusting) {
        if (this.isAdjusting != isAdjusting) {
            this.isAdjusting = isAdjusting;
            if (!isAdjusting) {
                this.setValue(this.adjustingValue);
            }
        }
    }

    @Override
    public void setMaximum(int maximum) {
        this.boundedRangeModel.setMaximum((double)maximum / this.getMultiplier());
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.isAdjusting;
    }

    @Override
    public int getValue() {
        return (int)((this.boundedRangeModel.getStart() - this.boundedRangeModel.getMinimum()) * this.getMultiplier() / (this.boundedRangeModel.getMaximum() - this.boundedRangeModel.getMinimum()));
    }

    @Override
    public int getExtent() {
        return this.useExtent ? (int)(this.boundedRangeModel.getExtent() * this.getMultiplier() / (this.boundedRangeModel.getMaximum() - this.boundedRangeModel.getMinimum())) : 0;
    }

    @Override
    public void setValue(int value) {
        this.adjustingValue = value;
        if (!this.isAdjusting || isContinuousUpdate) {
            double newValue = (double)value * (this.boundedRangeModel.getMaximum() - this.boundedRangeModel.getMinimum()) / this.getMultiplier() + this.boundedRangeModel.getMinimum();
            if (newValue < this.boundedRangeModel.getMinimum()) {
                newValue = this.boundedRangeModel.getMinimum();
            }
            if (newValue > this.boundedRangeModel.getMaximum()) {
                newValue = this.boundedRangeModel.getMaximum();
            }
            this.boundedRangeModel.setStart(newValue);
        }
    }

    @Override
    public void setExtent(int extent) {
        if (this.useExtent) {
            double newValue = (double)extent * (this.boundedRangeModel.getMaximum() - this.boundedRangeModel.getMinimum()) / this.getMultiplier();
            this.boundedRangeModel.setStart(newValue);
        }
    }

    @NotNull
    public String toString() {
        return this.getClass().getName() + "[" + this.boundedRangeModel + "]";
    }

    @Override
    public void setRangeProperties(int value, int extent, int min, int max, boolean adjusting) {
        this.setValue(value);
        this.setExtent(extent);
        this.setMinimum(min);
        this.setMaximum(max);
        this.setValueIsAdjusting(adjusting);
    }

    @Override
    public void addChangeListener(@NotNull ChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listenerList.add(ChangeListener.class, (EventListener)listener2);
    }

    @Override
    public void removeChangeListener(@NotNull ChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listenerList.remove(ChangeListener.class, (EventListener)listener2);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/mkui/component/input/BoundedIntervalAdapter$Companion;", "", "<init>", "()V", "isContinuousUpdate", "", "()Z", "setContinuousUpdate", "(Z)V", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isContinuousUpdate() {
            return isContinuousUpdate;
        }

        public final void setContinuousUpdate(boolean bl) {
            isContinuousUpdate = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

