/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.geom;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.AffineTransform;
import org.mkui.geom.Line2D;
import org.mkui.geom.PathIterator;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\u0010\u0013\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u001d\u001a\u00020\u001eH\u0096\u0002J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\"H\u0016R\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0015R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001c\u00a8\u0006#"}, d2={"Lorg/mkui/geom/LineIterator;", "Lorg/mkui/geom/PathIterator;", "l", "Lorg/mkui/geom/Line2D;", "at", "Lorg/mkui/geom/AffineTransform;", "<init>", "(Lorg/mkui/geom/Line2D;Lorg/mkui/geom/AffineTransform;)V", "line", "getLine", "()Lorg/mkui/geom/Line2D;", "setLine", "(Lorg/mkui/geom/Line2D;)V", "affine", "getAffine", "()Lorg/mkui/geom/AffineTransform;", "setAffine", "(Lorg/mkui/geom/AffineTransform;)V", "index", "", "getIndex", "()I", "setIndex", "(I)V", "windingRule", "getWindingRule", "isDone", "", "()Z", "next", "", "currentSegment", "coords", "", "", "mkui"})
@StabilityInferred(parameters=0)
public final class LineIterator
implements PathIterator {
    @NotNull
    private Line2D line;
    @Nullable
    private AffineTransform affine;
    private int index;
    public static final int $stable = 8;

    public LineIterator(@NotNull Line2D l, @Nullable AffineTransform at) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.line = l;
        this.affine = at;
    }

    @NotNull
    public final Line2D getLine() {
        return this.line;
    }

    public final void setLine(@NotNull Line2D line2D) {
        Intrinsics.checkNotNullParameter((Object)line2D, (String)"<set-?>");
        this.line = line2D;
    }

    @Nullable
    public final AffineTransform getAffine() {
        return this.affine;
    }

    public final void setAffine(@Nullable AffineTransform affineTransform) {
        this.affine = affineTransform;
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int n) {
        this.index = n;
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public boolean isDone() {
        return this.index > 1;
    }

    @Override
    public void next() {
        int n = this.index;
        this.index = n + 1;
    }

    @Override
    public int currentSegment(@NotNull float[] coords) {
        Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
        if (this.isDone()) {
            throw new NoSuchElementException("line iterator out of bounds");
        }
        int type = 0;
        if (this.index == 0) {
            coords[0] = (float)this.line.getX1();
            coords[1] = (float)this.line.getY1();
            type = 0;
        } else {
            coords[0] = (float)this.line.getX2();
            coords[1] = (float)this.line.getY2();
            type = 1;
        }
        if (this.affine != null) {
            AffineTransform affineTransform = this.affine;
            Intrinsics.checkNotNull((Object)affineTransform);
            affineTransform.transform(coords, 0, coords, 0, 1);
        }
        return type;
    }

    @Override
    public int currentSegment(@NotNull double[] coords) {
        Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
        if (this.isDone()) {
            throw new NoSuchElementException("line iterator out of bounds");
        }
        int type = 0;
        if (this.index == 0) {
            coords[0] = this.line.getX1();
            coords[1] = this.line.getY1();
            type = 0;
        } else {
            coords[0] = this.line.getX2();
            coords[1] = this.line.getY2();
            type = 1;
        }
        if (this.affine != null) {
            AffineTransform affineTransform = this.affine;
            Intrinsics.checkNotNull((Object)affineTransform);
            affineTransform.transform(coords, 0, coords, 0, 1);
        }
        return type;
    }
}

