/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.geom.curve;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.curve.BinaryCurveApproximationAlgorithm;
import org.mkui.geom.curve.ControlPath;
import org.mkui.geom.curve.GroupIterator;
import org.mkui.geom.curve.MultiPath;
import org.mkui.geom.curve.ParametricCurve;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lorg/mkui/geom/curve/CardinalSpline;", "Lorg/mkui/geom/curve/ParametricCurve;", "cp", "Lorg/mkui/geom/curve/ControlPath;", "gi", "Lorg/mkui/geom/curve/GroupIterator;", "<init>", "(Lorg/mkui/geom/curve/ControlPath;Lorg/mkui/geom/curve/GroupIterator;)V", "alpha", "", "getAlpha", "()D", "setAlpha", "(D)V", "appendTo", "", "mp", "Lorg/mkui/geom/curve/MultiPath;", "eval", "p", "", "sampleLimit", "", "getSampleLimit", "()I", "Companion", "mkui"})
@StabilityInferred(parameters=0)
public final class CardinalSpline
extends ParametricCurve {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double alpha = 0.5;
    public static final int $stable = 8;
    @NotNull
    private static final double[][] pt = new double[4][];

    public CardinalSpline(@Nullable ControlPath cp, @Nullable GroupIterator gi) {
        super(cp, gi);
    }

    public final double getAlpha() {
        return this.alpha;
    }

    public final void setAlpha(double d) {
        this.alpha = d;
    }

    @Override
    public void appendTo(@NotNull MultiPath mp) {
        Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
        GroupIterator groupIterator = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator);
        ControlPath controlPath = this.getCp();
        Intrinsics.checkNotNull((Object)controlPath);
        if (!groupIterator.isInRange(0, controlPath.numPoints())) {
            return;
        }
        GroupIterator groupIterator2 = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator2);
        if (groupIterator2.getGroupSize() < 4) {
            return;
        }
        GroupIterator groupIterator3 = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator3);
        groupIterator3.set(0, 0);
        for (int i = 0; i < 4; ++i) {
            ControlPath controlPath2 = this.getCp();
            Intrinsics.checkNotNull((Object)controlPath2);
            GroupIterator groupIterator4 = this.getGi();
            Intrinsics.checkNotNull((Object)groupIterator4);
            CardinalSpline.pt[i] = controlPath2.getPoint(groupIterator4.next()).getLocation();
        }
        double[] d = new double[mp.getDimension() + 1];
        this.eval(d);
        if (this.getConnect()) {
            mp.lineTo(d);
        } else {
            mp.moveTo(d);
        }
        GroupIterator groupIterator5 = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator5);
        groupIterator5.set(0, 0);
        while (true) {
            GroupIterator groupIterator6 = this.getGi();
            Intrinsics.checkNotNull((Object)groupIterator6);
            int index_i = groupIterator6.index_i();
            GroupIterator groupIterator7 = this.getGi();
            Intrinsics.checkNotNull((Object)groupIterator7);
            int count_j = groupIterator7.count_j();
            for (int i = 0; i < 4; ++i) {
                GroupIterator groupIterator8 = this.getGi();
                Intrinsics.checkNotNull((Object)groupIterator8);
                if (!groupIterator8.hasNext()) {
                    return;
                }
                ControlPath controlPath3 = this.getCp();
                Intrinsics.checkNotNull((Object)controlPath3);
                GroupIterator groupIterator9 = this.getGi();
                Intrinsics.checkNotNull((Object)groupIterator9);
                CardinalSpline.pt[i] = controlPath3.getPoint(groupIterator9.next()).getLocation();
            }
            GroupIterator groupIterator10 = this.getGi();
            Intrinsics.checkNotNull((Object)groupIterator10);
            groupIterator10.set(index_i, count_j);
            GroupIterator groupIterator11 = this.getGi();
            Intrinsics.checkNotNull((Object)groupIterator11);
            groupIterator11.next();
            BinaryCurveApproximationAlgorithm.INSTANCE.genPts(this, 0.0, 1.0, mp);
        }
    }

    @Override
    public void eval(@NotNull double[] p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        double t = p[p.length - 1];
        double t2 = t * t;
        double t3 = t2 * t;
        double a = (double)2 * t3 - (double)3 * t2 + 1.0;
        double b = (double)-2 * t3 + (double)3 * t2;
        double c2 = this.alpha * (t3 - (double)2 * t2 + t);
        double d = this.alpha * (t3 - t2);
        int n = p.length - 1;
        for (int i = 0; i < n; ++i) {
            double[] dArray = pt[1];
            Intrinsics.checkNotNull((Object)dArray);
            double d2 = a * dArray[i];
            double[] dArray2 = pt[2];
            Intrinsics.checkNotNull((Object)dArray2);
            double d3 = d2 + b * dArray2[i];
            double[] dArray3 = pt[2];
            Intrinsics.checkNotNull((Object)dArray3);
            double d4 = dArray3[i];
            double[] dArray4 = pt[0];
            Intrinsics.checkNotNull((Object)dArray4);
            double d5 = d3 + c2 * (d4 - dArray4[i]);
            double[] dArray5 = pt[3];
            Intrinsics.checkNotNull((Object)dArray5);
            double d6 = dArray5[i];
            double[] dArray6 = pt[1];
            Intrinsics.checkNotNull((Object)dArray6);
            p[i] = d5 + d * (d6 - dArray6[i]);
        }
    }

    @Override
    public int getSampleLimit() {
        return 1;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/mkui/geom/curve/CardinalSpline$Companion;", "", "<init>", "()V", "pt", "", "", "[[D", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

