/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.labeling;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.PropertyEvent;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.BreakIterator;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.Timer;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.View;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.labeling.EnhancedLabel;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\b\u0017\u0018\u0000 B2\u00020\u0001:\u0002ABB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0013\b\u0016\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\u0004\u0010\bB\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\tJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0007J\u0012\u0010\u0015\u001a\u00020\u00122\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0014J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\u0010\u0010\u0017\u001a\u00020\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\n\u00108\u001a\u0004\u0018\u000109H\u0016J\u0012\u0010:\u001a\u00020\u00122\b\u0010;\u001a\u0004\u0018\u000109H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR(\u0010 \u001a\u0004\u0018\u00010!2\b\u0010 \u001a\u0004\u0018\u00010!8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R(\u0010&\u001a\u0004\u0018\u00010'2\b\u0010&\u001a\u0004\u0018\u00010'8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R$\u0010.\u001a\u00020-2\u0006\u0010,\u001a\u00020-8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R$\u00102\u001a\u0002032\u0006\u00102\u001a\u0002038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b4\u00105\"\u0004\b6\u00107R$\u0010<\u001a\u00020\r2\u0006\u0010<\u001a\u00020\r8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@\u00a8\u0006C"}, d2={"Lorg/mkui/labeling/EnhancedJLabel;", "Ljavax/swing/JLabel;", "data", "Lorg/mkui/labeling/EnhancedLabel;", "<init>", "(Lorg/mkui/labeling/EnhancedLabel;)V", "text", "", "(Ljava/lang/String;)V", "()V", "propertiesListener", "Lcom/macrofocus/common/properties/PropertiesListener;", "getMinimumSize", "Ljava/awt/Dimension;", "g2", "Ljava/awt/Graphics2D;", "getPreferredSize", "setData", "", "addTag", "value", "unregisterListener", "registerListener", "setEffect", "effect", "Lorg/mkui/labeling/EnhancedLabel$Effect;", "effectOpacity", "", "getEffectOpacity", "()F", "setEffectOpacity", "(F)V", "rendering", "Lorg/mkui/labeling/EnhancedLabel$Rendering;", "getRendering", "()Lorg/mkui/labeling/EnhancedLabel$Rendering;", "setRendering", "(Lorg/mkui/labeling/EnhancedLabel$Rendering;)V", "minimumCharactersToDisplay", "", "getMinimumCharactersToDisplay", "()Ljava/lang/Integer;", "setMinimumCharactersToDisplay", "(Ljava/lang/Integer;)V", "justified", "", "isJustified", "()Z", "setJustified", "(Z)V", "angle", "", "getAngle", "()D", "setAngle", "(D)V", "getFont", "Ljava/awt/Font;", "setFont", "font", "desiredSize", "getDesiredSize", "()Ljava/awt/Dimension;", "setDesiredSize", "(Ljava/awt/Dimension;)V", "EnhancedLabelUI", "Companion", "mkui"})
@StabilityInferred(parameters=0)
public class EnhancedJLabel
extends JLabel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private EnhancedLabel data;
    @Nullable
    private PropertiesListener<String> propertiesListener;
    public static final int $stable = 8;

    public EnhancedJLabel(@NotNull EnhancedLabel data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.setUI(new EnhancedLabelUI());
        this.setData(data);
    }

    public EnhancedJLabel(@Nullable String text) {
        this();
        this.setText(text);
    }

    public EnhancedJLabel() {
        this(new EnhancedLabel());
        this.setUI(new EnhancedLabelUI());
    }

    @NotNull
    public final Dimension getMinimumSize(@NotNull Graphics2D g2) {
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        ComponentUI componentUI = this.ui;
        Intrinsics.checkNotNull((Object)componentUI, (String)"null cannot be cast to non-null type org.mkui.labeling.EnhancedJLabel.EnhancedLabelUI");
        return ((EnhancedLabelUI)componentUI).getMinimumSize(g2, this);
    }

    @NotNull
    public final Dimension getPreferredSize(@NotNull Graphics2D g2) {
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        ComponentUI componentUI = this.ui;
        Intrinsics.checkNotNull((Object)componentUI, (String)"null cannot be cast to non-null type org.mkui.labeling.EnhancedJLabel.EnhancedLabelUI");
        return ((EnhancedLabelUI)componentUI).getPreferredSize(g2, this);
    }

    public final void setData(@NotNull EnhancedLabel data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.unregisterListener(this.data);
        this.data = data;
        if (data.isHTML()) {
            super.setText(this.addTag(data.getText()));
        } else {
            super.setText(data.getText());
        }
        super.setVerticalAlignment(data.getVerticalAlignment());
        super.setHorizontalAlignment(data.getHorizontalAlignment());
        if (data.getFont() != null) {
            Font font = data.getFont();
            Intrinsics.checkNotNull((Object)font);
            super.setFont(font);
        }
        if (data.getForeground() != null) {
            Color color = data.getForeground();
            Intrinsics.checkNotNull((Object)color);
            super.setForeground(color);
        }
        if (data.getBackground() != null) {
            Color color = data.getBackground();
            Intrinsics.checkNotNull((Object)color);
            super.setBackground(color);
        }
        super.setBorder(BorderFactory.createEmptyBorder(data.getInsetTop(), data.getInsetLeft(), data.getInsetBottom(), data.getInsetRight()));
        this.registerListener(data);
    }

    @Nullable
    public final String addTag(@Nullable String value) {
        return value != null ? (!StringsKt.startsWith$default((String)value, (String)"<html>", (boolean)false, (int)2, null) ? "<html>" + value + "</html>" : value) : null;
    }

    protected void unregisterListener(@Nullable EnhancedLabel data) {
        if (data != null) {
            MutableProperties<String> mutableProperties = data.getProperties();
            PropertiesListener<String> propertiesListener = this.propertiesListener;
            Intrinsics.checkNotNull(propertiesListener);
            mutableProperties.removePropertiesListener(propertiesListener);
        }
    }

    protected void registerListener(@NotNull EnhancedLabel data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (this.propertiesListener == null) {
            this.propertiesListener = (PropertiesListener)new PropertiesListener<String>(this){
                final /* synthetic */ EnhancedJLabel this$0;
                {
                    this.this$0 = $receiver;
                }

                public void propertyChanged(String name, PropertyEvent<Object> event2) {
                    Intrinsics.checkNotNullParameter(event2, (String)"event");
                    this.this$0.repaint();
                }
            };
        }
        MutableProperties<String> mutableProperties = data.getProperties();
        PropertiesListener<String> propertiesListener = this.propertiesListener;
        Intrinsics.checkNotNull(propertiesListener);
        mutableProperties.addWeakPropertiesListener(propertiesListener);
    }

    public final void setEffect(@Nullable EnhancedLabel.Effect effect) {
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        EnhancedLabel.Effect effect2 = effect;
        Intrinsics.checkNotNull((Object)effect2);
        enhancedLabel.setEffect(effect2);
    }

    public final float getEffectOpacity() {
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        return enhancedLabel.getEffectOpacity();
    }

    public final void setEffectOpacity(float effectOpacity) {
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        enhancedLabel.getEffectOpacity();
    }

    @Nullable
    public final EnhancedLabel.Rendering getRendering() {
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        return enhancedLabel.getRendering();
    }

    public final void setRendering(@Nullable EnhancedLabel.Rendering rendering) {
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        EnhancedLabel.Rendering rendering2 = rendering;
        Intrinsics.checkNotNull((Object)((Object)rendering2));
        enhancedLabel.setRendering(rendering2);
    }

    @Nullable
    public final Integer getMinimumCharactersToDisplay() {
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        return enhancedLabel.getMinimumCharactersToDisplay();
    }

    public final void setMinimumCharactersToDisplay(@Nullable Integer minimumCharactersToDisplay) {
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        enhancedLabel.getMinimumCharactersToDisplay();
    }

    public final boolean isJustified() {
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        return enhancedLabel.isJustified();
    }

    public final void setJustified(boolean justified) {
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        enhancedLabel.setJustified(justified);
    }

    public final double getAngle() {
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        return enhancedLabel.getAngle();
    }

    public final void setAngle(double angle) {
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        enhancedLabel.setAngle(angle);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Nullable
    public Font getFont() {
        Font font;
        if (this.data != null) {
            EnhancedLabel enhancedLabel = this.data;
            Intrinsics.checkNotNull((Object)enhancedLabel);
            if (enhancedLabel.getFont() != null) {
                EnhancedLabel enhancedLabel2 = this.data;
                Intrinsics.checkNotNull((Object)enhancedLabel2);
                Font font2 = enhancedLabel2.getFont();
                font = font2;
                Intrinsics.checkNotNull((Object)font2);
                return font;
            }
        }
        font = super.getFont();
        return font;
    }

    @Override
    public void setFont(@Nullable Font font) {
        Font oldFont = this.getFont();
        if (this.data != null) {
            EnhancedLabel enhancedLabel = this.data;
            Intrinsics.checkNotNull((Object)enhancedLabel);
            Font font2 = font;
            Intrinsics.checkNotNull((Object)font2);
            enhancedLabel.setFont(font2);
        } else {
            super.setFont(font);
        }
        this.firePropertyChange("font", oldFont, font);
    }

    @NotNull
    public final Dimension getDesiredSize() {
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        int n = enhancedLabel.getDesiredWidth();
        EnhancedLabel enhancedLabel2 = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel2);
        return new Dimension(n, enhancedLabel2.getDesiredWidth());
    }

    public final void setDesiredSize(@NotNull Dimension desiredSize) {
        Intrinsics.checkNotNullParameter((Object)desiredSize, (String)"desiredSize");
        EnhancedLabel enhancedLabel = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel);
        enhancedLabel.setDesiredWidth(desiredSize.width);
        EnhancedLabel enhancedLabel2 = this.data;
        Intrinsics.checkNotNull((Object)enhancedLabel2);
        enhancedLabel2.setDesiredHeight(desiredSize.height);
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/mkui/labeling/EnhancedJLabel$Companion;", "", "<init>", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            JFrame frame = new JFrame("EnhancedJLabel");
            frame.setSize(new Dimension(600, 600));
            frame.getContentPane().setLayout(new BorderLayout());
            EnhancedJLabel label = new EnhancedJLabel();
            label.setText("This is a test");
            Font font = label.getFont();
            Intrinsics.checkNotNull((Object)font);
            label.setFont(font.deriveFont(72.0f));
            label.setEffect(EnhancedLabel.Effect.Shadow.INSTANCE);
            label.setBackground(Color.yellow);
            label.setRendering(EnhancedLabel.Rendering.Truncate);
            label.setVerticalAlignment(0);
            label.setHorizontalAlignment(0);
            label.setIconTextGap(0);
            frame.getContentPane().add((Component)label, "Center");
            frame.setVisible(true);
            Timer timer2 = new Timer(10, arg_0 -> Companion.main$lambda$0(label, arg_0));
            timer2.start();
        }

        private static final void main$lambda$0(EnhancedJLabel $label, ActionEvent it) {
            $label.setAngle(($label.getAngle() + 1.0) % (double)360);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0007\b\u0084\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J*\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0004J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0019H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\u0019H\u0002J\u0010\u0010\u001f\u001a\u00020\u00192\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ0\u0010 \u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u0016H\u0014J0\u0010$\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u0016H\u0014JD\u0010%\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u00102\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u0007H\u0014JD\u0010,\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\b\u0010!\u001a\u0004\u0018\u00010\u00102\u0006\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u00162\u0006\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u00010.H\u0002JP\u00100\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u000b\u001a\u0004\u0018\u0001012\u0006\u0010&\u001a\u00020\u00142\b\u0010!\u001a\u0004\u0018\u00010\u00102\u0006\u00102\u001a\u00020\u00162\u0006\u00103\u001a\u00020\u00162\b\u0010-\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u00010.H\u0002J4\u00104\u001a\u00020\n2\u0006\u0010\u000b\u001a\u0002012\b\u0010!\u001a\u0004\u0018\u00010\u00102\b\u00105\u001a\u0004\u0018\u00010.2\u0006\u0010\"\u001a\u0002062\u0006\u0010#\u001a\u000206H\u0002J\"\u00107\u001a\u00020\n2\u0006\u0010\u000b\u001a\u0002012\b\u00108\u001a\u0004\u0018\u00010\u00102\b\u0010\r\u001a\u0004\u0018\u00010.J\"\u00109\u001a\u00020\n2\u0006\u0010\u000b\u001a\u0002012\b\u00108\u001a\u0004\u0018\u00010\u00102\b\u0010\r\u001a\u0004\u0018\u00010.J\"\u0010:\u001a\u00020\n2\u0006\u0010\u000b\u001a\u0002012\b\u00108\u001a\u0004\u0018\u00010\u00102\b\u0010;\u001a\u0004\u0018\u00010.J\u0012\u0010<\u001a\u0004\u0018\u00010.2\b\u0010\r\u001a\u0004\u0018\u00010.R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/mkui/labeling/EnhancedJLabel$EnhancedLabelUI;", "Ljavax/swing/plaf/basic/BasicLabelUI;", "<init>", "(Lorg/mkui/labeling/EnhancedJLabel;)V", "useSwingPaintText", "", "paintIconR", "Ljava/awt/Rectangle;", "paintTextR", "paint", "", "g", "Ljava/awt/Graphics;", "c", "Ljavax/swing/JComponent;", "layout", "", "label", "Ljavax/swing/JLabel;", "fm", "Ljava/awt/FontMetrics;", "width", "", "height", "getMinimumSize", "Ljava/awt/Dimension;", "getPreferredSize", "getRotatedDimension", "dimension", "createAffineTransform", "Ljava/awt/geom/AffineTransform;", "getUnrotatedPreferredSize", "paintEnabledText", "text", "x", "y", "paintDisabledText", "layoutCL", "fontMetrics", "icon", "Ljavax/swing/Icon;", "viewR", "iconR", "textR", "paintText", "foreground", "Ljava/awt/Color;", "background", "paintWordWrapText", "Ljava/awt/Graphics2D;", "desiredWidth", "yStart", "paintEffect", "color", "", "paintTextShadow", "s", "paintTextEmphasize", "paintTextGlow", "glow", "removeAlpha", "mkui"})
    protected final class EnhancedLabelUI
    extends BasicLabelUI {
        private final boolean useSwingPaintText;
        @NotNull
        private final Rectangle paintIconR = new Rectangle();
        @NotNull
        private final Rectangle paintTextR = new Rectangle();

        @Override
        public void paint(@NotNull Graphics g2, @NotNull JComponent c2) {
            Intrinsics.checkNotNullParameter((Object)g2, (String)"g");
            Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
            Graphics2D g22 = (Graphics2D)g2;
            JLabel label = (JLabel)c2;
            EnhancedLabel.Rendering rendering = EnhancedJLabel.this.getRendering();
            if ((rendering == null ? -1 : WhenMappings.$EnumSwitchMapping$0[rendering.ordinal()]) == 1) {
                int n;
                int y = 0;
                if (label.getVerticalAlignment() != 1) {
                    Dimension d = this.getPreferredSize(g2, c2);
                    switch (label.getVerticalAlignment()) {
                        case 0: {
                            n = Math.max(0, (c2.getHeight() - d.height) / 2);
                            break;
                        }
                        case 3: {
                            n = Math.max(0, c2.getHeight() - d.height);
                            break;
                        }
                        default: {
                            n = 0;
                            break;
                        }
                    }
                } else {
                    n = 0;
                }
                y = n;
                g22.setFont(EnhancedJLabel.this.getFont());
                FontMetrics fontMetrics = g22.getFontMetrics();
                Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"getFontMetrics(...)");
                this.paintWordWrapText(label, g22, fontMetrics, EnhancedJLabel.this.getText(), EnhancedJLabel.this.getDesiredSize().width, y, label.getForeground(), label.getBackground());
            } else {
                Icon icon;
                switch (label.getHorizontalAlignment()) {
                    default: 
                }
                switch (label.getVerticalAlignment()) {
                    default: 
                }
                String text = label.getText();
                Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
                if (icon == null && text == null) {
                    return;
                }
                FontMetrics fm = label.getFontMetrics(g22.getFont());
                int width = 0;
                int height = 0;
                width = c2.getWidth();
                height = c2.getHeight();
                Intrinsics.checkNotNull((Object)fm);
                String clippedText = this.layout(label, fm, width, height);
                if (!(EnhancedJLabel.this.getAngle() == 0.0)) {
                    g22.rotate(Math.PI * EnhancedJLabel.this.getAngle() / 180.0, this.paintTextR.getCenterX(), this.paintTextR.getCenterY());
                }
                Icon icon3 = icon;
                if (icon3 != null) {
                    icon3.paintIcon(c2, g22, this.paintIconR.x, this.paintIconR.y);
                }
                if (clippedText != null) {
                    View v = (View)c2.getClientProperty("html");
                    if (v != null) {
                        v.paint(g22, this.paintTextR);
                    } else {
                        int textX = this.paintTextR.x;
                        int textY = this.paintTextR.y + fm.getAscent();
                        if (label.isEnabled()) {
                            this.paintEnabledText(label, g22, clippedText, textX, textY);
                        } else {
                            this.paintDisabledText(label, g22, clippedText, textX, textY);
                        }
                    }
                }
            }
        }

        @Nullable
        protected final String layout(@NotNull JLabel label, @NotNull FontMetrics fm, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)fm, (String)"fm");
            Insets insets = label.getInsets(null);
            String text = label.getText();
            Icon icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
            Rectangle paintViewR = new Rectangle();
            paintViewR.x = insets.left;
            paintViewR.y = insets.top;
            paintViewR.width = width - (insets.left + insets.right);
            paintViewR.height = height - (insets.top + insets.bottom);
            this.paintIconR.x = this.paintIconR.y = (this.paintIconR.width = (this.paintIconR.height = 0));
            this.paintTextR.x = this.paintTextR.y = (this.paintTextR.width = (this.paintTextR.height = 0));
            Intrinsics.checkNotNull((Object)text);
            return this.layoutCL(label, fm, text, icon, paintViewR, this.paintIconR, this.paintTextR);
        }

        @NotNull
        public final Dimension getMinimumSize(@NotNull Graphics g2, @NotNull JComponent c2) {
            Dimension dimension;
            Intrinsics.checkNotNullParameter((Object)g2, (String)"g");
            Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
            EnhancedLabel.Rendering rendering = EnhancedJLabel.this.getRendering();
            if ((rendering == null ? -1 : WhenMappings.$EnumSwitchMapping$0[rendering.ordinal()]) == 1) {
                Graphics2D g22 = (Graphics2D)g2;
                EnhancedJLabel label = (EnhancedJLabel)c2;
                g22.setFont(EnhancedJLabel.this.getFont());
                FontMetrics fontMetrics = g22.getFontMetrics(EnhancedJLabel.this.getFont());
                JLabel jLabel = label;
                Intrinsics.checkNotNull((Object)fontMetrics);
                Dimension d = this.paintWordWrapText(jLabel, null, fontMetrics, EnhancedJLabel.this.getText(), label.getDesiredSize().width, 0, null, null);
                dimension = new Dimension(d.width, fontMetrics.getHeight());
            } else {
                dimension = this.getPreferredSize(c2);
            }
            return dimension;
        }

        @Override
        @NotNull
        public Dimension getMinimumSize(@NotNull JComponent c2) {
            Dimension dimension;
            Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
            EnhancedLabel.Rendering rendering = EnhancedJLabel.this.getRendering();
            if ((rendering == null ? -1 : WhenMappings.$EnumSwitchMapping$0[rendering.ordinal()]) == 1) {
                EnhancedJLabel label = (EnhancedJLabel)c2;
                JLabel jLabel = label;
                FontMetrics fontMetrics = label.getFontMetrics(label.getFont());
                Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"getFontMetrics(...)");
                Dimension d = this.paintWordWrapText(jLabel, null, fontMetrics, EnhancedJLabel.this.getText(), label.getDesiredSize().width, 0, null, null);
                dimension = new Dimension(d.width, EnhancedJLabel.this.getFontMetrics(EnhancedJLabel.this.getFont()).getHeight());
            } else {
                dimension = this.getPreferredSize(c2);
            }
            return dimension;
        }

        @NotNull
        public final Dimension getPreferredSize(@NotNull Graphics g2, @NotNull JComponent c2) {
            Intrinsics.checkNotNullParameter((Object)g2, (String)"g");
            Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
            Insets insets = EnhancedJLabel.this.getInsets();
            Dimension size = null;
            EnhancedLabel.Rendering rendering = EnhancedJLabel.this.getRendering();
            if ((rendering == null ? -1 : WhenMappings.$EnumSwitchMapping$0[rendering.ordinal()]) == 1) {
                Graphics2D g22 = (Graphics2D)g2;
                EnhancedJLabel label = (EnhancedJLabel)c2;
                g22.setFont(EnhancedJLabel.this.getFont());
                JLabel jLabel = label;
                FontMetrics fontMetrics = g22.getFontMetrics(EnhancedJLabel.this.getFont());
                Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"getFontMetrics(...)");
                Dimension d = this.paintWordWrapText(jLabel, null, fontMetrics, EnhancedJLabel.this.getText(), label.getDesiredSize().width, 0, null, null);
                size = new Dimension(d.width, d.height);
            } else {
                Dimension dimension;
                if (!(EnhancedJLabel.this.getAngle() == 0.0)) {
                    Dimension dimension2 = super.getPreferredSize(c2);
                    Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"getPreferredSize(...)");
                    Dimension d = this.getRotatedDimension(dimension2);
                    dimension = new Dimension(d.width + insets.left + insets.right, d.height + insets.top + insets.bottom);
                } else {
                    Dimension dimension3 = super.getPreferredSize(c2);
                    Intrinsics.checkNotNull((Object)dimension3);
                    dimension = dimension3;
                }
                size = dimension;
            }
            return size;
        }

        @Override
        @NotNull
        public Dimension getPreferredSize(@NotNull JComponent c2) {
            Dimension dimension;
            Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
            Insets insets = EnhancedJLabel.this.getInsets();
            Dimension size = null;
            EnhancedLabel.Rendering rendering = EnhancedJLabel.this.getRendering();
            if ((rendering == null ? -1 : WhenMappings.$EnumSwitchMapping$0[rendering.ordinal()]) == 1) {
                EnhancedJLabel label = (EnhancedJLabel)c2;
                JLabel jLabel = label;
                FontMetrics fontMetrics = label.getFontMetrics(label.getFont());
                Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"getFontMetrics(...)");
                Dimension d = this.paintWordWrapText(jLabel, null, fontMetrics, EnhancedJLabel.this.getText(), label.getDesiredSize().width, 0, null, null);
                dimension = new Dimension(d.width, d.height);
            } else if (!(EnhancedJLabel.this.getAngle() == 0.0)) {
                Dimension dimension2 = super.getPreferredSize(c2);
                Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"getPreferredSize(...)");
                Dimension d = this.getRotatedDimension(dimension2);
                dimension = new Dimension(d.width + insets.left + insets.right, d.height + insets.top + insets.bottom);
            } else {
                Dimension dimension3 = super.getPreferredSize(c2);
                Intrinsics.checkNotNull((Object)dimension3);
                dimension = dimension3;
            }
            size = dimension;
            return size;
        }

        private final Dimension getRotatedDimension(Dimension dimension) {
            AffineTransform at = this.createAffineTransform(dimension);
            Rectangle rect = at.createTransformedShape(new Rectangle(dimension)).getBounds();
            return new Dimension(rect.width, rect.height);
        }

        private final AffineTransform createAffineTransform(Dimension dimension) {
            AffineTransform at = new AffineTransform();
            at.rotate(Math.PI * EnhancedJLabel.this.getAngle() / 180.0, dimension.getWidth() / 2.0, dimension.getHeight() / 2.0);
            return at;
        }

        @NotNull
        public final Dimension getUnrotatedPreferredSize(@Nullable JComponent c2) {
            Dimension dimension = super.getPreferredSize(c2);
            Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
            return dimension;
        }

        @Override
        protected void paintEnabledText(@NotNull JLabel label, @NotNull Graphics g2, @NotNull String text, int x, int y) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)g2, (String)"g");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Color color = label.getForeground();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getForeground(...)");
            this.paintText(label, g2, text, x, y, color, label.getBackground());
        }

        @Override
        protected void paintDisabledText(@NotNull JLabel label, @NotNull Graphics g2, @NotNull String text, int x, int y) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)g2, (String)"g");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Color color = label.getForeground();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getForeground(...)");
            this.paintText(label, g2, text, x, y, color, label.getBackground());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @Nullable
        protected String layoutCL(@NotNull JLabel label, @NotNull FontMetrics fontMetrics, @NotNull String text, @Nullable Icon icon, @NotNull Rectangle viewR, @NotNull Rectangle iconR, @NotNull Rectangle textR) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)viewR, (String)"viewR");
            Intrinsics.checkNotNullParameter((Object)iconR, (String)"iconR");
            Intrinsics.checkNotNullParameter((Object)textR, (String)"textR");
            EnhancedLabel.Rendering rendering = EnhancedJLabel.this.getRendering();
            switch (rendering == null ? -1 : WhenMappings.$EnumSwitchMapping$0[rendering.ordinal()]) {
                case 2: {
                    String truncatedString = super.layoutCL(label, fontMetrics, text, icon, viewR, iconR, textR);
                    if (!Intrinsics.areEqual((Object)text, (Object)truncatedString)) {
                        if (truncatedString == null) return null;
                        if (truncatedString.length() <= 3) return null;
                        if (EnhancedJLabel.this.getMinimumCharactersToDisplay() != null) {
                            int n = truncatedString.length() - 3;
                            Integer n2 = EnhancedJLabel.this.getMinimumCharactersToDisplay();
                            Intrinsics.checkNotNull((Object)n2);
                            if (n < n2) return null;
                        }
                    }
                    String string = truncatedString;
                    return string;
                }
                case 3: {
                    String clippedString = super.layoutCL(label, fontMetrics, text, icon, viewR, iconR, textR);
                    if (Intrinsics.areEqual((Object)text, (Object)clippedString)) return text;
                    if (clippedString == null) return text;
                    if (EnhancedJLabel.this.getMinimumCharactersToDisplay() == null) return text;
                    int n = clippedString.length();
                    Integer n3 = EnhancedJLabel.this.getMinimumCharactersToDisplay();
                    Intrinsics.checkNotNull((Object)n3);
                    if (n >= n3) return text;
                    return null;
                }
            }
            return text;
        }

        private final void paintText(JLabel label, Graphics g2, String text, int x, int y, Color foreground, Color background) {
            g2.setColor(foreground);
            if (background != null) {
                g2.translate(x, y);
                EnhancedLabel enhancedLabel = EnhancedJLabel.this.data;
                Intrinsics.checkNotNull((Object)enhancedLabel);
                EnhancedLabel.Effect effect = enhancedLabel.getEffect();
                if (Intrinsics.areEqual((Object)effect, (Object)EnhancedLabel.Effect.Shadow.INSTANCE)) {
                    Intrinsics.checkNotNull((Object)g2, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                    this.paintTextShadow((Graphics2D)g2, text, background);
                } else if (Intrinsics.areEqual((Object)effect, (Object)EnhancedLabel.Effect.Glow.INSTANCE)) {
                    Intrinsics.checkNotNull((Object)g2, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                    this.paintTextGlow((Graphics2D)g2, text, background);
                } else if (Intrinsics.areEqual((Object)effect, (Object)EnhancedLabel.Effect.Outline.INSTANCE)) {
                    Intrinsics.checkNotNull((Object)g2, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                    this.paintTextGlow((Graphics2D)g2, text, background);
                } else if (Intrinsics.areEqual((Object)effect, (Object)EnhancedLabel.Effect.Emphasize.INSTANCE)) {
                    Intrinsics.checkNotNull((Object)g2, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                    this.paintTextEmphasize((Graphics2D)g2, text, background);
                }
                g2.translate(-x, -y);
            }
            if (this.useSwingPaintText) {
                super.paintEnabledText(label, g2, text, x, y);
            } else if (text != null) {
                g2.drawString(text, x, y);
            }
        }

        private final Dimension paintWordWrapText(JLabel label, Graphics2D g2, FontMetrics fontMetrics, String text, int desiredWidth, int yStart, Color foreground, Color background) {
            Insets insets = EnhancedJLabel.this.getInsets();
            int width = desiredWidth + (insets.left + insets.right);
            float w = (float)insets.left + (float)insets.right;
            float x = insets.left;
            float y = (float)yStart + (float)insets.top;
            if (desiredWidth > 0 && text != null && ((CharSequence)text).length() > 0) {
                AttributedString as = new AttributedString(text);
                as.addAttribute(TextAttribute.FONT, EnhancedJLabel.this.getFont());
                as.addAttribute(TextAttribute.FOREGROUND, foreground);
                AttributedCharacterIterator aci = as.getIterator();
                FontRenderContext fontRenderContext = fontMetrics.getFontRenderContext();
                BreakIterator breakIterator = BreakIterator.getLineInstance();
                LineBreakMeasurer lbm = new LineBreakMeasurer(aci, breakIterator, fontRenderContext);
                float max = 0.0f;
                try {
                    while (lbm.getPosition() < aci.getEndIndex()) {
                        TextLayout layout = lbm.nextLayout(desiredWidth);
                        if (g2 != null && EnhancedJLabel.this.isJustified() && (double)layout.getVisibleAdvance() > 0.8 * (double)desiredWidth) {
                            layout = layout.getJustifiedLayout(desiredWidth);
                        }
                        float ascent = layout.getAscent();
                        float visibleAdvance = layout.getVisibleAdvance();
                        if (g2 != null) {
                            switch (label.getHorizontalAlignment()) {
                                case 2: 
                                case 10: {
                                    layout.draw(g2, x, y + ascent);
                                    break;
                                }
                                case 0: {
                                    float leftMargin = insets.left;
                                    float rightMargin = (float)EnhancedJLabel.this.getWidth() - (float)insets.right;
                                    layout.draw(g2, (leftMargin + rightMargin - visibleAdvance) / (float)2, y + ascent);
                                    break;
                                }
                                case 4: 
                                case 11: {
                                    float rightMargin = (float)EnhancedJLabel.this.getWidth() - (float)insets.right;
                                    layout.draw(g2, rightMargin - visibleAdvance, y + ascent);
                                    break;
                                }
                                default: {
                                    layout.draw(g2, x, y + ascent);
                                }
                            }
                        }
                        float leading = layout.getLeading();
                        float descent = layout.getDescent();
                        y += descent + leading + ascent;
                        max = Math.max(max, visibleAdvance);
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
                w += max;
            }
            return new Dimension((int)Math.ceil(w), (int)Math.ceil(y) + insets.bottom);
        }

        private final void paintEffect(Graphics2D g2, String text, Color color, double x, double y) {
            if (text != null) {
                Object oldTextAAHint = g2.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                Composite oldComposite = g2.getComposite();
                Color oldColor = g2.getColor();
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2.setColor(color);
                g2.translate(x, y);
                int additionalOffset = g2.getFontMetrics().getHeight() / 32;
                EnhancedLabel enhancedLabel = EnhancedJLabel.this.data;
                Intrinsics.checkNotNull((Object)enhancedLabel);
                EnhancedLabel.Effect effect = enhancedLabel.getEffect();
                if (Intrinsics.areEqual((Object)effect, (Object)EnhancedLabel.Effect.Emphasize.INSTANCE)) {
                    int size1 = 1 + additionalOffset;
                    for (int j = 0; j < size1; ++j) {
                        double distance = (double)j * (double)j;
                        float alpha = EnhancedJLabel.this.getEffectOpacity();
                        if (distance > 0.0) {
                            alpha = (float)((double)0.5f / distance * (double)EnhancedJLabel.this.getEffectOpacity());
                        }
                        if (alpha > 1.0f) {
                            alpha = 1.0f;
                        }
                        g2.setComposite(AlphaComposite.getInstance(3, alpha));
                        g2.drawString(text, 0, j);
                    }
                } else if (Intrinsics.areEqual((Object)effect, (Object)EnhancedLabel.Effect.Shadow.INSTANCE)) {
                    int size = 1 + additionalOffset;
                    for (int i = 0; i < size; ++i) {
                        for (int j = 0; j < size; ++j) {
                            double distance = (double)(i * i) + (double)j * (double)j;
                            float alpha = EnhancedJLabel.this.getEffectOpacity();
                            if (distance > 0.0) {
                                alpha = (float)((double)0.5f / distance * (double)EnhancedJLabel.this.getEffectOpacity());
                            }
                            if (alpha > 1.0f) {
                                alpha = 1.0f;
                            }
                            g2.setComposite(AlphaComposite.getInstance(3, alpha));
                            g2.drawString(text, i, j);
                        }
                    }
                } else if (Intrinsics.areEqual((Object)effect, (Object)EnhancedLabel.Effect.Glow.INSTANCE)) {
                    int size3 = 1 + additionalOffset;
                    for (int i = -size3; i <= size3; ++i) {
                        for (int j = -size3; j <= size3; ++j) {
                            double distance = (double)(i * i) + (double)j * (double)j;
                            float alpha = EnhancedJLabel.this.getEffectOpacity();
                            if (!(distance > 0.0)) continue;
                            alpha = (float)((double)1.0f / distance * (double)EnhancedJLabel.this.getEffectOpacity());
                            if (alpha > 1.0f) {
                                alpha = 1.0f;
                            }
                            g2.setComposite(AlphaComposite.getInstance(3, alpha));
                            g2.drawString(text, i, j);
                        }
                    }
                } else if (Intrinsics.areEqual((Object)effect, (Object)EnhancedLabel.Effect.Outline.INSTANCE)) {
                    Object oldAAHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    FontRenderContext frc = g2.getFontRenderContext();
                    Font font = EnhancedJLabel.this.getFont();
                    Intrinsics.checkNotNull((Object)font);
                    GlyphVector gv = font.createGlyphVector(frc, text);
                    g2.setStroke(new BasicStroke(2 + additionalOffset));
                    g2.setComposite(AlphaComposite.getInstance(3, EnhancedJLabel.this.getEffectOpacity()));
                    g2.draw(gv.getOutline());
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAAHint);
                }
                g2.translate(-x, -y);
                g2.setComposite(oldComposite);
                g2.setColor(oldColor);
                if (oldTextAAHint != null) {
                    g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldTextAAHint);
                }
            }
        }

        public final void paintTextShadow(@NotNull Graphics2D g2, @Nullable String s, @Nullable Color c2) {
            Intrinsics.checkNotNullParameter((Object)g2, (String)"g");
            this.paintEffect(g2, s, this.removeAlpha(c2), 1.0, 1.0);
        }

        public final void paintTextEmphasize(@NotNull Graphics2D g2, @Nullable String s, @Nullable Color c2) {
            Intrinsics.checkNotNullParameter((Object)g2, (String)"g");
            this.paintEffect(g2, s, this.removeAlpha(c2), 0.0, 1.0);
        }

        public final void paintTextGlow(@NotNull Graphics2D g2, @Nullable String s, @Nullable Color glow) {
            Intrinsics.checkNotNullParameter((Object)g2, (String)"g");
            this.paintEffect(g2, s, this.removeAlpha(glow), 0.0, 0.0);
        }

        @Nullable
        public final Color removeAlpha(@Nullable Color c2) {
            Color c3 = c2;
            if (c3 != null && c3.getAlpha() != 100) {
                c3 = new Color(c3.getRGB());
            }
            return c3;
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[EnhancedLabel.Rendering.values().length];
                try {
                    nArray[EnhancedLabel.Rendering.WordWrap.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EnhancedLabel.Rendering.Truncate.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EnhancedLabel.Rendering.Clip.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

