/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\nH\u0007J\u001b\u0010\u000b\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\nH\u0007\u00a8\u0006\f"}, d2={"Lorg/locationtech/jts/algorithm/Area;", "", "<init>", "()V", "ofRing", "", "ring", "", "Lorg/locationtech/jts/geom/Coordinate;", "([Lorg/locationtech/jts/geom/Coordinate;)D", "Lorg/locationtech/jts/geom/CoordinateSequence;", "ofRingSigned", "kts-core"})
public final class Area {
    @NotNull
    public static final Area INSTANCE = new Area();

    private Area() {
    }

    @JvmStatic
    public static final double ofRing(@NotNull Coordinate[] ring) {
        Intrinsics.checkNotNullParameter((Object)ring, (String)"ring");
        return Math.INSTANCE.abs(Area.ofRingSigned(ring));
    }

    @JvmStatic
    public static final double ofRing(@NotNull CoordinateSequence ring) {
        Intrinsics.checkNotNullParameter((Object)ring, (String)"ring");
        return Math.INSTANCE.abs(Area.ofRingSigned(ring));
    }

    @JvmStatic
    public static final double ofRingSigned(@NotNull Coordinate[] ring) {
        Intrinsics.checkNotNullParameter((Object)ring, (String)"ring");
        if (ring.length < 3) {
            return 0.0;
        }
        double sum = 0.0;
        double x0 = ring[0].x;
        int n = ring.length - 1;
        for (int i = 1; i < n; ++i) {
            double x = ring[i].x - x0;
            double y1 = ring[i + 1].y;
            double y2 = ring[i - 1].y;
            sum += x * (y2 - y1);
        }
        return sum / 2.0;
    }

    @JvmStatic
    public static final double ofRingSigned(@NotNull CoordinateSequence ring) {
        Intrinsics.checkNotNullParameter((Object)ring, (String)"ring");
        int n = ring.size();
        if (n < 3) {
            return 0.0;
        }
        Coordinate p0 = ring.createCoordinate();
        Coordinate p1 = ring.createCoordinate();
        Coordinate p2 = ring.createCoordinate();
        ring.getCoordinate(0, p1);
        ring.getCoordinate(1, p2);
        double x0 = p1.x;
        p2.x -= x0;
        double sum = 0.0;
        int n2 = n - 1;
        for (int i = 1; i < n2; ++i) {
            p0.y = p1.y;
            p1.x = p2.x;
            p1.y = p2.y;
            ring.getCoordinate(i + 1, p2);
            p2.x -= x0;
            sum += p1.x * (p0.y - p2.y);
        }
        return sum / 2.0;
    }
}

