/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 (2\u00020\u0001:\u0001(B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001b\u0010\u001a\u001a\u00020\u00122\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u001cH\u0002\u00a2\u0006\u0002\u0010\u001dJ\u001b\u0010\u001e\u001a\u00020\u00122\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u001cH\u0002\u00a2\u0006\u0002\u0010\u001dJ*\u0010\u001f\u001a\u00020\u00122\b\u0010 \u001a\u0004\u0018\u00010\u00072\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020$H\u0002J\u001b\u0010%\u001a\u00020\u00122\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u001cH\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u0007H\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006)"}, d2={"Lorg/locationtech/jts/algorithm/Centroid;", "", "geom", "Lorg/locationtech/jts/geom/Geometry;", "<init>", "(Lorg/locationtech/jts/geom/Geometry;)V", "areaBasePt", "Lorg/locationtech/jts/geom/Coordinate;", "triangleCent3", "areasum2", "", "cg3", "lineCentSum", "totalLength", "ptCount", "", "ptCentSum", "add", "", "centroid", "getCentroid", "()Lorg/locationtech/jts/geom/Coordinate;", "setAreaBasePoint", "basePt", "poly", "Lorg/locationtech/jts/geom/Polygon;", "addShell", "pts", "", "([Lorg/locationtech/jts/geom/Coordinate;)V", "addHole", "addTriangle", "p0", "p1", "p2", "isPositiveArea", "", "addLineSegments", "addPoint", "pt", "Companion", "kts-core"})
public final class Centroid {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Coordinate areaBasePt;
    @NotNull
    private final Coordinate triangleCent3;
    private double areasum2;
    @NotNull
    private final Coordinate cg3;
    @NotNull
    private final Coordinate lineCentSum;
    private double totalLength;
    private int ptCount;
    @NotNull
    private final Coordinate ptCentSum;

    public Centroid(@NotNull Geometry geom) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        this.triangleCent3 = new Coordinate();
        this.cg3 = new Coordinate();
        this.lineCentSum = new Coordinate();
        this.ptCentSum = new Coordinate();
        this.areaBasePt = null;
        this.add(geom);
    }

    private final void add(Geometry geom) {
        if (geom.isEmpty()) {
            return;
        }
        if (geom instanceof Point) {
            Coordinate coordinate = ((Point)geom).getCoordinate();
            Intrinsics.checkNotNull((Object)coordinate);
            this.addPoint(coordinate);
        } else if (geom instanceof LineString) {
            this.addLineSegments(((LineString)geom).getCoordinates());
        } else if (geom instanceof Polygon) {
            this.add((Polygon)geom);
        } else if (geom instanceof GeometryCollection) {
            Geometry gc = geom;
            int n = ((GeometryCollection)gc).getNumGeometries();
            for (int i = 0; i < n; ++i) {
                this.add(((GeometryCollection)gc).getGeometryN(i));
            }
        }
    }

    @Nullable
    public final Coordinate getCentroid() {
        Coordinate cent = new Coordinate();
        if (Math.abs(this.areasum2) > 0.0) {
            cent.x = this.cg3.x / (double)3 / this.areasum2;
            cent.y = this.cg3.y / (double)3 / this.areasum2;
        } else if (this.totalLength > 0.0) {
            cent.x = this.lineCentSum.x / this.totalLength;
            cent.y = this.lineCentSum.y / this.totalLength;
        } else if (this.ptCount > 0) {
            cent.x = this.ptCentSum.x / (double)this.ptCount;
            cent.y = this.ptCentSum.y / (double)this.ptCount;
        } else {
            return null;
        }
        return cent;
    }

    private final void setAreaBasePoint(Coordinate basePt) {
        this.areaBasePt = basePt;
    }

    private final void add(Polygon poly) {
        LinearRing linearRing = poly.getExteriorRing();
        Intrinsics.checkNotNull((Object)linearRing);
        this.addShell(linearRing.getCoordinates());
        int n = poly.getNumInteriorRing();
        for (int i = 0; i < n; ++i) {
            this.addHole(poly.getInteriorRingN(i).getCoordinates());
        }
    }

    private final void addShell(Coordinate[] pts) {
        if (!(pts.length == 0)) {
            this.setAreaBasePoint(pts[0]);
        }
        boolean isPositiveArea = !Orientation.isCCW(pts);
        int n = pts.length - 1;
        for (int i = 0; i < n; ++i) {
            this.addTriangle(this.areaBasePt, pts[i], pts[i + 1], isPositiveArea);
        }
        this.addLineSegments(pts);
    }

    private final void addHole(Coordinate[] pts) {
        boolean isPositiveArea = Orientation.isCCW(pts);
        int n = pts.length - 1;
        for (int i = 0; i < n; ++i) {
            this.addTriangle(this.areaBasePt, pts[i], pts[i + 1], isPositiveArea);
        }
        this.addLineSegments(pts);
    }

    private final void addTriangle(Coordinate p0, Coordinate p1, Coordinate p2, boolean isPositiveArea) {
        double sign = isPositiveArea ? 1.0 : -1.0;
        Centroid.Companion.centroid3(p0, p1, p2, this.triangleCent3);
        double area2 = Centroid.Companion.area2(p0, p1, p2);
        Coordinate coordinate = this.cg3;
        coordinate.x += sign * area2 * this.triangleCent3.x;
        coordinate = this.cg3;
        coordinate.y += sign * area2 * this.triangleCent3.y;
        this.areasum2 += sign * area2;
    }

    private final void addLineSegments(Coordinate[] pts) {
        double lineLen = 0.0;
        int n = pts.length - 1;
        for (int i = 0; i < n; ++i) {
            double segmentLen = pts[i].distance(pts[i + 1]);
            if (segmentLen == 0.0) continue;
            lineLen += segmentLen;
            double midx = (pts[i].x + pts[i + 1].x) / (double)2;
            Coordinate coordinate = this.lineCentSum;
            coordinate.x += segmentLen * midx;
            double midy = (pts[i].y + pts[i + 1].y) / (double)2;
            Coordinate coordinate2 = this.lineCentSum;
            coordinate2.y += segmentLen * midy;
        }
        this.totalLength += lineLen;
        if (lineLen == 0.0 && !(pts.length == 0)) {
            this.addPoint(pts[0]);
        }
    }

    private final void addPoint(Coordinate pt) {
        ++this.ptCount;
        Coordinate coordinate = this.ptCentSum;
        coordinate.x += pt.x;
        coordinate = this.ptCentSum;
        coordinate.y += pt.y;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J*\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0002J\"\u0010\u000e\u001a\u00020\u000f2\b\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002\u00a8\u0006\u0010"}, d2={"Lorg/locationtech/jts/algorithm/Centroid$Companion;", "", "<init>", "()V", "getCentroid", "Lorg/locationtech/jts/geom/Coordinate;", "geom", "Lorg/locationtech/jts/geom/Geometry;", "centroid3", "", "p1", "p2", "p3", "c", "area2", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Coordinate getCentroid(@NotNull Geometry geom) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            Centroid cent = new Centroid(geom);
            return cent.getCentroid();
        }

        private final void centroid3(Coordinate p1, Coordinate p2, Coordinate p3, Coordinate c) {
            Coordinate coordinate = p1;
            Intrinsics.checkNotNull((Object)coordinate);
            c.x = coordinate.x + p2.x + p3.x;
            c.y = p1.y + p2.y + p3.y;
        }

        private final double area2(Coordinate p1, Coordinate p2, Coordinate p3) {
            double d = p2.x;
            Coordinate coordinate = p1;
            Intrinsics.checkNotNull((Object)coordinate);
            return (d - coordinate.x) * (p3.y - p1.y) - (p3.x - p1.x) * (p2.y - p1.y);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

