/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0003\u0013\u0014\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\"\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/locationtech/jts/algorithm/InteriorPointArea;", "", "g", "Lorg/locationtech/jts/geom/Geometry;", "<init>", "(Lorg/locationtech/jts/geom/Geometry;)V", "value", "Lorg/locationtech/jts/geom/Coordinate;", "interiorPoint", "getInteriorPoint", "()Lorg/locationtech/jts/geom/Coordinate;", "maxWidth", "", "process", "", "geom", "processPolygon", "polygon", "Lorg/locationtech/jts/geom/Polygon;", "InteriorPointPolygon", "ScanLineYOrdinateFinder", "Companion", "kts-core"})
public final class InteriorPointArea {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Coordinate interiorPoint;
    private double maxWidth;

    public InteriorPointArea(@NotNull Geometry g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        this.maxWidth = -1.0;
        this.process(g);
    }

    @Nullable
    public final Coordinate getInteriorPoint() {
        return this.interiorPoint;
    }

    private final void process(Geometry geom) {
        if (geom.isEmpty()) {
            return;
        }
        if (geom instanceof Polygon) {
            this.processPolygon((Polygon)geom);
        } else if (geom instanceof GeometryCollection) {
            Geometry gc = geom;
            int n = ((GeometryCollection)gc).getNumGeometries();
            for (int i = 0; i < n; ++i) {
                this.process(((GeometryCollection)gc).getGeometryN(i));
            }
        }
    }

    private final void processPolygon(Polygon polygon) {
        InteriorPointPolygon intPtPoly = new InteriorPointPolygon(polygon);
        intPtPoly.process();
        double width = intPtPoly.getWidth();
        if (width > this.maxWidth) {
            this.maxWidth = width;
            this.interiorPoint = intPtPoly.getInteriorPoint();
        }
    }

    @JvmStatic
    @Nullable
    public static final Coordinate getInteriorPoint(@NotNull Geometry geom) {
        return Companion.getInteriorPoint(geom);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0002\u00a8\u0006\f"}, d2={"Lorg/locationtech/jts/algorithm/InteriorPointArea$Companion;", "", "<init>", "()V", "getInteriorPoint", "Lorg/locationtech/jts/geom/Coordinate;", "geom", "Lorg/locationtech/jts/geom/Geometry;", "avg", "", "a", "b", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final Coordinate getInteriorPoint(@NotNull Geometry geom) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            InteriorPointArea intPt = new InteriorPointArea(geom);
            return intPt.getInteriorPoint();
        }

        private final double avg(double a, double b) {
            return (a + b) / 2.0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0007\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0010\u001a\u00020\u0011J \u0010\u0012\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0016H\u0002J.\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0016H\u0002J\u0016\u0010\u001b\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\"\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\b\u001a\u0004\u0018\u00010\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lorg/locationtech/jts/algorithm/InteriorPointArea$InteriorPointPolygon;", "", "polygon", "Lorg/locationtech/jts/geom/Polygon;", "<init>", "(Lorg/locationtech/jts/geom/Polygon;)V", "interiorPointY", "", "value", "width", "getWidth", "()D", "Lorg/locationtech/jts/geom/Coordinate;", "interiorPoint", "getInteriorPoint", "()Lorg/locationtech/jts/geom/Coordinate;", "process", "", "scanRing", "ring", "Lorg/locationtech/jts/geom/LinearRing;", "crossings", "", "addEdgeCrossing", "p0", "p1", "scanY", "findBestMidpoint", "Companion", "kts-core"})
    private static final class InteriorPointPolygon {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Polygon polygon;
        private final double interiorPointY;
        private double width;
        @Nullable
        private Coordinate interiorPoint;

        public InteriorPointPolygon(@NotNull Polygon polygon) {
            Intrinsics.checkNotNullParameter((Object)polygon, (String)"polygon");
            this.polygon = polygon;
            this.interiorPointY = ScanLineYOrdinateFinder.Companion.getScanLineY(this.polygon);
        }

        public final double getWidth() {
            return this.width;
        }

        @Nullable
        public final Coordinate getInteriorPoint() {
            return this.interiorPoint;
        }

        public final void process() {
            if (this.polygon.isEmpty()) {
                return;
            }
            this.interiorPoint = new Coordinate(this.polygon.getCoordinate());
            List crossings = new ArrayList();
            this.scanRing(this.polygon.getExteriorRing(), crossings);
            int n = this.polygon.getNumInteriorRing();
            for (int i = 0; i < n; ++i) {
                this.scanRing(this.polygon.getInteriorRingN(i), crossings);
            }
            this.findBestMidpoint(crossings);
        }

        private final void scanRing(LinearRing ring, List<Double> crossings) {
            LinearRing linearRing = ring;
            Intrinsics.checkNotNull((Object)linearRing);
            if (!InteriorPointPolygon.Companion.intersectsHorizontalLine(linearRing.getEnvelopeInternal(), this.interiorPointY)) {
                return;
            }
            CoordinateSequence seq = ring.getCoordinateSequence();
            CoordinateSequence coordinateSequence = seq;
            Intrinsics.checkNotNull((Object)coordinateSequence);
            int n = coordinateSequence.size();
            for (int i = 1; i < n; ++i) {
                Coordinate ptPrev = seq.getCoordinate(i - 1);
                Coordinate pt = seq.getCoordinate(i);
                this.addEdgeCrossing(ptPrev, pt, this.interiorPointY, crossings);
            }
        }

        private final void addEdgeCrossing(Coordinate p0, Coordinate p1, double scanY, List<Double> crossings) {
            if (!InteriorPointPolygon.Companion.intersectsHorizontalLine(p0, p1, scanY)) {
                return;
            }
            if (!InteriorPointPolygon.Companion.isEdgeCrossingCounted(p0, p1, scanY)) {
                return;
            }
            double xInt = InteriorPointPolygon.Companion.intersection(p0, p1, scanY);
            crossings.add(xInt);
        }

        private final void findBestMidpoint(List<Double> crossings) {
            if (crossings.size() == 0) {
                return;
            }
            Assert.INSTANCE.isTrue(crossings.size() % 2 == 0, "Interior Point robustness failure: odd number of scanline crossings");
            CollectionsKt.sortWith(crossings, (arg_0, arg_1) -> InteriorPointPolygon.findBestMidpoint$lambda$1(InteriorPointPolygon::findBestMidpoint$lambda$0, arg_0, arg_1));
            for (int i = 0; i < crossings.size(); i += 2) {
                double x1 = ((Number)crossings.get(i)).doubleValue();
                double x2 = ((Number)crossings.get(i + 1)).doubleValue();
                double width = x2 - x1;
                if (!(width > this.width)) continue;
                this.width = width;
                double interiorPointX = Companion.avg(x1, x2);
                this.interiorPoint = new Coordinate(interiorPointX, this.interiorPointY);
            }
        }

        private static final int findBestMidpoint$lambda$0(double d1, double d2) {
            return Math.INSTANCE.compare(d1, d2);
        }

        private static final int findBestMidpoint$lambda$1(Function2 $tmp0, Object p0, Object p1) {
            return ((Number)$tmp0.invoke(p0, p1)).intValue();
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\nH\u0002J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0002J \u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\nH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/locationtech/jts/algorithm/InteriorPointArea$InteriorPointPolygon$Companion;", "", "<init>", "()V", "isEdgeCrossingCounted", "", "p0", "Lorg/locationtech/jts/geom/Coordinate;", "p1", "scanY", "", "intersection", "Y", "intersectsHorizontalLine", "env", "Lorg/locationtech/jts/geom/Envelope;", "y", "kts-core"})
        public static final class Companion {
            private Companion() {
            }

            private final boolean isEdgeCrossingCounted(Coordinate p0, Coordinate p1, double scanY) {
                double y0 = p0.y;
                double y1 = p1.y;
                if (y0 == y1) {
                    return false;
                }
                if (y0 == scanY && y1 < scanY) {
                    return false;
                }
                return !(y1 == scanY) || !(y0 < scanY);
            }

            private final double intersection(Coordinate p0, Coordinate p1, double Y) {
                double x0 = p0.x;
                double x1 = p1.x;
                if (x0 == x1) {
                    return x0;
                }
                double segDX = x1 - x0;
                double segDY = p1.y - p0.y;
                double m = segDY / segDX;
                return x0 + (Y - p0.y) / m;
            }

            private final boolean intersectsHorizontalLine(Envelope env, double y) {
                if (y < env.getMinY()) {
                    return false;
                }
                return y <= env.getMaxY();
            }

            private final boolean intersectsHorizontalLine(Coordinate p0, Coordinate p1, double y) {
                if (p0.y > y && p1.y > y) {
                    return false;
                }
                return !(p0.y < y) || !(p1.y < y);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lorg/locationtech/jts/algorithm/InteriorPointArea$ScanLineYOrdinateFinder;", "", "poly", "Lorg/locationtech/jts/geom/Polygon;", "<init>", "(Lorg/locationtech/jts/geom/Polygon;)V", "centreY", "", "hiY", "loY", "scanLineY", "getScanLineY", "()D", "process", "", "line", "Lorg/locationtech/jts/geom/LineString;", "updateInterval", "y", "Companion", "kts-core"})
    private static final class ScanLineYOrdinateFinder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Polygon poly;
        private final double centreY;
        private double hiY;
        private double loY;

        public ScanLineYOrdinateFinder(@NotNull Polygon poly) {
            Intrinsics.checkNotNullParameter((Object)poly, (String)"poly");
            this.poly = poly;
            this.hiY = Double.MAX_VALUE;
            this.loY = -1.7976931348623157E308;
            this.hiY = this.poly.getEnvelopeInternal().getMaxY();
            this.loY = this.poly.getEnvelopeInternal().getMinY();
            this.centreY = Companion.avg(this.loY, this.hiY);
        }

        public final double getScanLineY() {
            this.process(this.poly.getExteriorRing());
            int n = this.poly.getNumInteriorRing();
            for (int i = 0; i < n; ++i) {
                this.process(this.poly.getInteriorRingN(i));
            }
            return Companion.avg(this.hiY, this.loY);
        }

        private final void process(LineString line) {
            LineString lineString = line;
            Intrinsics.checkNotNull((Object)lineString);
            CoordinateSequence seq = lineString.getCoordinateSequence();
            CoordinateSequence coordinateSequence = seq;
            Intrinsics.checkNotNull((Object)coordinateSequence);
            int n = coordinateSequence.size();
            for (int i = 0; i < n; ++i) {
                double y = seq.getY(i);
                this.updateInterval(y);
            }
        }

        private final void updateInterval(double y) {
            if (y <= this.centreY) {
                if (y > this.loY) {
                    this.loY = y;
                }
            } else if (y > this.centreY && y < this.hiY) {
                this.hiY = y;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/locationtech/jts/algorithm/InteriorPointArea$ScanLineYOrdinateFinder$Companion;", "", "<init>", "()V", "getScanLineY", "", "poly", "Lorg/locationtech/jts/geom/Polygon;", "kts-core"})
        public static final class Companion {
            private Companion() {
            }

            public final double getScanLineY(@NotNull Polygon poly) {
                Intrinsics.checkNotNullParameter((Object)poly, (String)"poly");
                ScanLineYOrdinateFinder finder = new ScanLineYOrdinateFinder(poly);
                return finder.getScanLineY();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

