/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.algorithm.ConvexHull;
import org.locationtech.jts.algorithm.Rectangle;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0002J\u001b\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u00a2\u0006\u0002\u0010\u0012J3\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u001aJ \u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006 "}, d2={"Lorg/locationtech/jts/algorithm/MinimumAreaRectangle;", "", "inputGeom", "Lorg/locationtech/jts/geom/Geometry;", "isConvex", "", "<init>", "(Lorg/locationtech/jts/geom/Geometry;Z)V", "minimumRectangle", "getMinimumRectangle", "()Lorg/locationtech/jts/geom/Geometry;", "computeConvex", "convexGeom", "computeConvexRing", "Lorg/locationtech/jts/geom/Polygon;", "ring", "", "Lorg/locationtech/jts/geom/Coordinate;", "([Lorg/locationtech/jts/geom/Coordinate;)Lorg/locationtech/jts/geom/Polygon;", "findFurthestVertex", "", "pts", "baseSeg", "Lorg/locationtech/jts/geom/LineSegment;", "startIndex", "orient", "([Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/LineSegment;II)I", "isFurtherOrEqual", "d1", "", "d2", "Companion", "kts-core"})
public final class MinimumAreaRectangle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Geometry inputGeom;
    private final boolean isConvex;

    @JvmOverloads
    public MinimumAreaRectangle(@NotNull Geometry inputGeom, boolean isConvex) {
        Intrinsics.checkNotNullParameter((Object)inputGeom, (String)"inputGeom");
        this.inputGeom = inputGeom;
        this.isConvex = isConvex;
    }

    public /* synthetic */ MinimumAreaRectangle(Geometry geometry, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(geometry, bl);
    }

    private final Geometry getMinimumRectangle() {
        if (this.inputGeom.isEmpty()) {
            return GeometryFactory.createPolygon$default(this.inputGeom.getFactory(), null, null, 3, null);
        }
        if (this.isConvex) {
            return this.computeConvex(this.inputGeom);
        }
        Geometry convexGeom = new ConvexHull(this.inputGeom).getConvexHull();
        return this.computeConvex(convexGeom);
    }

    private final Geometry computeConvex(Geometry convexGeom) {
        Coordinate[] convexHullPts = null;
        if (convexGeom instanceof Polygon) {
            LinearRing linearRing = ((Polygon)convexGeom).getExteriorRing();
            Intrinsics.checkNotNull((Object)linearRing);
            convexHullPts = linearRing.getCoordinates();
        } else {
            convexHullPts = convexGeom.getCoordinates();
        }
        Intrinsics.checkNotNull((Object)convexHullPts);
        if (convexHullPts.length != 0) {
            if (convexHullPts.length == 1) {
                return this.inputGeom.getFactory().createPoint(convexHullPts[0].copy());
            }
            if (convexHullPts.length == 2 || convexHullPts.length == 3) {
                return MinimumAreaRectangle.Companion.computeMaximumLine(convexHullPts, this.inputGeom.getFactory());
            }
        }
        return this.computeConvexRing(convexHullPts);
    }

    private final Polygon computeConvexRing(Coordinate[] ring) {
        double minRectangleArea = Double.MAX_VALUE;
        int minRectangleBaseIndex = -1;
        int minRectangleDiamIndex = -1;
        int minRectangleLeftIndex = -1;
        int minRectangleRightIndex = -1;
        int diameterIndex = 1;
        int leftSideIndex = 1;
        int rightSideIndex = -1;
        LineSegment segBase = new LineSegment(null, null, 3, null);
        LineSegment segDiam = new LineSegment(null, null, 3, null);
        int n = ring.length - 1;
        for (int i = 0; i < n; ++i) {
            Coordinate diamBasePt;
            segBase.p0 = ring[i];
            segBase.p1 = ring[i + 1];
            diameterIndex = this.findFurthestVertex(ring, segBase, diameterIndex, 0);
            Coordinate diamPt = ring[diameterIndex];
            segDiam.p0 = diamBasePt = segBase.project(diamPt);
            segDiam.p1 = diamPt;
            leftSideIndex = this.findFurthestVertex(ring, segDiam, leftSideIndex, 1);
            if (i == 0) {
                rightSideIndex = diameterIndex;
            }
            rightSideIndex = this.findFurthestVertex(ring, segDiam, rightSideIndex, -1);
            double rectWidth = segDiam.distancePerpendicular(ring[leftSideIndex]) + segDiam.distancePerpendicular(ring[rightSideIndex]);
            double rectArea = segDiam.getLength() * rectWidth;
            if (!(rectArea < minRectangleArea)) continue;
            minRectangleArea = rectArea;
            minRectangleBaseIndex = i;
            minRectangleDiamIndex = diameterIndex;
            minRectangleLeftIndex = leftSideIndex;
            minRectangleRightIndex = rightSideIndex;
        }
        return Rectangle.INSTANCE.createFromSidePts(ring[minRectangleBaseIndex], ring[minRectangleBaseIndex + 1], ring[minRectangleDiamIndex], ring[minRectangleLeftIndex], ring[minRectangleRightIndex], this.inputGeom.getFactory());
    }

    private final int findFurthestVertex(Coordinate[] pts, LineSegment baseSeg, int startIndex, int orient) {
        int maxIndex;
        double maxDistance;
        double nextDistance = maxDistance = MinimumAreaRectangle.Companion.orientedDistance(baseSeg, pts[startIndex], orient);
        int nextIndex = maxIndex = startIndex;
        while (this.isFurtherOrEqual(nextDistance, maxDistance, orient)) {
            maxDistance = nextDistance;
            maxIndex = nextIndex;
            if ((nextIndex = MinimumAreaRectangle.Companion.nextIndex(pts, maxIndex)) == startIndex) break;
            nextDistance = MinimumAreaRectangle.Companion.orientedDistance(baseSeg, pts[nextIndex], orient);
        }
        return maxIndex;
    }

    private final boolean isFurtherOrEqual(double d1, double d2, int orient) {
        switch (orient) {
            case 0: {
                return Math.abs(d1) >= Math.abs(d2);
            }
            case 1: {
                return d1 >= d2;
            }
            case -1: {
                return d1 <= d2;
            }
        }
        throw new IllegalArgumentException("Invalid orientation index: " + orient);
    }

    @JvmOverloads
    public MinimumAreaRectangle(@NotNull Geometry inputGeom) {
        Intrinsics.checkNotNullParameter((Object)inputGeom, (String)"inputGeom");
        this(inputGeom, false, 2, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J#\u0010\u000f\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\u0006\u0010\u0012\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u0013J#\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a2\u0006\u0002\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lorg/locationtech/jts/algorithm/MinimumAreaRectangle$Companion;", "", "<init>", "()V", "getMinimumRectangle", "Lorg/locationtech/jts/geom/Geometry;", "geom", "orientedDistance", "", "seg", "Lorg/locationtech/jts/geom/LineSegment;", "p", "Lorg/locationtech/jts/geom/Coordinate;", "orient", "", "nextIndex", "ring", "", "index", "([Lorg/locationtech/jts/geom/Coordinate;I)I", "computeMaximumLine", "Lorg/locationtech/jts/geom/LineString;", "pts", "factory", "Lorg/locationtech/jts/geom/GeometryFactory;", "([Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/GeometryFactory;)Lorg/locationtech/jts/geom/LineString;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Geometry getMinimumRectangle(@NotNull Geometry geom) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            return new MinimumAreaRectangle(geom, false, 2, null).getMinimumRectangle();
        }

        private final double orientedDistance(LineSegment seg, Coordinate p, int orient) {
            double dist = seg.distancePerpendicularOriented(p);
            if (orient == 0) {
                return Math.abs(dist);
            }
            return dist;
        }

        private final int nextIndex(Coordinate[] ring, int index) {
            int index2 = index;
            if (++index2 >= ring.length - 1) {
                index2 = 0;
            }
            return index2;
        }

        private final LineString computeMaximumLine(Coordinate[] pts, GeometryFactory factory) {
            Coordinate ptMinX = null;
            Coordinate ptMaxX = null;
            Coordinate ptMinY = null;
            Coordinate ptMaxY = null;
            for (Coordinate p : pts) {
                if (ptMinX == null || p.getX() < ptMinX.getX()) {
                    ptMinX = p;
                }
                if (ptMaxX == null || p.getX() > ptMaxX.getX()) {
                    ptMaxX = p;
                }
                if (ptMinY == null || p.getY() < ptMinY.getY()) {
                    ptMinY = p;
                }
                if (ptMaxY != null && !(p.getY() > ptMaxY.getY())) continue;
                ptMaxY = p;
            }
            Coordinate p0 = ptMinX;
            Coordinate p1 = ptMaxX;
            Coordinate coordinate = p0;
            Intrinsics.checkNotNull(coordinate);
            double d = coordinate.getX();
            Coordinate coordinate2 = p1;
            Intrinsics.checkNotNull(coordinate2);
            if (d == coordinate2.getX()) {
                p0 = ptMinY;
                p1 = ptMaxY;
            }
            Coordinate[] coordinateArray = new Coordinate[2];
            Coordinate coordinate3 = p0;
            Intrinsics.checkNotNull((Object)coordinate3);
            coordinateArray[0] = coordinate3.copy();
            Coordinate coordinate4 = p1;
            Intrinsics.checkNotNull((Object)coordinate4);
            coordinateArray[1] = coordinate4.copy();
            return factory.createLineString(coordinateArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

