/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/locationtech/jts/algorithm/RayCrossingCounter;", "", "p", "Lorg/locationtech/jts/geom/Coordinate;", "<init>", "(Lorg/locationtech/jts/geom/Coordinate;)V", "crossingCount", "", "value", "", "isOnSegment", "()Z", "countSegment", "", "p1", "p2", "location", "getLocation", "()I", "isPointInPolygon", "Companion", "kts-core"})
public final class RayCrossingCounter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Coordinate p;
    private int crossingCount;
    private boolean isOnSegment;

    public RayCrossingCounter(@NotNull Coordinate p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        this.p = p;
    }

    public final boolean isOnSegment() {
        return this.isOnSegment;
    }

    public final void countSegment(@NotNull Coordinate p1, @NotNull Coordinate p2) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        if (p1.x < this.p.x && p2.x < this.p.x) {
            return;
        }
        if (this.p.x == p2.x && this.p.y == p2.y) {
            this.isOnSegment = true;
            return;
        }
        if (p1.y == this.p.y && p2.y == this.p.y) {
            double d;
            double minx = p1.x;
            double maxx = p2.x;
            if (minx > maxx) {
                minx = p2.x;
                maxx = p1.x;
            }
            boolean bl = minx <= (d = this.p.x) ? d <= maxx : false;
            if (bl) {
                this.isOnSegment = true;
            }
            return;
        }
        if (p1.y > this.p.y && p2.y <= this.p.y || p2.y > this.p.y && p1.y <= this.p.y) {
            int orient = Orientation.index(p1, p2, this.p);
            if (orient == 0) {
                this.isOnSegment = true;
                return;
            }
            if (p2.y < p1.y) {
                orient = -orient;
            }
            if (orient == 1) {
                int n = this.crossingCount;
                this.crossingCount = n + 1;
            }
        }
    }

    public final int getLocation() {
        if (this.isOnSegment) {
            return 1;
        }
        return this.crossingCount % 2 == 1 ? 0 : 2;
    }

    public final boolean isPointInPolygon() {
        return this.getLocation() != 2;
    }

    @JvmStatic
    public static final int locatePointInRing(@NotNull Coordinate p, @NotNull Coordinate[] ring) {
        return Companion.locatePointInRing(p, ring);
    }

    @JvmStatic
    public static final int locatePointInRing(@NotNull Coordinate p, @NotNull CoordinateSequence ring) {
        return Companion.locatePointInRing(p, ring);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0007\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Lorg/locationtech/jts/algorithm/RayCrossingCounter$Companion;", "", "<init>", "()V", "locatePointInRing", "", "p", "Lorg/locationtech/jts/geom/Coordinate;", "ring", "", "(Lorg/locationtech/jts/geom/Coordinate;[Lorg/locationtech/jts/geom/Coordinate;)I", "Lorg/locationtech/jts/geom/CoordinateSequence;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final int locatePointInRing(@NotNull Coordinate p, @NotNull Coordinate[] ring) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)ring, (String)"ring");
            RayCrossingCounter counter = new RayCrossingCounter(p);
            int n = ring.length;
            for (int i = 1; i < n; ++i) {
                Coordinate p1 = ring[i];
                Coordinate p2 = ring[i - 1];
                counter.countSegment(p1, p2);
                if (!counter.isOnSegment()) continue;
                return counter.getLocation();
            }
            return counter.getLocation();
        }

        @JvmStatic
        public final int locatePointInRing(@NotNull Coordinate p, @NotNull CoordinateSequence ring) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)ring, (String)"ring");
            RayCrossingCounter counter = new RayCrossingCounter(p);
            Coordinate p1 = new Coordinate();
            Coordinate p2 = new Coordinate();
            int n = ring.size();
            for (int i = 1; i < n; ++i) {
                p1.x = ring.getOrdinate(i, 0);
                p1.y = ring.getOrdinate(i, 1);
                p2.x = ring.getOrdinate(i - 1, 0);
                p2.y = ring.getOrdinate(i - 1, 1);
                counter.countSegment(p1, p2);
                if (!counter.isOnSegment()) continue;
                return counter.getLocation();
            }
            return counter.getLocation();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

