/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.Distance;
import org.locationtech.jts.algorithm.Intersection;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u0007H\u0016J0\u0010\n\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u0007H\u0014J(\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0002J(\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0002J(\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/locationtech/jts/algorithm/RobustLineIntersector;", "Lorg/locationtech/jts/algorithm/LineIntersector;", "<init>", "()V", "computeIntersection", "", "p", "Lorg/locationtech/jts/geom/Coordinate;", "p1", "p2", "computeIntersect", "", "q1", "q2", "computeCollinearIntersection", "intersection", "intersectionSafe", "isInSegmentEnvelopes", "", "intPt", "Companion", "kts-core"})
public final class RobustLineIntersector
extends LineIntersector {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void computeIntersection(@Nullable Coordinate p, @Nullable Coordinate p1, @Nullable Coordinate p2) {
        this.setProper(false);
        Coordinate coordinate = p1;
        Intrinsics.checkNotNull((Object)coordinate);
        Coordinate coordinate2 = p2;
        Intrinsics.checkNotNull((Object)coordinate2);
        Coordinate coordinate3 = p;
        Intrinsics.checkNotNull((Object)coordinate3);
        if (Envelope.Companion.intersects(coordinate, coordinate2, coordinate3) && Orientation.index(p1, p2, p) == 0 && Orientation.index(p2, p1, p) == 0) {
            this.setProper(true);
            if (Intrinsics.areEqual((Object)p, (Object)p1) || Intrinsics.areEqual((Object)p, (Object)p2)) {
                this.setProper(false);
            }
            this.setIntersectionNum(1);
            return;
        }
        this.setIntersectionNum(0);
    }

    @Override
    protected int computeIntersect(@Nullable Coordinate p1, @Nullable Coordinate p2, @Nullable Coordinate q1, @Nullable Coordinate q2) {
        boolean collinear;
        this.setProper(false);
        Coordinate coordinate = p1;
        Intrinsics.checkNotNull((Object)coordinate);
        Coordinate coordinate2 = p2;
        Intrinsics.checkNotNull((Object)coordinate2);
        Coordinate coordinate3 = q1;
        Intrinsics.checkNotNull((Object)coordinate3);
        Coordinate coordinate4 = q2;
        Intrinsics.checkNotNull((Object)coordinate4);
        if (!Envelope.Companion.intersects(coordinate, coordinate2, coordinate3, coordinate4)) {
            return 0;
        }
        int Pq1 = Orientation.index(p1, p2, q1);
        int Pq2 = Orientation.index(p1, p2, q2);
        if (Pq1 > 0 && Pq2 > 0 || Pq1 < 0 && Pq2 < 0) {
            return 0;
        }
        int Qp1 = Orientation.index(q1, q2, p1);
        int Qp2 = Orientation.index(q1, q2, p2);
        if (Qp1 > 0 && Qp2 > 0 || Qp1 < 0 && Qp2 < 0) {
            return 0;
        }
        boolean bl = collinear = Pq1 == 0 && Pq2 == 0 && Qp1 == 0 && Qp2 == 0;
        if (collinear) {
            return this.computeCollinearIntersection(p1, p2, q1, q2);
        }
        Coordinate p = null;
        double z = Double.NaN;
        if (Pq1 == 0 || Pq2 == 0 || Qp1 == 0 || Qp2 == 0) {
            this.setProper(false);
            if (p1.equals2D(q1)) {
                p = p1;
                z = RobustLineIntersector.Companion.zGet(p1, q1);
            } else if (p1.equals2D(q2)) {
                p = p1;
                z = RobustLineIntersector.Companion.zGet(p1, q2);
            } else if (p2.equals2D(q1)) {
                p = p2;
                z = RobustLineIntersector.Companion.zGet(p2, q1);
            } else if (p2.equals2D(q2)) {
                p = p2;
                z = RobustLineIntersector.Companion.zGet(p2, q2);
            } else if (Pq1 == 0) {
                p = q1;
                z = RobustLineIntersector.Companion.zGetOrInterpolate(q1, p1, p2);
            } else if (Pq2 == 0) {
                p = q2;
                z = RobustLineIntersector.Companion.zGetOrInterpolate(q2, p1, p2);
            } else if (Qp1 == 0) {
                p = p1;
                z = RobustLineIntersector.Companion.zGetOrInterpolate(p1, q1, q2);
            } else if (Qp2 == 0) {
                p = p2;
                z = RobustLineIntersector.Companion.zGetOrInterpolate(p2, q1, q2);
            }
        } else {
            this.setProper(true);
            p = this.intersection(p1, p2, q1, q2);
            z = RobustLineIntersector.Companion.zInterpolate(p, p1, p2, q1, q2);
        }
        this.intPt[0] = RobustLineIntersector.Companion.copyWithZ(p, z);
        return 1;
    }

    private final int computeCollinearIntersection(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        boolean q1inP = Envelope.Companion.intersects(p1, p2, q1);
        boolean q2inP = Envelope.Companion.intersects(p1, p2, q2);
        boolean p1inQ = Envelope.Companion.intersects(q1, q2, p1);
        boolean p2inQ = Envelope.Companion.intersects(q1, q2, p2);
        if (q1inP && q2inP) {
            this.intPt[0] = RobustLineIntersector.Companion.copyWithZInterpolate(q1, p1, p2);
            this.intPt[1] = RobustLineIntersector.Companion.copyWithZInterpolate(q2, p1, p2);
            return 2;
        }
        if (p1inQ && p2inQ) {
            this.intPt[0] = RobustLineIntersector.Companion.copyWithZInterpolate(p1, q1, q2);
            this.intPt[1] = RobustLineIntersector.Companion.copyWithZInterpolate(p2, q1, q2);
            return 2;
        }
        if (q1inP && p1inQ) {
            this.intPt[0] = RobustLineIntersector.Companion.copyWithZInterpolate(q1, p1, p2);
            this.intPt[1] = RobustLineIntersector.Companion.copyWithZInterpolate(p1, q1, q2);
            return Intrinsics.areEqual((Object)q1, (Object)p1) && !q2inP && !p2inQ ? 1 : 2;
        }
        if (q1inP && p2inQ) {
            this.intPt[0] = RobustLineIntersector.Companion.copyWithZInterpolate(q1, p1, p2);
            this.intPt[1] = RobustLineIntersector.Companion.copyWithZInterpolate(p2, q1, q2);
            return Intrinsics.areEqual((Object)q1, (Object)p2) && !q2inP && !p1inQ ? 1 : 2;
        }
        if (q2inP && p1inQ) {
            this.intPt[0] = RobustLineIntersector.Companion.copyWithZInterpolate(q2, p1, p2);
            this.intPt[1] = RobustLineIntersector.Companion.copyWithZInterpolate(p1, q1, q2);
            return Intrinsics.areEqual((Object)q2, (Object)p1) && !q1inP && !p2inQ ? 1 : 2;
        }
        if (q2inP && p2inQ) {
            this.intPt[0] = RobustLineIntersector.Companion.copyWithZInterpolate(q2, p1, p2);
            this.intPt[1] = RobustLineIntersector.Companion.copyWithZInterpolate(p2, q1, q2);
            return Intrinsics.areEqual((Object)q2, (Object)p2) && !q1inP && !p1inQ ? 1 : 2;
        }
        return 0;
    }

    private final Coordinate intersection(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        Coordinate intPt = this.intersectionSafe(p1, p2, q1, q2);
        if (!this.isInSegmentEnvelopes(intPt)) {
            intPt = RobustLineIntersector.Companion.copy(RobustLineIntersector.Companion.nearestEndpoint(p1, p2, q1, q2));
        }
        if (this.getPrecisionModel() != null) {
            PrecisionModel precisionModel = this.getPrecisionModel();
            Intrinsics.checkNotNull((Object)precisionModel);
            precisionModel.makePrecise(intPt);
        }
        return intPt;
    }

    private final Coordinate intersectionSafe(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
        Coordinate intPt = Intersection.intersection(p1, p2, q1, q2);
        if (intPt == null) {
            intPt = RobustLineIntersector.Companion.nearestEndpoint(p1, p2, q1, q2);
        }
        return intPt;
    }

    private final boolean isInSegmentEnvelopes(Coordinate intPt) {
        Coordinate coordinate = this.inputLines[0][0];
        Intrinsics.checkNotNull((Object)coordinate);
        Coordinate coordinate2 = this.inputLines[0][1];
        Intrinsics.checkNotNull((Object)coordinate2);
        Envelope env0 = new Envelope(coordinate, coordinate2);
        Coordinate coordinate3 = this.inputLines[1][0];
        Intrinsics.checkNotNull((Object)coordinate3);
        Coordinate coordinate4 = this.inputLines[1][1];
        Intrinsics.checkNotNull((Object)coordinate4);
        Envelope env1 = new Envelope(coordinate3, coordinate4);
        Coordinate coordinate5 = intPt;
        Intrinsics.checkNotNull((Object)coordinate5);
        return env0.contains(coordinate5) && env1.contains(intPt);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u001a\u0010\t\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0002J(\u0010\r\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J \u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0002J\"\u0010\u0013\u001a\u00020\u000b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0002J2\u0010\u0013\u001a\u00020\u000b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/locationtech/jts/algorithm/RobustLineIntersector$Companion;", "", "<init>", "()V", "copyWithZInterpolate", "Lorg/locationtech/jts/geom/Coordinate;", "p", "p1", "p2", "copyWithZ", "z", "", "copy", "nearestEndpoint", "q1", "q2", "zGet", "q", "zGetOrInterpolate", "zInterpolate", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        private final Coordinate copyWithZInterpolate(Coordinate p, Coordinate p1, Coordinate p2) {
            return this.copyWithZ(p, this.zGetOrInterpolate(p, p1, p2));
        }

        private final Coordinate copyWithZ(Coordinate p, double z) {
            Coordinate pCopy = this.copy(p);
            if (!Math.INSTANCE.isNaN(z)) {
                pCopy.setZ(z);
            }
            return pCopy;
        }

        private final Coordinate copy(Coordinate p) {
            Coordinate coordinate = p;
            Intrinsics.checkNotNull((Object)coordinate);
            return new Coordinate(coordinate);
        }

        private final Coordinate nearestEndpoint(Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
            Coordinate nearestPt = p1;
            double minDist = Distance.pointToSegment(p1, q1, q2);
            double dist = Distance.pointToSegment(p2, q1, q2);
            if (dist < minDist) {
                minDist = dist;
                nearestPt = p2;
            }
            if ((dist = Distance.pointToSegment(q1, p1, p2)) < minDist) {
                minDist = dist;
                nearestPt = q1;
            }
            if ((dist = Distance.pointToSegment(q2, p1, p2)) < minDist) {
                minDist = dist;
                nearestPt = q2;
            }
            return nearestPt;
        }

        private final double zGet(Coordinate p, Coordinate q) {
            double z = p.getZ();
            if (Math.INSTANCE.isNaN(z)) {
                z = q.getZ();
            }
            return z;
        }

        private final double zGetOrInterpolate(Coordinate p, Coordinate p1, Coordinate p2) {
            double z = p.getZ();
            return !Math.INSTANCE.isNaN(z) ? z : this.zInterpolate(p, p1, p2);
        }

        private final double zInterpolate(Coordinate p, Coordinate p1, Coordinate p2) {
            double p1z = p1.getZ();
            double p2z = p2.getZ();
            if (Math.INSTANCE.isNaN(p1z)) {
                return p2z;
            }
            if (Math.INSTANCE.isNaN(p2z)) {
                return p1z;
            }
            Coordinate coordinate = p;
            Intrinsics.checkNotNull((Object)coordinate);
            if (coordinate.equals2D(p1)) {
                return p1z;
            }
            if (p.equals2D(p2)) {
                return p2z;
            }
            double dz = p2z - p1z;
            if (dz == 0.0) {
                return p1z;
            }
            double dx = p2.x - p1.x;
            double dy = p2.y - p1.y;
            double seglen = dx * dx + dy * dy;
            double xoff = p.x - p1.x;
            double yoff = p.y - p1.y;
            double plen = xoff * xoff + yoff * yoff;
            double frac = Math.INSTANCE.sqrt(plen / seglen);
            double zoff = dz * frac;
            return p1z + zoff;
        }

        private final double zInterpolate(Coordinate p, Coordinate p1, Coordinate p2, Coordinate q1, Coordinate q2) {
            double zp = this.zInterpolate(p, p1, p2);
            double zq = this.zInterpolate(p, q1, q2);
            if (Math.INSTANCE.isNaN(zp)) {
                return zq;
            }
            return Math.INSTANCE.isNaN(zq) ? zp : (zp + zq) / 2.0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

