/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm.distance;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.distance.PointPairDistance;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000  2\u00020\u0001:\u0005\u001c\u001d\u001e\u001f B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0002Ja\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\"\u0010\u0018\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00150\u0019j\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0015`\u001aH\u0002\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"Lorg/locationtech/jts/algorithm/distance/DiscreteFrechetDistance;", "", "g0", "Lorg/locationtech/jts/geom/Geometry;", "g1", "<init>", "(Lorg/locationtech/jts/geom/Geometry;Lorg/locationtech/jts/geom/Geometry;)V", "ptDist", "Lorg/locationtech/jts/algorithm/distance/PointPairDistance;", "distance", "", "coordinates", "", "Lorg/locationtech/jts/geom/Coordinate;", "getCoordinates", "()[Lorg/locationtech/jts/geom/Coordinate;", "computeCoordinateDistances", "", "coords0", "coords1", "diagonal", "", "distances", "Lorg/locationtech/jts/algorithm/distance/DiscreteFrechetDistance$MatrixStorage;", "distanceToPair", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "([Lorg/locationtech/jts/geom/Coordinate;[Lorg/locationtech/jts/geom/Coordinate;[ILorg/locationtech/jts/algorithm/distance/DiscreteFrechetDistance$MatrixStorage;Ljava/util/HashMap;)V", "MatrixStorage", "RectMatrix", "CsrMatrix", "HashMapMatrix", "Companion", "kts-core"})
@SourceDebugExtension(value={"SMAP\nDiscreteFrechetDistance.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiscreteFrechetDistance.kt\norg/locationtech/jts/algorithm/distance/DiscreteFrechetDistance\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,528:1\n383#2,7:529\n383#2,7:536\n383#2,7:543\n*S KotlinDebug\n*F\n+ 1 DiscreteFrechetDistance.kt\norg/locationtech/jts/algorithm/distance/DiscreteFrechetDistance\n*L\n128#1:529,7\n152#1:536,7\n166#1:543,7\n*E\n"})
public final class DiscreteFrechetDistance {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Geometry g0;
    @NotNull
    private final Geometry g1;
    @Nullable
    private PointPairDistance ptDist;

    public DiscreteFrechetDistance(@NotNull Geometry g0, @NotNull Geometry g1) {
        Intrinsics.checkNotNullParameter((Object)g0, (String)"g0");
        Intrinsics.checkNotNullParameter((Object)g1, (String)"g1");
        this.g0 = g0;
        this.g1 = g1;
    }

    private final double distance() {
        Coordinate[] coords0 = this.g0.getCoordinates();
        Coordinate[] coords1 = this.g1.getCoordinates();
        Intrinsics.checkNotNull((Object)coords0);
        int n = coords0.length;
        Intrinsics.checkNotNull((Object)coords1);
        MatrixStorage distances = DiscreteFrechetDistance.Companion.createMatrixStorage(n, coords1.length);
        int[] diagonal = Companion.bresenhamDiagonal(coords0.length, coords1.length);
        HashMap<Double, int[]> distanceToPair = new HashMap<Double, int[]>();
        this.computeCoordinateDistances(coords0, coords1, diagonal, distances, distanceToPair);
        PointPairDistance pointPairDistance = this.ptDist = DiscreteFrechetDistance.Companion.computeFrechet(coords0, coords1, diagonal, distances, distanceToPair);
        Intrinsics.checkNotNull((Object)pointPairDistance);
        return pointPairDistance.getDistance();
    }

    @NotNull
    public final Coordinate[] getCoordinates() {
        if (this.ptDist == null) {
            this.distance();
        }
        PointPairDistance pointPairDistance = this.ptDist;
        Intrinsics.checkNotNull((Object)pointPairDistance);
        return pointPairDistance.getCoordinates();
    }

    /*
     * WARNING - void declaration
     */
    private final void computeCoordinateDistances(Coordinate[] coords0, Coordinate[] coords1, int[] diagonal, MatrixStorage distances, HashMap<Double, int[]> distanceToPair) {
        int[] answer$iv;
        int[] nArray;
        Object value$iv;
        Map $this$getOrPut$iv;
        boolean $i$f$getOrPut;
        Object key$iv;
        int numDiag = diagonal.length;
        double maxDistOnDiag = 0.0;
        int imin = 0;
        int jmin = 0;
        Intrinsics.checkNotNull((Object)coords0);
        int numCoords0 = coords0.length;
        Intrinsics.checkNotNull((Object)coords1);
        int numCoords1 = coords1.length;
        DiscreteFrechetDistance $this$computeCoordinateDistances_u24lambda_u240 = this;
        boolean bl = false;
        for (int k = 0; k < numDiag; k += 2) {
            int i0 = diagonal[k];
            int j0 = diagonal[k + 1];
            double diagDist = coords0[i0].distance(coords1[j0]);
            if (diagDist > maxDistOnDiag) {
                maxDistOnDiag = diagDist;
            }
            distances.set(i0, j0, diagDist);
            Map map = distanceToPair;
            key$iv = diagDist;
            $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv != null) continue;
            boolean bl2 = false;
            nArray = new int[]{i0, j0};
            answer$iv = nArray;
            $this$getOrPut$iv.put(key$iv, answer$iv);
        }
        for (int k = 0; k < numDiag - 2; k += 2) {
            double dist;
            double dist22;
            int i0 = diagonal[k];
            int j0 = diagonal[k + 1];
            Coordinate coord0 = coords0[i0];
            Coordinate coord1 = coords1[j0];
            int i = 0;
            i = i0 + 1;
            while (i < numCoords0 && !distances.isValueSet(i, j0) && ((dist22 = coords0[i].distance(coord1)) < maxDistOnDiag || i < imin)) {
                Object object;
                distances.set(i, j0, dist22);
                $this$getOrPut$iv = distanceToPair;
                key$iv = dist22;
                $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl3 = false;
                    nArray = new int[]{i, j0};
                    answer$iv = nArray;
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                int[] cfr_ignored_0 = (int[])object;
                int dist22 = i;
                i = dist22 + 1;
            }
            imin = i;
            int j = 0;
            j = j0 + 1;
            while (j < numCoords1 && !distances.isValueSet(i0, j) && ((dist = coord0.distance(coords1[j])) < maxDistOnDiag || j < jmin)) {
                Object object;
                void $this$getOrPut$iv2;
                distances.set(i0, j, dist);
                key$iv = distanceToPair;
                Double key$iv2 = dist;
                boolean $i$f$getOrPut2 = false;
                Object value$iv2 = $this$getOrPut$iv2.get(key$iv2);
                if (value$iv2 == null) {
                    boolean bl4 = false;
                    int[] nArray2 = new int[]{i0, j};
                    int[] answer$iv2 = nArray2;
                    $this$getOrPut$iv2.put(key$iv2, answer$iv2);
                    object = answer$iv2;
                } else {
                    object = value$iv2;
                }
                int[] cfr_ignored_1 = (int[])object;
                int n = j;
                j = n + 1;
            }
            jmin = j;
        }
    }

    @JvmStatic
    public static final double distance(@NotNull Geometry g0, @NotNull Geometry g1) {
        return Companion.distance(g0, g1);
    }

    @JvmStatic
    @NotNull
    public static final int[] bresenhamDiagonal(int numCols, int numRows) {
        return Companion.bresenhamDiagonal(numCols, numRows);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002Ja\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\n2\"\u0010\u0017\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00150\u0018j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0015`\u0019H\u0002\u00a2\u0006\u0002\u0010\u001aJ \u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\fH\u0002J\u0018\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\fH\u0007\u00a8\u0006\""}, d2={"Lorg/locationtech/jts/algorithm/distance/DiscreteFrechetDistance$Companion;", "", "<init>", "()V", "distance", "", "g0", "Lorg/locationtech/jts/geom/Geometry;", "g1", "createMatrixStorage", "Lorg/locationtech/jts/algorithm/distance/DiscreteFrechetDistance$MatrixStorage;", "rows", "", "cols", "computeFrechet", "Lorg/locationtech/jts/algorithm/distance/PointPairDistance;", "coords0", "", "Lorg/locationtech/jts/geom/Coordinate;", "coords1", "diagonal", "", "distances", "distanceToPair", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "([Lorg/locationtech/jts/geom/Coordinate;[Lorg/locationtech/jts/geom/Coordinate;[ILorg/locationtech/jts/algorithm/distance/DiscreteFrechetDistance$MatrixStorage;Ljava/util/HashMap;)Lorg/locationtech/jts/algorithm/distance/PointPairDistance;", "getMinDistanceAtCorner", "matrix", "i", "j", "bresenhamDiagonal", "numCols", "numRows", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final double distance(@NotNull Geometry g0, @NotNull Geometry g1) {
            Intrinsics.checkNotNullParameter((Object)g0, (String)"g0");
            Intrinsics.checkNotNullParameter((Object)g1, (String)"g1");
            DiscreteFrechetDistance dist = new DiscreteFrechetDistance(g0, g1);
            return dist.distance();
        }

        private final MatrixStorage createMatrixStorage(int rows, int cols) {
            int max = Math.INSTANCE.max(rows, cols);
            return max < 1024 ? (MatrixStorage)new RectMatrix(rows, cols, Double.POSITIVE_INFINITY) : (MatrixStorage)new CsrMatrix(rows, cols, Double.POSITIVE_INFINITY, 0, 8, null);
        }

        private final PointPairDistance computeFrechet(Coordinate[] coords0, Coordinate[] coords1, int[] diagonal, MatrixStorage distances, HashMap<Double, int[]> distanceToPair) {
            for (int d = 0; d < diagonal.length; d += 2) {
                double dist;
                int i0 = diagonal[d];
                int j0 = diagonal[d + 1];
                Intrinsics.checkNotNull((Object)coords0);
                int n = coords0.length;
                for (int i = i0; i < n && distances.isValueSet(i, j0); ++i) {
                    dist = this.getMinDistanceAtCorner(distances, i, j0);
                    if (!(dist > distances.get(i, j0))) continue;
                    distances.set(i, j0, dist);
                }
                Intrinsics.checkNotNull((Object)coords1);
                n = coords1.length;
                for (int j = j0 + 1; j < n && distances.isValueSet(i0, j); ++j) {
                    dist = this.getMinDistanceAtCorner(distances, i0, j);
                    if (!(dist > distances.get(i0, j))) continue;
                    distances.set(i0, j, dist);
                }
            }
            PointPairDistance result2 = new PointPairDistance();
            Intrinsics.checkNotNull((Object)coords0);
            int n = coords0.length - 1;
            Intrinsics.checkNotNull((Object)coords1);
            double distance = distances.get(n, coords1.length - 1);
            int[] nArray = distanceToPair.get(distance);
            if (nArray == null) {
                throw new IllegalStateException("Pair of points not recorded for computed distance");
            }
            int[] index = nArray;
            result2.initialize(coords0[index[0]], coords1[index[1]], distance);
            return result2;
        }

        private final double getMinDistanceAtCorner(MatrixStorage matrix, int i, int j) {
            if (i > 0 && j > 0) {
                double d0 = matrix.get(i - 1, j - 1);
                double d1 = matrix.get(i - 1, j);
                double d2 = matrix.get(i, j - 1);
                return Math.INSTANCE.min(Math.INSTANCE.min(d0, d1), d2);
            }
            if (i == 0 && j == 0) {
                return matrix.get(0, 0);
            }
            return i == 0 ? matrix.get(0, j - 1) : matrix.get(i - 1, 0);
        }

        @JvmStatic
        @NotNull
        public final int[] bresenhamDiagonal(int numCols, int numRows) {
            int dim = Math.INSTANCE.max(numCols, numRows);
            int[] diagXY = new int[2 * dim];
            int dx = numCols - 1;
            int dy = numRows - 1;
            int err = 0;
            int i = 0;
            if (numCols > numRows) {
                int y = 0;
                err = 2 * dy - dx;
                for (int x = 0; x < numCols; ++x) {
                    diagXY[i++] = x;
                    diagXY[i++] = y++;
                    if (err > 0) {
                        err -= 2 * dx;
                    }
                    err += 2 * dy;
                }
            } else {
                int x = 0;
                err = 2 * dx - dy;
                for (int y = 0; y < numRows; ++y) {
                    diagXY[i++] = x++;
                    diagXY[i++] = y;
                    if (err > 0) {
                        err -= 2 * dy;
                    }
                    err += 2 * dx;
                }
            }
            return diagXY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB+\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\u0019\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0096\u0002J!\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0006H\u0096\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0003H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/locationtech/jts/algorithm/distance/DiscreteFrechetDistance$CsrMatrix;", "Lorg/locationtech/jts/algorithm/distance/DiscreteFrechetDistance$MatrixStorage;", "numRows", "", "numCols", "defaultValue", "", "expectedValues", "<init>", "(IIDI)V", "v", "", "ri", "", "ci", "indexOf", "i", "j", "get", "set", "", "value", "isValueSet", "", "ensureCapacity", "required", "Companion", "kts-core"})
    public static final class CsrMatrix
    extends MatrixStorage {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private double[] v;
        @NotNull
        private final int[] ri;
        @NotNull
        private int[] ci;

        @JvmOverloads
        public CsrMatrix(int numRows, int numCols, double defaultValue, int expectedValues) {
            super(numRows, numCols, defaultValue);
            this.v = new double[expectedValues];
            this.ci = new int[expectedValues];
            this.ri = new int[numRows + 1];
        }

        public /* synthetic */ CsrMatrix(int n, int n2, double d, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 8) != 0) {
                n3 = CsrMatrix.Companion.expectedValuesHeuristic(n, n2);
            }
            this(n, n2, d, n3);
        }

        private final int indexOf(int i, int j) {
            int cHigh = this.ri[i + 1];
            int cLow = this.ri[i];
            return cHigh <= cLow ? ~cLow : CollectionsKt.binarySearch((List)ArraysKt.asList((int[])this.ci), (Comparable)Integer.valueOf(j), (int)cLow, (int)cHigh);
        }

        @Override
        public double get(int i, int j) {
            int vi = this.indexOf(i, j);
            return vi < 0 ? this.getDefaultValue() : this.v[vi];
        }

        @Override
        public void set(int i, int j, double value) {
            int vi = this.indexOf(i, j);
            if (vi < 0) {
                this.ensureCapacity(this.ri[this.getNumRows()] + 1);
                int ii = i + 1;
                int n = this.getNumRows();
                if (ii <= n) {
                    do {
                        int[] nArray = this.ri;
                        int n2 = ++ii;
                        nArray[n2] = nArray[n2] + 1;
                    } while (ii != n);
                }
                if ((n = (vi ^= 0xFFFFFFFF) + 1) <= (ii = this.ri[this.getNumRows()])) {
                    while (true) {
                        this.ci[ii] = this.ci[ii - 1];
                        this.v[ii] = this.v[ii - 1];
                        if (ii == n) break;
                        --ii;
                    }
                }
                this.ci[vi] = j;
            }
            this.v[vi] = value;
        }

        @Override
        public boolean isValueSet(int i, int j) {
            return this.indexOf(i, j) >= 0;
        }

        private final void ensureCapacity(int required) {
            if (required < this.v.length) {
                return;
            }
            int increment = Math.INSTANCE.max(this.getNumRows(), this.getNumCols());
            double[] dArray = Arrays.copyOf(this.v, this.v.length + increment);
            Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"copyOf(...)");
            this.v = dArray;
            int[] nArray = Arrays.copyOf(this.ci, this.v.length + increment);
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
            this.ci = nArray;
        }

        @JvmOverloads
        public CsrMatrix(int numRows, int numCols, double defaultValue) {
            this(numRows, numCols, defaultValue, 0, 8, null);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0002\u00a8\u0006\b"}, d2={"Lorg/locationtech/jts/algorithm/distance/DiscreteFrechetDistance$CsrMatrix$Companion;", "", "<init>", "()V", "expectedValuesHeuristic", "", "numRows", "numCols", "kts-core"})
        public static final class Companion {
            private Companion() {
            }

            private final int expectedValuesHeuristic(int numRows, int numCols) {
                int max = Math.INSTANCE.max(numRows, numCols);
                return max * max / 10;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0096\u0002J!\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0006H\u0096\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0016R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0006`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/locationtech/jts/algorithm/distance/DiscreteFrechetDistance$HashMapMatrix;", "Lorg/locationtech/jts/algorithm/distance/DiscreteFrechetDistance$MatrixStorage;", "numRows", "", "numCols", "defaultValue", "", "<init>", "(IID)V", "matrix", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "get", "i", "j", "set", "", "value", "isValueSet", "", "kts-core"})
    @SourceDebugExtension(value={"SMAP\nDiscreteFrechetDistance.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiscreteFrechetDistance.kt\norg/locationtech/jts/algorithm/distance/DiscreteFrechetDistance$HashMapMatrix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,528:1\n1#2:529\n*E\n"})
    public static final class HashMapMatrix
    extends MatrixStorage {
        @NotNull
        private final HashMap<Long, Double> matrix = new HashMap();

        public HashMapMatrix(int numRows, int numCols, double defaultValue) {
            super(numRows, numCols, defaultValue);
        }

        @Override
        public double get(int i, int j) {
            Map map = this.matrix;
            long key = (long)i << 32 | (long)j;
            Object object = map.get(key);
            if (object == null) {
                boolean bl = false;
                object = this.getDefaultValue();
            }
            return ((Number)object).doubleValue();
        }

        @Override
        public void set(int i, int j, double value) {
            long key = (long)i << 32 | (long)j;
            ((Map)this.matrix).put(key, value);
        }

        @Override
        public boolean isValueSet(int i, int j) {
            long key = (long)i << 32 | (long)j;
            return this.matrix.containsKey(key);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b \u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u00a6\u0002J!\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0006H\u00a6\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H&R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lorg/locationtech/jts/algorithm/distance/DiscreteFrechetDistance$MatrixStorage;", "", "numRows", "", "numCols", "defaultValue", "", "<init>", "(IID)V", "getNumRows", "()I", "getNumCols", "getDefaultValue", "()D", "get", "i", "j", "set", "", "value", "isValueSet", "", "kts-core"})
    public static abstract class MatrixStorage {
        private final int numRows;
        private final int numCols;
        private final double defaultValue;

        public MatrixStorage(int numRows, int numCols, double defaultValue) {
            this.numRows = numRows;
            this.numCols = numCols;
            this.defaultValue = defaultValue;
        }

        protected final int getNumRows() {
            return this.numRows;
        }

        protected final int getNumCols() {
            return this.numCols;
        }

        protected final double getDefaultValue() {
            return this.defaultValue;
        }

        public abstract double get(int var1, int var2);

        public abstract void set(int var1, int var2, double var3);

        public abstract boolean isValueSet(int var1, int var2);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0096\u0002J!\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0006H\u0096\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/locationtech/jts/algorithm/distance/DiscreteFrechetDistance$RectMatrix;", "Lorg/locationtech/jts/algorithm/distance/DiscreteFrechetDistance$MatrixStorage;", "numRows", "", "numCols", "defaultValue", "", "<init>", "(IID)V", "matrix", "", "get", "i", "j", "set", "", "value", "isValueSet", "", "kts-core"})
    public static final class RectMatrix
    extends MatrixStorage {
        @NotNull
        private final double[] matrix;

        public RectMatrix(int numRows, int numCols, double defaultValue) {
            super(numRows, numCols, defaultValue);
            this.matrix = new double[numRows * numCols];
            ArraysKt.fill$default((double[])this.matrix, (double)defaultValue, (int)0, (int)0, (int)6, null);
        }

        @Override
        public double get(int i, int j) {
            return this.matrix[i * this.getNumCols() + j];
        }

        @Override
        public void set(int i, int j, double value) {
            this.matrix[i * this.getNumCols() + j] = value;
        }

        @Override
        public boolean isValueSet(int i, int j) {
            return Math.INSTANCE.doubleToLongBits(this.get(i, j)) != Math.INSTANCE.doubleToLongBits(this.getDefaultValue());
        }
    }
}

