/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm.distance;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.distance.DistanceToPoint;
import org.locationtech.jts.algorithm.distance.PointPairDistance;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \u001a2\u00020\u0001:\u0003\u0018\u0019\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\r\u001a\u00020\nJ\u0006\u0010\u000e\u001a\u00020\nJ\u0018\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002J \u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lorg/locationtech/jts/algorithm/distance/DiscreteHausdorffDistance;", "", "g0", "Lorg/locationtech/jts/geom/Geometry;", "g1", "<init>", "(Lorg/locationtech/jts/geom/Geometry;Lorg/locationtech/jts/geom/Geometry;)V", "ptDist", "Lorg/locationtech/jts/algorithm/distance/PointPairDistance;", "densifyFrac", "", "setDensifyFraction", "", "distance", "orientedDistance", "coordinates", "", "Lorg/locationtech/jts/geom/Coordinate;", "getCoordinates", "()[Lorg/locationtech/jts/geom/Coordinate;", "compute", "computeOrientedDistance", "discreteGeom", "geom", "MaxPointDistanceFilter", "MaxDensifiedByFractionDistanceFilter", "Companion", "kts-core"})
public final class DiscreteHausdorffDistance {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Geometry g0;
    @NotNull
    private final Geometry g1;
    @NotNull
    private final PointPairDistance ptDist;
    private double densifyFrac;

    public DiscreteHausdorffDistance(@NotNull Geometry g0, @NotNull Geometry g1) {
        Intrinsics.checkNotNullParameter((Object)g0, (String)"g0");
        Intrinsics.checkNotNullParameter((Object)g1, (String)"g1");
        this.g0 = g0;
        this.g1 = g1;
        this.ptDist = new PointPairDistance();
    }

    public final void setDensifyFraction(double densifyFrac) {
        if (densifyFrac > 1.0 || densifyFrac <= 0.0) {
            throw new IllegalArgumentException("Fraction is not in range (0.0 - 1.0]");
        }
        this.densifyFrac = densifyFrac;
    }

    public final double distance() {
        this.compute(this.g0, this.g1);
        return this.ptDist.getDistance();
    }

    public final double orientedDistance() {
        this.computeOrientedDistance(this.g0, this.g1, this.ptDist);
        return this.ptDist.getDistance();
    }

    @NotNull
    public final Coordinate[] getCoordinates() {
        return this.ptDist.getCoordinates();
    }

    private final void compute(Geometry g0, Geometry g1) {
        this.computeOrientedDistance(g0, g1, this.ptDist);
        this.computeOrientedDistance(g1, g0, this.ptDist);
    }

    private final void computeOrientedDistance(Geometry discreteGeom, Geometry geom, PointPairDistance ptDist) {
        MaxPointDistanceFilter distFilter = new MaxPointDistanceFilter(geom);
        discreteGeom.apply(distFilter);
        ptDist.setMaximum(distFilter.getMaxPointDistance());
        if (this.densifyFrac > 0.0) {
            MaxDensifiedByFractionDistanceFilter fracFilter = new MaxDensifiedByFractionDistanceFilter(geom, this.densifyFrac);
            discreteGeom.apply(fracFilter);
            ptDist.setMaximum(fracFilter.getMaxPointDistance());
        }
    }

    @JvmStatic
    public static final double distance(@NotNull Geometry g0, @NotNull Geometry g1) {
        return Companion.distance(g0, g1);
    }

    @JvmStatic
    public static final double distance(@NotNull Geometry g0, @NotNull Geometry g1, double densifyFrac) {
        return Companion.distance(g0, g1, densifyFrac);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0007J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0005H\u0007\u00a8\u0006\n"}, d2={"Lorg/locationtech/jts/algorithm/distance/DiscreteHausdorffDistance$Companion;", "", "<init>", "()V", "distance", "", "g0", "Lorg/locationtech/jts/geom/Geometry;", "g1", "densifyFrac", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final double distance(@NotNull Geometry g0, @NotNull Geometry g1) {
            Intrinsics.checkNotNullParameter((Object)g0, (String)"g0");
            Intrinsics.checkNotNullParameter((Object)g1, (String)"g1");
            DiscreteHausdorffDistance dist = new DiscreteHausdorffDistance(g0, g1);
            return dist.distance();
        }

        @JvmStatic
        public final double distance(@NotNull Geometry g0, @NotNull Geometry g1, double densifyFrac) {
            Intrinsics.checkNotNullParameter((Object)g0, (String)"g0");
            Intrinsics.checkNotNullParameter((Object)g1, (String)"g1");
            DiscreteHausdorffDistance dist = new DiscreteHausdorffDistance(g0, g1);
            dist.setDensifyFraction(densifyFrac);
            return dist.distance();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lorg/locationtech/jts/algorithm/distance/DiscreteHausdorffDistance$MaxDensifiedByFractionDistanceFilter;", "Lorg/locationtech/jts/geom/CoordinateSequenceFilter;", "geom", "Lorg/locationtech/jts/geom/Geometry;", "fraction", "", "<init>", "(Lorg/locationtech/jts/geom/Geometry;D)V", "maxPointDistance", "Lorg/locationtech/jts/algorithm/distance/PointPairDistance;", "getMaxPointDistance", "()Lorg/locationtech/jts/algorithm/distance/PointPairDistance;", "minPtDist", "numSubSegs", "", "filter", "", "seq", "Lorg/locationtech/jts/geom/CoordinateSequence;", "index", "isGeometryChanged", "", "()Z", "isDone", "kts-core"})
    public static final class MaxDensifiedByFractionDistanceFilter
    implements CoordinateSequenceFilter {
        @NotNull
        private final Geometry geom;
        @NotNull
        private final PointPairDistance maxPointDistance;
        @NotNull
        private final PointPairDistance minPtDist;
        private int numSubSegs;

        public MaxDensifiedByFractionDistanceFilter(@NotNull Geometry geom, double fraction) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            this.geom = geom;
            this.maxPointDistance = new PointPairDistance();
            this.minPtDist = new PointPairDistance();
            this.numSubSegs = (int)Math.INSTANCE.round(1.0 / fraction);
        }

        @NotNull
        public final PointPairDistance getMaxPointDistance() {
            return this.maxPointDistance;
        }

        @Override
        public void filter(@Nullable CoordinateSequence seq, int index) {
            if (index == 0) {
                return;
            }
            CoordinateSequence coordinateSequence = seq;
            Intrinsics.checkNotNull((Object)coordinateSequence);
            Coordinate p0 = coordinateSequence.getCoordinate(index - 1);
            Coordinate p1 = seq.getCoordinate(index);
            double delx = (p1.x - p0.x) / (double)this.numSubSegs;
            double dely = (p1.y - p0.y) / (double)this.numSubSegs;
            int n = this.numSubSegs;
            for (int i = 0; i < n; ++i) {
                double x = p0.x + (double)i * delx;
                double y = p0.y + (double)i * dely;
                Coordinate pt = new Coordinate(x, y);
                this.minPtDist.initialize();
                DistanceToPoint.INSTANCE.computeDistance(this.geom, pt, this.minPtDist);
                this.maxPointDistance.setMaximum(this.minPtDist);
            }
        }

        @Override
        public boolean isGeometryChanged() {
            return false;
        }

        @Override
        public boolean isDone() {
            return false;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/locationtech/jts/algorithm/distance/DiscreteHausdorffDistance$MaxPointDistanceFilter;", "Lorg/locationtech/jts/geom/CoordinateFilter;", "geom", "Lorg/locationtech/jts/geom/Geometry;", "<init>", "(Lorg/locationtech/jts/geom/Geometry;)V", "maxPointDistance", "Lorg/locationtech/jts/algorithm/distance/PointPairDistance;", "getMaxPointDistance", "()Lorg/locationtech/jts/algorithm/distance/PointPairDistance;", "minPtDist", "filter", "", "pt", "Lorg/locationtech/jts/geom/Coordinate;", "kts-core"})
    public static final class MaxPointDistanceFilter
    implements CoordinateFilter {
        @NotNull
        private final Geometry geom;
        @NotNull
        private final PointPairDistance maxPointDistance;
        @NotNull
        private final PointPairDistance minPtDist;

        public MaxPointDistanceFilter(@NotNull Geometry geom) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            this.geom = geom;
            this.maxPointDistance = new PointPairDistance();
            this.minPtDist = new PointPairDistance();
        }

        @NotNull
        public final PointPairDistance getMaxPointDistance() {
            return this.maxPointDistance;
        }

        @Override
        public void filter(@Nullable Coordinate pt) {
            this.minPtDist.initialize();
            Coordinate coordinate = pt;
            Intrinsics.checkNotNull((Object)coordinate);
            DistanceToPoint.INSTANCE.computeDistance(this.geom, coordinate, this.minPtDist);
            this.maxPointDistance.setMaximum(this.minPtDist);
        }
    }
}

