/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00152\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0003:\u0001\u0015B\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u001c\u0010\f\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0016J,\u0010\u000f\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0007H\u0004R\u001a\u0010\u0006\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/locationtech/jts/geom/CoordinateSequenceComparator;", "Ljava/util/Comparator;", "", "Lkotlin/Comparator;", "<init>", "()V", "dimensionLimit", "", "(I)V", "getDimensionLimit", "()I", "setDimensionLimit", "compare", "o1", "o2", "compareCoordinate", "s1", "Lorg/locationtech/jts/geom/CoordinateSequence;", "s2", "i", "dimension", "Companion", "kts-core"})
public final class CoordinateSequenceComparator
implements Comparator<Object> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int dimensionLimit;

    protected final int getDimensionLimit() {
        return this.dimensionLimit;
    }

    protected final void setDimensionLimit(int n) {
        this.dimensionLimit = n;
    }

    public CoordinateSequenceComparator() {
        this.dimensionLimit = Integer.MAX_VALUE;
    }

    public CoordinateSequenceComparator(int dimensionLimit) {
        this.dimensionLimit = dimensionLimit;
    }

    @Override
    public int compare(@Nullable Object o1, @Nullable Object o2) {
        int i;
        CoordinateSequence s1 = (CoordinateSequence)o1;
        CoordinateSequence s2 = (CoordinateSequence)o2;
        CoordinateSequence coordinateSequence = s1;
        Intrinsics.checkNotNull((Object)coordinateSequence);
        int size1 = coordinateSequence.size();
        CoordinateSequence coordinateSequence2 = s2;
        Intrinsics.checkNotNull((Object)coordinateSequence2);
        int size2 = coordinateSequence2.size();
        int dim1 = s1.getDimension();
        int dim2 = s2.getDimension();
        int minDim = dim1;
        if (dim2 < minDim) {
            minDim = dim2;
        }
        boolean dimLimited = false;
        if (this.dimensionLimit <= minDim) {
            minDim = this.dimensionLimit;
            dimLimited = true;
        }
        if (!dimLimited) {
            if (dim1 < dim2) {
                return -1;
            }
            if (dim1 > dim2) {
                return 1;
            }
        }
        for (i = 0; i < size1 && i < size2; ++i) {
            int ptComp = this.compareCoordinate(s1, s2, i, minDim);
            if (ptComp == 0) continue;
            return ptComp;
        }
        if (i < size1) {
            return 1;
        }
        return i < size2 ? -1 : 0;
    }

    protected final int compareCoordinate(@Nullable CoordinateSequence s1, @Nullable CoordinateSequence s2, int i, int dimension) {
        for (int d = 0; d < dimension; ++d) {
            CoordinateSequence coordinateSequence = s1;
            Intrinsics.checkNotNull((Object)coordinateSequence);
            double ord1 = coordinateSequence.getOrdinate(i, d);
            CoordinateSequence coordinateSequence2 = s2;
            Intrinsics.checkNotNull((Object)coordinateSequence2);
            double ord2 = coordinateSequence2.getOrdinate(i, d);
            int comp = Companion.compare(ord1, ord2);
            if (comp == 0) continue;
            return comp;
        }
        return 0;
    }

    @JvmStatic
    public static final int compare(double a, double b) {
        return Companion.compare(a, b);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0007\u00a8\u0006\t"}, d2={"Lorg/locationtech/jts/geom/CoordinateSequenceComparator$Companion;", "", "<init>", "()V", "compare", "", "a", "", "b", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final int compare(double a, double b) {
            if (a < b) {
                return -1;
            }
            if (a > b) {
                return 1;
            }
            if (Math.INSTANCE.isNaN(a)) {
                return Math.INSTANCE.isNaN(b) ? 0 : -1;
            }
            return Math.INSTANCE.isNaN(b) ? 1 : 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

