/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.Distance;
import org.locationtech.jts.algorithm.Intersection;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 I2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u00060\u0003j\u0002`\u0004:\u0001IB\u001d\b\u0007\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tB)\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000b\u0012\u0006\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\u0004\b\b\u0010\u000fB\u0011\b\u0016\u0012\u0006\u0010\u0010\u001a\u00020\u0000\u00a2\u0006\u0004\b\b\u0010\u0011J\u000e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0000J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0006\u0010\u0017\u001a\u00020\u000bJ\u0006\u0010\u0018\u001a\u00020\u000bJ\u0006\u0010\u0019\u001a\u00020\u000bJ\u0006\u0010\u001a\u001a\u00020\u000bJ\u000e\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u0000J\u0010\u0010\"\u001a\u00020\u00142\b\u0010$\u001a\u0004\u0018\u00010\u0006J\u0006\u0010%\u001a\u00020\u0016J\u0006\u0010&\u001a\u00020\u0016J\u0006\u0010'\u001a\u00020\u000bJ\u000e\u0010(\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0000J\u0010\u0010(\u001a\u00020\u000b2\b\u0010$\u001a\u0004\u0018\u00010\u0006J\u0010\u0010)\u001a\u00020\u000b2\b\u0010$\u001a\u0004\u0018\u00010\u0006J\u000e\u0010*\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u0006J\u000e\u0010+\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u000bJ\u0016\u0010-\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020\u000bJ\u000e\u0010/\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u0006J\u000e\u00100\u001a\u00020\u000b2\u0006\u00101\u001a\u00020\u0006J\u000e\u00102\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0006J\u0010\u00102\u001a\u0004\u0018\u00010\u00002\u0006\u0010#\u001a\u00020\u0000J\u000e\u00103\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u000bJ\u000e\u00104\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0006J\u000e\u00105\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0006J\u001b\u00106\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u0006072\u0006\u00108\u001a\u00020\u0000\u00a2\u0006\u0002\u00109J\u0010\u0010:\u001a\u0004\u0018\u00010\u00062\u0006\u00108\u001a\u00020\u0000J\u000e\u0010;\u001a\u00020\u00062\u0006\u00108\u001a\u00020\u0000J\u000e\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?J\u0014\u0010@\u001a\u00020\u001f2\b\u0010A\u001a\u0004\u0018\u00010\u0002H\u0096\u0082\u0004J\n\u0010B\u001a\u00020\u0014H\u0096\u0080\u0004J\u0006\u0010C\u001a\u00020\u0014J\u0014\u0010D\u001a\u00020\u00142\b\u0010A\u001a\u0004\u0018\u00010\u0002H\u0096\u0082\u0004J\u000e\u0010E\u001a\u00020\u001f2\u0006\u0010F\u001a\u00020\u0000J\n\u0010G\u001a\u00020HH\u0096\u0080\u0004R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010 R\u0011\u0010!\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010 \u00a8\u0006J"}, d2={"Lorg/locationtech/jts/geom/LineSegment;", "", "", "Ljava/io/Serializable;", "Lorg/locationtech/jts/legacy/Serializable;", "p0", "Lorg/locationtech/jts/geom/Coordinate;", "p1", "<init>", "(Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;)V", "x0", "", "y0", "x1", "y1", "(DDDD)V", "ls", "(Lorg/locationtech/jts/geom/LineSegment;)V", "getCoordinate", "i", "", "setCoordinates", "", "minX", "maxX", "minY", "maxY", "length", "getLength", "()D", "isHorizontal", "", "()Z", "isVertical", "orientationIndex", "seg", "p", "reverse", "normalize", "angle", "distance", "distancePerpendicular", "distancePerpendicularOriented", "pointAlong", "segmentLengthFraction", "pointAlongOffset", "offsetDistance", "projectionFactor", "segmentFraction", "inputPt", "project", "offset", "reflect", "closestPoint", "closestPoints", "", "line", "(Lorg/locationtech/jts/geom/LineSegment;)[Lorg/locationtech/jts/geom/Coordinate;", "intersection", "lineIntersection", "toGeometry", "Lorg/locationtech/jts/geom/LineString;", "geomFactory", "Lorg/locationtech/jts/geom/GeometryFactory;", "equals", "o", "hashCode", "OLDhashCode", "compareTo", "equalsTopo", "other", "toString", "", "Companion", "kts-core"})
public class LineSegment
implements Comparable<Object>,
Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public Coordinate p0;
    @JvmField
    @NotNull
    public Coordinate p1;
    private static final long serialVersionUID = 3252005833466256227L;

    @JvmOverloads
    public LineSegment(@NotNull Coordinate p0, @NotNull Coordinate p1) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        this.p0 = p0;
        this.p1 = p1;
    }

    public /* synthetic */ LineSegment(Coordinate coordinate, Coordinate coordinate2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            coordinate = new Coordinate();
        }
        if ((n & 2) != 0) {
            coordinate2 = new Coordinate();
        }
        this(coordinate, coordinate2);
    }

    public LineSegment(double x0, double y0, double x1, double y1) {
        this(new Coordinate(x0, y0), new Coordinate(x1, y1));
    }

    public LineSegment(@NotNull LineSegment ls) {
        Intrinsics.checkNotNullParameter((Object)ls, (String)"ls");
        this(ls.p0, ls.p1);
    }

    @NotNull
    public final Coordinate getCoordinate(int i) {
        return i == 0 ? this.p0 : this.p1;
    }

    public final void setCoordinates(@NotNull LineSegment ls) {
        Intrinsics.checkNotNullParameter((Object)ls, (String)"ls");
        this.setCoordinates(ls.p0, ls.p1);
    }

    public final void setCoordinates(@NotNull Coordinate p0, @NotNull Coordinate p1) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        this.p0.x = p0.x;
        this.p0.y = p0.y;
        this.p1.x = p1.x;
        this.p1.y = p1.y;
    }

    public final double minX() {
        return Math.INSTANCE.min(this.p0.x, this.p1.x);
    }

    public final double maxX() {
        return Math.INSTANCE.max(this.p0.x, this.p1.x);
    }

    public final double minY() {
        return Math.INSTANCE.min(this.p0.y, this.p1.y);
    }

    public final double maxY() {
        return Math.INSTANCE.max(this.p0.y, this.p1.y);
    }

    public final double getLength() {
        return this.p0.distance(this.p1);
    }

    public final boolean isHorizontal() {
        return this.p0.y == this.p1.y;
    }

    public final boolean isVertical() {
        return this.p0.x == this.p1.x;
    }

    public final int orientationIndex(@NotNull LineSegment seg) {
        Intrinsics.checkNotNullParameter((Object)seg, (String)"seg");
        int orient0 = Orientation.index(this.p0, this.p1, seg.p0);
        int orient1 = Orientation.index(this.p0, this.p1, seg.p1);
        if (orient0 >= 0 && orient1 >= 0) {
            return Math.INSTANCE.max(orient0, orient1);
        }
        return orient0 <= 0 && orient1 <= 0 ? Math.INSTANCE.max(orient0, orient1) : 0;
    }

    public final int orientationIndex(@Nullable Coordinate p) {
        return Orientation.index(this.p0, this.p1, p);
    }

    public final void reverse() {
        Coordinate temp = this.p0;
        this.p0 = this.p1;
        this.p1 = temp;
    }

    public final void normalize() {
        if (this.p1.compareTo(this.p0) < 0) {
            this.reverse();
        }
    }

    public final double angle() {
        return Math.INSTANCE.atan2(this.p1.y - this.p0.y, this.p1.x - this.p0.x);
    }

    public final double distance(@NotNull LineSegment ls) {
        Intrinsics.checkNotNullParameter((Object)ls, (String)"ls");
        return Distance.segmentToSegment(this.p0, this.p1, ls.p0, ls.p1);
    }

    public final double distance(@Nullable Coordinate p) {
        Coordinate coordinate = p;
        Intrinsics.checkNotNull((Object)coordinate);
        return Distance.pointToSegment(coordinate, this.p0, this.p1);
    }

    public final double distancePerpendicular(@Nullable Coordinate p) {
        Coordinate coordinate = p;
        Intrinsics.checkNotNull((Object)coordinate);
        return Distance.pointToLinePerpendicular(coordinate, this.p0, this.p1);
    }

    public final double distancePerpendicularOriented(@NotNull Coordinate p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        if (this.p0.equals2D(this.p1)) {
            return this.p0.distance(p);
        }
        double dist = this.distancePerpendicular(p);
        if (this.orientationIndex(p) < 0) {
            return -dist;
        }
        return dist;
    }

    @NotNull
    public final Coordinate pointAlong(double segmentLengthFraction) {
        Coordinate coord = this.p0.create();
        coord.x = this.p0.x + segmentLengthFraction * (this.p1.x - this.p0.x);
        coord.y = this.p0.y + segmentLengthFraction * (this.p1.y - this.p0.y);
        return coord;
    }

    @NotNull
    public final Coordinate pointAlongOffset(double segmentLengthFraction, double offsetDistance) {
        double segx = this.p0.x + segmentLengthFraction * (this.p1.x - this.p0.x);
        double segy = this.p0.y + segmentLengthFraction * (this.p1.y - this.p0.y);
        double dx = this.p1.x - this.p0.x;
        double dy = this.p1.y - this.p0.y;
        double len = Math.INSTANCE.sqrt(dx * dx + dy * dy);
        double ux = 0.0;
        double uy = 0.0;
        if (!(offsetDistance == 0.0)) {
            if (len <= 0.0) {
                throw new IllegalStateException("Cannot compute offset from zero-length line segment");
            }
            ux = offsetDistance * dx / len;
            uy = offsetDistance * dy / len;
        }
        double offsetx = segx - uy;
        double offsety = segy + ux;
        Coordinate coord = this.p0.create();
        coord.x = offsetx;
        coord.y = offsety;
        return coord;
    }

    public final double projectionFactor(@NotNull Coordinate p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        if (Intrinsics.areEqual((Object)p, (Object)this.p0)) {
            return 0.0;
        }
        if (Intrinsics.areEqual((Object)p, (Object)this.p1)) {
            return 1.0;
        }
        double dx = this.p1.x - this.p0.x;
        double dy = this.p1.y - this.p0.y;
        double len = dx * dx + dy * dy;
        return len <= 0.0 ? Double.NaN : ((p.x - this.p0.x) * dx + (p.y - this.p0.y) * dy) / len;
    }

    public final double segmentFraction(@NotNull Coordinate inputPt) {
        Intrinsics.checkNotNullParameter((Object)inputPt, (String)"inputPt");
        double segFrac = this.projectionFactor(inputPt);
        if (segFrac < 0.0) {
            segFrac = 0.0;
        } else if (segFrac > 1.0 || Math.INSTANCE.isNaN(segFrac)) {
            segFrac = 1.0;
        }
        return segFrac;
    }

    @NotNull
    public final Coordinate project(@NotNull Coordinate p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        if (Intrinsics.areEqual((Object)p, (Object)this.p0) || Intrinsics.areEqual((Object)p, (Object)this.p1)) {
            return p.copy();
        }
        double r = this.projectionFactor(p);
        Coordinate coord = p.copy();
        coord.x = this.p0.x + r * (this.p1.x - this.p0.x);
        coord.y = this.p0.y + r * (this.p1.y - this.p0.y);
        return coord;
    }

    @Nullable
    public final LineSegment project(@NotNull LineSegment seg) {
        Intrinsics.checkNotNullParameter((Object)seg, (String)"seg");
        double pf0 = this.projectionFactor(seg.p0);
        double pf1 = this.projectionFactor(seg.p1);
        if (pf0 >= 1.0 && pf1 >= 1.0) {
            return null;
        }
        if (pf0 <= 0.0 && pf1 <= 0.0) {
            return null;
        }
        Coordinate newp0 = this.project(seg.p0);
        if (pf0 < 0.0) {
            newp0 = this.p0;
        }
        if (pf0 > 1.0) {
            newp0 = this.p1;
        }
        Coordinate newp1 = this.project(seg.p1);
        if (pf1 < 0.0) {
            newp1 = this.p0;
        }
        if (pf1 > 1.0) {
            newp1 = this.p1;
        }
        return new LineSegment(newp0, newp1);
    }

    @NotNull
    public final LineSegment offset(double offsetDistance) {
        Coordinate offset0 = this.pointAlongOffset(0.0, offsetDistance);
        Coordinate offset1 = this.pointAlongOffset(1.0, offsetDistance);
        return new LineSegment(offset0, offset1);
    }

    @NotNull
    public final Coordinate reflect(@NotNull Coordinate p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        double A = this.p1.y - this.p0.y;
        double B = this.p0.x - this.p1.x;
        double C = this.p0.y * (this.p1.x - this.p0.x) - this.p0.x * (this.p1.y - this.p0.y);
        double A2plusB2 = A * A + B * B;
        double A2subB2 = A * A - B * B;
        double x = p.x;
        double y = p.y;
        double rx = (-A2subB2 * x - (double)2 * A * B * y - (double)2 * A * C) / A2plusB2;
        double ry = (A2subB2 * y - (double)2 * A * B * x - (double)2 * B * C) / A2plusB2;
        Coordinate coord = p.copy();
        coord.x = rx;
        coord.y = ry;
        return coord;
    }

    @NotNull
    public final Coordinate closestPoint(@NotNull Coordinate p) {
        double dist1;
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        double factor = this.projectionFactor(p);
        if (factor > 0.0 && factor < 1.0) {
            return this.project(p);
        }
        double dist0 = this.p0.distance(p);
        return dist0 < (dist1 = this.p1.distance(p)) ? this.p0 : this.p1;
    }

    @NotNull
    public final Coordinate[] closestPoints(@NotNull LineSegment line) {
        Coordinate close11;
        Coordinate close10;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Coordinate intPt = this.intersection(line);
        if (intPt != null) {
            Coordinate[] coordinateArray = new Coordinate[]{intPt, intPt};
            return coordinateArray;
        }
        Coordinate[] closestPt = new Coordinate[2];
        double minDistance = Double.MAX_VALUE;
        double dist = 0.0;
        Coordinate close00 = this.closestPoint(line.p0);
        minDistance = close00.distance(line.p0);
        closestPt[0] = close00;
        closestPt[1] = line.p0;
        Coordinate close01 = this.closestPoint(line.p1);
        dist = close01.distance(line.p1);
        if (dist < minDistance) {
            minDistance = dist;
            closestPt[0] = close01;
            closestPt[1] = line.p1;
        }
        if ((dist = (close10 = line.closestPoint(this.p0)).distance(this.p0)) < minDistance) {
            minDistance = dist;
            closestPt[0] = this.p0;
            closestPt[1] = close10;
        }
        if ((dist = (close11 = line.closestPoint(this.p1)).distance(this.p1)) < minDistance) {
            minDistance = dist;
            closestPt[0] = this.p1;
            closestPt[1] = close11;
        }
        return closestPt;
    }

    @Nullable
    public final Coordinate intersection(@NotNull LineSegment line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        LineIntersector li = new RobustLineIntersector();
        li.computeIntersection(this.p0, this.p1, line.p0, line.p1);
        return li.hasIntersection() ? li.getIntersection(0) : null;
    }

    @NotNull
    public final Coordinate lineIntersection(@NotNull LineSegment line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Coordinate coordinate = Intersection.intersection(this.p0, this.p1, line.p0, line.p1);
        Intrinsics.checkNotNull((Object)coordinate);
        return coordinate;
    }

    @NotNull
    public final LineString toGeometry(@NotNull GeometryFactory geomFactory) {
        Intrinsics.checkNotNullParameter((Object)geomFactory, (String)"geomFactory");
        Coordinate[] coordinateArray = new Coordinate[]{this.p0, this.p1};
        return geomFactory.createLineString(coordinateArray);
    }

    public boolean equals(@Nullable Object o) {
        if (!(o instanceof LineSegment)) {
            return false;
        }
        Object other = o;
        return Intrinsics.areEqual((Object)this.p0, (Object)((LineSegment)other).p0) && Intrinsics.areEqual((Object)this.p1, (Object)((LineSegment)other).p1);
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 29 + Double.hashCode(this.p0.x);
        hash = hash * 29 + Double.hashCode(this.p0.y);
        hash = hash * 29 + Double.hashCode(this.p1.x);
        hash = hash * 29 + Double.hashCode(this.p1.y);
        return hash;
    }

    public final int OLDhashCode() {
        long bits0 = Math.INSTANCE.doubleToLongBits(this.p0.x);
        int hash0 = (int)(bits0 ^= Math.INSTANCE.doubleToLongBits(this.p0.y) * (long)31) ^ (int)(bits0 >> 32);
        long bits1 = Math.INSTANCE.doubleToLongBits(this.p1.x);
        int hash1 = (int)(bits1 ^= Math.INSTANCE.doubleToLongBits(this.p1.y) * (long)31) ^ (int)(bits1 >> 32);
        return hash0 ^ hash1;
    }

    @Override
    public int compareTo(@Nullable Object o) {
        LineSegment other;
        LineSegment lineSegment = other = (LineSegment)o;
        Intrinsics.checkNotNull((Object)lineSegment);
        int comp0 = this.p0.compareTo(lineSegment.p0);
        return comp0 != 0 ? comp0 : this.p1.compareTo(other.p1);
    }

    public final boolean equalsTopo(@NotNull LineSegment other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.areEqual((Object)this.p0, (Object)other.p0) && Intrinsics.areEqual((Object)this.p1, (Object)other.p1) || Intrinsics.areEqual((Object)this.p0, (Object)other.p1) && Intrinsics.areEqual((Object)this.p1, (Object)other.p0);
    }

    @NotNull
    public String toString() {
        return "LINESTRING( " + this.p0.x + " " + this.p0.y + ", " + this.p1.x + " " + this.p1.y + ")";
    }

    @JvmOverloads
    public LineSegment(@NotNull Coordinate p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        this(p0, null, 2, null);
    }

    @JvmOverloads
    public LineSegment() {
        this(null, null, 3, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/locationtech/jts/geom/LineSegment$Companion;", "", "<init>", "()V", "serialVersionUID", "", "midPoint", "Lorg/locationtech/jts/geom/Coordinate;", "p0", "p1", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmOverloads
        @NotNull
        public final Coordinate midPoint(@NotNull Coordinate p0, @NotNull Coordinate p1) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            return new Coordinate((p0.x + p1.x) / (double)2, (p0.y + p1.y) / (double)2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

