/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.util.AffineTransformation;
import org.locationtech.jts.math.Matrix;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001b"}, d2={"Lorg/locationtech/jts/geom/util/AffineTransformationBuilder;", "", "src0", "Lorg/locationtech/jts/geom/Coordinate;", "src1", "src2", "dest0", "dest1", "dest2", "<init>", "(Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;)V", "m00", "", "m01", "m02", "m10", "m11", "m12", "transformation", "Lorg/locationtech/jts/geom/util/AffineTransformation;", "getTransformation", "()Lorg/locationtech/jts/geom/util/AffineTransformation;", "compute", "", "solve", "", "b", "kts-core"})
public final class AffineTransformationBuilder {
    @NotNull
    private final Coordinate src0;
    @NotNull
    private final Coordinate src1;
    @NotNull
    private final Coordinate src2;
    @NotNull
    private final Coordinate dest0;
    @NotNull
    private final Coordinate dest1;
    @NotNull
    private final Coordinate dest2;
    private double m00;
    private double m01;
    private double m02;
    private double m10;
    private double m11;
    private double m12;

    public AffineTransformationBuilder(@NotNull Coordinate src0, @NotNull Coordinate src1, @NotNull Coordinate src2, @NotNull Coordinate dest0, @NotNull Coordinate dest1, @NotNull Coordinate dest2) {
        Intrinsics.checkNotNullParameter((Object)src0, (String)"src0");
        Intrinsics.checkNotNullParameter((Object)src1, (String)"src1");
        Intrinsics.checkNotNullParameter((Object)src2, (String)"src2");
        Intrinsics.checkNotNullParameter((Object)dest0, (String)"dest0");
        Intrinsics.checkNotNullParameter((Object)dest1, (String)"dest1");
        Intrinsics.checkNotNullParameter((Object)dest2, (String)"dest2");
        this.src0 = src0;
        this.src1 = src1;
        this.src2 = src2;
        this.dest0 = dest0;
        this.dest1 = dest1;
        this.dest2 = dest2;
    }

    @Nullable
    public final AffineTransformation getTransformation() {
        boolean isSolvable = this.compute();
        return isSolvable ? new AffineTransformation(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12) : null;
    }

    private final boolean compute() {
        double[] dArray = new double[]{this.dest0.x, this.dest1.x, this.dest2.x};
        double[] bx = dArray;
        double[] dArray2 = this.solve(bx);
        if (dArray2 == null) {
            return false;
        }
        double[] row0 = dArray2;
        this.m00 = row0[0];
        this.m01 = row0[1];
        this.m02 = row0[2];
        double[] dArray3 = new double[]{this.dest0.y, this.dest1.y, this.dest2.y};
        double[] by = dArray3;
        double[] dArray4 = this.solve(by);
        if (dArray4 == null) {
            return false;
        }
        double[] row1 = dArray4;
        this.m10 = row1[0];
        this.m11 = row1[1];
        this.m12 = row1[2];
        return true;
    }

    private final double[] solve(double[] b) {
        double[][] dArrayArray = new double[3][];
        double[] dArray = new double[]{this.src0.x, this.src0.y, 1.0};
        dArrayArray[0] = dArray;
        dArray = new double[]{this.src1.x, this.src1.y, 1.0};
        dArrayArray[1] = dArray;
        dArray = new double[]{this.src2.x, this.src2.y, 1.0};
        dArrayArray[2] = dArray;
        double[][] a = dArrayArray;
        return Matrix.INSTANCE.solve(a, b);
    }
}

