/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import org.locationtech.jts.operation.buffer.BufferOp;
import org.locationtech.jts.operation.overlayng.OverlayNGRobust;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 22\u00020\u0001:\u00012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\tJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0002\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0017H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0002\u001a\u00020\u0017H\u0002J\u0012\u0010\u0019\u001a\u00020\u00032\b\u0010\u0002\u001a\u0004\u0018\u00010\u001aH\u0002J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u00032\b\u0010\u0002\u001a\u0004\u0018\u00010\u001aH\u0002J\u0010\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u001fH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0002\u001a\u00020\u001fH\u0002J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\"2\u0006\u0010\u0002\u001a\u00020\u001fH\u0002J:\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u00032\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00030\"2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030'H\u0002J \u0010)\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00032\u000e\u0010&\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\"H\u0002J\u0018\u0010*\u001a\u0004\u0018\u00010\u00032\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00030\"H\u0002J\u0012\u0010,\u001a\u00020\u00032\b\u0010-\u001a\u0004\u0018\u00010\u0017H\u0002J\u0010\u0010.\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020/H\u0002J\u0010\u00100\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u000201H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00063"}, d2={"Lorg/locationtech/jts/geom/util/GeometryFixer;", "", "geom", "Lorg/locationtech/jts/geom/Geometry;", "<init>", "(Lorg/locationtech/jts/geom/Geometry;)V", "factory", "Lorg/locationtech/jts/geom/GeometryFactory;", "isKeepCollapsed", "", "isKeepMulti", "setKeepCollapsed", "", "setKeepMulti", "result", "getResult", "()Lorg/locationtech/jts/geom/Geometry;", "fixPoint", "Lorg/locationtech/jts/geom/Point;", "fixPointElement", "fixMultiPoint", "Lorg/locationtech/jts/geom/MultiPoint;", "fixLinearRing", "Lorg/locationtech/jts/geom/LinearRing;", "fixLinearRingElement", "fixLineString", "Lorg/locationtech/jts/geom/LineString;", "fixLineStringElement", "fixMultiLineString", "Lorg/locationtech/jts/geom/MultiLineString;", "fixPolygon", "Lorg/locationtech/jts/geom/Polygon;", "fixPolygonElement", "fixHoles", "", "classifyHoles", "shell", "holesFixed", "holes", "", "shells", "difference", "union", "polys", "fixRing", "ring", "fixMultiPolygon", "Lorg/locationtech/jts/geom/MultiPolygon;", "fixCollection", "Lorg/locationtech/jts/geom/GeometryCollection;", "Companion", "kts-core"})
public final class GeometryFixer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Geometry geom;
    @NotNull
    private final GeometryFactory factory;
    private boolean isKeepCollapsed;
    private boolean isKeepMulti;
    private static final boolean DEFAULT_KEEP_MULTI = true;

    public GeometryFixer(@NotNull Geometry geom) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        this.geom = geom;
        this.factory = this.geom.getFactory();
        this.isKeepMulti = true;
    }

    public final void setKeepCollapsed(boolean isKeepCollapsed) {
        this.isKeepCollapsed = isKeepCollapsed;
    }

    public final void setKeepMulti(boolean isKeepMulti) {
        this.isKeepMulti = isKeepMulti;
    }

    @NotNull
    public final Geometry getResult() {
        if (this.geom.getNumGeometries() == 0) {
            return this.geom.copy();
        }
        if (this.geom instanceof Point) {
            return this.fixPoint((Point)this.geom);
        }
        if (this.geom instanceof LinearRing) {
            return this.fixLinearRing((LinearRing)this.geom);
        }
        if (this.geom instanceof LineString) {
            return this.fixLineString((LineString)this.geom);
        }
        if (this.geom instanceof Polygon) {
            return this.fixPolygon((Polygon)this.geom);
        }
        if (this.geom instanceof MultiPoint) {
            return this.fixMultiPoint((MultiPoint)this.geom);
        }
        if (this.geom instanceof MultiLineString) {
            return this.fixMultiLineString((MultiLineString)this.geom);
        }
        if (this.geom instanceof MultiPolygon) {
            return this.fixMultiPolygon((MultiPolygon)this.geom);
        }
        if (this.geom instanceof GeometryCollection) {
            return this.fixCollection((GeometryCollection)this.geom);
        }
        throw new UnsupportedOperationException(Reflection.getOrCreateKotlinClass(this.geom.getClass()).getSimpleName());
    }

    private final Point fixPoint(Point geom) {
        Point point = this.fixPointElement(geom);
        if (point == null) {
            return GeometryFactory.createPoint$default(this.factory, null, 1, null);
        }
        Point pt = point;
        return pt;
    }

    private final Point fixPointElement(Point geom) {
        Point point;
        if (geom.isEmpty() || !GeometryFixer.Companion.isValidPoint(geom)) {
            point = null;
        } else {
            Geometry geometry = geom.copy();
            Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Point");
            point = (Point)geometry;
        }
        return point;
    }

    private final Geometry fixMultiPoint(MultiPoint geom) {
        List pts = new ArrayList();
        int n = geom.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Point fixPt;
            Geometry geometry = geom.getGeometryN(i);
            Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Point");
            Point pt = (Point)geometry;
            if (pt.isEmpty() || (fixPt = this.fixPointElement(pt)) == null) continue;
            pts.add(fixPt);
        }
        return !this.isKeepMulti && pts.size() == 1 ? (Geometry)pts.get(0) : (Geometry)this.factory.createMultiPoint(GeometryFactory.Companion.toPointArray(pts));
    }

    private final Geometry fixLinearRing(LinearRing geom) {
        Geometry geometry = this.fixLinearRingElement(geom);
        if (geometry == null) {
            return GeometryFactory.createLinearRing$default(this.factory, null, 1, null);
        }
        return geometry;
    }

    private final Geometry fixLinearRingElement(LinearRing geom) {
        if (geom.isEmpty()) {
            return null;
        }
        Coordinate[] pts = geom.getCoordinates();
        Coordinate[] ptsFix = GeometryFixer.Companion.fixCoordinates(pts);
        if (this.isKeepCollapsed) {
            if (ptsFix.length == 1) {
                return this.factory.createPoint(ptsFix[0]);
            }
            int n = ptsFix.length;
            boolean bl = 2 <= n ? n < 4 : false;
            if (bl) {
                return this.factory.createLineString(ptsFix);
            }
        }
        if (ptsFix.length <= 3) {
            return null;
        }
        LinearRing ring = this.factory.createLinearRing(ptsFix);
        return !ring.isValid() ? (Geometry)this.factory.createLineString(ptsFix) : (Geometry)ring;
    }

    private final Geometry fixLineString(LineString geom) {
        Geometry geometry = this.fixLineStringElement(geom);
        if (geometry == null) {
            return GeometryFactory.createLineString$default(this.factory, null, 1, null);
        }
        return geometry;
    }

    private final Geometry fixLineStringElement(LineString geom) {
        LineString lineString = geom;
        Intrinsics.checkNotNull((Object)lineString);
        if (lineString.isEmpty()) {
            return null;
        }
        Coordinate[] pts = geom.getCoordinates();
        Coordinate[] ptsFix = GeometryFixer.Companion.fixCoordinates(pts);
        if (this.isKeepCollapsed && ptsFix.length == 1) {
            return this.factory.createPoint(ptsFix[0]);
        }
        return ptsFix.length <= 1 ? null : (Geometry)this.factory.createLineString(ptsFix);
    }

    private final Geometry fixMultiLineString(MultiLineString geom) {
        List fixed = new ArrayList();
        boolean isMixed = false;
        int n = geom.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Geometry fix;
            Geometry geometry = geom.getGeometryN(i);
            Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
            LineString line = (LineString)geometry;
            if (line.isEmpty() || this.fixLineStringElement(line) == null) continue;
            if (!(fix instanceof LineString)) {
                isMixed = true;
            }
            fixed.add(fix);
        }
        if (!(fixed.size() != 1 || this.isKeepMulti && fixed.get(0) instanceof LineString)) {
            return (Geometry)fixed.get(0);
        }
        return isMixed ? (Geometry)this.factory.createGeometryCollection(GeometryFactory.Companion.toGeometryArray(fixed)) : (Geometry)this.factory.createMultiLineString(GeometryFactory.Companion.toLineStringArray(fixed));
    }

    private final Geometry fixPolygon(Polygon geom) {
        Geometry geometry = this.fixPolygonElement(geom);
        if (geometry == null) {
            return GeometryFactory.createPolygon$default(this.factory, null, null, 3, null);
        }
        return geometry;
    }

    private final Geometry fixPolygonElement(Polygon geom) {
        LinearRing shell = geom.getExteriorRing();
        Geometry fixShell = this.fixRing(shell);
        if (fixShell.isEmpty()) {
            return this.isKeepCollapsed ? this.fixLineString(shell) : null;
        }
        if (geom.getNumInteriorRing() == 0) {
            return fixShell;
        }
        List<Geometry> holesFixed = this.fixHoles(geom);
        List holes = new ArrayList();
        List shells = new ArrayList();
        this.classifyHoles(fixShell, holesFixed, holes, shells);
        Geometry polyWithHoles = this.difference(fixShell, holes);
        if (shells.size() == 0) {
            return polyWithHoles;
        }
        shells.add(polyWithHoles);
        return this.union(shells);
    }

    private final List<Geometry> fixHoles(Polygon geom) {
        List holes = new ArrayList();
        int n = geom.getNumInteriorRing();
        for (int i = 0; i < n; ++i) {
            Geometry holeRep = this.fixRing(geom.getInteriorRingN(i));
            if (holeRep == null) continue;
            holes.add(holeRep);
        }
        return holes;
    }

    private final void classifyHoles(Geometry shell, List<? extends Geometry> holesFixed, List<Geometry> holes, List<Geometry> shells) {
        PreparedGeometry shellPrep = PreparedGeometryFactory.Companion.prepare(shell);
        for (Geometry geometry : holesFixed) {
            boolean bl = shellPrep.intersects(geometry) ? holes.add(geometry) : shells.add(geometry);
        }
    }

    private final Geometry difference(Geometry shell, List<? extends Geometry> holes) {
        Collection collection = holes;
        if (collection == null || collection.isEmpty()) {
            return shell;
        }
        Geometry holesUnion = this.union(holes);
        Geometry geometry = OverlayNGRobust.overlay(shell, holesUnion, 3);
        Intrinsics.checkNotNull((Object)geometry);
        return geometry;
    }

    private final Geometry union(List<? extends Geometry> polys) {
        if (polys.isEmpty()) {
            return GeometryFactory.createPolygon$default(this.factory, null, null, 3, null);
        }
        return polys.size() == 1 ? polys.get(0) : OverlayNGRobust.union((Collection<? extends Geometry>)polys);
    }

    private final Geometry fixRing(LinearRing ring) {
        Geometry poly = GeometryFactory.createPolygon$default(this.factory, ring, null, 2, null);
        return BufferOp.Companion.bufferByZero(poly, true);
    }

    private final Geometry fixMultiPolygon(MultiPolygon geom) {
        List polys = new ArrayList();
        int n = geom.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Geometry geometry = geom.getGeometryN(i);
            Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
            Polygon poly = (Polygon)geometry;
            Geometry polyFix = this.fixPolygonElement(poly);
            if (polyFix == null || polyFix.isEmpty()) continue;
            polys.add(polyFix);
        }
        if (polys.size() == 0) {
            return this.factory.createMultiPolygon();
        }
        Geometry result2 = this.union(polys);
        if (this.isKeepMulti && result2 instanceof Polygon) {
            Polygon[] polygonArray = new Polygon[]{result2};
            result2 = this.factory.createMultiPolygon(polygonArray);
        }
        Geometry geometry = result2;
        Intrinsics.checkNotNull((Object)geometry);
        return geometry;
    }

    private final Geometry fixCollection(GeometryCollection geom) {
        Object[] geomRep = new Geometry[geom.getNumGeometries()];
        int n = geom.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            geomRep[i] = GeometryFixer.Companion.fix(geom.getGeometryN(i), this.isKeepCollapsed, this.isKeepMulti);
        }
        return this.factory.createGeometryCollection((Geometry[])ArraysKt.requireNoNulls((Object[])geomRep));
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Geometry fix(@NotNull Geometry geom, boolean isKeepMulti) {
        return Companion.fix(geom, isKeepMulti);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Geometry fix(@NotNull Geometry geom) {
        return Companion.fix(geom);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u0005H\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J!\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u00a2\u0006\u0002\u0010\u0011J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/locationtech/jts/geom/util/GeometryFixer$Companion;", "", "<init>", "()V", "DEFAULT_KEEP_MULTI", "", "fix", "Lorg/locationtech/jts/geom/Geometry;", "geom", "isKeepMulti", "isValidPoint", "pt", "Lorg/locationtech/jts/geom/Point;", "fixCoordinates", "", "Lorg/locationtech/jts/geom/Coordinate;", "pts", "([Lorg/locationtech/jts/geom/Coordinate;)[Lorg/locationtech/jts/geom/Coordinate;", "isKeepCollapsed", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Geometry fix(@NotNull Geometry geom, boolean isKeepMulti) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            GeometryFixer fix = new GeometryFixer(geom);
            fix.setKeepMulti(isKeepMulti);
            return fix.getResult();
        }

        public static /* synthetic */ Geometry fix$default(Companion companion, Geometry geometry, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.fix(geometry, bl);
        }

        private final boolean isValidPoint(Point pt) {
            Coordinate p;
            Coordinate coordinate = p = pt.getCoordinate();
            Intrinsics.checkNotNull((Object)coordinate);
            return coordinate.isValid();
        }

        private final Coordinate[] fixCoordinates(Coordinate[] pts) {
            Coordinate[] ptsClean = CoordinateArrays.INSTANCE.removeRepeatedOrInvalidPoints(pts);
            return CoordinateArrays.copyDeep(ptsClean);
        }

        private final Geometry fix(Geometry geom, boolean isKeepCollapsed, boolean isKeepMulti) {
            GeometryFixer fix = new GeometryFixer(geom);
            fix.setKeepCollapsed(isKeepCollapsed);
            fix.setKeepMulti(isKeepMulti);
            return fix.getResult();
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Geometry fix(@NotNull Geometry geom) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            return org.locationtech.jts.geom.util.GeometryFixer$Companion.fix$default(this, geom, false, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

