/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0017\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001f\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0004H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/locationtech/jts/geom/util/LinearComponentExtracter;", "Lorg/locationtech/jts/geom/GeometryComponentFilter;", "lines", "", "Lorg/locationtech/jts/geom/Geometry;", "<init>", "(Ljava/util/Collection;)V", "isForcedToLineString", "", "(Ljava/util/Collection;Z)V", "setForceToLineString", "", "filter", "geom", "Companion", "kts-core"})
public final class LinearComponentExtracter
implements GeometryComponentFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Collection<Geometry> lines;
    private boolean isForcedToLineString;

    public LinearComponentExtracter(@NotNull Collection<Geometry> lines) {
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        this.lines = lines;
    }

    public LinearComponentExtracter(@NotNull Collection<Geometry> lines, boolean isForcedToLineString) {
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        this.lines = lines;
        this.isForcedToLineString = isForcedToLineString;
    }

    public final void setForceToLineString(boolean isForcedToLineString) {
        this.isForcedToLineString = isForcedToLineString;
    }

    @Override
    public void filter(@NotNull Geometry geom) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        if (this.isForcedToLineString && geom instanceof LinearRing) {
            LineString line = geom.getFactory().createLineString(((LinearRing)geom).getCoordinateSequence());
            this.lines.add(line);
            return;
        }
        if (geom instanceof LineString) {
            this.lines.add(geom);
        }
    }

    @JvmStatic
    @NotNull
    public static final Collection<Geometry> getLines(@NotNull Collection<? extends Geometry> geoms, @NotNull Collection<Geometry> lines) {
        return Companion.getLines(geoms, lines);
    }

    @JvmStatic
    @NotNull
    public static final Collection<Geometry> getLines(@NotNull Geometry geom, @NotNull Collection<Geometry> lines) {
        return Companion.getLines(geom, lines);
    }

    @JvmStatic
    @NotNull
    public static final Collection<?> getLines(@NotNull Geometry geom, @NotNull Collection<Geometry> lines, boolean forceToLineString) {
        return Companion.getLines(geom, lines, forceToLineString);
    }

    @JvmStatic
    @NotNull
    public static final List<Geometry> getLines(@NotNull Geometry geom) {
        return Companion.getLines(geom);
    }

    @JvmStatic
    @NotNull
    public static final List<Geometry> getLines(@NotNull Geometry geom, boolean forceToLineString) {
        return Companion.getLines(geom, forceToLineString);
    }

    @JvmStatic
    @NotNull
    public static final Geometry getGeometry(@NotNull Geometry geom) {
        return Companion.getGeometry(geom);
    }

    @JvmStatic
    @NotNull
    public static final Geometry getGeometry(@NotNull Geometry geom, boolean forceToLineString) {
        return Companion.getGeometry(geom, forceToLineString);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u0007J0\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\n\u001a\u00020\u000bJ$\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\f\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u0007J*\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\f\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\u0006\u0010\f\u001a\u00020\u0006H\u0007J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0007J\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\u000f"}, d2={"Lorg/locationtech/jts/geom/util/LinearComponentExtracter$Companion;", "", "<init>", "()V", "getLines", "", "Lorg/locationtech/jts/geom/Geometry;", "geoms", "lines", "", "forceToLineString", "", "geom", "", "getGeometry", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Collection<Geometry> getLines(@NotNull Collection<? extends Geometry> geoms, @NotNull Collection<Geometry> lines) {
            Intrinsics.checkNotNullParameter(geoms, (String)"geoms");
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            for (Geometry geometry : geoms) {
                this.getLines(geometry, lines);
            }
            return lines;
        }

        @NotNull
        public final Collection<Geometry> getLines(@NotNull Collection<? extends Geometry> geoms, @NotNull Collection<Geometry> lines, boolean forceToLineString) {
            Intrinsics.checkNotNullParameter(geoms, (String)"geoms");
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            for (Geometry geometry : geoms) {
                this.getLines(geometry, lines, forceToLineString);
            }
            return lines;
        }

        @JvmStatic
        @NotNull
        public final Collection<Geometry> getLines(@NotNull Geometry geom, @NotNull Collection<Geometry> lines) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            if (geom instanceof LineString) {
                lines.add(geom);
            } else {
                geom.apply(new LinearComponentExtracter(lines));
            }
            return lines;
        }

        @JvmStatic
        @NotNull
        public final Collection<?> getLines(@NotNull Geometry geom, @NotNull Collection<Geometry> lines, boolean forceToLineString) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            geom.apply(new LinearComponentExtracter(lines, forceToLineString));
            return lines;
        }

        @JvmStatic
        @NotNull
        public final List<Geometry> getLines(@NotNull Geometry geom) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            return this.getLines(geom, false);
        }

        @JvmStatic
        @NotNull
        public final List<Geometry> getLines(@NotNull Geometry geom, boolean forceToLineString) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            List lines = new ArrayList();
            geom.apply(new LinearComponentExtracter(lines, forceToLineString));
            return lines;
        }

        @JvmStatic
        @NotNull
        public final Geometry getGeometry(@NotNull Geometry geom) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            return geom.getFactory().buildGeometry((Collection<? extends Geometry>)this.getLines(geom));
        }

        @JvmStatic
        @NotNull
        public final Geometry getGeometry(@NotNull Geometry geom, boolean forceToLineString) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            return geom.getFactory().buildGeometry((Collection<? extends Geometry>)this.getLines(geom, forceToLineString));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

