/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.geomgraph.DirectedEdge;
import org.locationtech.jts.geomgraph.EdgeEnd;
import org.locationtech.jts.geomgraph.EdgeEndStar;
import org.locationtech.jts.geomgraph.GraphComponent;
import org.locationtech.jts.geomgraph.Label;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0016J\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u000e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0000J\u000e\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eJ\u0016\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!J\u000e\u0010#\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!J\u0016\u0010$\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020!R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0012\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006&"}, d2={"Lorg/locationtech/jts/geomgraph/Node;", "Lorg/locationtech/jts/geomgraph/GraphComponent;", "coord", "Lorg/locationtech/jts/geom/Coordinate;", "edges", "Lorg/locationtech/jts/geomgraph/EdgeEndStar;", "<init>", "(Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geomgraph/EdgeEndStar;)V", "getCoord", "()Lorg/locationtech/jts/geom/Coordinate;", "setCoord", "(Lorg/locationtech/jts/geom/Coordinate;)V", "value", "getEdges", "()Lorg/locationtech/jts/geomgraph/EdgeEndStar;", "getCoordinate", "isIncidentEdgeInResult", "", "isIsolated", "()Z", "computeIM", "", "im", "Lorg/locationtech/jts/geom/IntersectionMatrix;", "add", "e", "Lorg/locationtech/jts/geomgraph/EdgeEnd;", "mergeLabel", "n", "label2", "Lorg/locationtech/jts/geomgraph/Label;", "setLabel", "argIndex", "", "onLocation", "setLabelBoundary", "computeMergedLocation", "eltIndex", "kts-core"})
public class Node
extends GraphComponent {
    @Nullable
    private Coordinate coord;
    @Nullable
    private EdgeEndStar edges;

    public Node(@Nullable Coordinate coord, @Nullable EdgeEndStar edges) {
        this.coord = coord;
        this.edges = edges;
        this.setLabel(new Label(0, -1));
    }

    @Nullable
    protected final Coordinate getCoord() {
        return this.coord;
    }

    protected final void setCoord(@Nullable Coordinate coordinate) {
        this.coord = coordinate;
    }

    @Nullable
    public final EdgeEndStar getEdges() {
        return this.edges;
    }

    @Override
    @Nullable
    public Coordinate getCoordinate() {
        return this.coord;
    }

    public final boolean isIncidentEdgeInResult() {
        EdgeEndStar edgeEndStar = this.edges;
        Intrinsics.checkNotNull((Object)edgeEndStar);
        for (EdgeEnd edgeEnd : edgeEndStar.getEdges()) {
            Intrinsics.checkNotNull((Object)edgeEnd, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.DirectedEdge");
            DirectedEdge de = (DirectedEdge)edgeEnd;
            if (!de.getEdge().isInResult()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isIsolated() {
        Label label = this.getLabel();
        Intrinsics.checkNotNull((Object)label);
        return label.getGeometryCount() == 1;
    }

    @Override
    protected void computeIM(@NotNull IntersectionMatrix im) {
        Intrinsics.checkNotNullParameter((Object)im, (String)"im");
    }

    public final void add(@NotNull EdgeEnd e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        EdgeEndStar edgeEndStar = this.edges;
        Intrinsics.checkNotNull((Object)edgeEndStar);
        edgeEndStar.insert(e);
        e.setNode(this);
    }

    public final void mergeLabel(@NotNull Node n) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        Label label = n.getLabel();
        Intrinsics.checkNotNull((Object)label);
        this.mergeLabel(label);
    }

    public final void mergeLabel(@NotNull Label label2) {
        Intrinsics.checkNotNullParameter((Object)label2, (String)"label2");
        for (int i = 0; i < 2; ++i) {
            int loc = this.computeMergedLocation(label2, i);
            Label label = this.getLabel();
            Intrinsics.checkNotNull((Object)label);
            int thisLoc = label.getLocation(i);
            if (thisLoc != -1) continue;
            Label label3 = this.getLabel();
            Intrinsics.checkNotNull((Object)label3);
            label3.setLocation(i, loc);
        }
    }

    public final void setLabel(int argIndex, int onLocation) {
        if (this.getLabel() == null) {
            this.setLabel(new Label(argIndex, onLocation));
        } else {
            Label label = this.getLabel();
            Intrinsics.checkNotNull((Object)label);
            label.setLocation(argIndex, onLocation);
        }
    }

    public final void setLabelBoundary(int argIndex) {
        if (this.getLabel() == null) {
            return;
        }
        int loc = -1;
        if (this.getLabel() != null) {
            Label label = this.getLabel();
            Intrinsics.checkNotNull((Object)label);
            loc = label.getLocation(argIndex);
        }
        int newLoc = switch (loc) {
            case 1 -> 0;
            case 0 -> 1;
            default -> 1;
        };
        Label label = this.getLabel();
        Intrinsics.checkNotNull((Object)label);
        label.setLocation(argIndex, newLoc);
    }

    public final int computeMergedLocation(@NotNull Label label2, int eltIndex) {
        Intrinsics.checkNotNullParameter((Object)label2, (String)"label2");
        int loc = -1;
        Label label = this.getLabel();
        Intrinsics.checkNotNull((Object)label);
        loc = label.getLocation(eltIndex);
        if (!label2.isNull(eltIndex)) {
            int nLoc = label2.getLocation(eltIndex);
            if (loc != 1) {
                loc = nLoc;
            }
        }
        return loc;
    }
}

