/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.bintree;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.index.bintree.Interval;
import org.locationtech.jts.index.bintree.Key;
import org.locationtech.jts.index.bintree.NodeBase;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u0004\u0018\u00010\u0003J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0014J\u0010\u0010\u000e\u001a\u00020\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\u0010\u001a\u00020\u00012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0000J\u0010\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\u0010\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0005H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/locationtech/jts/index/bintree/Node;", "Lorg/locationtech/jts/index/bintree/NodeBase;", "interval", "Lorg/locationtech/jts/index/bintree/Interval;", "level", "", "<init>", "(Lorg/locationtech/jts/index/bintree/Interval;I)V", "centre", "", "getInterval", "isSearchMatch", "", "itemInterval", "getNode", "searchInterval", "find", "insert", "", "node", "getSubnode", "index", "createSubnode", "Companion", "kts-core"})
public final class Node
extends NodeBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Interval interval;
    private final double centre;
    private final int level;

    public Node(@Nullable Interval interval, int level) {
        this.interval = interval;
        this.level = level;
        Interval interval2 = interval;
        Intrinsics.checkNotNull((Object)interval2);
        this.centre = (interval2.getMin() + interval.getMax()) / (double)2;
    }

    @Nullable
    public final Interval getInterval() {
        return this.interval;
    }

    @Override
    protected boolean isSearchMatch(@Nullable Interval itemInterval) {
        Interval interval = itemInterval;
        Intrinsics.checkNotNull((Object)interval);
        return interval.overlaps(this.interval);
    }

    @NotNull
    public final Node getNode(@Nullable Interval searchInterval) {
        Node node;
        int subnodeIndex = NodeBase.Companion.getSubnodeIndex(searchInterval, this.centre);
        if (subnodeIndex != -1) {
            Node node2 = this.getSubnode(subnodeIndex);
            node = node2.getNode(searchInterval);
        } else {
            node = this;
        }
        return node;
    }

    @NotNull
    public final NodeBase find(@Nullable Interval searchInterval) {
        int subnodeIndex = NodeBase.Companion.getSubnodeIndex(searchInterval, this.centre);
        if (subnodeIndex == -1) {
            return this;
        }
        if (this.getSubnode()[subnodeIndex] != null) {
            Node node = this.getSubnode()[subnodeIndex];
            Intrinsics.checkNotNull((Object)node);
            Node node2 = node;
            return node2.find(searchInterval);
        }
        return this;
    }

    public final void insert(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Assert.isTrue(this.interval == null || this.interval.contains(node.interval));
        int index = NodeBase.Companion.getSubnodeIndex(node.interval, this.centre);
        if (node.level == this.level - 1) {
            this.getSubnode()[index] = node;
        } else {
            Node childNode = this.createSubnode(index);
            childNode.insert(node);
            this.getSubnode()[index] = childNode;
        }
    }

    private final Node getSubnode(int index) {
        if (this.getSubnode()[index] == null) {
            this.getSubnode()[index] = this.createSubnode(index);
        }
        Node node = this.getSubnode()[index];
        Intrinsics.checkNotNull((Object)node);
        return node;
    }

    private final Node createSubnode(int index) {
        double min = 0.0;
        double max = 0.0;
        switch (index) {
            case 0: {
                Interval interval = this.interval;
                Intrinsics.checkNotNull((Object)interval);
                min = interval.getMin();
                max = this.centre;
                break;
            }
            case 1: {
                min = this.centre;
                Interval interval = this.interval;
                Intrinsics.checkNotNull((Object)interval);
                max = interval.getMax();
            }
        }
        Interval subInt = new Interval(min, max);
        return new Node(subInt, this.level - 1);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\b\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u0007\u00a8\u0006\u000b"}, d2={"Lorg/locationtech/jts/index/bintree/Node$Companion;", "", "<init>", "()V", "createNode", "Lorg/locationtech/jts/index/bintree/Node;", "itemInterval", "Lorg/locationtech/jts/index/bintree/Interval;", "createExpanded", "node", "addInterval", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Node createNode(@NotNull Interval itemInterval) {
            Intrinsics.checkNotNullParameter((Object)itemInterval, (String)"itemInterval");
            Key key = new Key(itemInterval);
            return new Node(key.getInterval(), key.getLevel());
        }

        @NotNull
        public final Node createExpanded(@Nullable Node node, @NotNull Interval addInterval) {
            Intrinsics.checkNotNullParameter((Object)addInterval, (String)"addInterval");
            Interval expandInt = new Interval(addInterval);
            if (node != null) {
                expandInt.expandToInclude(node.interval);
            }
            Node largerNode = this.createNode(expandInt);
            if (node != null) {
                largerNode.insert(node);
            }
            return largerNode;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

