/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.kdtree;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u001d\b\u0016\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0006\u0010\nJ\u000e\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u0004\u0018\u00010\u0000J\b\u0010 \u001a\u0004\u0018\u00010\u0000J\u0006\u0010!\u001a\u00020\"J\u0010\u0010%\u001a\u00020\"2\b\u0010&\u001a\u0004\u0018\u00010\u0000J\u0010\u0010'\u001a\u00020\"2\b\u0010(\u001a\u0004\u0018\u00010\u0000J\u0016\u0010)\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020+J\u0016\u0010,\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020+J\u0016\u0010-\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\tR\"\u0010\f\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\"\u0010\u0005\u001a\u0004\u0018\u00010\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019R\u0011\u0010#\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006/"}, d2={"Lorg/locationtech/jts/index/kdtree/KdNode;", "", "_x", "", "_y", "data", "<init>", "(DDLjava/lang/Object;)V", "p", "Lorg/locationtech/jts/geom/Coordinate;", "(Lorg/locationtech/jts/geom/Coordinate;Ljava/lang/Object;)V", "value", "coordinate", "getCoordinate", "()Lorg/locationtech/jts/geom/Coordinate;", "getData", "()Ljava/lang/Object;", "left", "right", "", "count", "getCount", "()I", "x", "getX", "()D", "y", "getY", "splitValue", "isSplitOnX", "", "getLeft", "getRight", "increment", "", "isRepeated", "()Z", "setLeft", "_left", "setRight", "_right", "isRangeOverLeft", "env", "Lorg/locationtech/jts/geom/Envelope;", "isRangeOverRight", "isPointOnLeft", "pt", "kts-core"})
public final class KdNode {
    @Nullable
    private Coordinate coordinate;
    @Nullable
    private Object data;
    @Nullable
    private KdNode left;
    @Nullable
    private KdNode right;
    private int count;

    @Nullable
    public final Coordinate getCoordinate() {
        return this.coordinate;
    }

    @Nullable
    public final Object getData() {
        return this.data;
    }

    public final int getCount() {
        return this.count;
    }

    public KdNode(double _x, double _y, @Nullable Object data) {
        this.coordinate = new Coordinate(_x, _y);
        this.left = null;
        this.right = null;
        this.count = 1;
        this.data = data;
    }

    public KdNode(@Nullable Coordinate p, @Nullable Object data) {
        Coordinate coordinate = p;
        Intrinsics.checkNotNull((Object)coordinate);
        this.coordinate = new Coordinate(coordinate);
        this.left = null;
        this.right = null;
        this.count = 1;
        this.data = data;
    }

    public final double getX() {
        Coordinate coordinate = this.coordinate;
        Intrinsics.checkNotNull((Object)coordinate);
        return coordinate.x;
    }

    public final double getY() {
        Coordinate coordinate = this.coordinate;
        Intrinsics.checkNotNull((Object)coordinate);
        return coordinate.y;
    }

    public final double splitValue(boolean isSplitOnX) {
        double d;
        if (isSplitOnX) {
            Coordinate coordinate = this.coordinate;
            Intrinsics.checkNotNull((Object)coordinate);
            d = coordinate.x;
        } else {
            Coordinate coordinate = this.coordinate;
            Intrinsics.checkNotNull((Object)coordinate);
            d = coordinate.y;
        }
        return d;
    }

    @Nullable
    public final KdNode getLeft() {
        return this.left;
    }

    @Nullable
    public final KdNode getRight() {
        return this.right;
    }

    public final void increment() {
        ++this.count;
    }

    public final boolean isRepeated() {
        return this.count > 1;
    }

    public final void setLeft(@Nullable KdNode _left) {
        this.left = _left;
    }

    public final void setRight(@Nullable KdNode _right) {
        this.right = _right;
    }

    public final boolean isRangeOverLeft(boolean isSplitOnX, @NotNull Envelope env) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        double envMin = isSplitOnX ? env.getMinX() : env.getMinY();
        double splitValue = this.splitValue(isSplitOnX);
        return envMin < splitValue;
    }

    public final boolean isRangeOverRight(boolean isSplitOnX, @NotNull Envelope env) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        double envMax = isSplitOnX ? env.getMaxX() : env.getMaxY();
        double splitValue = this.splitValue(isSplitOnX);
        return splitValue <= envMax;
    }

    public final boolean isPointOnLeft(boolean isSplitOnX, @NotNull Coordinate pt) {
        Intrinsics.checkNotNullParameter((Object)pt, (String)"pt");
        double ptOrdinate = isSplitOnX ? pt.x : pt.y;
        double splitValue = this.splitValue(isSplitOnX);
        return ptOrdinate < splitValue;
    }
}

