/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.quadtree;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.index.quadtree.DoubleBits;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/locationtech/jts/index/quadtree/IntervalSize;", "", "<init>", "()V", "MIN_BINARY_EXPONENT", "", "isZeroWidth", "", "min", "", "max", "kts-core"})
public final class IntervalSize {
    @NotNull
    public static final IntervalSize INSTANCE = new IntervalSize();
    public static final int MIN_BINARY_EXPONENT = -50;

    private IntervalSize() {
    }

    public final boolean isZeroWidth(double min, double max) {
        double width = max - min;
        if (width == 0.0) {
            return true;
        }
        double maxAbs = Math.INSTANCE.max(Math.INSTANCE.abs(min), Math.INSTANCE.abs(max));
        double scaledInterval = width / maxAbs;
        int level = DoubleBits.Companion.exponent(scaledInterval);
        return level <= -50;
    }
}

