/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.quadtree;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.quadtree.Key;
import org.locationtech.jts.index.quadtree.NodeBase;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u0014J\u0010\u0010\u0012\u001a\u00020\u00002\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\u0013\u001a\u00020\u00012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0000J\u0010\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u0010\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0005H\u0002R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/locationtech/jts/index/quadtree/Node;", "Lorg/locationtech/jts/index/quadtree/NodeBase;", "envelope", "Lorg/locationtech/jts/geom/Envelope;", "level", "", "<init>", "(Lorg/locationtech/jts/geom/Envelope;I)V", "getEnvelope", "()Lorg/locationtech/jts/geom/Envelope;", "getLevel", "()I", "centrex", "", "centrey", "isSearchMatch", "", "searchEnv", "getNode", "find", "insertNode", "", "node", "getSubnode", "index", "createSubnode", "Companion", "kts-core"})
public final class Node
extends NodeBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Envelope envelope;
    private final int level;
    private final double centrex;
    private final double centrey;

    public Node(@Nullable Envelope envelope, int level) {
        this.envelope = envelope;
        this.level = level;
        Envelope envelope2 = this.envelope;
        Intrinsics.checkNotNull((Object)envelope2);
        this.centrex = (envelope2.getMinX() + this.envelope.getMaxX()) / (double)2;
        this.centrey = (this.envelope.getMinY() + this.envelope.getMaxY()) / (double)2;
    }

    @Nullable
    public final Envelope getEnvelope() {
        return this.envelope;
    }

    public final int getLevel() {
        return this.level;
    }

    @Override
    protected boolean isSearchMatch(@Nullable Envelope searchEnv) {
        boolean bl;
        if (searchEnv == null) {
            bl = false;
        } else {
            Envelope envelope = this.envelope;
            Intrinsics.checkNotNull((Object)envelope);
            bl = envelope.intersects(searchEnv);
        }
        return bl;
    }

    @NotNull
    public final Node getNode(@Nullable Envelope searchEnv) {
        Node node;
        int subnodeIndex = NodeBase.Companion.getSubnodeIndex(searchEnv, this.centrex, this.centrey);
        if (subnodeIndex != -1) {
            Node node2 = this.getSubnode(subnodeIndex);
            node = node2.getNode(searchEnv);
        } else {
            node = this;
        }
        return node;
    }

    @NotNull
    public final NodeBase find(@Nullable Envelope searchEnv) {
        int subnodeIndex = NodeBase.Companion.getSubnodeIndex(searchEnv, this.centrex, this.centrey);
        if (subnodeIndex == -1) {
            return this;
        }
        if (this.getSubnode()[subnodeIndex] != null) {
            Node node = this.getSubnode()[subnodeIndex];
            Intrinsics.checkNotNull((Object)node);
            Node node2 = node;
            return node2.find(searchEnv);
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    public final void insertNode(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.envelope == null) ** GOTO lbl-1000
        v0 = node.envelope;
        Intrinsics.checkNotNull((Object)v0);
        if (this.envelope.contains(v0)) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        Assert.isTrue(v1);
        index = NodeBase.Companion.getSubnodeIndex(node.envelope, this.centrex, this.centrey);
        if (node.level == this.level - 1) {
            this.getSubnode()[index] = node;
        } else {
            childNode = this.createSubnode(index);
            childNode.insertNode(node);
            this.getSubnode()[index] = childNode;
        }
    }

    private final Node getSubnode(int index) {
        if (this.getSubnode()[index] == null) {
            this.getSubnode()[index] = this.createSubnode(index);
        }
        Node node = this.getSubnode()[index];
        Intrinsics.checkNotNull((Object)node);
        return node;
    }

    private final Node createSubnode(int index) {
        double minx = 0.0;
        double maxx = 0.0;
        double miny = 0.0;
        double maxy = 0.0;
        switch (index) {
            case 0: {
                Envelope envelope = this.envelope;
                Intrinsics.checkNotNull((Object)envelope);
                minx = envelope.getMinX();
                maxx = this.centrex;
                miny = this.envelope.getMinY();
                maxy = this.centrey;
                break;
            }
            case 1: {
                minx = this.centrex;
                Envelope envelope = this.envelope;
                Intrinsics.checkNotNull((Object)envelope);
                maxx = envelope.getMaxX();
                miny = this.envelope.getMinY();
                maxy = this.centrey;
                break;
            }
            case 2: {
                Envelope envelope = this.envelope;
                Intrinsics.checkNotNull((Object)envelope);
                minx = envelope.getMinX();
                maxx = this.centrex;
                miny = this.centrey;
                maxy = this.envelope.getMaxY();
                break;
            }
            case 3: {
                minx = this.centrex;
                Envelope envelope = this.envelope;
                Intrinsics.checkNotNull((Object)envelope);
                maxx = envelope.getMaxX();
                miny = this.centrey;
                maxy = this.envelope.getMaxY();
            }
        }
        Envelope sqEnv = new Envelope(minx, maxx, miny, maxy);
        return new Node(sqEnv, this.level - 1);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001a\u0010\b\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\u000b"}, d2={"Lorg/locationtech/jts/index/quadtree/Node$Companion;", "", "<init>", "()V", "createNode", "Lorg/locationtech/jts/index/quadtree/Node;", "env", "Lorg/locationtech/jts/geom/Envelope;", "createExpanded", "node", "addEnv", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Node createNode(@NotNull Envelope env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            Key key = new Key(env);
            return new Node(key.getEnvelope(), key.getLevel());
        }

        @NotNull
        public final Node createExpanded(@Nullable Node node, @Nullable Envelope addEnv) {
            Envelope envelope = addEnv;
            Intrinsics.checkNotNull((Object)envelope);
            Envelope expandEnv = new Envelope(envelope);
            if (node != null) {
                Envelope envelope2 = node.getEnvelope();
                Intrinsics.checkNotNull((Object)envelope2);
                expandEnv.expandToInclude(envelope2);
            }
            Node largerNode = this.createNode(expandEnv);
            if (node != null) {
                largerNode.insertNode(node);
            }
            return largerNode;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

