/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.quadtree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.ArrayListVisitor;
import org.locationtech.jts.index.ItemVisitor;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.quadtree.Root;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001f2\u00020\u00012\u00060\u0002j\u0002`\u0003:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\u000f\u001a\u00020\u000bJ\u001c\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u001c\u0010\u0016\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0016\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0013H\u0016J\u001c\u0010\u0017\u001a\u00020\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u00132\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u0018J\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u001e\u001a\u0004\u0018\u00010\u0007R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000e\u00a8\u0006 "}, d2={"Lorg/locationtech/jts/index/quadtree/Quadtree;", "Lorg/locationtech/jts/index/SpatialIndex;", "Ljava/io/Serializable;", "Lorg/locationtech/jts/legacy/Serializable;", "<init>", "()V", "root", "Lorg/locationtech/jts/index/quadtree/Root;", "minExtent", "", "depth", "", "isEmpty", "", "()Z", "size", "insert", "", "itemEnv", "Lorg/locationtech/jts/geom/Envelope;", "item", "", "remove", "query", "", "searchEnv", "visitor", "Lorg/locationtech/jts/index/ItemVisitor;", "queryAll", "collectStats", "getRoot", "Companion", "kts-core"})
public final class Quadtree
implements SpatialIndex,
Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Root root = new Root();
    private double minExtent = 1.0;
    private static final long serialVersionUID = -7461163625812743604L;

    public final int depth() {
        Root root = this.root;
        return root != null ? root.depth() : 0;
    }

    public final boolean isEmpty() {
        Root root = this.root;
        return root != null ? root.isEmpty() : true;
    }

    public final int size() {
        Root root = this.root;
        return root != null ? root.size() : 0;
    }

    @Override
    public void insert(@Nullable Envelope itemEnv, @Nullable Object item) {
        Envelope envelope = itemEnv;
        Intrinsics.checkNotNull((Object)envelope);
        this.collectStats(envelope);
        Envelope insertEnv = Companion.ensureExtent(itemEnv, this.minExtent);
        Root root = this.root;
        Intrinsics.checkNotNull((Object)root);
        Object object = item;
        Intrinsics.checkNotNull((Object)object);
        root.insert(insertEnv, object);
    }

    @Override
    public boolean remove(@Nullable Envelope itemEnv, @Nullable Object item) {
        Envelope envelope = itemEnv;
        Intrinsics.checkNotNull((Object)envelope);
        Envelope posEnv = Companion.ensureExtent(envelope, this.minExtent);
        Root root = this.root;
        Intrinsics.checkNotNull((Object)root);
        return root.remove(posEnv, item);
    }

    @Override
    @NotNull
    public List<?> query(@Nullable Envelope searchEnv) {
        ArrayListVisitor visitor = new ArrayListVisitor();
        this.query(searchEnv, visitor);
        return visitor.getItems();
    }

    @Override
    public void query(@Nullable Envelope searchEnv, @Nullable ItemVisitor visitor) {
        Root root = this.root;
        Intrinsics.checkNotNull((Object)root);
        ItemVisitor itemVisitor = visitor;
        Intrinsics.checkNotNull((Object)itemVisitor);
        root.visit(searchEnv, itemVisitor);
    }

    @NotNull
    public final List<Object> queryAll() {
        List foundItems = new ArrayList();
        Root root = this.root;
        Intrinsics.checkNotNull((Object)root);
        root.addAllItems(foundItems);
        return foundItems;
    }

    private final void collectStats(Envelope itemEnv) {
        double delY;
        double delX = itemEnv.getWidth();
        if (delX < this.minExtent && delX > 0.0) {
            this.minExtent = delX;
        }
        if ((delY = itemEnv.getHeight()) < this.minExtent && delY > 0.0) {
            this.minExtent = delY;
        }
    }

    @Nullable
    public final Root getRoot() {
        return this.root;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/locationtech/jts/index/quadtree/Quadtree$Companion;", "", "<init>", "()V", "serialVersionUID", "", "ensureExtent", "Lorg/locationtech/jts/geom/Envelope;", "itemEnv", "minExtent", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Envelope ensureExtent(@NotNull Envelope itemEnv, double minExtent) {
            Intrinsics.checkNotNullParameter((Object)itemEnv, (String)"itemEnv");
            double minx = itemEnv.getMinX();
            double maxx = itemEnv.getMaxX();
            double miny = itemEnv.getMinY();
            double maxy = itemEnv.getMaxY();
            if (!(minx == maxx) && !(miny == maxy)) {
                return itemEnv;
            }
            if (minx == maxx) {
                minx -= minExtent / 2.0;
                maxx += minExtent / 2.0;
            }
            if (miny == maxy) {
                miny -= minExtent / 2.0;
                maxy += minExtent / 2.0;
            }
            return new Envelope(minx, maxx, miny, maxy);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

