/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0007J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u001e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J \u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/locationtech/jts/io/ByteOrderValues;", "", "<init>", "()V", "BIG_ENDIAN", "", "LITTLE_ENDIAN", "getInt", "buf", "", "byteOrder", "putInt", "", "intValue", "getLong", "", "putLong", "longValue", "getDouble", "", "putDouble", "doubleValue", "kts-core"})
public final class ByteOrderValues {
    @NotNull
    public static final ByteOrderValues INSTANCE = new ByteOrderValues();
    public static final int BIG_ENDIAN = 1;
    public static final int LITTLE_ENDIAN = 2;

    private ByteOrderValues() {
    }

    public final int getInt(@NotNull byte[] buf, int byteOrder) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        return byteOrder == 1 ? (buf[0] & 0xFF) << 24 | (buf[1] & 0xFF) << 16 | (buf[2] & 0xFF) << 8 | buf[3] & 0xFF : (buf[3] & 0xFF) << 24 | (buf[2] & 0xFF) << 16 | (buf[1] & 0xFF) << 8 | buf[0] & 0xFF;
    }

    @JvmStatic
    public static final void putInt(int intValue, @NotNull byte[] buf, int byteOrder) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        if (byteOrder == 1) {
            buf[0] = (byte)(intValue >> 24);
            buf[1] = (byte)(intValue >> 16);
            buf[2] = (byte)(intValue >> 8);
            buf[3] = (byte)intValue;
        } else {
            buf[0] = (byte)intValue;
            buf[1] = (byte)(intValue >> 8);
            buf[2] = (byte)(intValue >> 16);
            buf[3] = (byte)(intValue >> 24);
        }
    }

    public final long getLong(@NotNull byte[] buf, int byteOrder) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        return byteOrder == 1 ? (long)(buf[0] & 0xFF) << 56 | (long)(buf[1] & 0xFF) << 48 | (long)(buf[2] & 0xFF) << 40 | (long)(buf[3] & 0xFF) << 32 | (long)(buf[4] & 0xFF) << 24 | (long)(buf[5] & 0xFF) << 16 | (long)(buf[6] & 0xFF) << 8 | (long)(buf[7] & 0xFF) : (long)(buf[7] & 0xFF) << 56 | (long)(buf[6] & 0xFF) << 48 | (long)(buf[5] & 0xFF) << 40 | (long)(buf[4] & 0xFF) << 32 | (long)(buf[3] & 0xFF) << 24 | (long)(buf[2] & 0xFF) << 16 | (long)(buf[1] & 0xFF) << 8 | (long)(buf[0] & 0xFF);
    }

    public final void putLong(long longValue, @NotNull byte[] buf, int byteOrder) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        if (byteOrder == 1) {
            buf[0] = (byte)(longValue >> 56);
            buf[1] = (byte)(longValue >> 48);
            buf[2] = (byte)(longValue >> 40);
            buf[3] = (byte)(longValue >> 32);
            buf[4] = (byte)(longValue >> 24);
            buf[5] = (byte)(longValue >> 16);
            buf[6] = (byte)(longValue >> 8);
            buf[7] = (byte)longValue;
        } else {
            buf[0] = (byte)longValue;
            buf[1] = (byte)(longValue >> 8);
            buf[2] = (byte)(longValue >> 16);
            buf[3] = (byte)(longValue >> 24);
            buf[4] = (byte)(longValue >> 32);
            buf[5] = (byte)(longValue >> 40);
            buf[6] = (byte)(longValue >> 48);
            buf[7] = (byte)(longValue >> 56);
        }
    }

    public final double getDouble(@NotNull byte[] buf, int byteOrder) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        long longVal = this.getLong(buf, byteOrder);
        return Math.INSTANCE.longBitsToDouble(longVal);
    }

    @JvmStatic
    public static final void putDouble(double doubleValue, @NotNull byte[] buf, int byteOrder) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        long longVal = Math.INSTANCE.doubleToLongBits(doubleValue);
        INSTANCE.putLong(longVal, buf, byteOrder);
    }
}

