/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001b\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u001b\b\u0016\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\nB\u001b\b\u0016\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\rJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u000fJ\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0013J\u000e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u000fJ\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aJ\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u0014\u0010\u001f\u001a\u00020\u00132\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0002J\u0010\u0010 \u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/locationtech/jts/io/WKTFileReader;", "", "file", "Ljava/io/File;", "wktReader", "Lorg/locationtech/jts/io/WKTReader;", "<init>", "(Ljava/io/File;Lorg/locationtech/jts/io/WKTReader;)V", "filename", "", "(Ljava/lang/String;Lorg/locationtech/jts/io/WKTReader;)V", "reader", "Ljava/io/Reader;", "(Ljava/io/Reader;Lorg/locationtech/jts/io/WKTReader;)V", "count", "", "limit", "offset", "isStrictParsing", "", "setLimit", "", "setStrictParsing", "isStrict", "setOffset", "read", "", "Lorg/locationtech/jts/geom/Geometry;", "bufferedReader", "Ljava/io/BufferedReader;", "geoms", "isAtLimit", "isAtEndOfFile", "kts-core"})
public final class WKTFileReader {
    @Nullable
    private File file;
    @Nullable
    private Reader reader;
    @NotNull
    private WKTReader wktReader;
    private int count;
    private int limit;
    private int offset;
    private boolean isStrictParsing;

    public WKTFileReader(@Nullable File file, @NotNull WKTReader wktReader) {
        Intrinsics.checkNotNullParameter((Object)wktReader, (String)"wktReader");
        this.limit = -1;
        this.isStrictParsing = true;
        this.file = file;
        this.wktReader = wktReader;
    }

    public WKTFileReader(@Nullable String filename, @NotNull WKTReader wktReader) {
        Intrinsics.checkNotNullParameter((Object)wktReader, (String)"wktReader");
        this(new File(filename), wktReader);
    }

    public WKTFileReader(@Nullable Reader reader, @NotNull WKTReader wktReader) {
        Intrinsics.checkNotNullParameter((Object)wktReader, (String)"wktReader");
        this.limit = -1;
        this.isStrictParsing = true;
        this.reader = reader;
        this.wktReader = wktReader;
    }

    public final void setLimit(int limit) {
        this.limit = limit;
    }

    public final void setStrictParsing(boolean isStrict) {
        this.isStrictParsing = isStrict;
    }

    public final void setOffset(int offset) {
        this.offset = offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Geometry> read() throws IOException, ParseException {
        List<Geometry> list;
        if (this.file != null) {
            this.reader = new FileReader(this.file);
        }
        this.count = 0;
        try {
            List<Geometry> list2;
            try (BufferedReader bufferedReader = new BufferedReader(this.reader);){
                list2 = this.read(bufferedReader);
            }
            list = list2;
        }
        finally {
            Reader reader = this.reader;
            Intrinsics.checkNotNull((Object)reader);
            reader.close();
        }
        return list;
    }

    private final List<Geometry> read(BufferedReader bufferedReader) throws IOException, ParseException {
        List geoms;
        block2: {
            geoms = new ArrayList();
            try {
                this.read(bufferedReader, geoms);
            }
            catch (ParseException ex) {
                if (!this.isStrictParsing && geoms.size() != 0) break block2;
                throw ex;
            }
        }
        return geoms;
    }

    private final void read(BufferedReader bufferedReader, List<Geometry> geoms) throws IOException, ParseException {
        while (!this.isAtEndOfFile(bufferedReader) && !this.isAtLimit(geoms)) {
            Geometry g = this.wktReader.read(bufferedReader);
            if (this.count >= this.offset) {
                geoms.add(g);
            }
            int n = this.count;
            this.count = n + 1;
        }
    }

    private final boolean isAtLimit(List<?> geoms) {
        if (this.limit < 0) {
            return false;
        }
        return geoms.size() >= this.limit;
    }

    private final boolean isAtEndOfFile(BufferedReader bufferedReader) throws IOException {
        int ch = 0;
        do {
            bufferedReader.mark(1);
            ch = bufferedReader.read();
            if (ch >= 0) continue;
            return true;
        } while (Character.isWhitespace(ch));
        bufferedReader.reset();
        return false;
    }
}

