/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io;

import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.Ordinate;
import org.locationtech.jts.io.OrdinateFormat;
import org.locationtech.jts.io.StringWriter;
import org.locationtech.jts.io.Writer;
import org.locationtech.jts.legacy.EnumSetKt;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0014\u0018\u0000 _2\u00020\u0001:\u0002^_B\u0013\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0003J\u000e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0003J#\u0010\u0019\u001a\u00020\u00152\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t\u00a2\u0006\u0002\u0010\u001aJ\u001b\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t\u00a2\u0006\u0002\u0010\u001cJ\u000e\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 J\u0016\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 J\u0016\u0010#\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J \u0010#\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010%\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0002J(\u0010&\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u000eH\u0002JM\u0010&\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 2\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010)JM\u0010*\u001a\u00020\u00152\u0006\u0010+\u001a\u00020,2\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010-JM\u0010.\u001a\u00020\u00152\u0006\u0010/\u001a\u0002002\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u00101JM\u00102\u001a\u00020\u00152\u0006\u00103\u001a\u0002042\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u00105JM\u00106\u001a\u00020\u00152\u0006\u00107\u001a\u0002082\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u00109JM\u0010:\u001a\u00020\u00152\u0006\u0010;\u001a\u00020<2\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010=JM\u0010>\u001a\u00020\u00152\u0006\u0010?\u001a\u00020@2\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010AJM\u0010B\u001a\u00020\u00152\u0006\u0010C\u001a\u00020D2\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010EJM\u0010F\u001a\u00020\u00152\u0006\u0010G\u001a\u00020H2\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010IJG\u0010J\u001a\u00020\u00152\b\u0010K\u001a\u0004\u0018\u00010L2\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t2\u0006\u0010M\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010NJ-\u0010O\u001a\u00020\u00152\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t2\u0006\u0010!\u001a\u00020\"H\u0002\u00a2\u0006\u0002\u0010PJW\u0010Q\u001a\u00020\u00152\b\u0010K\u001a\u0004\u0018\u00010L2\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u00032\u0006\u0010R\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010SJU\u0010T\u001a\u00020\u00152\u0006\u00107\u001a\u0002082\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u00032\u0006\u0010R\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010UJM\u0010V\u001a\u00020\u00152\u0006\u0010W\u001a\u00020<2\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010=JM\u0010X\u001a\u00020\u00152\u0006\u0010?\u001a\u00020@2\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010AJM\u0010Y\u001a\u00020\u00152\u0006\u0010C\u001a\u00020D2\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010EJM\u0010Z\u001a\u00020\u00152\u0006\u0010G\u001a\u00020H2\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010IJ(\u0010[\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u00102\u0006\u0010\\\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"H\u0002J \u0010]\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"H\u0002R \u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006`"}, d2={"Lorg/locationtech/jts/io/WKTWriter;", "", "outputDimension", "", "<init>", "(I)V", "outputOrdinates", "Ljava/util/EnumSet;", "Lorg/locationtech/jts/io/Ordinate;", "Lorg/locationtech/jts/legacy/EnumSet;", "Ljava/util/EnumSet;", "precisionModel", "Lorg/locationtech/jts/geom/PrecisionModel;", "ordinateFormat", "Lorg/locationtech/jts/io/OrdinateFormat;", "isFormatted", "", "coordsPerLine", "indentTabStr", "", "setFormatted", "", "setMaxCoordinatesPerLine", "setTab", "size", "setOutputOrdinates", "(Ljava/util/EnumSet;)V", "getOutputOrdinates", "()Ljava/util/EnumSet;", "setPrecisionModel", "write", "geometry", "Lorg/locationtech/jts/geom/Geometry;", "writer", "Lorg/locationtech/jts/io/Writer;", "writeFormatted", "useFormatting", "getFormatter", "appendGeometryTaggedText", "formatter", "level", "(Lorg/locationtech/jts/geom/Geometry;Ljava/util/EnumSet;ZILorg/locationtech/jts/io/Writer;Lorg/locationtech/jts/io/OrdinateFormat;)V", "appendPointTaggedText", "point", "Lorg/locationtech/jts/geom/Point;", "(Lorg/locationtech/jts/geom/Point;Ljava/util/EnumSet;ZILorg/locationtech/jts/io/Writer;Lorg/locationtech/jts/io/OrdinateFormat;)V", "appendLineStringTaggedText", "lineString", "Lorg/locationtech/jts/geom/LineString;", "(Lorg/locationtech/jts/geom/LineString;Ljava/util/EnumSet;ZILorg/locationtech/jts/io/Writer;Lorg/locationtech/jts/io/OrdinateFormat;)V", "appendLinearRingTaggedText", "linearRing", "Lorg/locationtech/jts/geom/LinearRing;", "(Lorg/locationtech/jts/geom/LinearRing;Ljava/util/EnumSet;ZILorg/locationtech/jts/io/Writer;Lorg/locationtech/jts/io/OrdinateFormat;)V", "appendPolygonTaggedText", "polygon", "Lorg/locationtech/jts/geom/Polygon;", "(Lorg/locationtech/jts/geom/Polygon;Ljava/util/EnumSet;ZILorg/locationtech/jts/io/Writer;Lorg/locationtech/jts/io/OrdinateFormat;)V", "appendMultiPointTaggedText", "multipoint", "Lorg/locationtech/jts/geom/MultiPoint;", "(Lorg/locationtech/jts/geom/MultiPoint;Ljava/util/EnumSet;ZILorg/locationtech/jts/io/Writer;Lorg/locationtech/jts/io/OrdinateFormat;)V", "appendMultiLineStringTaggedText", "multiLineString", "Lorg/locationtech/jts/geom/MultiLineString;", "(Lorg/locationtech/jts/geom/MultiLineString;Ljava/util/EnumSet;ZILorg/locationtech/jts/io/Writer;Lorg/locationtech/jts/io/OrdinateFormat;)V", "appendMultiPolygonTaggedText", "multiPolygon", "Lorg/locationtech/jts/geom/MultiPolygon;", "(Lorg/locationtech/jts/geom/MultiPolygon;Ljava/util/EnumSet;ZILorg/locationtech/jts/io/Writer;Lorg/locationtech/jts/io/OrdinateFormat;)V", "appendGeometryCollectionTaggedText", "geometryCollection", "Lorg/locationtech/jts/geom/GeometryCollection;", "(Lorg/locationtech/jts/geom/GeometryCollection;Ljava/util/EnumSet;ZILorg/locationtech/jts/io/Writer;Lorg/locationtech/jts/io/OrdinateFormat;)V", "appendCoordinate", "seq", "Lorg/locationtech/jts/geom/CoordinateSequence;", "i", "(Lorg/locationtech/jts/geom/CoordinateSequence;Ljava/util/EnumSet;ILorg/locationtech/jts/io/Writer;Lorg/locationtech/jts/io/OrdinateFormat;)V", "appendOrdinateText", "(Ljava/util/EnumSet;Lorg/locationtech/jts/io/Writer;)V", "appendSequenceText", "indentFirst", "(Lorg/locationtech/jts/geom/CoordinateSequence;Ljava/util/EnumSet;ZIZLorg/locationtech/jts/io/Writer;Lorg/locationtech/jts/io/OrdinateFormat;)V", "appendPolygonText", "(Lorg/locationtech/jts/geom/Polygon;Ljava/util/EnumSet;ZIZLorg/locationtech/jts/io/Writer;Lorg/locationtech/jts/io/OrdinateFormat;)V", "appendMultiPointText", "multiPoint", "appendMultiLineStringText", "appendMultiPolygonText", "appendGeometryCollectionText", "indentCoords", "coordIndex", "indent", "CheckOrdinatesFilter", "Companion", "kts-core"})
@SourceDebugExtension(value={"SMAP\nWKTWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WKTWriter.kt\norg/locationtech/jts/io/WKTWriter\n+ 2 EnumSet.kt\norg/locationtech/jts/legacy/EnumSetKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,997:1\n15#2:998\n1#3:999\n*S KotlinDebug\n*F\n+ 1 WKTWriter.kt\norg/locationtech/jts/io/WKTWriter\n*L\n123#1:998\n123#1:999\n*E\n"})
public final class WKTWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EnumSet<Ordinate> outputOrdinates;
    private final int outputDimension;
    @Nullable
    private PrecisionModel precisionModel;
    @Nullable
    private OrdinateFormat ordinateFormat;
    private boolean isFormatted;
    private int coordsPerLine;
    @Nullable
    private String indentTabStr;
    private static final int INDENT = 2;
    private static final int OUTPUT_DIMENSION = 2;

    @JvmOverloads
    public WKTWriter(int outputDimension) {
        EnumSet<Ordinate> enumSet;
        this.coordsPerLine = -1;
        this.setTab(2);
        this.outputDimension = outputDimension;
        if (outputDimension < 2 || outputDimension > 4) {
            throw new IllegalArgumentException("Invalid output dimension (must be 2 to 4)");
        }
        Ordinate[] ordinateArray = new Ordinate[]{Ordinate.X, Ordinate.Y};
        Object[] values$iv = ordinateArray;
        boolean $i$f$enumSetOf = false;
        EnumSet<Ordinate> $this$enumSetOf_u24lambda_u240$iv = enumSet = EnumSet.noneOf(Ordinate.class);
        boolean bl = false;
        Intrinsics.checkNotNull($this$enumSetOf_u24lambda_u240$iv);
        CollectionsKt.addAll((Collection)$this$enumSetOf_u24lambda_u240$iv, (Object[])values$iv);
        EnumSet<Ordinate> enumSet2 = enumSet;
        Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"apply(...)");
        this.outputOrdinates = enumSet2;
        if (outputDimension > 2) {
            EnumSetKt.add(this.outputOrdinates, (Enum)Ordinate.Z);
        }
        if (outputDimension > 3) {
            EnumSetKt.add(this.outputOrdinates, (Enum)Ordinate.M);
        }
    }

    public /* synthetic */ WKTWriter(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        this(n);
    }

    public final void setFormatted(boolean isFormatted) {
        this.isFormatted = isFormatted;
    }

    public final void setMaxCoordinatesPerLine(int coordsPerLine) {
        this.coordsPerLine = coordsPerLine;
    }

    public final void setTab(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Tab count must be positive");
        }
        this.indentTabStr = WKTWriter.Companion.stringOfChar(' ', size);
    }

    public final void setOutputOrdinates(@NotNull EnumSet<Ordinate> outputOrdinates) {
        Intrinsics.checkNotNullParameter(outputOrdinates, (String)"outputOrdinates");
        EnumSetKt.remove(this.outputOrdinates, (Enum)Ordinate.Z);
        EnumSetKt.remove(this.outputOrdinates, (Enum)Ordinate.M);
        if (this.outputDimension == 3) {
            if (EnumSetKt.contains(outputOrdinates, (Enum)Ordinate.Z)) {
                EnumSetKt.add(this.outputOrdinates, (Enum)Ordinate.Z);
            } else if (EnumSetKt.contains(outputOrdinates, (Enum)Ordinate.M)) {
                EnumSetKt.add(this.outputOrdinates, (Enum)Ordinate.M);
            }
        }
        if (this.outputDimension == 4) {
            if (EnumSetKt.contains(outputOrdinates, (Enum)Ordinate.Z)) {
                EnumSetKt.add(this.outputOrdinates, (Enum)Ordinate.Z);
            }
            if (EnumSetKt.contains(outputOrdinates, (Enum)Ordinate.M)) {
                EnumSetKt.add(this.outputOrdinates, (Enum)Ordinate.M);
            }
        }
    }

    @NotNull
    public final EnumSet<Ordinate> getOutputOrdinates() {
        return this.outputOrdinates;
    }

    public final void setPrecisionModel(@NotNull PrecisionModel precisionModel) {
        Intrinsics.checkNotNullParameter((Object)precisionModel, (String)"precisionModel");
        this.precisionModel = precisionModel;
        this.ordinateFormat = OrdinateFormat.Companion.create(precisionModel.getMaximumSignificantDigits());
    }

    @NotNull
    public final String write(@NotNull Geometry geometry) {
        Intrinsics.checkNotNullParameter((Object)geometry, (String)"geometry");
        Writer sw = new StringWriter();
        try {
            this.writeFormatted(geometry, false, sw);
        }
        catch (IOException ex) {
            Assert.shouldNeverReachHere$default(null, 1, null);
        }
        return sw.toString();
    }

    public final void write(@NotNull Geometry geometry, @NotNull Writer writer) throws IOException {
        Intrinsics.checkNotNullParameter((Object)geometry, (String)"geometry");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        this.writeFormatted(geometry, this.isFormatted, writer);
    }

    @NotNull
    public final String writeFormatted(@NotNull Geometry geometry) {
        Intrinsics.checkNotNullParameter((Object)geometry, (String)"geometry");
        Writer sw = new StringWriter();
        try {
            this.writeFormatted(geometry, true, sw);
        }
        catch (IOException ex) {
            Assert.shouldNeverReachHere$default(null, 1, null);
        }
        return sw.toString();
    }

    public final void writeFormatted(@NotNull Geometry geometry, @NotNull Writer writer) throws IOException {
        Intrinsics.checkNotNullParameter((Object)geometry, (String)"geometry");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        this.writeFormatted(geometry, true, writer);
    }

    private final void writeFormatted(Geometry geometry, boolean useFormatting, Writer writer) throws IOException {
        OrdinateFormat formatter = this.getFormatter(geometry);
        this.appendGeometryTaggedText(geometry, useFormatting, writer, formatter);
    }

    private final OrdinateFormat getFormatter(Geometry geometry) {
        if (this.ordinateFormat != null) {
            OrdinateFormat ordinateFormat = this.ordinateFormat;
            Intrinsics.checkNotNull((Object)ordinateFormat);
            return ordinateFormat;
        }
        PrecisionModel pm = geometry.getPrecisionModel();
        return WKTWriter.Companion.createFormatter(pm);
    }

    private final void appendGeometryTaggedText(Geometry geometry, boolean useFormatting, Writer writer, OrdinateFormat formatter) throws IOException {
        CheckOrdinatesFilter cof = new CheckOrdinatesFilter(this.outputOrdinates);
        geometry.apply(cof);
        this.appendGeometryTaggedText(geometry, cof.getOutputOrdinates(), useFormatting, 0, writer, formatter);
    }

    private final void appendGeometryTaggedText(Geometry geometry, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, Writer writer, OrdinateFormat formatter) throws IOException {
        this.indent(useFormatting, level, writer);
        if (geometry instanceof Point) {
            this.appendPointTaggedText((Point)geometry, outputOrdinates, useFormatting, level, writer, formatter);
        } else if (geometry instanceof LinearRing) {
            this.appendLinearRingTaggedText((LinearRing)geometry, outputOrdinates, useFormatting, level, writer, formatter);
        } else if (geometry instanceof LineString) {
            this.appendLineStringTaggedText((LineString)geometry, outputOrdinates, useFormatting, level, writer, formatter);
        } else if (geometry instanceof Polygon) {
            this.appendPolygonTaggedText((Polygon)geometry, outputOrdinates, useFormatting, level, writer, formatter);
        } else if (geometry instanceof MultiPoint) {
            this.appendMultiPointTaggedText((MultiPoint)geometry, outputOrdinates, useFormatting, level, writer, formatter);
        } else if (geometry instanceof MultiLineString) {
            this.appendMultiLineStringTaggedText((MultiLineString)geometry, outputOrdinates, useFormatting, level, writer, formatter);
        } else if (geometry instanceof MultiPolygon) {
            this.appendMultiPolygonTaggedText((MultiPolygon)geometry, outputOrdinates, useFormatting, level, writer, formatter);
        } else if (geometry instanceof GeometryCollection) {
            this.appendGeometryCollectionTaggedText((GeometryCollection)geometry, outputOrdinates, useFormatting, level, writer, formatter);
        } else {
            Assert.shouldNeverReachHere("Unsupported Geometry implementation:" + Reflection.getOrCreateKotlinClass(geometry.getClass()));
        }
    }

    private final void appendPointTaggedText(Point point, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, Writer writer, OrdinateFormat formatter) throws IOException {
        writer.write("POINT");
        writer.write(" ");
        this.appendOrdinateText(outputOrdinates, writer);
        this.appendSequenceText(point.getCoordinateSequence(), outputOrdinates, useFormatting, level, false, writer, formatter);
    }

    private final void appendLineStringTaggedText(LineString lineString, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, Writer writer, OrdinateFormat formatter) throws IOException {
        writer.write("LINESTRING");
        writer.write(" ");
        this.appendOrdinateText(outputOrdinates, writer);
        this.appendSequenceText(lineString.getCoordinateSequence(), outputOrdinates, useFormatting, level, false, writer, formatter);
    }

    private final void appendLinearRingTaggedText(LinearRing linearRing, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, Writer writer, OrdinateFormat formatter) throws IOException {
        writer.write("LINEARRING");
        writer.write(" ");
        this.appendOrdinateText(outputOrdinates, writer);
        this.appendSequenceText(linearRing.getCoordinateSequence(), outputOrdinates, useFormatting, level, false, writer, formatter);
    }

    private final void appendPolygonTaggedText(Polygon polygon, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, Writer writer, OrdinateFormat formatter) throws IOException {
        writer.write("POLYGON");
        writer.write(" ");
        this.appendOrdinateText(outputOrdinates, writer);
        this.appendPolygonText(polygon, outputOrdinates, useFormatting, level, false, writer, formatter);
    }

    private final void appendMultiPointTaggedText(MultiPoint multipoint, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, Writer writer, OrdinateFormat formatter) throws IOException {
        writer.write("MULTIPOINT");
        writer.write(" ");
        this.appendOrdinateText(outputOrdinates, writer);
        this.appendMultiPointText(multipoint, outputOrdinates, useFormatting, level, writer, formatter);
    }

    private final void appendMultiLineStringTaggedText(MultiLineString multiLineString, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, Writer writer, OrdinateFormat formatter) throws IOException {
        writer.write("MULTILINESTRING");
        writer.write(" ");
        this.appendOrdinateText(outputOrdinates, writer);
        this.appendMultiLineStringText(multiLineString, outputOrdinates, useFormatting, level, writer, formatter);
    }

    private final void appendMultiPolygonTaggedText(MultiPolygon multiPolygon, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, Writer writer, OrdinateFormat formatter) throws IOException {
        writer.write("MULTIPOLYGON");
        writer.write(" ");
        this.appendOrdinateText(outputOrdinates, writer);
        this.appendMultiPolygonText(multiPolygon, outputOrdinates, useFormatting, level, writer, formatter);
    }

    private final void appendGeometryCollectionTaggedText(GeometryCollection geometryCollection, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, Writer writer, OrdinateFormat formatter) throws IOException {
        writer.write("GEOMETRYCOLLECTION");
        writer.write(" ");
        this.appendOrdinateText(outputOrdinates, writer);
        this.appendGeometryCollectionText(geometryCollection, outputOrdinates, useFormatting, level, writer, formatter);
    }

    private final void appendCoordinate(CoordinateSequence seq, EnumSet<Ordinate> outputOrdinates, int i, Writer writer, OrdinateFormat formatter) throws IOException {
        CoordinateSequence coordinateSequence = seq;
        Intrinsics.checkNotNull((Object)coordinateSequence);
        writer.write(WKTWriter.Companion.writeNumber(coordinateSequence.getX(i), formatter) + " " + WKTWriter.Companion.writeNumber(seq.getY(i), formatter));
        if (EnumSetKt.contains(outputOrdinates, (Enum)Ordinate.Z)) {
            writer.write(" ");
            writer.write(WKTWriter.Companion.writeNumber(seq.getZ(i), formatter));
        }
        if (EnumSetKt.contains(outputOrdinates, (Enum)Ordinate.M)) {
            writer.write(" ");
            writer.write(WKTWriter.Companion.writeNumber(seq.getM(i), formatter));
        }
    }

    private final void appendOrdinateText(EnumSet<Ordinate> outputOrdinates, Writer writer) throws IOException {
        if (EnumSetKt.contains(outputOrdinates, (Enum)Ordinate.Z)) {
            writer.write("Z");
        }
        if (EnumSetKt.contains(outputOrdinates, (Enum)Ordinate.M)) {
            writer.write("M");
        }
    }

    private final void appendSequenceText(CoordinateSequence seq, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, boolean indentFirst, Writer writer, OrdinateFormat formatter) throws IOException {
        CoordinateSequence coordinateSequence = seq;
        Intrinsics.checkNotNull((Object)coordinateSequence);
        if (coordinateSequence.size() == 0) {
            writer.write("EMPTY");
        } else {
            if (indentFirst) {
                this.indent(useFormatting, level, writer);
            }
            writer.write("(");
            int n = seq.size();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    writer.write(", ");
                    if (this.coordsPerLine > 0 && i % this.coordsPerLine == 0) {
                        this.indent(useFormatting, level + 1, writer);
                    }
                }
                this.appendCoordinate(seq, outputOrdinates, i, writer, formatter);
            }
            writer.write(")");
        }
    }

    private final void appendPolygonText(Polygon polygon, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, boolean indentFirst, Writer writer, OrdinateFormat formatter) throws IOException {
        if (polygon.isEmpty()) {
            writer.write("EMPTY");
        } else {
            if (indentFirst) {
                this.indent(useFormatting, level, writer);
            }
            writer.write("(");
            LinearRing linearRing = polygon.getExteriorRing();
            Intrinsics.checkNotNull((Object)linearRing);
            this.appendSequenceText(linearRing.getCoordinateSequence(), outputOrdinates, useFormatting, level, false, writer, formatter);
            int n = polygon.getNumInteriorRing();
            for (int i = 0; i < n; ++i) {
                writer.write(", ");
                this.appendSequenceText(polygon.getInteriorRingN(i).getCoordinateSequence(), outputOrdinates, useFormatting, level + 1, true, writer, formatter);
            }
            writer.write(")");
        }
    }

    private final void appendMultiPointText(MultiPoint multiPoint, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, Writer writer, OrdinateFormat formatter) throws IOException {
        if (multiPoint.getNumGeometries() == 0) {
            writer.write("EMPTY");
        } else {
            writer.write("(");
            int n = multiPoint.getNumGeometries();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    writer.write(", ");
                    this.indentCoords(useFormatting, i, level + 1, writer);
                }
                Geometry geometry = multiPoint.getGeometryN(i);
                Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Point");
                this.appendSequenceText(((Point)geometry).getCoordinateSequence(), outputOrdinates, useFormatting, level, false, writer, formatter);
            }
            writer.write(")");
        }
    }

    private final void appendMultiLineStringText(MultiLineString multiLineString, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, Writer writer, OrdinateFormat formatter) throws IOException {
        if (multiLineString.getNumGeometries() == 0) {
            writer.write("EMPTY");
        } else {
            int level2 = level;
            boolean doIndent = false;
            writer.write("(");
            int n = multiLineString.getNumGeometries();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    writer.write(", ");
                    level2 = level + 1;
                    doIndent = true;
                }
                Geometry geometry = multiLineString.getGeometryN(i);
                Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
                this.appendSequenceText(((LineString)geometry).getCoordinateSequence(), outputOrdinates, useFormatting, level2, doIndent, writer, formatter);
            }
            writer.write(")");
        }
    }

    private final void appendMultiPolygonText(MultiPolygon multiPolygon, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, Writer writer, OrdinateFormat formatter) throws IOException {
        if (multiPolygon.getNumGeometries() == 0) {
            writer.write("EMPTY");
        } else {
            int level2 = level;
            boolean doIndent = false;
            writer.write("(");
            int n = multiPolygon.getNumGeometries();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    writer.write(", ");
                    level2 = level + 1;
                    doIndent = true;
                }
                Geometry geometry = multiPolygon.getGeometryN(i);
                Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
                this.appendPolygonText((Polygon)geometry, outputOrdinates, useFormatting, level2, doIndent, writer, formatter);
            }
            writer.write(")");
        }
    }

    private final void appendGeometryCollectionText(GeometryCollection geometryCollection, EnumSet<Ordinate> outputOrdinates, boolean useFormatting, int level, Writer writer, OrdinateFormat formatter) throws IOException {
        if (geometryCollection.getNumGeometries() == 0) {
            writer.write("EMPTY");
        } else {
            int level2 = level;
            writer.write("(");
            int n = geometryCollection.getNumGeometries();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    writer.write(", ");
                    level2 = level + 1;
                }
                this.appendGeometryTaggedText(geometryCollection.getGeometryN(i), outputOrdinates, useFormatting, level2, writer, formatter);
            }
            writer.write(")");
        }
    }

    private final void indentCoords(boolean useFormatting, int coordIndex, int level, Writer writer) throws IOException {
        if (this.coordsPerLine <= 0 || coordIndex % this.coordsPerLine != 0) {
            return;
        }
        this.indent(useFormatting, level, writer);
    }

    private final void indent(boolean useFormatting, int level, Writer writer) throws IOException {
        if (!useFormatting || level <= 0) {
            return;
        }
        writer.write("\n");
        for (int i = 0; i < level; ++i) {
            String string = this.indentTabStr;
            Intrinsics.checkNotNull((Object)string);
            writer.write(string);
        }
    }

    @JvmOverloads
    public WKTWriter() {
        this(0, 1, null);
    }

    @JvmStatic
    @NotNull
    public static final String toPoint(@NotNull Coordinate p0) {
        return Companion.toPoint(p0);
    }

    @JvmStatic
    @NotNull
    public static final String toLineString(@NotNull CoordinateSequence seq) {
        return Companion.toLineString(seq);
    }

    @JvmStatic
    @NotNull
    public static final String toLineString(@NotNull Coordinate[] coord) {
        return Companion.toLineString(coord);
    }

    @JvmStatic
    @NotNull
    public static final String toLineString(@NotNull Coordinate p0, @NotNull Coordinate p1) {
        return Companion.toLineString(p0, p1);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001b\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005\u00a2\u0006\u0002\u0010\u0015R \u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR \u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lorg/locationtech/jts/io/WKTWriter$CheckOrdinatesFilter;", "Lorg/locationtech/jts/geom/CoordinateSequenceFilter;", "checkOrdinateFlags", "Ljava/util/EnumSet;", "Lorg/locationtech/jts/io/Ordinate;", "Lorg/locationtech/jts/legacy/EnumSet;", "<init>", "(Lorg/locationtech/jts/io/WKTWriter;Ljava/util/EnumSet;)V", "Ljava/util/EnumSet;", "outputOrdinates", "filter", "", "seq", "Lorg/locationtech/jts/geom/CoordinateSequence;", "i", "", "isGeometryChanged", "", "()Z", "isDone", "getOutputOrdinates", "()Ljava/util/EnumSet;", "kts-core"})
    @SourceDebugExtension(value={"SMAP\nWKTWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WKTWriter.kt\norg/locationtech/jts/io/WKTWriter$CheckOrdinatesFilter\n+ 2 EnumSet.kt\norg/locationtech/jts/legacy/EnumSetKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,997:1\n15#2:998\n1#3:999\n*S KotlinDebug\n*F\n+ 1 WKTWriter.kt\norg/locationtech/jts/io/WKTWriter$CheckOrdinatesFilter\n*L\n49#1:998\n49#1:999\n*E\n"})
    private final class CheckOrdinatesFilter
    implements CoordinateSequenceFilter {
        @NotNull
        private final EnumSet<Ordinate> checkOrdinateFlags;
        @NotNull
        private final EnumSet<Ordinate> outputOrdinates;

        public CheckOrdinatesFilter(EnumSet<Ordinate> checkOrdinateFlags) {
            EnumSet<Ordinate> enumSet;
            Intrinsics.checkNotNullParameter(checkOrdinateFlags, (String)"checkOrdinateFlags");
            Ordinate[] ordinateArray = new Ordinate[]{Ordinate.X, Ordinate.Y};
            Object[] values$iv = ordinateArray;
            boolean $i$f$enumSetOf = false;
            EnumSet<Ordinate> $this$enumSetOf_u24lambda_u240$iv = enumSet = EnumSet.noneOf(Ordinate.class);
            boolean bl = false;
            Intrinsics.checkNotNull($this$enumSetOf_u24lambda_u240$iv);
            CollectionsKt.addAll((Collection)$this$enumSetOf_u24lambda_u240$iv, (Object[])values$iv);
            EnumSet<Ordinate> enumSet2 = enumSet;
            Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"apply(...)");
            this.outputOrdinates = enumSet2;
            this.checkOrdinateFlags = checkOrdinateFlags;
        }

        @Override
        public void filter(@Nullable CoordinateSequence seq, int i) {
            if (EnumSetKt.contains(this.checkOrdinateFlags, (Enum)Ordinate.Z) && !EnumSetKt.contains(this.outputOrdinates, (Enum)Ordinate.Z)) {
                CoordinateSequence coordinateSequence = seq;
                Intrinsics.checkNotNull((Object)coordinateSequence);
                if (!Math.INSTANCE.isNaN(coordinateSequence.getZ(i))) {
                    EnumSetKt.add(this.outputOrdinates, (Enum)Ordinate.Z);
                }
            }
            if (EnumSetKt.contains(this.checkOrdinateFlags, (Enum)Ordinate.M) && !EnumSetKt.contains(this.outputOrdinates, (Enum)Ordinate.M)) {
                CoordinateSequence coordinateSequence = seq;
                Intrinsics.checkNotNull((Object)coordinateSequence);
                if (!Math.INSTANCE.isNaN(coordinateSequence.getM(i))) {
                    EnumSetKt.add(this.outputOrdinates, (Enum)Ordinate.M);
                }
            }
        }

        @Override
        public boolean isGeometryChanged() {
            return false;
        }

        @Override
        public boolean isDone() {
            return Intrinsics.areEqual(this.outputOrdinates, this.checkOrdinateFlags);
        }

        @NotNull
        public final EnumSet<Ordinate> getOutputOrdinates() {
            return this.outputOrdinates;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007J\u001b\u0010\b\u001a\u00020\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\u0007\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0007J\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0007J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0015H\u0002J\u0018\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u0018H\u0002R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/locationtech/jts/io/WKTWriter$Companion;", "", "<init>", "()V", "toPoint", "", "p0", "Lorg/locationtech/jts/geom/Coordinate;", "toLineString", "seq", "Lorg/locationtech/jts/geom/CoordinateSequence;", "coord", "", "([Lorg/locationtech/jts/geom/Coordinate;)Ljava/lang/String;", "p1", "format", "p", "x", "", "y", "INDENT", "", "OUTPUT_DIMENSION", "createFormatter", "Lorg/locationtech/jts/io/OrdinateFormat;", "precisionModel", "Lorg/locationtech/jts/geom/PrecisionModel;", "stringOfChar", "ch", "", "count", "writeNumber", "d", "formatter", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String toPoint(@NotNull Coordinate p0) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            return "POINT ( " + this.format(p0) + " )";
        }

        @JvmStatic
        @NotNull
        public final String toLineString(@NotNull CoordinateSequence seq) {
            Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
            StringBuilder buf = new StringBuilder();
            buf.append("LINESTRING");
            buf.append(" ");
            if (seq.size() == 0) {
                v0 = buf.append("EMPTY");
            } else {
                buf.append("(");
                int n = seq.size();
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    buf.append(this.format(seq.getX(i), seq.getY(i)));
                }
                v0 = buf.append(")");
            }
            String string = buf.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @JvmStatic
        @NotNull
        public final String toLineString(@NotNull Coordinate[] coord) {
            Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
            StringBuilder buf = new StringBuilder();
            buf.append("LINESTRING");
            buf.append(" ");
            if (coord.length == 0) {
                v0 = buf.append("EMPTY");
            } else {
                buf.append("(");
                int n = coord.length;
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    buf.append(this.format(coord[i]));
                }
                v0 = buf.append(")");
            }
            String string = buf.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        @JvmStatic
        @NotNull
        public final String toLineString(@NotNull Coordinate p0, @NotNull Coordinate p1) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            return "LINESTRING ( " + this.format(p0) + ", " + this.format(p1) + " )";
        }

        @NotNull
        public final String format(@NotNull Coordinate p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return this.format(p.x, p.y);
        }

        private final String format(double x, double y) {
            return OrdinateFormat.DEFAULT.format(x) + " " + OrdinateFormat.DEFAULT.format(y);
        }

        private final OrdinateFormat createFormatter(PrecisionModel precisionModel) {
            return OrdinateFormat.Companion.create(precisionModel.getMaximumSignificantDigits());
        }

        private final String stringOfChar(char ch, int count) {
            StringBuilder buf = new StringBuilder(count);
            for (int i = 0; i < count; ++i) {
                buf.append(ch);
            }
            String string = buf.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final String writeNumber(double d, OrdinateFormat formatter) {
            return formatter.format(d);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

