/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.linearref;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Lineal;
import org.locationtech.jts.linearref.LinearGeometryBuilder;
import org.locationtech.jts.linearref.LinearIterator;
import org.locationtech.jts.linearref.LinearLocation;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u0018\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/locationtech/jts/linearref/ExtractLineByLocation;", "", "line", "Lorg/locationtech/jts/geom/Geometry;", "<init>", "(Lorg/locationtech/jts/geom/Geometry;)V", "extract", "start", "Lorg/locationtech/jts/linearref/LinearLocation;", "end", "reverse", "linear", "computeLine", "Lorg/locationtech/jts/geom/LineString;", "computeLinear", "Companion", "kts-core"})
public final class ExtractLineByLocation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Geometry line;

    public ExtractLineByLocation(@NotNull Geometry line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        this.line = line;
    }

    @Nullable
    public final Geometry extract(@NotNull LinearLocation start, @NotNull LinearLocation end) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        return end.compareTo(start) < 0 ? this.reverse(this.computeLinear(end, start)) : this.computeLinear(start, end);
    }

    private final Geometry reverse(Geometry linear) {
        if (linear instanceof Lineal) {
            return linear.reverse();
        }
        Assert.shouldNeverReachHere("non-linear geometry encountered");
        return null;
    }

    private final LineString computeLine(LinearLocation start, LinearLocation end) {
        Coordinate[] newCoordinateArray;
        int n;
        int i;
        Coordinate[] coordinates = this.line.getCoordinates();
        CoordinateList newCoordinates = new CoordinateList();
        int startSegmentIndex = start.getSegmentIndex();
        if (start.getSegmentFraction() > 0.0) {
            ++startSegmentIndex;
        }
        int lastSegmentIndex = end.getSegmentIndex();
        if (end.getSegmentFraction() == 1.0) {
            ++lastSegmentIndex;
        }
        Intrinsics.checkNotNull((Object)coordinates);
        if (lastSegmentIndex >= coordinates.length) {
            lastSegmentIndex = coordinates.length - 1;
        }
        if (!start.isVertex()) {
            newCoordinates.add(start.getCoordinate(this.line));
        }
        if ((i = startSegmentIndex) <= (n = lastSegmentIndex)) {
            while (true) {
                newCoordinates.add(coordinates[i]);
                if (i == n) break;
                ++i;
            }
        }
        if (!end.isVertex()) {
            newCoordinates.add(end.getCoordinate(this.line));
        }
        if (newCoordinates.size() <= 0) {
            newCoordinates.add(start.getCoordinate(this.line));
        }
        if ((newCoordinateArray = newCoordinates.toCoordinateArray()).length <= 1) {
            Coordinate[] coordinateArray = new Coordinate[]{newCoordinateArray[0], newCoordinateArray[0]};
            newCoordinateArray = coordinateArray;
        }
        return this.line.getFactory().createLineString(newCoordinateArray);
    }

    private final Geometry computeLinear(LinearLocation start, LinearLocation end) {
        LinearGeometryBuilder builder = new LinearGeometryBuilder(this.line.getFactory());
        builder.setFixInvalidLines(true);
        if (!start.isVertex()) {
            LinearGeometryBuilder.add$default(builder, start.getCoordinate(this.line), false, 2, null);
        }
        LinearIterator it = new LinearIterator(this.line, start);
        while (it.hasNext()) {
            if (end.compareLocationValues(it.getComponentIndex(), it.getVertexIndex(), 0.0) < 0) break;
            Coordinate pt = it.getSegmentStart();
            LinearGeometryBuilder.add$default(builder, pt, false, 2, null);
            if (it.isEndOfLine()) {
                builder.endLine();
            }
            it.next();
        }
        if (!end.isVertex()) {
            LinearGeometryBuilder.add$default(builder, end.getCoordinate(this.line), false, 2, null);
        }
        return builder.getGeometry();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u00a8\u0006\n"}, d2={"Lorg/locationtech/jts/linearref/ExtractLineByLocation$Companion;", "", "<init>", "()V", "extract", "Lorg/locationtech/jts/geom/Geometry;", "line", "start", "Lorg/locationtech/jts/linearref/LinearLocation;", "end", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Geometry extract(@NotNull Geometry line, @NotNull LinearLocation start, @NotNull LinearLocation end) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            ExtractLineByLocation ls = new ExtractLineByLocation(line);
            return ls.extract(start, end);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

