/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.SegmentIntersector;
import org.locationtech.jts.noding.SegmentString;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 .2\u00020\u0001:\u0001.B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010!\u001a\u00020\tJ\u0006\u0010\"\u001a\u00020\tJ\u0006\u0010#\u001a\u00020\tJ(\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020\u0013H\u0002J(\u0010*\u001a\u00020+2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\u001a\u0010\u001b\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0015\"\u0004\b\u001d\u0010\u0017R\u001a\u0010\u001e\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0015\"\u0004\b \u0010\u0017R\u0014\u0010,\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u0006/"}, d2={"Lorg/locationtech/jts/noding/IntersectionAdder;", "Lorg/locationtech/jts/noding/SegmentIntersector;", "lineIntersector", "Lorg/locationtech/jts/algorithm/LineIntersector;", "<init>", "(Lorg/locationtech/jts/algorithm/LineIntersector;)V", "getLineIntersector", "()Lorg/locationtech/jts/algorithm/LineIntersector;", "hasIntersection", "", "hasProper", "hasProperInterior", "hasInterior", "properIntersectionPoint", "Lorg/locationtech/jts/geom/Coordinate;", "getProperIntersectionPoint", "()Lorg/locationtech/jts/geom/Coordinate;", "isSelfIntersection", "numIntersections", "", "getNumIntersections", "()I", "setNumIntersections", "(I)V", "numInteriorIntersections", "getNumInteriorIntersections", "setNumInteriorIntersections", "numProperIntersections", "getNumProperIntersections", "setNumProperIntersections", "numTests", "getNumTests", "setNumTests", "hasProperIntersection", "hasProperInteriorIntersection", "hasInteriorIntersection", "isTrivialIntersection", "e0", "Lorg/locationtech/jts/noding/SegmentString;", "segIndex0", "e1", "segIndex1", "processIntersections", "", "isDone", "()Z", "Companion", "kts-core"})
public final class IntersectionAdder
implements SegmentIntersector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LineIntersector lineIntersector;
    private boolean hasIntersection;
    private boolean hasProper;
    private boolean hasProperInterior;
    private boolean hasInterior;
    @Nullable
    private final Coordinate properIntersectionPoint;
    private final boolean isSelfIntersection;
    private int numIntersections;
    private int numInteriorIntersections;
    private int numProperIntersections;
    private int numTests;

    public IntersectionAdder(@NotNull LineIntersector lineIntersector) {
        Intrinsics.checkNotNullParameter((Object)lineIntersector, (String)"lineIntersector");
        this.lineIntersector = lineIntersector;
    }

    @NotNull
    public final LineIntersector getLineIntersector() {
        return this.lineIntersector;
    }

    @Nullable
    public final Coordinate getProperIntersectionPoint() {
        return this.properIntersectionPoint;
    }

    public final int getNumIntersections() {
        return this.numIntersections;
    }

    public final void setNumIntersections(int n) {
        this.numIntersections = n;
    }

    public final int getNumInteriorIntersections() {
        return this.numInteriorIntersections;
    }

    public final void setNumInteriorIntersections(int n) {
        this.numInteriorIntersections = n;
    }

    public final int getNumProperIntersections() {
        return this.numProperIntersections;
    }

    public final void setNumProperIntersections(int n) {
        this.numProperIntersections = n;
    }

    public final int getNumTests() {
        return this.numTests;
    }

    public final void setNumTests(int n) {
        this.numTests = n;
    }

    public final boolean hasIntersection() {
        return this.hasIntersection;
    }

    public final boolean hasProperIntersection() {
        return this.hasProper;
    }

    public final boolean hasProperInteriorIntersection() {
        return this.hasProperInterior;
    }

    public final boolean hasInteriorIntersection() {
        return this.hasInterior;
    }

    private final boolean isTrivialIntersection(SegmentString e0, int segIndex0, SegmentString e1, int segIndex1) {
        if (e0 == e1 && this.lineIntersector.getIntersectionNum() == 1) {
            if (Companion.isAdjacentSegments(segIndex0, segIndex1)) {
                return true;
            }
            if (e0.isClosed()) {
                int maxSegIndex = e0.size() - 1;
                if (segIndex0 == 0 && segIndex1 == maxSegIndex || segIndex1 == 0 && segIndex0 == maxSegIndex) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void processIntersections(@NotNull SegmentString e0, int segIndex0, @NotNull SegmentString e1, int segIndex1) {
        Intrinsics.checkNotNullParameter((Object)e0, (String)"e0");
        Intrinsics.checkNotNullParameter((Object)e1, (String)"e1");
        if (e0 == e1 && segIndex0 == segIndex1) {
            return;
        }
        int n = this.numTests;
        this.numTests = n + 1;
        Coordinate p00 = e0.getCoordinate(segIndex0);
        Coordinate p01 = e0.getCoordinate(segIndex0 + 1);
        Coordinate p10 = e1.getCoordinate(segIndex1);
        Coordinate p11 = e1.getCoordinate(segIndex1 + 1);
        this.lineIntersector.computeIntersection(p00, p01, p10, p11);
        if (this.lineIntersector.hasIntersection()) {
            int n2 = this.numIntersections;
            this.numIntersections = n2 + 1;
            if (this.lineIntersector.isInteriorIntersection()) {
                n2 = this.numInteriorIntersections;
                this.numInteriorIntersections = n2 + 1;
                this.hasInterior = true;
            }
            if (!this.isTrivialIntersection(e0, segIndex0, e1, segIndex1)) {
                this.hasIntersection = true;
                ((NodedSegmentString)e0).addIntersections(this.lineIntersector, segIndex0, 0);
                ((NodedSegmentString)e1).addIntersections(this.lineIntersector, segIndex1, 1);
                if (this.lineIntersector.isProper()) {
                    n2 = this.numProperIntersections;
                    this.numProperIntersections = n2 + 1;
                    this.hasProper = true;
                    this.hasProperInterior = true;
                }
            }
        }
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lorg/locationtech/jts/noding/IntersectionAdder$Companion;", "", "<init>", "()V", "isAdjacentSegments", "", "i1", "", "i2", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isAdjacentSegments(int i1, int i2) {
            return Math.INSTANCE.abs(i1 - i2) == 1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

