/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.chain.MonotoneChain;
import org.locationtech.jts.index.chain.MonotoneChainBuilder;
import org.locationtech.jts.index.chain.MonotoneChainOverlapAction;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.SegmentIntersector;
import org.locationtech.jts.noding.SegmentString;
import org.locationtech.jts.noding.SinglePassNoder;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001#B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0013\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006B\u001b\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0002\u0010\tJ\u0016\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0014H\u0016J\b\u0010 \u001a\u00020\u001eH\u0002J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u001aH\u0002R\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006$"}, d2={"Lorg/locationtech/jts/noding/MCIndexNoder;", "Lorg/locationtech/jts/noding/SinglePassNoder;", "<init>", "()V", "si", "Lorg/locationtech/jts/noding/SegmentIntersector;", "(Lorg/locationtech/jts/noding/SegmentIntersector;)V", "overlapTolerance", "", "(Lorg/locationtech/jts/noding/SegmentIntersector;D)V", "monoChains", "", "", "index", "Lorg/locationtech/jts/index/SpatialIndex;", "getIndex", "()Lorg/locationtech/jts/index/SpatialIndex;", "idCounter", "", "nodedSegStrings", "", "nOverlaps", "monotoneChains", "getMonotoneChains", "()Ljava/util/List;", "nodedSubstrings", "Lorg/locationtech/jts/noding/SegmentString;", "getNodedSubstrings", "()Ljava/util/Collection;", "computeNodes", "", "inputSegStrings", "intersectChains", "add", "segStr", "SegmentOverlapAction", "kts-core"})
public final class MCIndexNoder
extends SinglePassNoder {
    @NotNull
    private final List<Object> monoChains = new ArrayList();
    @NotNull
    private final SpatialIndex index = new STRtree();
    private int idCounter;
    @Nullable
    private Collection<?> nodedSegStrings;
    private int nOverlaps;
    private double overlapTolerance;

    @NotNull
    public final SpatialIndex getIndex() {
        return this.index;
    }

    public MCIndexNoder() {
    }

    public MCIndexNoder(@Nullable SegmentIntersector si) {
        super(si);
    }

    public MCIndexNoder(@Nullable SegmentIntersector si, double overlapTolerance) {
        super(si);
        this.overlapTolerance = overlapTolerance;
    }

    @NotNull
    public final List<?> getMonotoneChains() {
        return this.monoChains;
    }

    @Override
    @NotNull
    public Collection<SegmentString> getNodedSubstrings() {
        return NodedSegmentString.Companion.getNodedSubstrings(this.nodedSegStrings);
    }

    @Override
    public void computeNodes(@NotNull Collection<? extends SegmentString> inputSegStrings) {
        Intrinsics.checkNotNullParameter(inputSegStrings, (String)"inputSegStrings");
        this.nodedSegStrings = inputSegStrings;
        Iterator<? extends SegmentString> i = inputSegStrings.iterator();
        while (i.hasNext()) {
            this.add(i.next());
        }
        this.intersectChains();
    }

    private final void intersectChains() {
        MonotoneChainOverlapAction overlapAction = new SegmentOverlapAction(this.getSegInt());
        for (Object object : this.monoChains) {
            List<?> overlapChains;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.locationtech.jts.index.chain.MonotoneChain");
            MonotoneChain queryChain = (MonotoneChain)object;
            Envelope queryEnv = queryChain.getEnvelope(this.overlapTolerance);
            List<?> list = overlapChains = this.index.query(queryEnv);
            Intrinsics.checkNotNull(list);
            for (Object obj : list) {
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.index.chain.MonotoneChain");
                MonotoneChain testChain = (MonotoneChain)obj;
                if (testChain.getId() > queryChain.getId()) {
                    queryChain.computeOverlaps(testChain, this.overlapTolerance, overlapAction);
                    int n = this.nOverlaps;
                    this.nOverlaps = n + 1;
                }
                SegmentIntersector segmentIntersector = this.getSegInt();
                Intrinsics.checkNotNull((Object)segmentIntersector);
                if (!segmentIntersector.isDone()) continue;
                return;
            }
        }
    }

    private final void add(SegmentString segStr) {
        List<MonotoneChain> segChains = MonotoneChainBuilder.getChains(segStr.getCoordinates(), segStr);
        Iterator<MonotoneChain> i = segChains.iterator();
        while (i.hasNext()) {
            MonotoneChain mc;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.index.chain.MonotoneChain");
            int n = this.idCounter;
            this.idCounter = n + 1;
            mc.setId(n);
            this.index.insert(mc.getEnvelope(this.overlapTolerance), mc);
            this.monoChains.add(mc);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000bH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/locationtech/jts/noding/MCIndexNoder$SegmentOverlapAction;", "Lorg/locationtech/jts/index/chain/MonotoneChainOverlapAction;", "si", "Lorg/locationtech/jts/noding/SegmentIntersector;", "<init>", "(Lorg/locationtech/jts/noding/SegmentIntersector;)V", "overlap", "", "mc1", "Lorg/locationtech/jts/index/chain/MonotoneChain;", "start1", "", "mc2", "start2", "kts-core"})
    public static final class SegmentOverlapAction
    extends MonotoneChainOverlapAction {
        @Nullable
        private final SegmentIntersector si;

        public SegmentOverlapAction(@Nullable SegmentIntersector si) {
            this.si = si;
        }

        @Override
        public void overlap(@NotNull MonotoneChain mc1, int start1, @NotNull MonotoneChain mc2, int start2) {
            Intrinsics.checkNotNullParameter((Object)mc1, (String)"mc1");
            Intrinsics.checkNotNullParameter((Object)mc2, (String)"mc2");
            SegmentString ss1 = (SegmentString)mc1.getContext();
            SegmentString ss2 = (SegmentString)mc2.getContext();
            SegmentIntersector segmentIntersector = this.si;
            Intrinsics.checkNotNull((Object)segmentIntersector);
            SegmentString segmentString = ss1;
            Intrinsics.checkNotNull((Object)segmentString);
            SegmentString segmentString2 = ss2;
            Intrinsics.checkNotNull((Object)segmentString2);
            segmentIntersector.processIntersections(segmentString, start1, segmentString2, start2);
        }
    }
}

