/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding.snapround;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.util.LinearComponentExtracter;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.Noder;
import org.locationtech.jts.noding.NodingValidator;
import org.locationtech.jts.noding.SegmentString;
import org.locationtech.jts.noding.snapround.SnapRoundingNoder;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010J\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\r2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\r2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/locationtech/jts/noding/snapround/GeometryNoder;", "", "pm", "Lorg/locationtech/jts/geom/PrecisionModel;", "<init>", "(Lorg/locationtech/jts/geom/PrecisionModel;)V", "geomFact", "Lorg/locationtech/jts/geom/GeometryFactory;", "isValidityChecked", "", "setValidate", "", "node", "", "Lorg/locationtech/jts/geom/LineString;", "geoms", "", "toLineStrings", "segStrings", "extractLines", "Lorg/locationtech/jts/geom/Geometry;", "toSegmentStrings", "Lorg/locationtech/jts/noding/SegmentString;", "lines", "kts-core"})
public final class GeometryNoder {
    @NotNull
    private final PrecisionModel pm;
    @Nullable
    private GeometryFactory geomFact;
    private boolean isValidityChecked;

    public GeometryNoder(@NotNull PrecisionModel pm) {
        Intrinsics.checkNotNullParameter((Object)pm, (String)"pm");
        this.pm = pm;
    }

    public final void setValidate(boolean isValidityChecked) {
        this.isValidityChecked = isValidityChecked;
    }

    @NotNull
    public final List<LineString> node(@NotNull Collection<?> geoms) {
        Intrinsics.checkNotNullParameter(geoms, (String)"geoms");
        Object obj = geoms.iterator().next();
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Geometry");
        Geometry geom0 = (Geometry)obj;
        this.geomFact = geom0.getFactory();
        List<SegmentString> segStrings = this.toSegmentStrings((Collection)this.extractLines(geoms));
        Noder sr = new SnapRoundingNoder(this.pm);
        sr.computeNodes((Collection<? extends SegmentString>)segStrings);
        Collection<SegmentString> collection = sr.getNodedSubstrings();
        Intrinsics.checkNotNull(collection);
        Collection<SegmentString> nodedLines = collection;
        if (this.isValidityChecked) {
            NodingValidator nv = new NodingValidator(nodedLines);
            nv.checkValid();
        }
        return this.toLineStrings(nodedLines);
    }

    private final List<LineString> toLineStrings(Collection<?> segStrings) {
        List lines = new ArrayList();
        for (Object obj : segStrings) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.noding.SegmentString");
            SegmentString ss = (SegmentString)obj;
            if (ss.size() < 2) continue;
            GeometryFactory geometryFactory = this.geomFact;
            Intrinsics.checkNotNull((Object)geometryFactory);
            lines.add(geometryFactory.createLineString(ss.getCoordinates()));
        }
        return lines;
    }

    private final List<Geometry> extractLines(Collection<?> geoms) {
        List lines = new ArrayList();
        LinearComponentExtracter lce = new LinearComponentExtracter(lines);
        for (Object obj : geoms) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Geometry");
            Geometry geom = (Geometry)obj;
            geom.apply(lce);
        }
        return lines;
    }

    private final List<SegmentString> toSegmentStrings(Collection<?> lines) {
        List segStrings = new ArrayList();
        for (Object obj : lines) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
            LineString line = (LineString)obj;
            segStrings.add(new NodedSegmentString(line.getCoordinates(), null));
        }
        return segStrings;
    }
}

