/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding.snapround;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.index.kdtree.KdNode;
import org.locationtech.jts.index.kdtree.KdNodeVisitor;
import org.locationtech.jts.noding.MCIndexNoder;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.Noder;
import org.locationtech.jts.noding.SegmentString;
import org.locationtech.jts.noding.snapround.HotPixel;
import org.locationtech.jts.noding.snapround.HotPixelIndex;
import org.locationtech.jts.noding.snapround.SnapRoundingIntersectionAdder;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 '2\u00020\u0001:\u0001'B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0002J\u0016\u0010\u0015\u001a\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0002J\u0016\u0010\u0016\u001a\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J!\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u001aH\u0002\u00a2\u0006\u0002\u0010\u001cJ\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001f\u001a\u00020\nH\u0002J(\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\nH\u0002J \u0010&\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010#\u001a\u00020$H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006("}, d2={"Lorg/locationtech/jts/noding/snapround/SnapRoundingNoder;", "Lorg/locationtech/jts/noding/Noder;", "pm", "Lorg/locationtech/jts/geom/PrecisionModel;", "<init>", "(Lorg/locationtech/jts/geom/PrecisionModel;)V", "pixelIndex", "Lorg/locationtech/jts/noding/snapround/HotPixelIndex;", "snappedResult", "", "Lorg/locationtech/jts/noding/NodedSegmentString;", "nodedSubstrings", "", "Lorg/locationtech/jts/noding/SegmentString;", "getNodedSubstrings", "()Ljava/util/Collection;", "computeNodes", "", "inputSegmentStrings", "snapRound", "segStrings", "addIntersectionPixels", "addVertexPixels", "round", "Lorg/locationtech/jts/geom/Coordinate;", "pt", "", "pts", "([Lorg/locationtech/jts/geom/Coordinate;)[Lorg/locationtech/jts/geom/Coordinate;", "computeSnaps", "computeSegmentSnaps", "ss", "snapSegment", "p0", "p1", "segIndex", "", "addVertexNodeSnaps", "snapVertexNode", "Companion", "kts-core"})
public final class SnapRoundingNoder
implements Noder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PrecisionModel pm;
    @NotNull
    private final HotPixelIndex pixelIndex;
    @Nullable
    private List<NodedSegmentString> snappedResult;
    private static final int NEARNESS_FACTOR = 100;

    public SnapRoundingNoder(@NotNull PrecisionModel pm) {
        Intrinsics.checkNotNullParameter((Object)pm, (String)"pm");
        this.pm = pm;
        this.pixelIndex = new HotPixelIndex(this.pm);
    }

    @Override
    @NotNull
    public Collection<SegmentString> getNodedSubstrings() {
        return NodedSegmentString.Companion.getNodedSubstrings((Collection)this.snappedResult);
    }

    @Override
    public void computeNodes(@NotNull Collection<? extends SegmentString> inputSegmentStrings) {
        Intrinsics.checkNotNullParameter(inputSegmentStrings, (String)"inputSegmentStrings");
        this.snappedResult = this.snapRound(inputSegmentStrings);
    }

    private final List<NodedSegmentString> snapRound(Collection<NodedSegmentString> segStrings) {
        this.addIntersectionPixels(segStrings);
        this.addVertexPixels(segStrings);
        return this.computeSnaps(segStrings);
    }

    private final void addIntersectionPixels(Collection<NodedSegmentString> segStrings) {
        double snapGridSize = 1.0 / this.pm.getScale();
        double nearnessTol = snapGridSize / (double)100;
        SnapRoundingIntersectionAdder intAdder = new SnapRoundingIntersectionAdder(nearnessTol);
        MCIndexNoder noder = new MCIndexNoder(intAdder, nearnessTol);
        noder.computeNodes(segStrings);
        List<Coordinate> intPts = intAdder.getIntersections();
        this.pixelIndex.addNodes(intPts);
    }

    private final void addVertexPixels(Collection<NodedSegmentString> segStrings) {
        for (NodedSegmentString nss : segStrings) {
            Coordinate[] pts = nss.getCoordinates();
            this.pixelIndex.add(pts);
        }
    }

    private final Coordinate round(Coordinate pt) {
        Coordinate p2 = pt.copy();
        this.pm.makePrecise(p2);
        return p2;
    }

    private final Coordinate[] round(Coordinate[] pts) {
        CoordinateList roundPts = new CoordinateList();
        int n = pts.length;
        for (int i = 0; i < n; ++i) {
            roundPts.add(this.round(pts[i]), false);
        }
        return roundPts.toCoordinateArray();
    }

    private final List<NodedSegmentString> computeSnaps(Collection<NodedSegmentString> segStrings) {
        List snapped = new ArrayList();
        for (NodedSegmentString ss : segStrings) {
            NodedSegmentString snappedSS = this.computeSegmentSnaps(ss);
            if (snappedSS == null) continue;
            snapped.add(snappedSS);
        }
        for (NodedSegmentString ss : snapped) {
            this.addVertexNodeSnaps(ss);
        }
        return snapped;
    }

    private final NodedSegmentString computeSegmentSnaps(NodedSegmentString ss) {
        Coordinate[] pts = ss.getNodedCoordinates();
        Coordinate[] ptsRound = this.round(pts);
        if (ptsRound.length <= 1) {
            return null;
        }
        NodedSegmentString snapSS = new NodedSegmentString(ptsRound, ss.getData());
        int snapSSindex = 0;
        int n = pts.length - 1;
        for (int i = 0; i < n; ++i) {
            Coordinate currSnap = snapSS.getCoordinate(snapSSindex);
            Coordinate p1 = pts[i + 1];
            Coordinate p1Round = this.round(p1);
            if (p1Round.equals2D(currSnap)) continue;
            Coordinate p0 = pts[i];
            this.snapSegment(p0, p1, snapSS, snapSSindex);
            ++snapSSindex;
        }
        return snapSS;
    }

    private final void snapSegment(Coordinate p0, Coordinate p1, NodedSegmentString ss, int segIndex) {
        this.pixelIndex.query(p0, p1, new KdNodeVisitor(p0, p1, ss, segIndex){
            final /* synthetic */ Coordinate $p0;
            final /* synthetic */ Coordinate $p1;
            final /* synthetic */ NodedSegmentString $ss;
            final /* synthetic */ int $segIndex;
            {
                this.$p0 = $p0;
                this.$p1 = $p1;
                this.$ss = $ss;
                this.$segIndex = $segIndex;
            }

            public void visit(KdNode node) {
                KdNode kdNode = node;
                Intrinsics.checkNotNull((Object)kdNode);
                Object object = kdNode.getData();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.locationtech.jts.noding.snapround.HotPixel");
                HotPixel hp = (HotPixel)object;
                if (!hp.isNode() && (hp.intersects(this.$p0) || hp.intersects(this.$p1))) {
                    return;
                }
                if (hp.intersects(this.$p0, this.$p1)) {
                    this.$ss.addIntersection(hp.getCoordinate(), this.$segIndex);
                    hp.setToNode();
                }
            }
        });
    }

    private final void addVertexNodeSnaps(NodedSegmentString ss) {
        Coordinate[] pts = ss.getCoordinates();
        int n = pts.length - 1;
        for (int i = 1; i < n; ++i) {
            Coordinate p0 = pts[i];
            this.snapVertexNode(p0, ss, i);
        }
    }

    private final void snapVertexNode(Coordinate p0, NodedSegmentString ss, int segIndex) {
        this.pixelIndex.query(p0, p0, new KdNodeVisitor(p0, ss, segIndex){
            final /* synthetic */ Coordinate $p0;
            final /* synthetic */ NodedSegmentString $ss;
            final /* synthetic */ int $segIndex;
            {
                this.$p0 = $p0;
                this.$ss = $ss;
                this.$segIndex = $segIndex;
            }

            public void visit(KdNode node) {
                KdNode kdNode = node;
                Intrinsics.checkNotNull((Object)kdNode);
                Object object = kdNode.getData();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.locationtech.jts.noding.snapround.HotPixel");
                HotPixel hp = (HotPixel)object;
                if (hp.isNode() && hp.getCoordinate().equals2D(this.$p0)) {
                    this.$ss.addIntersection(this.$p0, this.$segIndex);
                }
            }
        });
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/locationtech/jts/noding/snapround/SnapRoundingNoder$Companion;", "", "<init>", "()V", "NEARNESS_FACTOR", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

