/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.BoundaryNodeRule;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geomgraph.GeometryGraph;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B%\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\tJ\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001d\u001a\u00020\u001eJ\u0012\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u000fH\u0004R\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\"\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001b\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006\""}, d2={"Lorg/locationtech/jts/operation/GeometryGraphOperation;", "", "g0", "Lorg/locationtech/jts/geom/Geometry;", "g1", "boundaryNodeRule", "Lorg/locationtech/jts/algorithm/BoundaryNodeRule;", "<init>", "(Lorg/locationtech/jts/geom/Geometry;Lorg/locationtech/jts/geom/Geometry;Lorg/locationtech/jts/algorithm/BoundaryNodeRule;)V", "(Lorg/locationtech/jts/geom/Geometry;)V", "li", "Lorg/locationtech/jts/algorithm/LineIntersector;", "getLi", "()Lorg/locationtech/jts/algorithm/LineIntersector;", "resultPrecisionModel", "Lorg/locationtech/jts/geom/PrecisionModel;", "getResultPrecisionModel", "()Lorg/locationtech/jts/geom/PrecisionModel;", "setResultPrecisionModel", "(Lorg/locationtech/jts/geom/PrecisionModel;)V", "arg", "", "Lorg/locationtech/jts/geomgraph/GeometryGraph;", "getArg", "()[Lorg/locationtech/jts/geomgraph/GeometryGraph;", "setArg", "([Lorg/locationtech/jts/geomgraph/GeometryGraph;)V", "[Lorg/locationtech/jts/geomgraph/GeometryGraph;", "getArgGeometry", "i", "", "setComputationPrecision", "", "pm", "kts-core"})
public class GeometryGraphOperation {
    @NotNull
    private final LineIntersector li;
    @Nullable
    private PrecisionModel resultPrecisionModel;
    @NotNull
    private GeometryGraph[] arg;

    @NotNull
    protected final LineIntersector getLi() {
        return this.li;
    }

    @Nullable
    protected final PrecisionModel getResultPrecisionModel() {
        return this.resultPrecisionModel;
    }

    protected final void setResultPrecisionModel(@Nullable PrecisionModel precisionModel) {
        this.resultPrecisionModel = precisionModel;
    }

    @NotNull
    protected final GeometryGraph[] getArg() {
        return this.arg;
    }

    protected final void setArg(@NotNull GeometryGraph[] geometryGraphArray) {
        Intrinsics.checkNotNullParameter((Object)geometryGraphArray, (String)"<set-?>");
        this.arg = geometryGraphArray;
    }

    @JvmOverloads
    public GeometryGraphOperation(@NotNull Geometry g0, @NotNull Geometry g1, @Nullable BoundaryNodeRule boundaryNodeRule) {
        Intrinsics.checkNotNullParameter((Object)g0, (String)"g0");
        Intrinsics.checkNotNullParameter((Object)g1, (String)"g1");
        this.li = new RobustLineIntersector();
        if (g0.getPrecisionModel().compareTo(g1.getPrecisionModel()) >= 0) {
            this.setComputationPrecision(g0.getPrecisionModel());
        } else {
            this.setComputationPrecision(g1.getPrecisionModel());
        }
        GeometryGraph[] geometryGraphArray = new GeometryGraph[]{new GeometryGraph(0, g0, boundaryNodeRule), new GeometryGraph(1, g1, boundaryNodeRule)};
        this.arg = geometryGraphArray;
    }

    public /* synthetic */ GeometryGraphOperation(Geometry geometry, Geometry geometry2, BoundaryNodeRule boundaryNodeRule, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            boundaryNodeRule = BoundaryNodeRule.OGC_SFS_BOUNDARY_RULE;
        }
        this(geometry, geometry2, boundaryNodeRule);
    }

    public GeometryGraphOperation(@NotNull Geometry g0) {
        Intrinsics.checkNotNullParameter((Object)g0, (String)"g0");
        this.li = new RobustLineIntersector();
        this.setComputationPrecision(g0.getPrecisionModel());
        GeometryGraph[] geometryGraphArray = new GeometryGraph[]{new GeometryGraph(0, g0, null, 4, null)};
        this.arg = geometryGraphArray;
    }

    @Nullable
    public final Geometry getArgGeometry(int i) {
        return this.arg[i].getGeometry();
    }

    protected final void setComputationPrecision(@Nullable PrecisionModel pm) {
        this.resultPrecisionModel = pm;
        this.li.setPrecisionModel(this.resultPrecisionModel);
    }

    @JvmOverloads
    public GeometryGraphOperation(@NotNull Geometry g0, @NotNull Geometry g1) {
        Intrinsics.checkNotNullParameter((Object)g0, (String)"g0");
        Intrinsics.checkNotNullParameter((Object)g1, (String)"g1");
        this(g0, g1, null, 4, null);
    }
}

