/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.linemerge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.legacy.TreeSet;
import org.locationtech.jts.operation.linemerge.LineMergeEdge;
import org.locationtech.jts.operation.linemerge.LineMergeGraph;
import org.locationtech.jts.planargraph.DirectedEdge;
import org.locationtech.jts.planargraph.Edge;
import org.locationtech.jts.planargraph.GraphComponent;
import org.locationtech.jts.planargraph.Node;
import org.locationtech.jts.planargraph.Subgraph;
import org.locationtech.jts.planargraph.algorithm.ConnectedSubgraphFinder;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010+\n\u0002\b\b\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\rJ\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0006\u0010\u000e\u001a\u00020\u000bJ\b\u0010\u001a\u001a\u00020\u0010H\u0002J\u0016\u0010\u001b\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d\u0018\u00010\u001cH\u0002J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020 H\u0002J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u0010\u0004\u001a\u00020 H\u0002J&\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u001e2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001e0%2\u0006\u0010&\u001a\u00020\u000bH\u0002J\u001c\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001c2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001cH\u0002J\u001c\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001c2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001cH\u0002J\u001c\u0010*\u001a\u00020\r2\u0012\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u001cH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006-"}, d2={"Lorg/locationtech/jts/operation/linemerge/LineSequencer;", "", "<init>", "()V", "graph", "Lorg/locationtech/jts/operation/linemerge/LineMergeGraph;", "factory", "Lorg/locationtech/jts/geom/GeometryFactory;", "lineCount", "", "isRun", "", "sequencedGeometry", "Lorg/locationtech/jts/geom/Geometry;", "isSequenceable", "add", "", "geometries", "", "geometry", "addLine", "lineString", "Lorg/locationtech/jts/geom/LineString;", "sequencedLineStrings", "getSequencedLineStrings", "()Lorg/locationtech/jts/geom/Geometry;", "computeSequence", "findSequences", "", "", "Lorg/locationtech/jts/planargraph/DirectedEdge;", "hasSequence", "Lorg/locationtech/jts/planargraph/Subgraph;", "findSequence", "addReverseSubpath", "de", "lit", "", "expectedClosed", "orient", "seq", "reverse", "buildSequencedGeometry", "sequences", "Companion", "kts-core"})
public final class LineSequencer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LineMergeGraph graph = new LineMergeGraph();
    @Nullable
    private GeometryFactory factory = new GeometryFactory();
    private int lineCount;
    private boolean isRun;
    @Nullable
    private Geometry sequencedGeometry;
    private boolean isSequenceable;

    public final void add(@NotNull Collection<?> geometries) {
        Intrinsics.checkNotNullParameter(geometries, (String)"geometries");
        for (Object obj : geometries) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Geometry");
            Geometry geometry = (Geometry)obj;
            this.add(geometry);
        }
    }

    public final void add(@NotNull Geometry geometry) {
        Intrinsics.checkNotNullParameter((Object)geometry, (String)"geometry");
        geometry.apply(new GeometryComponentFilter(this){
            final /* synthetic */ LineSequencer this$0;
            {
                this.this$0 = $receiver;
            }

            public void filter(Geometry component) {
                Intrinsics.checkNotNullParameter((Object)component, (String)"component");
                if (component instanceof LineString) {
                    LineSequencer.access$addLine(this.this$0, (LineString)component);
                }
            }
        });
    }

    private final void addLine(LineString lineString) {
        if (this.factory == null) {
            this.factory = lineString.getFactory();
        }
        this.graph.addEdge(lineString);
        int n = this.lineCount;
        this.lineCount = n + 1;
    }

    public final boolean isSequenceable() {
        this.computeSequence();
        return this.isSequenceable;
    }

    @Nullable
    public final Geometry getSequencedLineStrings() {
        this.computeSequence();
        return this.sequencedGeometry;
    }

    private final void computeSequence() {
        if (this.isRun) {
            return;
        }
        this.isRun = true;
        List<List<DirectedEdge>> list = this.findSequences();
        if (list == null) {
            return;
        }
        List<List<DirectedEdge>> sequences = list;
        this.sequencedGeometry = this.buildSequencedGeometry(sequences);
        this.isSequenceable = true;
        Geometry geometry = this.sequencedGeometry;
        Intrinsics.checkNotNull((Object)geometry);
        int finalLineCount = geometry.getNumGeometries();
        Assert.INSTANCE.isTrue(this.lineCount == finalLineCount, "Lines were missing from result");
        Assert.INSTANCE.isTrue(this.sequencedGeometry instanceof LineString || this.sequencedGeometry instanceof MultiLineString, "Result is not lineal");
    }

    private final List<List<DirectedEdge>> findSequences() {
        List sequences = new ArrayList();
        ConnectedSubgraphFinder csFinder = new ConnectedSubgraphFinder(this.graph);
        List<Subgraph> subgraphs = csFinder.getConnectedSubgraphs();
        Iterator<Subgraph> i = subgraphs.iterator();
        while (i.hasNext()) {
            Subgraph subgraph;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.planargraph.Subgraph");
            if (this.hasSequence(subgraph)) {
                List<DirectedEdge> seq = this.findSequence(subgraph);
                sequences.add(seq);
                continue;
            }
            return null;
        }
        return sequences;
    }

    private final boolean hasSequence(Subgraph graph) {
        int oddDegreeCount = 0;
        Iterator<?> i = graph.nodeIterator();
        while (i.hasNext()) {
            Object obj = i.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.planargraph.Node");
            Node node = (Node)obj;
            if (node.getDegree() % 2 != 1) continue;
            ++oddDegreeCount;
        }
        return oddDegreeCount <= 2;
    }

    private final List<DirectedEdge> findSequence(Subgraph graph) {
        Node startNode;
        GraphComponent.Companion.setVisited(graph.edgeIterator(), false);
        Node node = startNode = LineSequencer.Companion.findLowestDegreeNode(graph);
        Intrinsics.checkNotNull((Object)node);
        DirectedEdge startDE = node.getOutEdges().iterator().next();
        DirectedEdge directedEdge = startDE.getSym();
        Intrinsics.checkNotNull((Object)directedEdge);
        DirectedEdge startDESym = directedEdge;
        List seq = new ArrayList();
        ListIterator<DirectedEdge> lit = seq.listIterator();
        this.addReverseSubpath(startDESym, lit, false);
        while (lit.hasPrevious()) {
            DirectedEdge prev = lit.previous();
            DirectedEdge unvisitedOutDE = LineSequencer.Companion.findUnvisitedBestOrientedDE(prev.getFromNode());
            if (unvisitedOutDE == null) continue;
            DirectedEdge directedEdge2 = unvisitedOutDE.getSym();
            Intrinsics.checkNotNull((Object)directedEdge2);
            this.addReverseSubpath(directedEdge2, lit, true);
        }
        return this.orient(seq);
    }

    private final void addReverseSubpath(DirectedEdge de, ListIterator<DirectedEdge> lit, boolean expectedClosed) {
        DirectedEdge de2 = de;
        Node endNode = de2.getToNode();
        Node fromNode = null;
        while (true) {
            DirectedEdge unvisitedOutDE;
            DirectedEdge directedEdge = de2.getSym();
            Intrinsics.checkNotNull((Object)directedEdge);
            lit.add(directedEdge);
            Edge edge = de2.getEdge();
            Intrinsics.checkNotNull((Object)edge);
            edge.setVisited(true);
            fromNode = de2.getFromNode();
            if (LineSequencer.Companion.findUnvisitedBestOrientedDE(fromNode) == null) break;
            Intrinsics.checkNotNull((Object)unvisitedOutDE.getSym());
        }
        if (expectedClosed) {
            Assert.INSTANCE.isTrue(fromNode == endNode, "path not contiguous");
        }
    }

    private final List<DirectedEdge> orient(List<DirectedEdge> seq) {
        boolean hasDegree1Node;
        DirectedEdge startEdge = seq.get(0);
        DirectedEdge endEdge = seq.get(seq.size() - 1);
        Node startNode = startEdge.getFromNode();
        Node endNode = endEdge.getToNode();
        boolean flipSeq = false;
        boolean bl = hasDegree1Node = startNode.getDegree() == 1 || endNode.getDegree() == 1;
        if (hasDegree1Node) {
            boolean hasObviousStartNode = false;
            if (endEdge.getToNode().getDegree() == 1 && !endEdge.getEdgeDirection()) {
                hasObviousStartNode = true;
                flipSeq = true;
            }
            if (startEdge.getFromNode().getDegree() == 1 && startEdge.getEdgeDirection()) {
                hasObviousStartNode = true;
                flipSeq = false;
            }
            if (!hasObviousStartNode && startEdge.getFromNode().getDegree() == 1) {
                flipSeq = true;
            }
        }
        return flipSeq ? this.reverse(seq) : seq;
    }

    private final List<DirectedEdge> reverse(List<DirectedEdge> seq) {
        ArrayList<DirectedEdge> newSeq = new ArrayList<DirectedEdge>();
        Iterator<DirectedEdge> i = seq.iterator();
        while (i.hasNext()) {
            DirectedEdge de;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.planargraph.DirectedEdge");
            DirectedEdge directedEdge = de.getSym();
            Intrinsics.checkNotNull((Object)directedEdge);
            newSeq.add(0, directedEdge);
        }
        return newSeq;
    }

    private final Geometry buildSequencedGeometry(List<List<DirectedEdge>> sequences) {
        Geometry geometry;
        List lines = new ArrayList();
        Iterator<List<DirectedEdge>> i1 = sequences.iterator();
        while (i1.hasNext()) {
            List<DirectedEdge> seq;
            Intrinsics.checkNotNull(i1.next(), (String)"null cannot be cast to non-null type kotlin.collections.List<org.locationtech.jts.planargraph.DirectedEdge>");
            Iterator<DirectedEdge> i2 = seq.iterator();
            while (i2.hasNext()) {
                LineString line;
                DirectedEdge de;
                Intrinsics.checkNotNull((Object)i2.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.planargraph.DirectedEdge");
                Edge edge = de.getEdge();
                Intrinsics.checkNotNull((Object)edge, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.linemerge.LineMergeEdge");
                LineMergeEdge e = (LineMergeEdge)edge;
                LineString lineToAdd = line = e.getLine();
                if (!de.getEdgeDirection() && !line.isClosed()) {
                    lineToAdd = LineSequencer.Companion.reverse(line);
                }
                lines.add(lineToAdd);
            }
        }
        if (lines.size() == 0) {
            GeometryFactory geometryFactory = this.factory;
            Intrinsics.checkNotNull((Object)geometryFactory);
            geometry = geometryFactory.createMultiLineString(new LineString[0]);
        } else {
            GeometryFactory geometryFactory = this.factory;
            Intrinsics.checkNotNull((Object)geometryFactory);
            geometry = geometryFactory.buildGeometry(lines);
        }
        return geometry;
    }

    @JvmStatic
    public static final boolean isSequenced(@Nullable Geometry geom) {
        return Companion.isSequenced(geom);
    }

    public static final /* synthetic */ void access$addLine(LineSequencer $this, LineString lineString) {
        $this.addLine(lineString);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0007J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/locationtech/jts/operation/linemerge/LineSequencer$Companion;", "", "<init>", "()V", "sequence", "Lorg/locationtech/jts/geom/Geometry;", "geom", "isSequenced", "", "findUnvisitedBestOrientedDE", "Lorg/locationtech/jts/planargraph/DirectedEdge;", "node", "Lorg/locationtech/jts/planargraph/Node;", "findLowestDegreeNode", "graph", "Lorg/locationtech/jts/planargraph/Subgraph;", "reverse", "Lorg/locationtech/jts/geom/LineString;", "line", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Geometry sequence(@NotNull Geometry geom) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            LineSequencer sequencer = new LineSequencer();
            sequencer.add(geom);
            return sequencer.getSequencedLineStrings();
        }

        @JvmStatic
        public final boolean isSequenced(@Nullable Geometry geom) {
            if (!(geom instanceof MultiLineString)) {
                return true;
            }
            Geometry mls = geom;
            Set prevSubgraphNodes = (Set)((Object)new TreeSet(null, null, 3, null));
            Coordinate lastNode = null;
            List currNodes = new ArrayList();
            int n = ((MultiLineString)mls).getNumGeometries();
            for (int i = 0; i < n; ++i) {
                Geometry geometry = ((MultiLineString)mls).getGeometryN(i);
                Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
                LineString line = (LineString)geometry;
                Coordinate startNode = line.getCoordinateN(0);
                Coordinate endNode = line.getCoordinateN(line.getNumPoints() - 1);
                if (prevSubgraphNodes.contains(startNode)) {
                    return false;
                }
                if (prevSubgraphNodes.contains(endNode)) {
                    return false;
                }
                if (lastNode != null && !Intrinsics.areEqual((Object)startNode, lastNode)) {
                    prevSubgraphNodes.addAll(currNodes);
                    currNodes.clear();
                }
                currNodes.add(startNode);
                currNodes.add(endNode);
                lastNode = endNode;
            }
            return true;
        }

        private final DirectedEdge findUnvisitedBestOrientedDE(Node node) {
            DirectedEdge wellOrientedDE = null;
            DirectedEdge unvisitedDE = null;
            Iterator<DirectedEdge> i = node.getOutEdges().iterator();
            while (i.hasNext()) {
                DirectedEdge de;
                Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.planargraph.DirectedEdge");
                Edge edge = de.getEdge();
                Intrinsics.checkNotNull((Object)edge);
                if (edge.isVisited()) continue;
                unvisitedDE = de;
                if (!de.getEdgeDirection()) continue;
                wellOrientedDE = de;
            }
            DirectedEdge directedEdge = wellOrientedDE;
            if (directedEdge == null) {
                directedEdge = unvisitedDE;
            }
            return directedEdge;
        }

        private final Node findLowestDegreeNode(Subgraph graph) {
            int minDegree = Integer.MAX_VALUE;
            Node minDegreeNode = null;
            Iterator<?> i = graph.nodeIterator();
            while (i.hasNext()) {
                Object obj = i.next();
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.planargraph.Node");
                Node node = (Node)obj;
                if (minDegreeNode != null && node.getDegree() >= minDegree) continue;
                minDegree = node.getDegree();
                minDegreeNode = node;
            }
            return minDegreeNode;
        }

        private final LineString reverse(LineString line) {
            Coordinate[] pts = line.getCoordinates();
            Object[] revPts = new Coordinate[pts.length];
            int len = pts.length;
            for (int i = 0; i < len; ++i) {
                revPts[len - 1 - i] = new Coordinate(pts[i]);
            }
            return line.getFactory().createLineString((Coordinate[])ArraysKt.requireNoNulls((Object[])revPts));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

