/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlay;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.PointLocation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.geomgraph.DirectedEdge;
import org.locationtech.jts.geomgraph.EdgeRing;
import org.locationtech.jts.geomgraph.Label;
import org.locationtech.jts.geomgraph.PlanarGraph;
import org.locationtech.jts.operation.overlay.MaximalEdgeRing;
import org.locationtech.jts.operation.overlay.MinimalEdgeRing;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 !2\u00020\u0001:\u0001!B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ \u0010\t\u001a\u00020\n2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\f\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000eJ\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00072\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J8\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0018\u0010\u0019\u001a\u0004\u0018\u00010\b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u001e\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J2\u0010\u001d\u001a\u00020\n2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\"\u0010\u001f\u001a\u00020\n2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0002J\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00110\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Lorg/locationtech/jts/operation/overlay/PolygonBuilder;", "", "geometryFactory", "Lorg/locationtech/jts/geom/GeometryFactory;", "<init>", "(Lorg/locationtech/jts/geom/GeometryFactory;)V", "shellList", "", "Lorg/locationtech/jts/geomgraph/EdgeRing;", "add", "", "graph", "Lorg/locationtech/jts/geomgraph/PlanarGraph;", "dirEdges", "", "nodes", "polygons", "Lorg/locationtech/jts/geom/Polygon;", "getPolygons", "()Ljava/util/List;", "buildMaximalEdgeRings", "Lorg/locationtech/jts/operation/overlay/MaximalEdgeRing;", "buildMinimalEdgeRings", "maxEdgeRings", "freeHoleList", "findShell", "minEdgeRings", "placePolygonHoles", "shell", "sortShellsAndHoles", "edgeRings", "placeFreeHoles", "computePolygons", "Companion", "kts-core"})
public final class PolygonBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GeometryFactory geometryFactory;
    @NotNull
    private final List<EdgeRing> shellList;

    public PolygonBuilder(@NotNull GeometryFactory geometryFactory) {
        Intrinsics.checkNotNullParameter((Object)geometryFactory, (String)"geometryFactory");
        this.geometryFactory = geometryFactory;
        this.shellList = new ArrayList();
    }

    public final void add(@NotNull PlanarGraph graph) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        this.add(graph.getEdgeEnds(), graph.getNodes());
    }

    public final void add(@NotNull Collection<?> dirEdges, @Nullable Collection<?> nodes) {
        Intrinsics.checkNotNullParameter(dirEdges, (String)"dirEdges");
        Collection<?> collection = nodes;
        Intrinsics.checkNotNull(collection);
        PlanarGraph.Companion.linkResultDirectedEdges(collection);
        List<MaximalEdgeRing> maxEdgeRings = this.buildMaximalEdgeRings(dirEdges);
        List freeHoleList = new ArrayList();
        List<EdgeRing> edgeRings = this.buildMinimalEdgeRings(maxEdgeRings, this.shellList, freeHoleList);
        this.sortShellsAndHoles(edgeRings, this.shellList, freeHoleList);
        this.placeFreeHoles(this.shellList, freeHoleList);
    }

    @NotNull
    public final List<Polygon> getPolygons() {
        return this.computePolygons(this.shellList);
    }

    private final List<MaximalEdgeRing> buildMaximalEdgeRings(Collection<?> dirEdges) {
        List maxEdgeRings = new ArrayList();
        for (Object obj : dirEdges) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.DirectedEdge");
            DirectedEdge de = (DirectedEdge)obj;
            if (!de.isInResult()) continue;
            Label label = de.getLabel();
            Intrinsics.checkNotNull((Object)label);
            if (!label.isArea() || de.getEdgeRing() != null) continue;
            MaximalEdgeRing er = new MaximalEdgeRing(de, this.geometryFactory);
            maxEdgeRings.add(er);
            er.setInResult();
        }
        return maxEdgeRings;
    }

    private final List<EdgeRing> buildMinimalEdgeRings(List<MaximalEdgeRing> maxEdgeRings, List<EdgeRing> shellList, List<EdgeRing> freeHoleList) {
        List edgeRings = new ArrayList();
        Iterator<MaximalEdgeRing> it = maxEdgeRings.iterator();
        while (it.hasNext()) {
            boolean bl;
            MaximalEdgeRing er;
            Intrinsics.checkNotNull((Object)it.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.operation.overlay.MaximalEdgeRing");
            if (er.getMaxNodeDegree() > 2) {
                er.linkDirectedEdgesForMinimalEdgeRings();
                List<EdgeRing> minEdgeRings = er.buildMinimalRings();
                EdgeRing shell = this.findShell(minEdgeRings);
                if (shell != null) {
                    this.placePolygonHoles(shell, minEdgeRings);
                    bl = shellList.add(shell);
                    continue;
                }
                bl = freeHoleList.addAll((Collection<EdgeRing>)minEdgeRings);
                continue;
            }
            bl = edgeRings.add(er);
        }
        return edgeRings;
    }

    private final EdgeRing findShell(List<EdgeRing> minEdgeRings) {
        int shellCount = 0;
        EdgeRing shell = null;
        for (EdgeRing edgeRing : minEdgeRings) {
            Intrinsics.checkNotNull((Object)edgeRing, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.overlay.MinimalEdgeRing");
            EdgeRing er = (MinimalEdgeRing)edgeRing;
            if (er.isHole()) continue;
            shell = er;
            ++shellCount;
        }
        Assert.INSTANCE.isTrue(shellCount <= 1, "found two shells in MinimalEdgeRing list");
        return shell;
    }

    private final void placePolygonHoles(EdgeRing shell, List<EdgeRing> minEdgeRings) {
        for (EdgeRing edgeRing : minEdgeRings) {
            Intrinsics.checkNotNull((Object)edgeRing, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.overlay.MinimalEdgeRing");
            MinimalEdgeRing er = (MinimalEdgeRing)edgeRing;
            if (!er.isHole()) continue;
            er.setShell(shell);
        }
    }

    private final void sortShellsAndHoles(List<EdgeRing> edgeRings, List<EdgeRing> shellList, List<EdgeRing> freeHoleList) {
        Iterator<EdgeRing> it = edgeRings.iterator();
        while (it.hasNext()) {
            EdgeRing er;
            Intrinsics.checkNotNull((Object)it.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.EdgeRing");
            boolean bl = er.isHole() ? freeHoleList.add(er) : shellList.add(er);
        }
    }

    private final void placeFreeHoles(List<EdgeRing> shellList, List<?> freeHoleList) {
        for (Object obj : freeHoleList) {
            EdgeRing shell;
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.EdgeRing");
            EdgeRing hole = (EdgeRing)obj;
            if (hole.getShell() != null) continue;
            if (PolygonBuilder.Companion.findEdgeRingContaining(hole, shellList) == null) {
                throw new TopologyException("unable to assign hole to a shell", hole.getCoordinate(0));
            }
            hole.setShell(shell);
        }
    }

    private final List<Polygon> computePolygons(List<EdgeRing> shellList) {
        List resultPolyList = new ArrayList();
        Iterator<EdgeRing> it = shellList.iterator();
        while (it.hasNext()) {
            EdgeRing er;
            Intrinsics.checkNotNull((Object)it.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.EdgeRing");
            Polygon poly = er.toPolygon(this.geometryFactory);
            resultPolyList.add(poly);
        }
        return resultPolyList;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bH\u0002\u00a8\u0006\t"}, d2={"Lorg/locationtech/jts/operation/overlay/PolygonBuilder$Companion;", "", "<init>", "()V", "findEdgeRingContaining", "Lorg/locationtech/jts/geomgraph/EdgeRing;", "testEr", "shellList", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        private final EdgeRing findEdgeRingContaining(EdgeRing testEr, List<EdgeRing> shellList) {
            LinearRing testRing;
            LinearRing linearRing = testRing = testEr.getLinearRing();
            Intrinsics.checkNotNull((Object)linearRing);
            Envelope testEnv = linearRing.getEnvelopeInternal();
            Coordinate testPt = testRing.getCoordinateN(0);
            EdgeRing minShell = null;
            Envelope minShellEnv = null;
            Iterator<EdgeRing> it = shellList.iterator();
            while (it.hasNext()) {
                EdgeRing tryShell;
                LinearRing tryShellRing;
                Intrinsics.checkNotNull((Object)it.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.EdgeRing");
                LinearRing linearRing2 = tryShellRing = tryShell.getLinearRing();
                Intrinsics.checkNotNull((Object)linearRing2);
                Envelope tryShellEnv = linearRing2.getEnvelopeInternal();
                if (Intrinsics.areEqual((Object)tryShellEnv, (Object)testEnv) || !tryShellEnv.contains(testEnv)) continue;
                testPt = CoordinateArrays.ptNotInList(testRing.getCoordinates(), tryShellRing.getCoordinates());
                boolean isContained = false;
                Coordinate coordinate = testPt;
                Intrinsics.checkNotNull((Object)coordinate);
                if (PointLocation.isInRing(coordinate, tryShellRing.getCoordinates())) {
                    isContained = true;
                }
                if (!isContained) continue;
                if (minShell != null) {
                    Envelope envelope = minShellEnv;
                    Intrinsics.checkNotNull(envelope);
                    if (!envelope.contains(tryShellEnv)) continue;
                }
                minShell = tryShell;
                LinearRing linearRing3 = minShell.getLinearRing();
                Intrinsics.checkNotNull((Object)linearRing3);
                minShellEnv = linearRing3.getEnvelopeInternal();
            }
            return minShell;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

