/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlay.snap;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.legacy.TreeSet;
import org.locationtech.jts.operation.overlay.snap.SnapTransformer;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0002\u00a2\u0006\u0002\u0010\u0011J\u001b\u0010\u0012\u001a\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u00a2\u0006\u0002\u0010\u0014J\u001b\u0010\u0015\u001a\u00020\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u00a2\u0006\u0002\u0010\u0014R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/locationtech/jts/operation/overlay/snap/GeometrySnapper;", "", "srcGeom", "Lorg/locationtech/jts/geom/Geometry;", "<init>", "(Lorg/locationtech/jts/geom/Geometry;)V", "snapTo", "snapGeom", "snapTolerance", "", "snapToSelf", "cleanResult", "", "extractTargetCoordinates", "", "Lorg/locationtech/jts/geom/Coordinate;", "g", "(Lorg/locationtech/jts/geom/Geometry;)[Lorg/locationtech/jts/geom/Coordinate;", "computeSnapTolerance", "ringPts", "([Lorg/locationtech/jts/geom/Coordinate;)D", "computeMinimumSegmentLength", "pts", "Companion", "kts-core"})
@SourceDebugExtension(value={"SMAP\nGeometrySnapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeometrySnapper.kt\norg/locationtech/jts/operation/overlay/snap/GeometrySnapper\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,224:1\n37#2,2:225\n*S KotlinDebug\n*F\n+ 1 GeometrySnapper.kt\norg/locationtech/jts/operation/overlay/snap/GeometrySnapper\n*L\n90#1:225,2\n*E\n"})
public final class GeometrySnapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Geometry srcGeom;
    private static final double SNAP_PRECISION_FACTOR = 1.0E-9;

    public GeometrySnapper(@Nullable Geometry srcGeom) {
        this.srcGeom = srcGeom;
    }

    @NotNull
    public final Geometry snapTo(@Nullable Geometry snapGeom, double snapTolerance) {
        Coordinate[] snapPts = this.extractTargetCoordinates(snapGeom);
        SnapTransformer snapTrans = new SnapTransformer(snapTolerance, snapPts);
        Geometry geometry = this.srcGeom;
        Intrinsics.checkNotNull((Object)geometry);
        return snapTrans.transform(geometry);
    }

    @NotNull
    public final Geometry snapToSelf(double snapTolerance, boolean cleanResult) {
        Geometry snappedGeom;
        Coordinate[] snapPts = this.extractTargetCoordinates(this.srcGeom);
        SnapTransformer snapTrans = new SnapTransformer(snapTolerance, snapPts, true);
        Geometry geometry = this.srcGeom;
        Intrinsics.checkNotNull((Object)geometry);
        Geometry result2 = snappedGeom = snapTrans.transform(geometry);
        if (cleanResult && result2 instanceof Polygonal) {
            result2 = snappedGeom.buffer(0.0);
        }
        return result2;
    }

    private final Coordinate[] extractTargetCoordinates(Geometry g) {
        Set ptSet = (Set)((Object)new TreeSet(null, null, 3, null));
        Geometry geometry = g;
        Intrinsics.checkNotNull((Object)geometry);
        Coordinate[] pts = geometry.getCoordinates();
        Intrinsics.checkNotNull((Object)pts);
        int n = pts.length;
        for (int i = 0; i < n; ++i) {
            ptSet.add(pts[i]);
        }
        Collection $this$toTypedArray$iv = ptSet;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Coordinate[0]);
    }

    private final double computeSnapTolerance(Coordinate[] ringPts) {
        double minSegLen = this.computeMinimumSegmentLength(ringPts);
        return minSegLen / (double)10;
    }

    private final double computeMinimumSegmentLength(Coordinate[] pts) {
        double minSegLen = Double.MAX_VALUE;
        int n = pts.length - 1;
        for (int i = 0; i < n; ++i) {
            double segLen = pts[i].distance(pts[i + 1]);
            if (!(segLen < minSegLen)) continue;
            minSegLen = segLen;
        }
        return minSegLen;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u0006\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bJ-\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\b\u0010\n\u001a\u0004\u0018\u00010\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000fJ \u0010\u0010\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/locationtech/jts/operation/overlay/snap/GeometrySnapper$Companion;", "", "<init>", "()V", "SNAP_PRECISION_FACTOR", "", "computeOverlaySnapTolerance", "g", "Lorg/locationtech/jts/geom/Geometry;", "computeSizeBasedSnapTolerance", "g0", "g1", "snap", "", "snapTolerance", "(Lorg/locationtech/jts/geom/Geometry;Lorg/locationtech/jts/geom/Geometry;D)[Lorg/locationtech/jts/geom/Geometry;", "snapToSelf", "geom", "cleanResult", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final double computeOverlaySnapTolerance(@NotNull Geometry g) {
            double fixedSnapTol;
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            double snapTolerance = this.computeSizeBasedSnapTolerance(g);
            PrecisionModel pm = g.getPrecisionModel();
            if (Intrinsics.areEqual((Object)pm.getType(), (Object)PrecisionModel.FIXED) && (fixedSnapTol = 1.0 / pm.getScale() * (double)2 / 1.415) > snapTolerance) {
                snapTolerance = fixedSnapTol;
            }
            return snapTolerance;
        }

        public final double computeSizeBasedSnapTolerance(@NotNull Geometry g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Envelope env = g.getEnvelopeInternal();
            double minDimension = Math.INSTANCE.min(env.getHeight(), env.getWidth());
            return minDimension * 1.0E-9;
        }

        public final double computeOverlaySnapTolerance(@NotNull Geometry g0, @NotNull Geometry g1) {
            Intrinsics.checkNotNullParameter((Object)g0, (String)"g0");
            Intrinsics.checkNotNullParameter((Object)g1, (String)"g1");
            return Math.INSTANCE.min(this.computeOverlaySnapTolerance(g0), this.computeOverlaySnapTolerance(g1));
        }

        @NotNull
        public final Geometry[] snap(@Nullable Geometry g0, @Nullable Geometry g1, double snapTolerance) {
            Object[] snapGeom = new Geometry[2];
            GeometrySnapper snapper0 = new GeometrySnapper(g0);
            snapGeom[0] = snapper0.snapTo(g1, snapTolerance);
            GeometrySnapper snapper1 = new GeometrySnapper(g1);
            snapGeom[1] = snapper1.snapTo(snapGeom[0], snapTolerance);
            return (Geometry[])ArraysKt.requireNoNulls((Object[])snapGeom);
        }

        @NotNull
        public final Geometry snapToSelf(@Nullable Geometry geom, double snapTolerance, boolean cleanResult) {
            GeometrySnapper snapper0 = new GeometrySnapper(geom);
            return snapper0.snapToSelf(snapTolerance, cleanResult);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

