/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.operation.overlayng.EdgeSourceInfo;
import org.locationtech.jts.operation.overlayng.OverlayLabel;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 %2\u00020\u0001:\u0001%B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\rJ\u0006\u0010\u0016\u001a\u00020\rJ\u0006\u0010\u0017\u001a\u00020\u0010J\u000e\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0000J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\rH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u0000J\n\u0010\"\u001a\u00020#H\u0096\u0080\u0004J\u0006\u0010$\u001a\u00020#R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/locationtech/jts/operation/overlayng/Edge;", "", "coordinates", "", "Lorg/locationtech/jts/geom/Coordinate;", "info", "Lorg/locationtech/jts/operation/overlayng/EdgeSourceInfo;", "<init>", "([Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/operation/overlayng/EdgeSourceInfo;)V", "getCoordinates", "()[Lorg/locationtech/jts/geom/Coordinate;", "[Lorg/locationtech/jts/geom/Coordinate;", "aDim", "", "aDepthDelta", "aIsHole", "", "bDim", "bDepthDelta", "bIsHole", "getCoordinate", "index", "size", "direction", "relativeDirection", "edge2", "createLabel", "Lorg/locationtech/jts/operation/overlayng/OverlayLabel;", "isShell", "geomIndex", "copyInfo", "", "merge", "edge", "toString", "", "toLineString", "Companion", "kts-core"})
public final class Edge {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Coordinate[] coordinates;
    private int aDim;
    private int aDepthDelta;
    private boolean aIsHole;
    private int bDim;
    private int bDepthDelta;
    private boolean bIsHole;

    public Edge(@NotNull Coordinate[] coordinates, @NotNull EdgeSourceInfo info) {
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.coordinates = coordinates;
        this.aDim = -1;
        this.bDim = -1;
        this.copyInfo(info);
    }

    @NotNull
    public final Coordinate[] getCoordinates() {
        return this.coordinates;
    }

    @NotNull
    public final Coordinate getCoordinate(int index) {
        return this.coordinates[index];
    }

    public final int size() {
        return this.coordinates.length;
    }

    public final boolean direction() {
        int cmp1;
        Coordinate[] pts = this.coordinates;
        if (pts.length < 2) {
            throw new IllegalStateException("Edge must have >= 2 points");
        }
        Coordinate p0 = pts[0];
        Coordinate p1 = pts[1];
        Coordinate pn0 = pts[pts.length - 1];
        Coordinate pn1 = pts[pts.length - 2];
        int cmp = 0;
        int cmp0 = p0.compareTo(pn0);
        if (cmp0 != 0) {
            cmp = cmp0;
        }
        if (cmp == 0 && (cmp1 = p1.compareTo(pn1)) != 0) {
            cmp = cmp1;
        }
        if (cmp == 0) {
            throw new IllegalStateException("Edge direction cannot be determined because endpoints are equal");
        }
        return cmp == -1;
    }

    public final boolean relativeDirection(@NotNull Edge edge2) {
        Intrinsics.checkNotNullParameter((Object)edge2, (String)"edge2");
        if (!this.getCoordinate(0).equals2D(edge2.getCoordinate(0))) {
            return false;
        }
        return this.getCoordinate(1).equals2D(edge2.getCoordinate(1));
    }

    @NotNull
    public final OverlayLabel createLabel() {
        OverlayLabel lbl = new OverlayLabel();
        Edge.Companion.initLabel(lbl, 0, this.aDim, this.aDepthDelta, this.aIsHole);
        Edge.Companion.initLabel(lbl, 1, this.bDim, this.bDepthDelta, this.bIsHole);
        return lbl;
    }

    private final boolean isShell(int geomIndex) {
        return geomIndex == 0 ? this.aDim == 2 && !this.aIsHole : this.bDim == 2 && !this.bIsHole;
    }

    private final void copyInfo(EdgeSourceInfo info) {
        if (info.getIndex() == 0) {
            this.aDim = info.getDimension();
            this.aIsHole = info.isHole();
            this.aDepthDelta = info.getDepthDelta();
        } else {
            this.bDim = info.getDimension();
            this.bIsHole = info.isHole();
            this.bDepthDelta = info.getDepthDelta();
        }
    }

    public final void merge(@NotNull Edge edge) {
        boolean relDir;
        Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
        this.aIsHole = Edge.Companion.isHoleMerged(0, this, edge);
        this.bIsHole = Edge.Companion.isHoleMerged(1, this, edge);
        if (edge.aDim > this.aDim) {
            this.aDim = edge.aDim;
        }
        if (edge.bDim > this.bDim) {
            this.bDim = edge.bDim;
        }
        int flipFactor = (relDir = this.relativeDirection(edge)) ? 1 : -1;
        this.aDepthDelta += flipFactor * edge.aDepthDelta;
        this.bDepthDelta += flipFactor * edge.bDepthDelta;
    }

    @NotNull
    public String toString() {
        String ptsStr = Edge.Companion.toStringPts(this.coordinates);
        String aInfo = Companion.infoString(0, this.aDim, this.aIsHole, this.aDepthDelta);
        String bInfo = Companion.infoString(1, this.bDim, this.bIsHole, this.bDepthDelta);
        return "Edge( " + ptsStr + " ) " + aInfo + "/" + bInfo;
    }

    @NotNull
    public final String toLineString() {
        return WKTWriter.Companion.toLineString(this.coordinates);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ0\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J \u0010\u0018\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J\u001b\u0010\u001c\u001a\u00020\u001d2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u00a2\u0006\u0002\u0010\u001eJ&\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000fJ\u0018\u0010!\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a8\u0006#"}, d2={"Lorg/locationtech/jts/operation/overlayng/Edge$Companion;", "", "<init>", "()V", "isCollapsed", "", "pts", "", "Lorg/locationtech/jts/geom/Coordinate;", "([Lorg/locationtech/jts/geom/Coordinate;)Z", "initLabel", "", "lbl", "Lorg/locationtech/jts/operation/overlayng/OverlayLabel;", "geomIndex", "", "dim", "depthDelta", "isHole", "labelDim", "locationRight", "locationLeft", "delSign", "depthDel", "isHoleMerged", "edge1", "Lorg/locationtech/jts/operation/overlayng/Edge;", "edge2", "toStringPts", "", "([Lorg/locationtech/jts/geom/Coordinate;)Ljava/lang/String;", "infoString", "index", "ringRoleSymbol", "hasAreaParent", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isCollapsed(@NotNull Coordinate[] pts) {
            Intrinsics.checkNotNullParameter((Object)pts, (String)"pts");
            if (pts.length < 2) {
                return true;
            }
            if (pts[0].equals2D(pts[1])) {
                return true;
            }
            return pts.length > 2 && pts[pts.length - 1].equals2D(pts[pts.length - 2]);
        }

        private final void initLabel(OverlayLabel lbl, int geomIndex, int dim, int depthDelta, boolean isHole) {
            int dimLabel = this.labelDim(dim, depthDelta);
            switch (dimLabel) {
                case -1: {
                    lbl.initNotPart(geomIndex);
                    break;
                }
                case 2: {
                    lbl.initBoundary(geomIndex, this.locationLeft(depthDelta), this.locationRight(depthDelta), isHole);
                    break;
                }
                case 3: {
                    lbl.initCollapse(geomIndex, isHole);
                    break;
                }
                case 1: {
                    lbl.initLine(geomIndex);
                }
            }
        }

        private final int labelDim(int dim, int depthDelta) {
            if (dim == -1) {
                return -1;
            }
            if (dim == 1) {
                return 1;
            }
            boolean isCollapse = depthDelta == 0;
            return isCollapse ? 3 : 2;
        }

        private final int locationRight(int depthDelta) {
            int delSign = this.delSign(depthDelta);
            switch (delSign) {
                case 0: {
                    return OverlayLabel.Companion.getLOC_UNKNOWN();
                }
                case 1: {
                    return 0;
                }
                case -1: {
                    return 2;
                }
            }
            return OverlayLabel.Companion.getLOC_UNKNOWN();
        }

        private final int locationLeft(int depthDelta) {
            int delSign = this.delSign(depthDelta);
            switch (delSign) {
                case 0: {
                    return OverlayLabel.Companion.getLOC_UNKNOWN();
                }
                case 1: {
                    return 2;
                }
                case -1: {
                    return 0;
                }
            }
            return OverlayLabel.Companion.getLOC_UNKNOWN();
        }

        private final int delSign(int depthDel) {
            if (depthDel > 0) {
                return 1;
            }
            return depthDel < 0 ? -1 : 0;
        }

        private final boolean isHoleMerged(int geomIndex, Edge edge1, Edge edge2) {
            boolean isShell1 = edge1.isShell(geomIndex);
            boolean isShell2 = edge2.isShell(geomIndex);
            boolean isShellMerged = isShell1 || isShell2;
            return !isShellMerged;
        }

        private final String toStringPts(Coordinate[] pts) {
            Coordinate orig = pts[0];
            Coordinate dest = pts[pts.length - 1];
            String dirPtStr = pts.length > 2 ? ", " + WKTWriter.Companion.format(pts[1]) : "";
            return WKTWriter.Companion.format(orig) + dirPtStr + " .. " + WKTWriter.Companion.format(dest);
        }

        @NotNull
        public final String infoString(int index, int dim, boolean isHole, int depthDelta) {
            return (index == 0 ? "A:" : "B:") + OverlayLabel.Companion.dimensionSymbol(dim) + this.ringRoleSymbol(dim, isHole) + depthDelta;
        }

        private final String ringRoleSymbol(int dim, boolean isHole) {
            return this.hasAreaParent(dim) ? "" + OverlayLabel.Companion.ringRoleSymbol(isHole) : "";
        }

        private final boolean hasAreaParent(int dim) {
            return dim == 2 || dim == 3;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

