/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001b"}, d2={"Lorg/locationtech/jts/operation/overlayng/RobustClipEnvelopeComputer;", "", "targetEnv", "Lorg/locationtech/jts/geom/Envelope;", "<init>", "(Lorg/locationtech/jts/geom/Envelope;)V", "envelope", "getEnvelope", "()Lorg/locationtech/jts/geom/Envelope;", "add", "", "g", "Lorg/locationtech/jts/geom/Geometry;", "addCollection", "gc", "Lorg/locationtech/jts/geom/GeometryCollection;", "addPolygon", "poly", "Lorg/locationtech/jts/geom/Polygon;", "addPolygonRing", "ring", "Lorg/locationtech/jts/geom/LinearRing;", "addSegment", "p1", "Lorg/locationtech/jts/geom/Coordinate;", "p2", "Companion", "kts-core"})
public final class RobustClipEnvelopeComputer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Envelope targetEnv;
    @NotNull
    private final Envelope envelope;

    public RobustClipEnvelopeComputer(@NotNull Envelope targetEnv) {
        Intrinsics.checkNotNullParameter((Object)targetEnv, (String)"targetEnv");
        this.targetEnv = targetEnv;
        this.envelope = this.targetEnv.copy();
    }

    @NotNull
    public final Envelope getEnvelope() {
        return this.envelope;
    }

    public final void add(@Nullable Geometry g) {
        if (g == null || g.isEmpty()) {
            return;
        }
        if (g instanceof Polygon) {
            this.addPolygon((Polygon)g);
        } else if (g instanceof GeometryCollection) {
            this.addCollection((GeometryCollection)g);
        }
    }

    private final void addCollection(GeometryCollection gc) {
        int n = gc.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Geometry g = gc.getGeometryN(i);
            this.add(g);
        }
    }

    private final void addPolygon(Polygon poly) {
        LinearRing shell = poly.getExteriorRing();
        this.addPolygonRing(shell);
        int n = poly.getNumInteriorRing();
        for (int i = 0; i < n; ++i) {
            LinearRing hole = poly.getInteriorRingN(i);
            this.addPolygonRing(hole);
        }
    }

    private final void addPolygonRing(LinearRing ring) {
        LinearRing linearRing = ring;
        Intrinsics.checkNotNull((Object)linearRing);
        if (linearRing.isEmpty()) {
            return;
        }
        CoordinateSequence coordinateSequence = ring.getCoordinateSequence();
        Intrinsics.checkNotNull((Object)coordinateSequence);
        CoordinateSequence seq = coordinateSequence;
        int n = seq.size();
        for (int i = 1; i < n; ++i) {
            this.addSegment(seq.getCoordinate(i - 1), seq.getCoordinate(i));
        }
    }

    private final void addSegment(Coordinate p1, Coordinate p2) {
        if (RobustClipEnvelopeComputer.Companion.intersectsSegment(this.targetEnv, p1, p2)) {
            this.envelope.expandToInclude(p1);
            this.envelope.expandToInclude(p2);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u0005J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/locationtech/jts/operation/overlayng/RobustClipEnvelopeComputer$Companion;", "", "<init>", "()V", "getEnvelope", "Lorg/locationtech/jts/geom/Envelope;", "a", "Lorg/locationtech/jts/geom/Geometry;", "b", "targetEnv", "intersectsSegment", "", "env", "p1", "Lorg/locationtech/jts/geom/Coordinate;", "p2", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Envelope getEnvelope(@Nullable Geometry a, @Nullable Geometry b, @NotNull Envelope targetEnv) {
            Intrinsics.checkNotNullParameter((Object)targetEnv, (String)"targetEnv");
            RobustClipEnvelopeComputer cec = new RobustClipEnvelopeComputer(targetEnv);
            cec.add(a);
            cec.add(b);
            return cec.getEnvelope();
        }

        private final boolean intersectsSegment(Envelope env, Coordinate p1, Coordinate p2) {
            return env.intersects(p1, p2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

