/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.polygonize;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.algorithm.locate.IndexedPointInAreaLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.operation.polygonize.PolygonizeDirectedEdge;
import org.locationtech.jts.operation.polygonize.PolygonizeEdge;
import org.locationtech.jts.planargraph.DirectedEdge;
import org.locationtech.jts.planargraph.Edge;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 C2\u00020\u0001:\u0002BCB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u0010\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020\bH\u0002J\u0006\u0010&\u001a\u00020!J\u000e\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020\u000bJ\u000e\u0010'\u001a\u00020!2\u0006\u0010)\u001a\u00020\u0000J\u0010\u0010/\u001a\u00020\u00172\b\u00100\u001a\u0004\u0018\u00010\u0012J\b\u00108\u001a\u0004\u0018\u00010\u000bJ\u0010\u00109\u001a\u00020!2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0000J\u0006\u0010:\u001a\u00020\u0017J\b\u0010;\u001a\u0004\u0018\u00010\u0000J\b\u0010>\u001a\u0004\u0018\u00010\u0000J\u0006\u0010?\u001a\u00020!J\n\u0010@\u001a\u00020AH\u0096\u0080\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\u0004\u0018\u00010\r8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0016\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0019\"\u0004\b\u001b\u0010\u001cR\u001e\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0019R$\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0017@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0019\"\u0004\b\u001f\u0010\u001cR\u0011\u0010*\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0011\u0010.\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0019R\u001a\u00101\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0011\u00104\u001a\u0002058F\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0011\u0010<\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b<\u0010\u0019R\u0011\u0010=\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b=\u0010\u0019\u00a8\u0006D"}, d2={"Lorg/locationtech/jts/operation/polygonize/EdgeRing;", "", "factory", "Lorg/locationtech/jts/geom/GeometryFactory;", "<init>", "(Lorg/locationtech/jts/geom/GeometryFactory;)V", "deList", "", "Lorg/locationtech/jts/planargraph/DirectedEdge;", "lowestEdge", "ring", "Lorg/locationtech/jts/geom/LinearRing;", "locator", "Lorg/locationtech/jts/algorithm/locate/IndexedPointInAreaLocator;", "getLocator", "()Lorg/locationtech/jts/algorithm/locate/IndexedPointInAreaLocator;", "ringPts", "", "Lorg/locationtech/jts/geom/Coordinate;", "[Lorg/locationtech/jts/geom/Coordinate;", "holes", "shell", "value", "", "isHole", "()Z", "isProcessed", "setProcessed", "(Z)V", "isIncludedSet", "isIncluded", "setIncluded", "build", "", "startDE", "Lorg/locationtech/jts/operation/polygonize/PolygonizeDirectedEdge;", "add", "de", "computeHole", "addHole", "hole", "holeER", "polygon", "Lorg/locationtech/jts/geom/Polygon;", "getPolygon", "()Lorg/locationtech/jts/geom/Polygon;", "isValid", "isInRing", "pt", "coordinates", "getCoordinates", "()[Lorg/locationtech/jts/geom/Coordinate;", "lineString", "Lorg/locationtech/jts/geom/LineString;", "getLineString", "()Lorg/locationtech/jts/geom/LineString;", "getRing", "setShell", "hasShell", "getShell", "isOuterHole", "isOuterShell", "getOuterHole", "updateIncluded", "toString", "", "EnvelopeComparator", "Companion", "kts-core"})
public final class EdgeRing {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GeometryFactory factory;
    @NotNull
    private final List<DirectedEdge> deList;
    @Nullable
    private final DirectedEdge lowestEdge;
    @Nullable
    private LinearRing ring;
    @Nullable
    private IndexedPointInAreaLocator locator;
    @Nullable
    private Coordinate[] ringPts;
    @Nullable
    private List<LinearRing> holes;
    @Nullable
    private EdgeRing shell;
    private boolean isHole;
    private boolean isProcessed;
    private boolean isIncludedSet;
    private boolean isIncluded;

    public EdgeRing(@NotNull GeometryFactory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        this.factory = factory;
        this.deList = new ArrayList();
    }

    private final IndexedPointInAreaLocator getLocator() {
        if (this.locator == null) {
            this.locator = new IndexedPointInAreaLocator(this.getRing());
        }
        return this.locator;
    }

    public final boolean isHole() {
        return this.isHole;
    }

    public final boolean isProcessed() {
        return this.isProcessed;
    }

    public final void setProcessed(boolean bl) {
        this.isProcessed = bl;
    }

    public final boolean isIncludedSet() {
        return this.isIncludedSet;
    }

    public final boolean isIncluded() {
        return this.isIncluded;
    }

    public final void setIncluded(boolean isIncluded) {
        this.isIncluded = isIncluded;
        this.isIncludedSet = true;
    }

    /*
     * Unable to fully structure code
     */
    public final void build(@NotNull PolygonizeDirectedEdge startDE) {
        Intrinsics.checkNotNullParameter((Object)startDE, (String)"startDE");
        de = startDE;
        do {
            v0 = de;
            Intrinsics.checkNotNull((Object)v0);
            this.add(v0);
            de.setRing(this);
            de = de.getNext();
            Assert.INSTANCE.isTrue(de != null, "found null DE in ring");
            if (de == startDE) ** GOTO lbl-1000
            v1 = de;
            Intrinsics.checkNotNull((Object)v1);
            if (!v1.isInRing()) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = false;
            }
            Assert.INSTANCE.isTrue(v2, "found DE already in ring");
        } while (de != startDE);
    }

    private final void add(DirectedEdge de) {
        this.deList.add(de);
    }

    public final void computeHole() {
        LinearRing ring;
        LinearRing linearRing = ring = this.getRing();
        Intrinsics.checkNotNull((Object)linearRing);
        this.isHole = Orientation.isCCW(linearRing.getCoordinates());
    }

    public final void addHole(@NotNull LinearRing hole) {
        Intrinsics.checkNotNullParameter((Object)hole, (String)"hole");
        if (this.holes == null) {
            this.holes = new ArrayList();
        }
        List<LinearRing> list = this.holes;
        Intrinsics.checkNotNull(list);
        list.add(hole);
    }

    public final void addHole(@NotNull EdgeRing holeER) {
        Intrinsics.checkNotNullParameter((Object)holeER, (String)"holeER");
        holeER.setShell(this);
        LinearRing hole = holeER.getRing();
        if (this.holes == null) {
            this.holes = new ArrayList();
        }
        List<LinearRing> list = this.holes;
        Intrinsics.checkNotNull(list);
        LinearRing linearRing = hole;
        Intrinsics.checkNotNull((Object)linearRing);
        list.add(linearRing);
    }

    @NotNull
    public final Polygon getPolygon() {
        Object[] holeLR = null;
        if (this.holes != null) {
            List<LinearRing> list = this.holes;
            Intrinsics.checkNotNull(list);
            holeLR = new LinearRing[list.size()];
            List<LinearRing> list2 = this.holes;
            Intrinsics.checkNotNull(list2);
            int n = ((Collection)list2).size();
            for (int i = 0; i < n; ++i) {
                List<LinearRing> list3 = this.holes;
                Intrinsics.checkNotNull(list3);
                holeLR[i] = list3.get(i);
            }
        }
        return this.factory.createPolygon(this.ring, (LinearRing[])(holeLR != null ? (LinearRing[])ArraysKt.requireNoNulls((Object[])holeLR) : null));
    }

    public final boolean isValid() {
        this.getCoordinates();
        Intrinsics.checkNotNull((Object)this.ringPts);
        if (this.ringPts.length <= 3) {
            return false;
        }
        this.getRing();
        LinearRing linearRing = this.ring;
        Intrinsics.checkNotNull((Object)linearRing);
        return linearRing.isValid();
    }

    public final boolean isInRing(@Nullable Coordinate pt) {
        IndexedPointInAreaLocator indexedPointInAreaLocator = this.getLocator();
        Intrinsics.checkNotNull((Object)indexedPointInAreaLocator);
        Coordinate coordinate = pt;
        Intrinsics.checkNotNull((Object)coordinate);
        return 2 != indexedPointInAreaLocator.locate(coordinate);
    }

    private final Coordinate[] getCoordinates() {
        if (this.ringPts == null) {
            CoordinateList coordList = new CoordinateList();
            for (DirectedEdge de : this.deList) {
                Edge edge = de.getEdge();
                Intrinsics.checkNotNull((Object)edge, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.polygonize.PolygonizeEdge");
                PolygonizeEdge edge2 = (PolygonizeEdge)edge;
                EdgeRing.Companion.addEdge(edge2.getLine().getCoordinates(), de.getEdgeDirection(), coordList);
            }
            this.ringPts = coordList.toCoordinateArray();
        }
        Intrinsics.checkNotNull((Object)this.ringPts);
        return this.ringPts;
    }

    @NotNull
    public final LineString getLineString() {
        this.getCoordinates();
        return this.factory.createLineString(this.ringPts);
    }

    @Nullable
    public final LinearRing getRing() {
        if (this.ring != null) {
            return this.ring;
        }
        this.getCoordinates();
        try {
            Intrinsics.checkNotNull((Object)this.ringPts);
            this.ring = this.factory.createLinearRing(this.ringPts);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.ring;
    }

    public final void setShell(@Nullable EdgeRing shell) {
        this.shell = shell;
    }

    public final boolean hasShell() {
        return this.shell != null;
    }

    @Nullable
    public final EdgeRing getShell() {
        return this.isHole ? this.shell : this;
    }

    public final boolean isOuterHole() {
        return !this.isHole ? false : !this.hasShell();
    }

    public final boolean isOuterShell() {
        return this.getOuterHole() != null;
    }

    @Nullable
    public final EdgeRing getOuterHole() {
        if (this.isHole) {
            return null;
        }
        int n = ((Collection)this.deList).size();
        for (int i = 0; i < n; ++i) {
            EdgeRing adjRing;
            DirectedEdge directedEdge = this.deList.get(i).getSym();
            Intrinsics.checkNotNull((Object)directedEdge, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.polygonize.PolygonizeDirectedEdge");
            EdgeRing edgeRing = adjRing = ((PolygonizeDirectedEdge)directedEdge).getRing();
            Intrinsics.checkNotNull((Object)edgeRing);
            if (!edgeRing.isOuterHole()) continue;
            return adjRing;
        }
        return null;
    }

    public final void updateIncluded() {
        if (this.isHole) {
            return;
        }
        int n = ((Collection)this.deList).size();
        for (int i = 0; i < n; ++i) {
            DirectedEdge directedEdge = this.deList.get(i).getSym();
            Intrinsics.checkNotNull((Object)directedEdge, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.polygonize.PolygonizeDirectedEdge");
            EdgeRing edgeRing = ((PolygonizeDirectedEdge)directedEdge).getRing();
            Intrinsics.checkNotNull((Object)edgeRing);
            EdgeRing adjShell = edgeRing.getShell();
            if (adjShell == null || !adjShell.isIncludedSet) continue;
            this.setIncluded(!adjShell.isIncluded);
            return;
        }
    }

    @NotNull
    public String toString() {
        return WKTWriter.Companion.toLineString(new CoordinateArraySequence(this.getCoordinates(), 0, 0, 6, null));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bJ\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rJ+\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lorg/locationtech/jts/operation/polygonize/EdgeRing$Companion;", "", "<init>", "()V", "findEdgeRingContaining", "Lorg/locationtech/jts/operation/polygonize/EdgeRing;", "testEr", "erList", "", "findDirEdgesInRing", "", "Lorg/locationtech/jts/planargraph/DirectedEdge;", "startDE", "Lorg/locationtech/jts/operation/polygonize/PolygonizeDirectedEdge;", "addEdge", "", "coords", "", "Lorg/locationtech/jts/geom/Coordinate;", "isForward", "", "coordList", "Lorg/locationtech/jts/geom/CoordinateList;", "([Lorg/locationtech/jts/geom/Coordinate;ZLorg/locationtech/jts/geom/CoordinateList;)V", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final EdgeRing findEdgeRingContaining(@NotNull EdgeRing testEr, @NotNull List<EdgeRing> erList) {
            LinearRing testRing;
            Intrinsics.checkNotNullParameter((Object)testEr, (String)"testEr");
            Intrinsics.checkNotNullParameter(erList, (String)"erList");
            LinearRing linearRing = testRing = testEr.getRing();
            Intrinsics.checkNotNull((Object)linearRing);
            Envelope testEnv = linearRing.getEnvelopeInternal();
            Coordinate testPt = testRing.getCoordinateN(0);
            EdgeRing minRing = null;
            Envelope minRingEnv = null;
            Iterator<EdgeRing> it = erList.iterator();
            while (it.hasNext()) {
                boolean isContained;
                EdgeRing tryEdgeRing;
                LinearRing tryRing;
                Intrinsics.checkNotNull((Object)it.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.operation.polygonize.EdgeRing");
                LinearRing linearRing2 = tryRing = tryEdgeRing.getRing();
                Intrinsics.checkNotNull((Object)linearRing2);
                Envelope tryShellEnv = linearRing2.getEnvelopeInternal();
                if (Intrinsics.areEqual((Object)tryShellEnv, (Object)testEnv) || !tryShellEnv.contains(testEnv) || (testPt = CoordinateArrays.ptNotInList(testRing.getCoordinates(), tryEdgeRing.getCoordinates())) == null || !(isContained = tryEdgeRing.isInRing(testPt))) continue;
                if (minRing != null) {
                    Envelope envelope = minRingEnv;
                    Intrinsics.checkNotNull(envelope);
                    if (!envelope.contains(tryShellEnv)) continue;
                }
                minRing = tryEdgeRing;
                LinearRing linearRing3 = minRing.getRing();
                Intrinsics.checkNotNull((Object)linearRing3);
                minRingEnv = linearRing3.getEnvelopeInternal();
            }
            return minRing;
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final List<DirectedEdge> findDirEdgesInRing(@NotNull PolygonizeDirectedEdge startDE) {
            Intrinsics.checkNotNullParameter((Object)startDE, (String)"startDE");
            de = startDE;
            edges = new ArrayList<E>();
            do {
                v0 = de;
                Intrinsics.checkNotNull((Object)v0);
                edges.add(v0);
                de = de.getNext();
                Assert.INSTANCE.isTrue(de != null, "found null DE in ring");
                if (de == startDE) ** GOTO lbl-1000
                v1 = de;
                Intrinsics.checkNotNull((Object)v1);
                if (!v1.isInRing()) lbl-1000:
                // 2 sources

                {
                    v2 = true;
                } else {
                    v2 = false;
                }
                Assert.INSTANCE.isTrue(v2, "found DE already in ring");
            } while (de != startDE);
            return edges;
        }

        private final void addEdge(Coordinate[] coords, boolean isForward, CoordinateList coordList) {
            if (isForward) {
                int n = coords.length;
                for (int i = 0; i < n; ++i) {
                    coordList.add(coords[i], false);
                }
            } else {
                int n = coords.length + -1;
                if (0 <= n) {
                    do {
                        int i = n--;
                        coordList.add(coords[i], false);
                    } while (0 <= n);
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lorg/locationtech/jts/operation/polygonize/EdgeRing$EnvelopeComparator;", "Ljava/util/Comparator;", "", "Lkotlin/Comparator;", "<init>", "()V", "compare", "", "obj0", "obj1", "kts-core"})
    public static final class EnvelopeComparator
    implements Comparator<Object> {
        @Override
        public int compare(@NotNull Object obj0, @NotNull Object obj1) {
            Intrinsics.checkNotNullParameter((Object)obj0, (String)"obj0");
            Intrinsics.checkNotNullParameter((Object)obj1, (String)"obj1");
            EdgeRing r0 = (EdgeRing)obj0;
            EdgeRing r1 = (EdgeRing)obj1;
            LinearRing linearRing = r0.getRing();
            Intrinsics.checkNotNull((Object)linearRing);
            Geometry geometry = linearRing.getEnvelope();
            LinearRing linearRing2 = r1.getRing();
            Intrinsics.checkNotNull((Object)linearRing2);
            return geometry.compareTo(linearRing2.getEnvelope());
        }
    }
}

