/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.polygonize;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.operation.polygonize.EdgeRing;
import org.locationtech.jts.operation.polygonize.HoleAssigner;
import org.locationtech.jts.operation.polygonize.PolygonizeGraph;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0012\u0018\u0000 ?2\u00020\u0001:\u0002>?B\u0013\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010-\u001a\u00020.2\n\u0010/\u001a\u0006\u0012\u0002\b\u00030\u000fJ\u000e\u0010-\u001a\u00020.2\u0006\u00100\u001a\u00020'J\u0010\u0010-\u001a\u00020.2\u0006\u00101\u001a\u00020\u0010H\u0002J\u000e\u00102\u001a\u00020.2\u0006\u0010*\u001a\u00020\u0003J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\b\u00108\u001a\u00020.H\u0002J2\u00109\u001a\u00020.2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00162\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00162\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00100\u0016H\u0002J\u0016\u0010=\u001a\u00020.2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\"\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8DX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R \u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u0016X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR \u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u0016X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0018\"\u0004\b\u001d\u0010\u001aR\"\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u0016X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0018\"\u0004\b!\u0010\u001aR\"\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u0016X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0018\"\u0004\b$\u0010\u001aR\"\u0010%\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010&X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0018\"\u0004\b)\u0010\u001aR\u000e\u0010*\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u00103\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u0012R\u0011\u00105\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b6\u00107\u00a8\u0006@"}, d2={"Lorg/locationtech/jts/operation/polygonize/Polygonizer;", "", "extractOnlyPolygonal", "", "<init>", "(Z)V", "lineStringAdder", "Lorg/locationtech/jts/operation/polygonize/Polygonizer$LineStringAdder;", "graph", "Lorg/locationtech/jts/operation/polygonize/PolygonizeGraph;", "getGraph", "()Lorg/locationtech/jts/operation/polygonize/PolygonizeGraph;", "setGraph", "(Lorg/locationtech/jts/operation/polygonize/PolygonizeGraph;)V", "dangles", "", "Lorg/locationtech/jts/geom/LineString;", "getDangles", "()Ljava/util/Collection;", "setDangles", "(Ljava/util/Collection;)V", "cutEdges", "", "getCutEdges", "()Ljava/util/List;", "setCutEdges", "(Ljava/util/List;)V", "invalidRingLines", "getInvalidRingLines", "setInvalidRingLines", "holeList", "Lorg/locationtech/jts/operation/polygonize/EdgeRing;", "getHoleList", "setHoleList", "shellList", "getShellList", "setShellList", "polyList", "", "Lorg/locationtech/jts/geom/Geometry;", "getPolyList", "setPolyList", "isCheckingRingsValid", "geomFactory", "Lorg/locationtech/jts/geom/GeometryFactory;", "add", "", "geomList", "g", "line", "setCheckRingsValid", "polygons", "getPolygons", "geometry", "getGeometry", "()Lorg/locationtech/jts/geom/Geometry;", "polygonize", "findValidRings", "edgeRingList", "validEdgeRingList", "invalidRingList", "findShellsAndHoles", "LineStringAdder", "Companion", "kts-core"})
public final class Polygonizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean extractOnlyPolygonal;
    @NotNull
    private final LineStringAdder lineStringAdder;
    @Nullable
    private PolygonizeGraph graph;
    @NotNull
    private Collection<? extends LineString> dangles;
    @NotNull
    private List<LineString> cutEdges;
    @NotNull
    private List<LineString> invalidRingLines;
    @Nullable
    private List<EdgeRing> holeList;
    @Nullable
    private List<EdgeRing> shellList;
    @Nullable
    private List<? extends Geometry> polyList;
    private boolean isCheckingRingsValid;
    @Nullable
    private GeometryFactory geomFactory;

    @JvmOverloads
    public Polygonizer(boolean extractOnlyPolygonal) {
        this.extractOnlyPolygonal = extractOnlyPolygonal;
        this.lineStringAdder = new LineStringAdder(this);
        this.dangles = new ArrayList();
        this.cutEdges = new ArrayList();
        this.invalidRingLines = new ArrayList();
        this.isCheckingRingsValid = true;
    }

    public /* synthetic */ Polygonizer(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    @Nullable
    protected final PolygonizeGraph getGraph() {
        return this.graph;
    }

    protected final void setGraph(@Nullable PolygonizeGraph polygonizeGraph) {
        this.graph = polygonizeGraph;
    }

    @NotNull
    protected final Collection<LineString> getDangles() {
        this.polygonize();
        return this.dangles;
    }

    protected final void setDangles(@NotNull Collection<? extends LineString> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"<set-?>");
        this.dangles = collection;
    }

    @NotNull
    protected final List<LineString> getCutEdges() {
        return this.cutEdges;
    }

    protected final void setCutEdges(@NotNull List<LineString> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.cutEdges = list;
    }

    @NotNull
    protected final List<LineString> getInvalidRingLines() {
        return this.invalidRingLines;
    }

    protected final void setInvalidRingLines(@NotNull List<LineString> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.invalidRingLines = list;
    }

    @Nullable
    protected final List<EdgeRing> getHoleList() {
        return this.holeList;
    }

    protected final void setHoleList(@Nullable List<EdgeRing> list) {
        this.holeList = list;
    }

    @Nullable
    protected final List<EdgeRing> getShellList() {
        return this.shellList;
    }

    protected final void setShellList(@Nullable List<EdgeRing> list) {
        this.shellList = list;
    }

    @Nullable
    protected final List<Geometry> getPolyList() {
        return this.polyList;
    }

    protected final void setPolyList(@Nullable List<? extends Geometry> list) {
        this.polyList = list;
    }

    public final void add(@NotNull Collection<?> geomList) {
        Intrinsics.checkNotNullParameter(geomList, (String)"geomList");
        for (Object obj : geomList) {
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Geometry");
            Geometry geometry = (Geometry)obj;
            this.add(geometry);
        }
    }

    public final void add(@NotNull Geometry g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        g.apply(this.lineStringAdder);
    }

    private final void add(LineString line) {
        this.geomFactory = line.getFactory();
        if (this.graph == null) {
            GeometryFactory geometryFactory = this.geomFactory;
            Intrinsics.checkNotNull((Object)geometryFactory);
            this.graph = new PolygonizeGraph(geometryFactory);
        }
        PolygonizeGraph polygonizeGraph = this.graph;
        Intrinsics.checkNotNull((Object)polygonizeGraph);
        polygonizeGraph.addEdge(line);
    }

    public final void setCheckRingsValid(boolean isCheckingRingsValid) {
        this.isCheckingRingsValid = isCheckingRingsValid;
    }

    @Nullable
    public final Collection<?> getPolygons() {
        this.polygonize();
        return this.polyList;
    }

    @NotNull
    public final Geometry getGeometry() {
        Geometry geometry;
        if (this.geomFactory == null) {
            this.geomFactory = new GeometryFactory();
        }
        this.polygonize();
        if (this.extractOnlyPolygonal) {
            GeometryFactory geometryFactory = this.geomFactory;
            Intrinsics.checkNotNull((Object)geometryFactory);
            List<? extends Geometry> list = this.polyList;
            Intrinsics.checkNotNull(list);
            geometry = geometryFactory.buildGeometry((Collection<? extends Geometry>)list);
        } else {
            GeometryFactory geometryFactory = this.geomFactory;
            Intrinsics.checkNotNull((Object)geometryFactory);
            geometry = geometryFactory.createGeometryCollection(GeometryFactory.Companion.toGeometryArray((Collection<? extends Geometry>)this.polyList));
        }
        return geometry;
    }

    @NotNull
    public final Collection<LineString> getCutEdges() {
        this.polygonize();
        return this.cutEdges;
    }

    @NotNull
    public final Collection<LineString> getInvalidRingLines() {
        this.polygonize();
        return this.invalidRingLines;
    }

    private final void polygonize() {
        if (this.polyList != null) {
            return;
        }
        this.polyList = new ArrayList();
        if (this.graph == null) {
            return;
        }
        PolygonizeGraph polygonizeGraph = this.graph;
        Intrinsics.checkNotNull((Object)polygonizeGraph);
        this.dangles = polygonizeGraph.deleteDangles();
        PolygonizeGraph polygonizeGraph2 = this.graph;
        Intrinsics.checkNotNull((Object)polygonizeGraph2);
        this.cutEdges = polygonizeGraph2.deleteCutEdges();
        PolygonizeGraph polygonizeGraph3 = this.graph;
        Intrinsics.checkNotNull((Object)polygonizeGraph3);
        List<EdgeRing> edgeRingList = polygonizeGraph3.getEdgeRings();
        List<EdgeRing> validEdgeRingList = new ArrayList();
        this.invalidRingLines = new ArrayList();
        if (this.isCheckingRingsValid) {
            this.findValidRings(edgeRingList, validEdgeRingList, this.invalidRingLines);
        } else {
            validEdgeRingList = edgeRingList;
        }
        this.findShellsAndHoles(validEdgeRingList);
        HoleAssigner.Companion.assignHolesToShells(this.holeList, this.shellList);
        List<EdgeRing> list = this.shellList;
        Intrinsics.checkNotNull(list);
        CollectionsKt.sortWith(list, (Comparator)new EdgeRing.EnvelopeComparator());
        boolean includeAll = true;
        if (this.extractOnlyPolygonal) {
            List<EdgeRing> list2 = this.shellList;
            Intrinsics.checkNotNull(list2);
            Polygonizer.Companion.findDisjointShells(list2);
            includeAll = false;
        }
        List<EdgeRing> list3 = this.shellList;
        Intrinsics.checkNotNull(list3);
        this.polyList = Polygonizer.Companion.extractPolygons(list3, includeAll);
    }

    private final void findValidRings(List<EdgeRing> edgeRingList, List<EdgeRing> validEdgeRingList, List<LineString> invalidRingList) {
        Iterator<EdgeRing> i = edgeRingList.iterator();
        while (i.hasNext()) {
            EdgeRing er;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.operation.polygonize.EdgeRing");
            boolean bl = er.isValid() ? validEdgeRingList.add(er) : invalidRingList.add(er.getLineString());
        }
    }

    private final void findShellsAndHoles(List<EdgeRing> edgeRingList) {
        this.holeList = new ArrayList();
        this.shellList = new ArrayList();
        Iterator<EdgeRing> i = edgeRingList.iterator();
        while (i.hasNext()) {
            boolean bl;
            EdgeRing er;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.operation.polygonize.EdgeRing");
            er.computeHole();
            if (er.isHole()) {
                List<EdgeRing> list = this.holeList;
                Intrinsics.checkNotNull(list);
                bl = list.add(er);
                continue;
            }
            List<EdgeRing> list = this.shellList;
            Intrinsics.checkNotNull(list);
            bl = list.add(er);
        }
    }

    @JvmOverloads
    public Polygonizer() {
        this(false, 1, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0016\u0010\t\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/locationtech/jts/operation/polygonize/Polygonizer$Companion;", "", "<init>", "()V", "findDisjointShells", "", "shellList", "", "Lorg/locationtech/jts/operation/polygonize/EdgeRing;", "findOuterShells", "extractPolygons", "", "Lorg/locationtech/jts/geom/Geometry;", "includeAll", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        private final void findDisjointShells(List<EdgeRing> shellList) {
            this.findOuterShells(shellList);
            boolean isMoreToScan = false;
            do {
                isMoreToScan = false;
                Iterator<EdgeRing> i = shellList.iterator();
                while (i.hasNext()) {
                    EdgeRing er;
                    Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.operation.polygonize.EdgeRing");
                    if (er.isIncludedSet()) continue;
                    er.updateIncluded();
                    if (er.isIncludedSet()) continue;
                    isMoreToScan = true;
                }
            } while (isMoreToScan);
        }

        private final void findOuterShells(List<EdgeRing> shellList) {
            Iterator<EdgeRing> i = shellList.iterator();
            while (i.hasNext()) {
                EdgeRing er;
                Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.operation.polygonize.EdgeRing");
                EdgeRing outerHoleER = er.getOuterHole();
                if (outerHoleER == null || outerHoleER.isProcessed()) continue;
                er.setIncluded(true);
                outerHoleER.setProcessed(true);
            }
        }

        private final List<Geometry> extractPolygons(List<EdgeRing> shellList, boolean includeAll) {
            List polyList = new ArrayList();
            Iterator<EdgeRing> i = shellList.iterator();
            while (i.hasNext()) {
                EdgeRing er;
                Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.operation.polygonize.EdgeRing");
                if (!includeAll && !er.isIncluded()) continue;
                polyList.add(er.getPolygon());
            }
            return polyList;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\r"}, d2={"Lorg/locationtech/jts/operation/polygonize/Polygonizer$LineStringAdder;", "Lorg/locationtech/jts/geom/GeometryComponentFilter;", "p", "Lorg/locationtech/jts/operation/polygonize/Polygonizer;", "<init>", "(Lorg/locationtech/jts/operation/polygonize/Polygonizer;)V", "getP", "()Lorg/locationtech/jts/operation/polygonize/Polygonizer;", "setP", "filter", "", "g", "Lorg/locationtech/jts/geom/Geometry;", "kts-core"})
    private static final class LineStringAdder
    implements GeometryComponentFilter {
        @NotNull
        private Polygonizer p;

        public LineStringAdder(@NotNull Polygonizer p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            this.p = p;
        }

        @NotNull
        public final Polygonizer getP() {
            return this.p;
        }

        public final void setP(@NotNull Polygonizer polygonizer) {
            Intrinsics.checkNotNullParameter((Object)polygonizer, (String)"<set-?>");
            this.p = polygonizer;
        }

        @Override
        public void filter(@NotNull Geometry g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            if (g instanceof LineString) {
                this.p.add((LineString)g);
            }
        }
    }
}

