/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.relate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.BoundaryNodeRule;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.EdgeEnd;
import org.locationtech.jts.geomgraph.GeometryGraph;
import org.locationtech.jts.geomgraph.Label;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0007J\r\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0086\u0002J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u0001J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0018\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J\u0010\u0010\u0017\u001a\u00020\u000f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/locationtech/jts/operation/relate/EdgeEndBundle;", "Lorg/locationtech/jts/geomgraph/EdgeEnd;", "boundaryNodeRule", "Lorg/locationtech/jts/algorithm/BoundaryNodeRule;", "e", "<init>", "(Lorg/locationtech/jts/algorithm/BoundaryNodeRule;Lorg/locationtech/jts/geomgraph/EdgeEnd;)V", "(Lorg/locationtech/jts/geomgraph/EdgeEnd;)V", "edgeEnds", "", "iterator", "", "getEdgeEnds", "", "insert", "", "computeLabel", "computeLabelOn", "geomIndex", "", "computeLabelSides", "computeLabelSide", "side", "updateIM", "im", "Lorg/locationtech/jts/geom/IntersectionMatrix;", "kts-core"})
public final class EdgeEndBundle
extends EdgeEnd {
    @NotNull
    private final List<EdgeEnd> edgeEnds;

    public EdgeEndBundle(@Nullable BoundaryNodeRule boundaryNodeRule, @NotNull EdgeEnd e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Edge edge = e.getEdge();
        Coordinate coordinate = e.getCoordinate();
        Intrinsics.checkNotNull((Object)coordinate);
        Coordinate coordinate2 = e.getDirectedCoordinate();
        Intrinsics.checkNotNull((Object)coordinate2);
        Label label = e.getLabel();
        Intrinsics.checkNotNull((Object)label);
        super(edge, coordinate, coordinate2, new Label(label));
        this.edgeEnds = new ArrayList();
        this.insert(e);
    }

    public EdgeEndBundle(@NotNull EdgeEnd e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this(null, e);
    }

    @NotNull
    public final Iterator<?> iterator() {
        return this.edgeEnds.iterator();
    }

    @NotNull
    public final List<EdgeEnd> getEdgeEnds() {
        return this.edgeEnds;
    }

    public final void insert(@NotNull EdgeEnd e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.edgeEnds.add(e);
    }

    @Override
    public void computeLabel(@NotNull BoundaryNodeRule boundaryNodeRule) {
        Intrinsics.checkNotNullParameter((Object)boundaryNodeRule, (String)"boundaryNodeRule");
        boolean isArea = false;
        Iterator<?> it = this.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.EdgeEnd");
            EdgeEnd e = (EdgeEnd)obj;
            Label label = e.getLabel();
            Intrinsics.checkNotNull((Object)label);
            if (!label.isArea()) continue;
            isArea = true;
        }
        if (isArea) {
            this.setLabel(new Label(-1, -1, -1));
        } else {
            this.setLabel(new Label(-1));
        }
        for (int i = 0; i < 2; ++i) {
            this.computeLabelOn(i, boundaryNodeRule);
            if (!isArea) continue;
            this.computeLabelSides(i);
        }
    }

    private final void computeLabelOn(int geomIndex, BoundaryNodeRule boundaryNodeRule) {
        int boundaryCount = 0;
        boolean foundInterior = false;
        Iterator<?> it = this.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.EdgeEnd");
            EdgeEnd e = (EdgeEnd)obj;
            Label label = e.getLabel();
            Intrinsics.checkNotNull((Object)label);
            int loc = label.getLocation(geomIndex);
            if (loc == 1) {
                ++boundaryCount;
            }
            if (loc != 0) continue;
            foundInterior = true;
        }
        int loc = -1;
        if (foundInterior) {
            loc = 0;
        }
        if (boundaryCount > 0) {
            loc = GeometryGraph.Companion.determineBoundary(boundaryNodeRule, boundaryCount);
        }
        Label label = this.getLabel();
        Intrinsics.checkNotNull((Object)label);
        label.setLocation(geomIndex, loc);
    }

    private final void computeLabelSides(int geomIndex) {
        this.computeLabelSide(geomIndex, 1);
        this.computeLabelSide(geomIndex, 2);
    }

    private final void computeLabelSide(int geomIndex, int side) {
        Iterator<?> it = this.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.EdgeEnd");
            EdgeEnd e = (EdgeEnd)obj;
            Label label = e.getLabel();
            Intrinsics.checkNotNull((Object)label);
            if (!label.isArea()) continue;
            Label label2 = e.getLabel();
            Intrinsics.checkNotNull((Object)label2);
            int loc = label2.getLocation(geomIndex, side);
            switch (loc) {
                case 0: {
                    Label label3 = this.getLabel();
                    Intrinsics.checkNotNull((Object)label3);
                    label3.setLocation(geomIndex, side, 0);
                    return;
                }
                case 2: {
                    Label label4 = this.getLabel();
                    Intrinsics.checkNotNull((Object)label4);
                    label4.setLocation(geomIndex, side, 2);
                }
            }
        }
    }

    public final void updateIM(@Nullable IntersectionMatrix im) {
        Label label = this.getLabel();
        Intrinsics.checkNotNull((Object)label);
        IntersectionMatrix intersectionMatrix = im;
        Intrinsics.checkNotNull((Object)intersectionMatrix);
        Edge.Companion.updateIM(label, intersectionMatrix);
    }
}

