/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.union;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.GeometryFilter;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\u0010J\u0016\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\u001eH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u0019H\u0002J\u0012\u0010 \u001a\u00020\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0019H\u0016J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u0010H\u0002R\"\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016\u00a8\u0006#"}, d2={"Lorg/locationtech/jts/operation/union/InputExtracter;", "Lorg/locationtech/jts/geom/GeometryFilter;", "<init>", "()V", "value", "Lorg/locationtech/jts/geom/GeometryFactory;", "factory", "getFactory", "()Lorg/locationtech/jts/geom/GeometryFactory;", "polygons", "", "Lorg/locationtech/jts/geom/Polygon;", "lines", "Lorg/locationtech/jts/geom/LineString;", "points", "Lorg/locationtech/jts/geom/Point;", "", "dimension", "getDimension", "()I", "isEmpty", "", "()Z", "getExtract", "", "Lorg/locationtech/jts/geom/Geometry;", "dim", "add", "", "geoms", "", "geom", "filter", "recordDimension", "Companion", "kts-core"})
public final class InputExtracter
implements GeometryFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private GeometryFactory factory;
    @NotNull
    private final List<Polygon> polygons = new ArrayList();
    @NotNull
    private final List<LineString> lines = new ArrayList();
    @NotNull
    private final List<Point> points = new ArrayList();
    private int dimension = -1;

    @Nullable
    public final GeometryFactory getFactory() {
        return this.factory;
    }

    public final int getDimension() {
        return this.dimension;
    }

    public final boolean isEmpty() {
        return this.polygons.isEmpty() && this.lines.isEmpty() && this.points.isEmpty();
    }

    @Nullable
    public final List<Geometry> getExtract(int dim) {
        switch (dim) {
            case 0: {
                return this.points;
            }
            case 1: {
                return this.lines;
            }
            case 2: {
                return this.polygons;
            }
        }
        Assert.shouldNeverReachHere("Invalid dimension: " + dim);
        return null;
    }

    private final void add(Collection<? extends Geometry> geoms) {
        for (Geometry geometry : geoms) {
            this.add(geometry);
        }
    }

    private final void add(Geometry geom) {
        if (this.factory == null) {
            this.factory = geom.getFactory();
        }
        geom.apply(this);
    }

    @Override
    public void filter(@Nullable Geometry geom) {
        Geometry geometry = geom;
        Intrinsics.checkNotNull((Object)geometry);
        this.recordDimension(geometry.getDimension());
        if (geom instanceof GeometryCollection) {
            return;
        }
        if (geom.isEmpty()) {
            return;
        }
        Geometry geometry2 = geom;
        if (geometry2 instanceof Polygon) {
            this.polygons.add((Polygon)geom);
            return;
        }
        if (geometry2 instanceof LineString) {
            this.lines.add((LineString)geom);
            return;
        }
        if (geometry2 instanceof Point) {
            this.points.add((Point)geom);
            return;
        }
        Assert.shouldNeverReachHere("Unhandled geometry type: " + geom.getGeometryType());
    }

    private final void recordDimension(int dim) {
        if (dim > this.dimension) {
            this.dimension = dim;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\b\u00a8\u0006\n"}, d2={"Lorg/locationtech/jts/operation/union/InputExtracter$Companion;", "", "<init>", "()V", "extract", "Lorg/locationtech/jts/operation/union/InputExtracter;", "geoms", "", "Lorg/locationtech/jts/geom/Geometry;", "geom", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final InputExtracter extract(@NotNull Collection<? extends Geometry> geoms) {
            Intrinsics.checkNotNullParameter(geoms, (String)"geoms");
            InputExtracter extracter = new InputExtracter();
            extracter.add(geoms);
            return extracter;
        }

        @NotNull
        public final InputExtracter extract(@NotNull Geometry geom) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            InputExtracter extracter = new InputExtracter();
            extracter.add(geom);
            return extracter;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

