/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.union;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Puntal;
import org.locationtech.jts.operation.union.CascadedPolygonUnion;
import org.locationtech.jts.operation.union.InputExtracter;
import org.locationtech.jts.operation.union.PointGeometryUnion;
import org.locationtech.jts.operation.union.UnionStrategy;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B!\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0017\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0007\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fJ\u0016\u0010\u0013\u001a\u00020\u00112\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u0004H\u0002J\b\u0010\u0014\u001a\u0004\u0018\u00010\u0004J\u001e\u0010\u0015\u001a\u0004\u0018\u00010\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/locationtech/jts/operation/union/UnaryUnionOp;", "", "geoms", "", "Lorg/locationtech/jts/geom/Geometry;", "geomFact", "Lorg/locationtech/jts/geom/GeometryFactory;", "<init>", "(Ljava/util/Collection;Lorg/locationtech/jts/geom/GeometryFactory;)V", "(Ljava/util/Collection;)V", "geom", "(Lorg/locationtech/jts/geom/Geometry;)V", "extracter", "Lorg/locationtech/jts/operation/union/InputExtracter;", "unionFunction", "Lorg/locationtech/jts/operation/union/UnionStrategy;", "setUnionFunction", "", "unionFun", "extract", "union", "unionWithNull", "g0", "g1", "unionNoOpt", "Companion", "kts-core"})
public final class UnaryUnionOp {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private GeometryFactory geomFact;
    @Nullable
    private InputExtracter extracter;
    @NotNull
    private UnionStrategy unionFunction;

    public UnaryUnionOp(@NotNull Collection<? extends Geometry> geoms, @Nullable GeometryFactory geomFact) {
        Intrinsics.checkNotNullParameter(geoms, (String)"geoms");
        this.unionFunction = CascadedPolygonUnion.Companion.getCLASSIC_UNION();
        this.geomFact = geomFact;
        this.extract(geoms);
    }

    public UnaryUnionOp(@NotNull Collection<? extends Geometry> geoms) {
        Intrinsics.checkNotNullParameter(geoms, (String)"geoms");
        this.unionFunction = CascadedPolygonUnion.Companion.getCLASSIC_UNION();
        this.extract(geoms);
    }

    public UnaryUnionOp(@NotNull Geometry geom) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        this.unionFunction = CascadedPolygonUnion.Companion.getCLASSIC_UNION();
        this.extract(geom);
    }

    public final void setUnionFunction(@NotNull UnionStrategy unionFun) {
        Intrinsics.checkNotNullParameter((Object)unionFun, (String)"unionFun");
        this.unionFunction = unionFun;
    }

    private final void extract(Collection<? extends Geometry> geoms) {
        this.extracter = InputExtracter.Companion.extract(geoms);
    }

    private final void extract(Geometry geom) {
        this.extracter = InputExtracter.Companion.extract(geom);
    }

    @Nullable
    public final Geometry union() {
        if (this.geomFact == null) {
            InputExtracter inputExtracter = this.extracter;
            Intrinsics.checkNotNull((Object)inputExtracter);
            this.geomFact = inputExtracter.getFactory();
        }
        if (this.geomFact == null) {
            return null;
        }
        InputExtracter inputExtracter = this.extracter;
        Intrinsics.checkNotNull((Object)inputExtracter);
        if (inputExtracter.isEmpty()) {
            GeometryFactory geometryFactory = this.geomFact;
            Intrinsics.checkNotNull((Object)geometryFactory);
            InputExtracter inputExtracter2 = this.extracter;
            Intrinsics.checkNotNull((Object)inputExtracter2);
            return geometryFactory.createEmpty(inputExtracter2.getDimension());
        }
        InputExtracter inputExtracter3 = this.extracter;
        Intrinsics.checkNotNull((Object)inputExtracter3);
        List<Geometry> list = inputExtracter3.getExtract(0);
        Intrinsics.checkNotNull(list);
        List<Geometry> points = list;
        InputExtracter inputExtracter4 = this.extracter;
        Intrinsics.checkNotNull((Object)inputExtracter4);
        List<Geometry> list2 = inputExtracter4.getExtract(1);
        Intrinsics.checkNotNull(list2);
        List<Geometry> lines = list2;
        InputExtracter inputExtracter5 = this.extracter;
        Intrinsics.checkNotNull((Object)inputExtracter5);
        List<Geometry> list3 = inputExtracter5.getExtract(2);
        Intrinsics.checkNotNull(list3);
        List<Geometry> polygons = list3;
        Geometry unionPoints = null;
        if (!((Collection)points).isEmpty()) {
            GeometryFactory geometryFactory = this.geomFact;
            Intrinsics.checkNotNull((Object)geometryFactory);
            Geometry ptGeom = geometryFactory.buildGeometry((Collection<? extends Geometry>)points);
            unionPoints = this.unionNoOpt(ptGeom);
        }
        Geometry unionLines = null;
        if (!((Collection)lines).isEmpty()) {
            GeometryFactory geometryFactory = this.geomFact;
            Intrinsics.checkNotNull((Object)geometryFactory);
            Geometry lineGeom = geometryFactory.buildGeometry((Collection<? extends Geometry>)lines);
            unionLines = this.unionNoOpt(lineGeom);
        }
        Geometry unionPolygons = null;
        if (!((Collection)polygons).isEmpty()) {
            unionPolygons = CascadedPolygonUnion.Companion.union((Collection)polygons, this.unionFunction);
        }
        Geometry unionLA = this.unionWithNull(unionLines, unionPolygons);
        Geometry union = null;
        union = unionPoints == null ? unionLA : (unionLA == null ? unionPoints : PointGeometryUnion.Companion.union((Puntal)((Object)unionPoints), unionLA));
        Geometry geometry = union;
        if (geometry == null) {
            GeometryFactory geometryFactory = this.geomFact;
            Intrinsics.checkNotNull((Object)geometryFactory);
            geometry = geometryFactory.createGeometryCollection();
        }
        return geometry;
    }

    private final Geometry unionWithNull(Geometry g0, Geometry g1) {
        Geometry geometry;
        if (g0 == null && g1 == null) {
            return null;
        }
        if (g1 == null) {
            geometry = g0;
        } else {
            geometry = g0;
            if (geometry == null || (geometry = geometry.union(g1)) == null) {
                geometry = g1;
            }
        }
        return geometry;
    }

    private final Geometry unionNoOpt(Geometry g0) {
        GeometryFactory geometryFactory = this.geomFact;
        Intrinsics.checkNotNull((Object)geometryFactory);
        Geometry empty = GeometryFactory.createPoint$default(geometryFactory, null, 1, null);
        return this.unionFunction.union(g0, empty);
    }

    @JvmStatic
    @Nullable
    public static final Geometry union(@NotNull Collection<? extends Geometry> geoms) {
        return Companion.union(geoms);
    }

    @JvmStatic
    @Nullable
    public static final Geometry union(@NotNull Collection<? extends Geometry> geoms, @Nullable GeometryFactory geomFact) {
        return Companion.union(geoms, geomFact);
    }

    @JvmStatic
    @Nullable
    public static final Geometry union(@NotNull Geometry geom) {
        return Companion.union(geom);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u0007J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0007\u00a8\u0006\u000b"}, d2={"Lorg/locationtech/jts/operation/union/UnaryUnionOp$Companion;", "", "<init>", "()V", "union", "Lorg/locationtech/jts/geom/Geometry;", "geoms", "", "geomFact", "Lorg/locationtech/jts/geom/GeometryFactory;", "geom", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final Geometry union(@NotNull Collection<? extends Geometry> geoms) {
            Intrinsics.checkNotNullParameter(geoms, (String)"geoms");
            UnaryUnionOp op = new UnaryUnionOp(geoms);
            return op.union();
        }

        @JvmStatic
        @Nullable
        public final Geometry union(@NotNull Collection<? extends Geometry> geoms, @Nullable GeometryFactory geomFact) {
            Intrinsics.checkNotNullParameter(geoms, (String)"geoms");
            UnaryUnionOp op = new UnaryUnionOp(geoms, geomFact);
            return op.union();
        }

        @JvmStatic
        @Nullable
        public final Geometry union(@NotNull Geometry geom) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            UnaryUnionOp op = new UnaryUnionOp(geom);
            return op.union();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

