/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.valid;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.BoundaryNodeRule;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.util.LinearComponentExtracter;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.noding.BasicSegmentString;
import org.locationtech.jts.noding.MCIndexNoder;
import org.locationtech.jts.noding.SegmentIntersector;
import org.locationtech.jts.noding.SegmentString;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 #2\u00020\u0001:\u0002\"#B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tJ\u0006\u0010\u000b\u001a\u00020\tJ\b\u0010\u0019\u001a\u00020\u0010H\u0002J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u0003H\u0002J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u0003H\u0002J\u0010\u0010 \u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u0003H\u0002J\u0010\u0010!\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0019\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006$"}, d2={"Lorg/locationtech/jts/operation/valid/IsSimpleOp;", "", "inputGeom", "Lorg/locationtech/jts/geom/Geometry;", "boundaryNodeRule", "Lorg/locationtech/jts/algorithm/BoundaryNodeRule;", "<init>", "(Lorg/locationtech/jts/geom/Geometry;Lorg/locationtech/jts/algorithm/BoundaryNodeRule;)V", "isClosedEndpointsInInterior", "", "isFindAllLocations", "isSimple", "nonSimplePts", "", "Lorg/locationtech/jts/geom/Coordinate;", "setFindAllLocations", "", "isFindAll", "nonSimpleLocation", "getNonSimpleLocation", "()Lorg/locationtech/jts/geom/Coordinate;", "nonSimpleLocations", "", "getNonSimpleLocations", "()Ljava/util/List;", "compute", "computeSimple", "geom", "isSimpleMultiPoint", "mp", "Lorg/locationtech/jts/geom/MultiPoint;", "isSimplePolygonal", "isSimpleGeometryCollection", "isSimpleLinearGeometry", "NonSimpleIntersectionFinder", "Companion", "kts-core"})
public final class IsSimpleOp {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Geometry inputGeom;
    private final boolean isClosedEndpointsInInterior;
    private boolean isFindAllLocations;
    private boolean isSimple;
    @Nullable
    private List<Coordinate> nonSimplePts;

    @JvmOverloads
    public IsSimpleOp(@NotNull Geometry inputGeom, @NotNull BoundaryNodeRule boundaryNodeRule) {
        Intrinsics.checkNotNullParameter((Object)inputGeom, (String)"inputGeom");
        Intrinsics.checkNotNullParameter((Object)boundaryNodeRule, (String)"boundaryNodeRule");
        this.inputGeom = inputGeom;
        this.isClosedEndpointsInInterior = !boundaryNodeRule.isInBoundary(2);
    }

    public /* synthetic */ IsSimpleOp(Geometry geometry, BoundaryNodeRule boundaryNodeRule, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            boundaryNodeRule = BoundaryNodeRule.MOD2_BOUNDARY_RULE;
        }
        this(geometry, boundaryNodeRule);
    }

    public final void setFindAllLocations(boolean isFindAll) {
        this.isFindAllLocations = isFindAll;
    }

    public final boolean isSimple() {
        this.compute();
        return this.isSimple;
    }

    @Nullable
    public final Coordinate getNonSimpleLocation() {
        Coordinate coordinate;
        this.compute();
        List<Coordinate> list = this.nonSimplePts;
        Intrinsics.checkNotNull(list);
        if (list.size() == 0) {
            coordinate = null;
        } else {
            List<Coordinate> list2 = this.nonSimplePts;
            Intrinsics.checkNotNull(list2);
            coordinate = list2.get(0);
        }
        return coordinate;
    }

    @Nullable
    public final List<Coordinate> getNonSimpleLocations() {
        this.compute();
        return this.nonSimplePts;
    }

    private final void compute() {
        if (this.nonSimplePts != null) {
            return;
        }
        this.nonSimplePts = new ArrayList();
        this.isSimple = this.computeSimple(this.inputGeom);
    }

    private final boolean computeSimple(Geometry geom) {
        boolean bl;
        if (geom.isEmpty()) {
            return true;
        }
        if (geom instanceof Point) {
            return true;
        }
        if (geom instanceof LineString) {
            return this.isSimpleLinearGeometry(geom);
        }
        if (geom instanceof MultiLineString) {
            return this.isSimpleLinearGeometry(geom);
        }
        if (geom instanceof MultiPoint) {
            return this.isSimpleMultiPoint((MultiPoint)geom);
        }
        if (geom instanceof Polygonal) {
            bl = this.isSimplePolygonal(geom);
        } else {
            GeometryCollection geometryCollection = geom instanceof GeometryCollection ? (GeometryCollection)geom : null;
            if (geometryCollection != null) {
                GeometryCollection it = geometryCollection;
                boolean bl2 = false;
                bl = this.isSimpleGeometryCollection(it);
            } else {
                bl = true;
            }
        }
        return bl;
    }

    private final boolean isSimpleMultiPoint(MultiPoint mp) {
        if (mp.isEmpty()) {
            return true;
        }
        boolean isSimple = true;
        Set points = new HashSet();
        int n = mp.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Geometry geometry = mp.getGeometryN(i);
            Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Point");
            Point pt = (Point)geometry;
            Coordinate p = pt.getCoordinate();
            if (CollectionsKt.contains((Iterable)points, (Object)p)) {
                List<Coordinate> list = this.nonSimplePts;
                Intrinsics.checkNotNull(list);
                Coordinate coordinate = p;
                Intrinsics.checkNotNull((Object)coordinate);
                list.add(coordinate);
                isSimple = false;
                if (this.isFindAllLocations) continue;
                break;
            }
            Coordinate coordinate = p;
            Intrinsics.checkNotNull((Object)coordinate);
            points.add(coordinate);
        }
        return isSimple;
    }

    private final boolean isSimplePolygonal(Geometry geom) {
        boolean isSimple = true;
        List<Geometry> rings = LinearComponentExtracter.Companion.getLines(geom);
        for (Geometry ring : rings) {
            if (this.isSimpleLinearGeometry(ring)) continue;
            isSimple = false;
            if (this.isFindAllLocations) continue;
            break;
        }
        return isSimple;
    }

    private final boolean isSimpleGeometryCollection(Geometry geom) {
        boolean isSimple = true;
        int n = geom.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Geometry comp = geom.getGeometryN(i);
            if (this.computeSimple(comp)) continue;
            isSimple = false;
            if (!this.isFindAllLocations) break;
        }
        return isSimple;
    }

    private final boolean isSimpleLinearGeometry(Geometry geom) {
        if (geom.isEmpty()) {
            return true;
        }
        List segStrings = IsSimpleOp.Companion.extractSegmentStrings(geom);
        NonSimpleIntersectionFinder segInt = new NonSimpleIntersectionFinder(this.isClosedEndpointsInInterior, this.isFindAllLocations, this.nonSimplePts);
        MCIndexNoder noder = new MCIndexNoder();
        noder.setSegmentIntersector(segInt);
        noder.computeNodes(segStrings);
        return !segInt.hasIntersection();
    }

    @JvmOverloads
    public IsSimpleOp(@NotNull Geometry inputGeom) {
        Intrinsics.checkNotNullParameter((Object)inputGeom, (String)"inputGeom");
        this(inputGeom, null, 2, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J#\u0010\r\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0002\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/locationtech/jts/operation/valid/IsSimpleOp$Companion;", "", "<init>", "()V", "isSimple", "", "geom", "Lorg/locationtech/jts/geom/Geometry;", "getNonSimpleLocation", "Lorg/locationtech/jts/geom/Coordinate;", "extractSegmentStrings", "", "Lorg/locationtech/jts/noding/SegmentString;", "trimRepeatedPoints", "", "pts", "([Lorg/locationtech/jts/geom/Coordinate;)[Lorg/locationtech/jts/geom/Coordinate;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isSimple(@NotNull Geometry geom) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            IsSimpleOp op = new IsSimpleOp(geom, null, 2, null);
            return op.isSimple();
        }

        @Nullable
        public final Coordinate getNonSimpleLocation(@NotNull Geometry geom) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            IsSimpleOp op = new IsSimpleOp(geom, null, 2, null);
            return op.getNonSimpleLocation();
        }

        private final List<SegmentString> extractSegmentStrings(Geometry geom) {
            List segStrings = new ArrayList();
            int n = geom.getNumGeometries();
            for (int i = 0; i < n; ++i) {
                Geometry geometry = geom.getGeometryN(i);
                Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
                LineString line = (LineString)geometry;
                Coordinate[] trimPts = this.trimRepeatedPoints(line.getCoordinates());
                if (trimPts == null) continue;
                SegmentString ss = new BasicSegmentString(trimPts, null);
                segStrings.add(ss);
            }
            return segStrings;
        }

        private final Coordinate[] trimRepeatedPoints(Coordinate[] pts) {
            int endIndex;
            int startIndex;
            if (pts.length <= 2) {
                return pts;
            }
            int len = pts.length;
            boolean hasRepeatedStart = pts[0].equals2D(pts[1]);
            boolean hasRepeatedEnd = pts[len - 1].equals2D(pts[len - 2]);
            if (!hasRepeatedStart && !hasRepeatedEnd) {
                return pts;
            }
            Coordinate startPt = pts[0];
            for (startIndex = 0; startIndex < len - 1 && startPt.equals2D(pts[startIndex + 1]); ++startIndex) {
            }
            Coordinate endPt = pts[endIndex];
            for (endIndex = len - 1; endIndex > 0 && endPt.equals2D(pts[endIndex - 1]); --endIndex) {
            }
            return endIndex - startIndex < 1 ? null : CoordinateArrays.INSTANCE.extract(pts, startIndex, endIndex);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0010\u001a\u00020\u0003J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0016H\u0016J(\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u001a\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lorg/locationtech/jts/operation/valid/IsSimpleOp$NonSimpleIntersectionFinder;", "Lorg/locationtech/jts/noding/SegmentIntersector;", "isClosedEndpointsInInterior", "", "isFindAll", "intersectionPts", "", "Lorg/locationtech/jts/geom/Coordinate;", "<init>", "(ZZLjava/util/List;)V", "li", "Lorg/locationtech/jts/algorithm/LineIntersector;", "getLi", "()Lorg/locationtech/jts/algorithm/LineIntersector;", "setLi", "(Lorg/locationtech/jts/algorithm/LineIntersector;)V", "hasIntersection", "processIntersections", "", "ss0", "Lorg/locationtech/jts/noding/SegmentString;", "segIndex0", "", "ss1", "segIndex1", "findIntersection", "isDone", "()Z", "Companion", "kts-core"})
    private static final class NonSimpleIntersectionFinder
    implements SegmentIntersector {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final boolean isClosedEndpointsInInterior;
        private final boolean isFindAll;
        @Nullable
        private final List<Coordinate> intersectionPts;
        @NotNull
        private LineIntersector li;

        public NonSimpleIntersectionFinder(boolean isClosedEndpointsInInterior, boolean isFindAll, @Nullable List<Coordinate> intersectionPts) {
            this.isClosedEndpointsInInterior = isClosedEndpointsInInterior;
            this.isFindAll = isFindAll;
            this.intersectionPts = intersectionPts;
            this.li = new RobustLineIntersector();
        }

        @NotNull
        public final LineIntersector getLi() {
            return this.li;
        }

        public final void setLi(@NotNull LineIntersector lineIntersector) {
            Intrinsics.checkNotNullParameter((Object)lineIntersector, (String)"<set-?>");
            this.li = lineIntersector;
        }

        public final boolean hasIntersection() {
            List<Coordinate> list = this.intersectionPts;
            Intrinsics.checkNotNull(list);
            return list.size() > 0;
        }

        @Override
        public void processIntersections(@NotNull SegmentString ss0, int segIndex0, @NotNull SegmentString ss1, int segIndex1) {
            boolean isSameSegment;
            Intrinsics.checkNotNullParameter((Object)ss0, (String)"ss0");
            Intrinsics.checkNotNullParameter((Object)ss1, (String)"ss1");
            boolean isSameSegString = ss0 == ss1;
            boolean bl = isSameSegment = isSameSegString && segIndex0 == segIndex1;
            if (isSameSegment) {
                return;
            }
            boolean hasInt = this.findIntersection(ss0, segIndex0, ss1, segIndex1);
            if (hasInt) {
                List<Coordinate> list = this.intersectionPts;
                Intrinsics.checkNotNull(list);
                list.add(this.li.getIntersection(0));
            }
        }

        private final boolean findIntersection(SegmentString ss0, int segIndex0, SegmentString ss1, int segIndex1) {
            boolean hasInteriorVertexInt;
            boolean isAdjacentSegment;
            boolean hasEqualSegments;
            Coordinate p00 = ss0.getCoordinate(segIndex0);
            Coordinate p01 = ss0.getCoordinate(segIndex0 + 1);
            Coordinate p10 = ss1.getCoordinate(segIndex1);
            Coordinate p11 = ss1.getCoordinate(segIndex1 + 1);
            this.li.computeIntersection(p00, p01, p10, p11);
            if (!this.li.hasIntersection()) {
                return false;
            }
            boolean hasInteriorInt = this.li.isInteriorIntersection();
            if (hasInteriorInt) {
                return true;
            }
            boolean bl = hasEqualSegments = this.li.getIntersectionNum() >= 2;
            if (hasEqualSegments) {
                return true;
            }
            boolean isSameSegString = ss0 == ss1;
            boolean bl2 = isAdjacentSegment = isSameSegString && Math.INSTANCE.abs(segIndex1 - segIndex0) <= 1;
            if (isAdjacentSegment) {
                return false;
            }
            boolean isIntersectionEndpt0 = NonSimpleIntersectionFinder.Companion.isIntersectionEndpoint(ss0, segIndex0, this.li, 0);
            boolean isIntersectionEndpt1 = NonSimpleIntersectionFinder.Companion.isIntersectionEndpoint(ss1, segIndex1, this.li, 1);
            boolean bl3 = hasInteriorVertexInt = !isIntersectionEndpt0 || !isIntersectionEndpt1;
            if (hasInteriorVertexInt) {
                return true;
            }
            if (this.isClosedEndpointsInInterior && !isSameSegString) {
                boolean hasInteriorEndpointInt;
                boolean bl4 = hasInteriorEndpointInt = ss0.isClosed() || ss1.isClosed();
                if (hasInteriorEndpointInt) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isDone() {
            boolean bl;
            if (this.isFindAll) {
                bl = false;
            } else {
                List<Coordinate> list = this.intersectionPts;
                Intrinsics.checkNotNull(list);
                bl = list.size() > 0;
            }
            return bl;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\tH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/locationtech/jts/operation/valid/IsSimpleOp$NonSimpleIntersectionFinder$Companion;", "", "<init>", "()V", "isIntersectionEndpoint", "", "ss", "Lorg/locationtech/jts/noding/SegmentString;", "ssIndex", "", "li", "Lorg/locationtech/jts/algorithm/LineIntersector;", "liSegmentIndex", "intersectionVertexIndex", "segmentIndex", "kts-core"})
        public static final class Companion {
            private Companion() {
            }

            private final boolean isIntersectionEndpoint(SegmentString ss, int ssIndex, LineIntersector li, int liSegmentIndex) {
                int vertexIndex = this.intersectionVertexIndex(li, liSegmentIndex);
                return vertexIndex == 0 ? ssIndex == 0 : ssIndex + 2 == ss.size();
            }

            private final int intersectionVertexIndex(LineIntersector li, int segmentIndex) {
                Coordinate endPt0;
                Coordinate intPt = li.getIntersection(0);
                Coordinate coordinate = endPt0 = li.getEndpoint(segmentIndex, 0);
                Intrinsics.checkNotNull((Object)coordinate);
                return intPt.equals2D(coordinate) ? 0 : 1;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

