/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.valid;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.legacy.StackKt;
import org.locationtech.jts.operation.valid.PolygonRingSelfNode;
import org.locationtech.jts.operation.valid.PolygonRingTouch;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 02\u00020\u0001:\u00010B\u0013\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B%\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0004\u0010\tJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u0000J\u0006\u0010\u0015\u001a\u00020\u0014J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u0000H\u0002J\b\u0010\u001a\u001a\u00020\u0014H\u0002J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J6\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u001f2\b\u0010\"\u001a\u0004\u0018\u00010\u001f2\b\u0010#\u001a\u0004\u0018\u00010\u001f2\b\u0010$\u001a\u0004\u0018\u00010\u001f2\b\u0010%\u001a\u0004\u0018\u00010\u001fJ\u0018\u0010&\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\n\u0010'\u001a\u0004\u0018\u00010\u001fH\u0002J(\u0010(\u001a\u0004\u0018\u00010\u001f2\u0006\u0010)\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u00002\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000e0,H\u0002J\b\u0010-\u001a\u0004\u0018\u00010\u001fJ\n\u0010.\u001a\u00020/H\u0096\u0080\u0004R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u000f\u001a\u0016\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010j\n\u0012\u0004\u0012\u00020\u0011\u0018\u0001`\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00061"}, d2={"Lorg/locationtech/jts/operation/valid/PolygonRing;", "", "ring", "Lorg/locationtech/jts/geom/LinearRing;", "<init>", "(Lorg/locationtech/jts/geom/LinearRing;)V", "index", "", "shell", "(Lorg/locationtech/jts/geom/LinearRing;ILorg/locationtech/jts/operation/valid/PolygonRing;)V", "id", "touchSetRoot", "touches", "", "Lorg/locationtech/jts/operation/valid/PolygonRingTouch;", "selfNodes", "Ljava/util/ArrayList;", "Lorg/locationtech/jts/operation/valid/PolygonRingSelfNode;", "Lkotlin/collections/ArrayList;", "isSamePolygon", "", "isShell", "isInTouchSet", "()Z", "setTouchSetRoot", "", "hasTouches", "getTouches", "", "addTouch", "pt", "Lorg/locationtech/jts/geom/Coordinate;", "addSelfTouch", "origin", "e00", "e01", "e10", "e11", "isOnlyTouch", "findHoleCycleLocation", "scanForHoleCycle", "currentTouch", "root", "touchStack", "Lkotlin/collections/ArrayDeque;", "findInteriorSelfNode", "toString", "", "Companion", "kts-core"})
@SourceDebugExtension(value={"SMAP\nPolygonRing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolygonRing.kt\norg/locationtech/jts/operation/valid/PolygonRing\n+ 2 Stack.kt\norg/locationtech/jts/legacy/StackKt\n*L\n1#1,393:1\n21#2:394\n*S KotlinDebug\n*F\n+ 1 PolygonRing.kt\norg/locationtech/jts/operation/valid/PolygonRing\n*L\n225#1:394\n*E\n"})
public final class PolygonRing {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int id;
    @Nullable
    private PolygonRing shell;
    @Nullable
    private LinearRing ring;
    @Nullable
    private PolygonRing touchSetRoot;
    @Nullable
    private Map<Integer, PolygonRingTouch> touches;
    @Nullable
    private ArrayList<PolygonRingSelfNode> selfNodes;

    public PolygonRing(@Nullable LinearRing ring) {
        this.ring = ring;
        this.id = -1;
        this.shell = this;
    }

    public PolygonRing(@Nullable LinearRing ring, int index, @Nullable PolygonRing shell) {
        this.ring = ring;
        this.id = index;
        this.shell = shell;
    }

    public final boolean isSamePolygon(@NotNull PolygonRing ring) {
        Intrinsics.checkNotNullParameter((Object)ring, (String)"ring");
        return this.shell == ring.shell;
    }

    public final boolean isShell() {
        return this.shell == this;
    }

    private final boolean isInTouchSet() {
        return this.touchSetRoot != null;
    }

    private final void setTouchSetRoot(PolygonRing ring) {
        this.touchSetRoot = ring;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasTouches() {
        if (this.touches == null) return false;
        Map<Integer, PolygonRingTouch> map = this.touches;
        Intrinsics.checkNotNull(map);
        if (map.isEmpty()) return false;
        return true;
    }

    private final Collection<PolygonRingTouch> getTouches() {
        Map<Integer, PolygonRingTouch> map = this.touches;
        Intrinsics.checkNotNull(map);
        return map.values();
    }

    private final void addTouch(PolygonRing ring, Coordinate pt) {
        if (this.touches == null) {
            this.touches = new HashMap();
        }
        Map<Integer, PolygonRingTouch> map = this.touches;
        Intrinsics.checkNotNull(map);
        PolygonRingTouch touch = map.get(ring.id);
        if (touch == null) {
            Map<Integer, PolygonRingTouch> map2 = this.touches;
            Intrinsics.checkNotNull(map2);
            map2.put(ring.id, new PolygonRingTouch(ring, pt));
        }
    }

    public final void addSelfTouch(@NotNull Coordinate origin, @Nullable Coordinate e00, @Nullable Coordinate e01, @Nullable Coordinate e10, @Nullable Coordinate e11) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        if (this.selfNodes == null) {
            this.selfNodes = new ArrayList();
        }
        ArrayList<PolygonRingSelfNode> arrayList = this.selfNodes;
        Intrinsics.checkNotNull(arrayList);
        arrayList.add(new PolygonRingSelfNode(origin, e00, e01, e10, e11));
    }

    private final boolean isOnlyTouch(PolygonRing ring, Coordinate pt) {
        if (this.touches == null) {
            return true;
        }
        Map<Integer, PolygonRingTouch> map = this.touches;
        Intrinsics.checkNotNull(map);
        PolygonRingTouch polygonRingTouch = map.get(ring.id);
        if (polygonRingTouch == null) {
            return true;
        }
        PolygonRingTouch touch = polygonRingTouch;
        return touch.isAtLocation(pt);
    }

    private final Coordinate findHoleCycleLocation() {
        if (this.isInTouchSet()) {
            return null;
        }
        PolygonRing root = this;
        root.setTouchSetRoot(root);
        if (!this.hasTouches()) {
            return null;
        }
        ArrayDeque touchStack = new ArrayDeque();
        PolygonRing.Companion.init(root, (ArrayDeque<PolygonRingTouch>)touchStack);
        while (!touchStack.isEmpty()) {
            Object t = StackKt.pop((List)touchStack);
            Intrinsics.checkNotNull(t);
            PolygonRingTouch touch = (PolygonRingTouch)t;
            Coordinate holeCyclePt = this.scanForHoleCycle(touch, root, (ArrayDeque<PolygonRingTouch>)touchStack);
            if (holeCyclePt == null) continue;
            return holeCyclePt;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final Coordinate scanForHoleCycle(PolygonRingTouch currentTouch, PolygonRing root, ArrayDeque<PolygonRingTouch> touchStack) {
        PolygonRing ring = currentTouch.getRing();
        Coordinate currentPt = currentTouch.getCoordinate();
        for (PolygonRingTouch touch : ring.getTouches()) {
            void $this$push$iv;
            if (currentPt.equals2D(touch.getCoordinate())) continue;
            PolygonRing touchRing = touch.getRing();
            if (touchRing.touchSetRoot == root) {
                return touch.getCoordinate();
            }
            touchRing.setTouchSetRoot(root);
            List list = (List)touchStack;
            PolygonRingTouch item$iv = touch;
            boolean $i$f$push = false;
            $this$push$iv.add(item$iv);
        }
        return null;
    }

    @Nullable
    public final Coordinate findInteriorSelfNode() {
        if (this.selfNodes == null) {
            return null;
        }
        LinearRing linearRing = this.ring;
        Intrinsics.checkNotNull((Object)linearRing);
        boolean isCCW = Orientation.isCCW(linearRing.getCoordinates());
        boolean isInteriorOnRight = this.isShell() ^ isCCW;
        ArrayList<PolygonRingSelfNode> arrayList = this.selfNodes;
        Intrinsics.checkNotNull(arrayList);
        Iterator<PolygonRingSelfNode> iterator2 = arrayList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<PolygonRingSelfNode> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            PolygonRingSelfNode selfNode;
            Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
            if (selfNode.isExterior(isInteriorOnRight)) continue;
            return selfNode.getCoordinate();
        }
        return null;
    }

    @NotNull
    public String toString() {
        return String.valueOf(this.ring);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\"\u0010\b\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u0004\u0018\u00010\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fJ\u0016\u0010\u0010\u001a\u0004\u0018\u00010\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fJ\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00072\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/locationtech/jts/operation/valid/PolygonRing$Companion;", "", "<init>", "()V", "isShell", "", "polyRing", "Lorg/locationtech/jts/operation/valid/PolygonRing;", "addTouch", "ring0", "ring1", "pt", "Lorg/locationtech/jts/geom/Coordinate;", "findHoleCycleLocation", "polyRings", "", "findInteriorSelfNode", "init", "", "root", "touchStack", "Lkotlin/collections/ArrayDeque;", "Lorg/locationtech/jts/operation/valid/PolygonRingTouch;", "kts-core"})
    @SourceDebugExtension(value={"SMAP\nPolygonRing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolygonRing.kt\norg/locationtech/jts/operation/valid/PolygonRing$Companion\n+ 2 Stack.kt\norg/locationtech/jts/legacy/StackKt\n*L\n1#1,393:1\n21#2:394\n*S KotlinDebug\n*F\n+ 1 PolygonRing.kt\norg/locationtech/jts/operation/valid/PolygonRing$Companion\n*L\n334#1:394\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isShell(@Nullable PolygonRing polyRing) {
            PolygonRing polygonRing = polyRing;
            return polygonRing != null ? polygonRing.isShell() : true;
        }

        public final boolean addTouch(@Nullable PolygonRing ring0, @Nullable PolygonRing ring1, @NotNull Coordinate pt) {
            Intrinsics.checkNotNullParameter((Object)pt, (String)"pt");
            if (ring0 == null || ring1 == null) {
                return false;
            }
            if (!ring0.isSamePolygon(ring1)) {
                return false;
            }
            if (!ring0.isOnlyTouch(ring1, pt)) {
                return true;
            }
            if (!ring1.isOnlyTouch(ring0, pt)) {
                return true;
            }
            ring0.addTouch(ring1, pt);
            ring1.addTouch(ring0, pt);
            return false;
        }

        @Nullable
        public final Coordinate findHoleCycleLocation(@NotNull List<PolygonRing> polyRings) {
            Intrinsics.checkNotNullParameter(polyRings, (String)"polyRings");
            for (PolygonRing polyRing : polyRings) {
                Coordinate holeCycleLoc;
                if (polyRing.isInTouchSet() || (holeCycleLoc = polyRing.findHoleCycleLocation()) == null) continue;
                return holeCycleLoc;
            }
            return null;
        }

        @Nullable
        public final Coordinate findInteriorSelfNode(@NotNull List<PolygonRing> polyRings) {
            Intrinsics.checkNotNullParameter(polyRings, (String)"polyRings");
            for (PolygonRing polyRing : polyRings) {
                Coordinate interiorSelfNode = polyRing.findInteriorSelfNode();
                if (interiorSelfNode == null) continue;
                return interiorSelfNode;
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        private final void init(PolygonRing root, ArrayDeque<PolygonRingTouch> touchStack) {
            for (PolygonRingTouch touch : root.getTouches()) {
                void $this$push$iv;
                touch.getRing().setTouchSetRoot(root);
                List list = (List)touchStack;
                PolygonRingTouch item$iv = touch;
                boolean $i$f$push = false;
                $this$push$iv.add(item$iv);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

