/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.precision;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.util.GeometryEditor;
import org.locationtech.jts.precision.PointwisePrecisionReducerTransformer;
import org.locationtech.jts.precision.PrecisionReducerTransformer;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0007J\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0007J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fJ\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0018\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/locationtech/jts/precision/GeometryPrecisionReducer;", "", "targetPM", "Lorg/locationtech/jts/geom/PrecisionModel;", "<init>", "(Lorg/locationtech/jts/geom/PrecisionModel;)V", "removeCollapsed", "", "changePrecisionModel", "isPointwise", "setRemoveCollapsedComponents", "", "setChangePrecisionModel", "setPointwise", "reduce", "Lorg/locationtech/jts/geom/Geometry;", "geom", "changePM", "newPM", "createEditor", "Lorg/locationtech/jts/geom/util/GeometryEditor;", "geomFactory", "Lorg/locationtech/jts/geom/GeometryFactory;", "createFactory", "inputFactory", "pm", "Companion", "kts-core"})
public final class GeometryPrecisionReducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PrecisionModel targetPM;
    private boolean removeCollapsed;
    private boolean changePrecisionModel;
    private boolean isPointwise;

    public GeometryPrecisionReducer(@NotNull PrecisionModel targetPM) {
        Intrinsics.checkNotNullParameter((Object)targetPM, (String)"targetPM");
        this.targetPM = targetPM;
        this.removeCollapsed = true;
    }

    public final void setRemoveCollapsedComponents(boolean removeCollapsed) {
        this.removeCollapsed = removeCollapsed;
    }

    public final void setChangePrecisionModel(boolean changePrecisionModel) {
        this.changePrecisionModel = changePrecisionModel;
    }

    public final void setPointwise(boolean isPointwise) {
        this.isPointwise = isPointwise;
    }

    @Nullable
    public final Geometry reduce(@Nullable Geometry geom) {
        Geometry reduced = this.isPointwise ? PointwisePrecisionReducerTransformer.Companion.reduce(geom, this.targetPM) : PrecisionReducerTransformer.Companion.reduce(geom, this.targetPM, this.removeCollapsed);
        return this.changePrecisionModel ? this.changePM(reduced, this.targetPM) : reduced;
    }

    private final Geometry changePM(Geometry geom, PrecisionModel newPM) {
        GeometryEditor geomEditor = this.createEditor(geom.getFactory(), newPM);
        return geomEditor.edit(geom, new GeometryEditor.NoOpGeometryOperation());
    }

    private final GeometryEditor createEditor(GeometryFactory geomFactory, PrecisionModel newPM) {
        if (geomFactory.getPrecisionModel() == newPM) {
            return new GeometryEditor();
        }
        GeometryFactory newFactory = this.createFactory(geomFactory, newPM);
        return new GeometryEditor(newFactory);
    }

    private final GeometryFactory createFactory(GeometryFactory inputFactory, PrecisionModel pm) {
        return new GeometryFactory(pm, inputFactory.getSRID(), inputFactory.getCoordinateSequenceFactory());
    }

    @JvmStatic
    @Nullable
    public static final Geometry reduce(@Nullable Geometry g, @NotNull PrecisionModel precModel) {
        return Companion.reduce(g, precModel);
    }

    @JvmStatic
    @Nullable
    public static final Geometry reducePointwise(@Nullable Geometry g, @NotNull PrecisionModel precModel) {
        return Companion.reducePointwise(g, precModel);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u001a\u0010\t\u001a\u0004\u0018\u00010\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\bJ\u001c\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\r"}, d2={"Lorg/locationtech/jts/precision/GeometryPrecisionReducer$Companion;", "", "<init>", "()V", "reduce", "Lorg/locationtech/jts/geom/Geometry;", "g", "precModel", "Lorg/locationtech/jts/geom/PrecisionModel;", "reduceKeepCollapsed", "geom", "pm", "reducePointwise", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final Geometry reduce(@Nullable Geometry g, @NotNull PrecisionModel precModel) {
            Intrinsics.checkNotNullParameter((Object)precModel, (String)"precModel");
            GeometryPrecisionReducer reducer = new GeometryPrecisionReducer(precModel);
            return reducer.reduce(g);
        }

        @Nullable
        public final Geometry reduceKeepCollapsed(@Nullable Geometry geom, @NotNull PrecisionModel pm) {
            Intrinsics.checkNotNullParameter((Object)pm, (String)"pm");
            GeometryPrecisionReducer reducer = new GeometryPrecisionReducer(pm);
            reducer.setRemoveCollapsedComponents(false);
            return reducer.reduce(geom);
        }

        @JvmStatic
        @Nullable
        public final Geometry reducePointwise(@Nullable Geometry g, @NotNull PrecisionModel precModel) {
            Intrinsics.checkNotNullParameter((Object)precModel, (String)"precModel");
            GeometryPrecisionReducer reducer = new GeometryPrecisionReducer(precModel);
            reducer.setPointwise(true);
            return reducer.reduce(g);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

