/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate.quadedge;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.triangulate.quadedge.QuadEdge;
import org.locationtech.jts.triangulate.quadedge.QuadEdgeLocator;
import org.locationtech.jts.triangulate.quadedge.QuadEdgeSubdivision;
import org.locationtech.jts.triangulate.quadedge.Vertex;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u0007H\u0002J\u0012\u0010\u000b\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/locationtech/jts/triangulate/quadedge/LastFoundQuadEdgeLocator;", "Lorg/locationtech/jts/triangulate/quadedge/QuadEdgeLocator;", "subdiv", "Lorg/locationtech/jts/triangulate/quadedge/QuadEdgeSubdivision;", "<init>", "(Lorg/locationtech/jts/triangulate/quadedge/QuadEdgeSubdivision;)V", "lastEdge", "Lorg/locationtech/jts/triangulate/quadedge/QuadEdge;", "init", "", "findEdge", "locate", "v", "Lorg/locationtech/jts/triangulate/quadedge/Vertex;", "kts-core"})
public final class LastFoundQuadEdgeLocator
implements QuadEdgeLocator {
    @NotNull
    private final QuadEdgeSubdivision subdiv;
    @Nullable
    private QuadEdge lastEdge;

    public LastFoundQuadEdgeLocator(@NotNull QuadEdgeSubdivision subdiv) {
        Intrinsics.checkNotNullParameter((Object)subdiv, (String)"subdiv");
        this.subdiv = subdiv;
        this.init();
    }

    private final void init() {
        this.lastEdge = this.findEdge();
    }

    private final QuadEdge findEdge() {
        Collection<?> edges = this.subdiv.getEdges();
        Object obj = edges.iterator().next();
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.triangulate.quadedge.QuadEdge");
        return (QuadEdge)obj;
    }

    @Override
    @NotNull
    public QuadEdge locate(@Nullable Vertex v) {
        QuadEdge e;
        QuadEdge quadEdge = this.lastEdge;
        Intrinsics.checkNotNull((Object)quadEdge);
        if (!quadEdge.isLive()) {
            this.init();
        }
        Vertex vertex = v;
        Intrinsics.checkNotNull((Object)vertex);
        QuadEdge quadEdge2 = this.lastEdge;
        Intrinsics.checkNotNull((Object)quadEdge2);
        this.lastEdge = e = this.subdiv.locateFromEdge(vertex, quadEdge2);
        return e;
    }
}

