/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate.quadedge;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.HCoordinate;
import org.locationtech.jts.algorithm.NotRepresentableException;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.triangulate.quadedge.QuadEdge;
import org.locationtech.jts.triangulate.quadedge.TrianglePredicate;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u0000 =2\u00020\u0001:\u0001=B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\bB\u0013\b\u0016\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0005\u0010\u000bJ\n\u0010\u0019\u001a\u00020\u001aH\u0096\u0080\u0004J\u0010\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0000J\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0003J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0000J\u000e\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u0000J\u000e\u0010$\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u0000J\u0011\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0003H\u0086\u0002J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0000J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0000J\u0006\u0010)\u001a\u00020\u0003J\u0006\u0010*\u001a\u00020\u0000J\u001e\u0010+\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0000J\u0016\u0010.\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0000J\u000e\u0010/\u001a\u00020\u001c2\u0006\u00100\u001a\u000201J\u000e\u00102\u001a\u00020\u001c2\u0006\u00100\u001a\u000201J\u0018\u00103\u001a\u0002042\u0006\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0000H\u0002J\u001a\u00105\u001a\u00020\u00032\b\u00106\u001a\u0004\u0018\u00010\u00002\u0006\u00107\u001a\u00020\u0000H\u0002J\u0016\u00108\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0000J\u000e\u00109\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0000J\u0018\u0010:\u001a\u0004\u0018\u00010\u00002\u0006\u0010-\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0000J\u001e\u0010;\u001a\u00020\u00032\u0006\u0010<\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0000R\u001e\u0010\r\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R$\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0018\u00a8\u0006>"}, d2={"Lorg/locationtech/jts/triangulate/quadedge/Vertex;", "", "_x", "", "_y", "<init>", "(DD)V", "_z", "(DDD)V", "_p", "Lorg/locationtech/jts/geom/Coordinate;", "(Lorg/locationtech/jts/geom/Coordinate;)V", "value", "coordinate", "getCoordinate", "()Lorg/locationtech/jts/geom/Coordinate;", "x", "getX", "()D", "y", "getY", "z", "getZ", "setZ", "(D)V", "toString", "", "equals", "", "tolerance", "classify", "", "p0", "p1", "crossProduct", "v", "dot", "times", "c", "sum", "sub", "magn", "cross", "isInCircle", "a", "b", "isCCW", "rightOf", "e", "Lorg/locationtech/jts/triangulate/quadedge/QuadEdge;", "leftOf", "bisector", "Lorg/locationtech/jts/algorithm/HCoordinate;", "distance", "v1", "v2", "circumRadiusRatio", "midPoint", "circleCenter", "interpolateZValue", "v0", "Companion", "kts-core"})
public class Vertex {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Coordinate coordinate;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int BEYOND = 2;
    public static final int BEHIND = 3;
    public static final int BETWEEN = 4;
    public static final int ORIGIN = 5;
    public static final int DESTINATION = 6;

    @NotNull
    public final Coordinate getCoordinate() {
        return this.coordinate;
    }

    public Vertex(double _x, double _y) {
        this.coordinate = new Coordinate(_x, _y);
    }

    public Vertex(double _x, double _y, double _z) {
        this.coordinate = new Coordinate(_x, _y, _z);
    }

    public Vertex(@Nullable Coordinate _p) {
        Coordinate coordinate = _p;
        Intrinsics.checkNotNull((Object)coordinate);
        this.coordinate = new Coordinate(coordinate);
    }

    public final double getX() {
        return this.coordinate.x;
    }

    public final double getY() {
        return this.coordinate.y;
    }

    public final double getZ() {
        return this.coordinate.getZ();
    }

    public final void setZ(double _z) {
        this.coordinate.setZ(_z);
    }

    @NotNull
    public String toString() {
        return "POINT (" + this.coordinate.x + " " + this.coordinate.y + ")";
    }

    public final boolean equals(@Nullable Vertex _x) {
        double d = this.coordinate.x;
        Vertex vertex = _x;
        Intrinsics.checkNotNull((Object)vertex);
        return d == vertex.getX() && this.coordinate.y == _x.getY();
    }

    public final boolean equals(@NotNull Vertex _x, double tolerance) {
        Intrinsics.checkNotNullParameter((Object)_x, (String)"_x");
        return this.coordinate.distance(_x.coordinate) < tolerance;
    }

    public final int classify(@NotNull Vertex p0, @NotNull Vertex p1) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Vertex p2 = this;
        Vertex a = p1.sub(p0);
        Vertex b = p2.sub(p0);
        double sa = a.crossProduct(b);
        if (sa > 0.0) {
            return 0;
        }
        if (sa < 0.0) {
            return 1;
        }
        if (a.getX() * b.getX() < 0.0 || a.getY() * b.getY() < 0.0) {
            return 3;
        }
        if (a.magn() < b.magn()) {
            return 2;
        }
        if (p0.equals(p2)) {
            return 5;
        }
        return p1.equals(p2) ? 6 : 4;
    }

    public final double crossProduct(@NotNull Vertex v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return this.coordinate.x * v.getY() - this.coordinate.y * v.getX();
    }

    public final double dot(@NotNull Vertex v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return this.coordinate.x * v.getX() + this.coordinate.y * v.getY();
    }

    @NotNull
    public final Vertex times(double c) {
        return new Vertex(c * this.coordinate.x, c * this.coordinate.y);
    }

    @NotNull
    public final Vertex sum(@NotNull Vertex v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new Vertex(this.coordinate.x + v.getX(), this.coordinate.y + v.getY());
    }

    @NotNull
    public final Vertex sub(@NotNull Vertex v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new Vertex(this.coordinate.x - v.getX(), this.coordinate.y - v.getY());
    }

    public final double magn() {
        return Math.INSTANCE.sqrt(this.coordinate.x * this.coordinate.x + this.coordinate.y * this.coordinate.y);
    }

    @NotNull
    public final Vertex cross() {
        return new Vertex(this.coordinate.y, -this.coordinate.x);
    }

    public final boolean isInCircle(@NotNull Vertex a, @NotNull Vertex b, @NotNull Vertex c) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return TrianglePredicate.INSTANCE.isInCircleRobust(a.coordinate, b.coordinate, c.coordinate, this.coordinate);
    }

    public final boolean isCCW(@NotNull Vertex b, @NotNull Vertex c) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return (b.coordinate.x - this.coordinate.x) * (c.coordinate.y - this.coordinate.y) - (b.coordinate.y - this.coordinate.y) * (c.coordinate.x - this.coordinate.x) > 0.0;
    }

    public final boolean rightOf(@NotNull QuadEdge e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Vertex vertex = e.dest();
        Intrinsics.checkNotNull((Object)vertex);
        Vertex vertex2 = e.orig();
        Intrinsics.checkNotNull((Object)vertex2);
        return this.isCCW(vertex, vertex2);
    }

    public final boolean leftOf(@NotNull QuadEdge e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Vertex vertex = e.orig();
        Intrinsics.checkNotNull((Object)vertex);
        Vertex vertex2 = e.dest();
        Intrinsics.checkNotNull((Object)vertex2);
        return this.isCCW(vertex, vertex2);
    }

    private final HCoordinate bisector(Vertex a, Vertex b) {
        double dx = b.getX() - a.getX();
        double dy = b.getY() - a.getY();
        HCoordinate l1 = new HCoordinate(a.getX() + dx / 2.0, a.getY() + dy / 2.0, 1.0);
        HCoordinate l2 = new HCoordinate(a.getX() - dy + dx / 2.0, a.getY() + dx + dy / 2.0, 1.0);
        return new HCoordinate(l1, l2);
    }

    private final double distance(Vertex v1, Vertex v2) {
        double d = v2.getX();
        Vertex vertex = v1;
        Intrinsics.checkNotNull((Object)vertex);
        return Math.INSTANCE.sqrt(Math.INSTANCE.pow(d - vertex.getX(), 2.0) + Math.INSTANCE.pow(v2.getY() - v1.getY(), 2.0));
    }

    public final double circumRadiusRatio(@NotNull Vertex b, @NotNull Vertex c) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Vertex x = this.circleCenter(b, c);
        double radius = this.distance(x, b);
        double edgeLength = this.distance(this, b);
        double el = this.distance(b, c);
        if (el < edgeLength) {
            edgeLength = el;
        }
        if ((el = this.distance(c, this)) < edgeLength) {
            edgeLength = el;
        }
        return radius / edgeLength;
    }

    @NotNull
    public final Vertex midPoint(@NotNull Vertex a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        double xm = (this.coordinate.x + a.getX()) / 2.0;
        double ym = (this.coordinate.y + a.getY()) / 2.0;
        double zm = (this.coordinate.getZ() + a.getZ()) / 2.0;
        return new Vertex(xm, ym, zm);
    }

    @Nullable
    public final Vertex circleCenter(@NotNull Vertex b, @NotNull Vertex c) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Vertex a = new Vertex(this.getX(), this.getY());
        HCoordinate cab = this.bisector(a, b);
        HCoordinate cbc = this.bisector(b, c);
        HCoordinate hcc = new HCoordinate(cab, cbc);
        Vertex cc = null;
        try {
            cc = new Vertex(hcc.getX(), hcc.getY());
        }
        catch (NotRepresentableException notRepresentableException) {
            // empty catch block
        }
        return cc;
    }

    public final double interpolateZValue(@NotNull Vertex v0, @NotNull Vertex v1, @NotNull Vertex v2) {
        Intrinsics.checkNotNullParameter((Object)v0, (String)"v0");
        Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
        double x0 = v0.getX();
        double y0 = v0.getY();
        double a = v1.getX() - x0;
        double b = v2.getX() - x0;
        double c = v1.getY() - y0;
        double d = v2.getY() - y0;
        double det = a * d - b * c;
        double dx = this.getX() - x0;
        double dy = this.getY() - y0;
        double t = (d * dx - b * dy) / det;
        double u = (-c * dx + a * dy) / det;
        return v0.getZ() + t * (v1.getZ() - v0.getZ()) + u * (v2.getZ() - v0.getZ());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fJ\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/locationtech/jts/triangulate/quadedge/Vertex$Companion;", "", "<init>", "()V", "LEFT", "", "RIGHT", "BEYOND", "BEHIND", "BETWEEN", "ORIGIN", "DESTINATION", "interpolateZ", "", "p", "Lorg/locationtech/jts/geom/Coordinate;", "v0", "v1", "v2", "p0", "p1", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final double interpolateZ(@NotNull Coordinate p, @NotNull Coordinate v0, @NotNull Coordinate v1, @NotNull Coordinate v2) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)v0, (String)"v0");
            Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
            Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
            double x0 = v0.x;
            double y0 = v0.y;
            double a = v1.x - x0;
            double b = v2.x - x0;
            double c = v1.y - y0;
            double d = v2.y - y0;
            double det = a * d - b * c;
            double dx = p.x - x0;
            double dy = p.y - y0;
            double t = (d * dx - b * dy) / det;
            double u = (-c * dx + a * dy) / det;
            return v0.getZ() + t * (v1.getZ() - v0.getZ()) + u * (v2.getZ() - v0.getZ());
        }

        public final double interpolateZ(@NotNull Coordinate p, @NotNull Coordinate p0, @NotNull Coordinate p1) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            double segLen = p0.distance(p1);
            double ptLen = p.distance(p0);
            double dz = p1.getZ() - p0.getZ();
            return p0.getZ() + dz * (ptLen / segLen);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

